--
-- PostgreSQL database dump
--

\restrict gfLnDCtVJ4Nol6ojP1qH9KvoIP7txV2s3N8MaqWI6pkYHLXZf9SyLSf1rSI1AUv

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.1 (Ubuntu 18.1-1.pgdg24.04+2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: pg_trgm; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS pg_trgm WITH SCHEMA public;


--
-- Name: EXTENSION pg_trgm; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pg_trgm IS 'text similarity measurement and index searching based on trigrams';


--
-- Name: unaccent; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS unaccent WITH SCHEMA public;


--
-- Name: EXTENSION unaccent; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION unaccent IS 'text search dictionary that removes accents';


--
-- Name: vector; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS vector WITH SCHEMA public;


--
-- Name: EXTENSION vector; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION vector IS 'vector data type and ivfflat and hnsw access methods';


--
-- Name: queue_job_notify(); Type: FUNCTION; Schema: public; Owner: ductin
--

CREATE FUNCTION public.queue_job_notify() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            BEGIN
                IF TG_OP = 'DELETE' THEN
                    IF OLD.state != 'done' THEN
                        PERFORM pg_notify('queue_job', OLD.uuid);
                    END IF;
                ELSE
                    PERFORM pg_notify('queue_job', NEW.uuid);
                END IF;
                RETURN NULL;
            END;
            $$;


ALTER FUNCTION public.queue_job_notify() OWNER TO ductin;

--
-- Name: knowledge_dictionary; Type: TEXT SEARCH DICTIONARY; Schema: public; Owner: ductin
--

CREATE TEXT SEARCH DICTIONARY public.knowledge_dictionary (
    TEMPLATE = pg_catalog.simple );


ALTER TEXT SEARCH DICTIONARY public.knowledge_dictionary OWNER TO ductin;

--
-- Name: knowledge_config; Type: TEXT SEARCH CONFIGURATION; Schema: public; Owner: ductin
--

CREATE TEXT SEARCH CONFIGURATION public.knowledge_config (
    PARSER = pg_catalog."default" );

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR asciiword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR word WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR numword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR email WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR url WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR host WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR sfloat WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR version WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_numpart WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_part WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_asciipart WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR protocol WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR numhword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR asciihword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR url_path WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR file WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR "float" WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR "int" WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR uint WITH public.knowledge_dictionary;


ALTER TEXT SEARCH CONFIGURATION public.knowledge_config OWNER TO ductin;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: Salespersons; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public."Salespersons" (
    sale_commission_plan_user_wizard_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public."Salespersons" OWNER TO ductin;

--
-- Name: TABLE "Salespersons"; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public."Salespersons" IS 'RELATION BETWEEN sale_commission_plan_user_wizard AND res_users';


--
-- Name: account_account; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    account_type character varying NOT NULL,
    name jsonb NOT NULL,
    code_store jsonb,
    note text,
    deprecated boolean,
    reconcile boolean,
    non_trade boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    create_asset character varying NOT NULL,
    multiple_assets_per_line boolean,
    disallowed_expenses_category_id integer
);


ALTER TABLE public.account_account OWNER TO ductin;

--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.account_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.account_type IS 'Type';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.code_store; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.code_store IS 'Code Store';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.deprecated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.deprecated IS 'Deprecated';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.non_trade; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.non_trade IS 'Non Trade';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.create_asset; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.create_asset IS 'Create Asset';


--
-- Name: COLUMN account_account.multiple_assets_per_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.multiple_assets_per_line IS 'Multiple Assets per Line';


--
-- Name: COLUMN account_account.disallowed_expenses_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account.disallowed_expenses_category_id IS 'Disallowed Expenses Category';


--
-- Name: account_account_account_asset_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_account_asset_rel (
    account_account_id integer NOT NULL,
    account_asset_id integer NOT NULL
);


ALTER TABLE public.account_account_account_asset_rel OWNER TO ductin;

--
-- Name: TABLE account_account_account_asset_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_account_asset_rel IS 'RELATION BETWEEN account_account AND account_asset';


--
-- Name: account_account_account_auto_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_account_auto_reconcile_wizard_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_auto_reconcile_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_account_account_auto_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_account_auto_reconcile_wizard_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_account';


--
-- Name: account_account_account_import_summary_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_account_import_summary_rel (
    account_import_summary_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_import_summary_rel OWNER TO ductin;

--
-- Name: TABLE account_account_account_import_summary_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_account_import_summary_rel IS 'RELATION BETWEEN account_import_summary AND account_account';


--
-- Name: account_account_account_journal_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_account_journal_rel (
    account_account_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_account_account_journal_rel OWNER TO ductin;

--
-- Name: TABLE account_account_account_journal_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_account_journal_rel IS 'RELATION BETWEEN account_account AND account_journal';


--
-- Name: account_account_account_merge_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_account_merge_wizard_rel (
    account_merge_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_merge_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_account_account_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_account_merge_wizard_rel IS 'RELATION BETWEEN account_merge_wizard AND account_account';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_account_tag OWNER TO ductin;

--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_exclude_res_currency_provision; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_exclude_res_currency_provision (
    account_account_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


ALTER TABLE public.account_account_exclude_res_currency_provision OWNER TO ductin;

--
-- Name: TABLE account_account_exclude_res_currency_provision; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_exclude_res_currency_provision IS 'RELATION BETWEEN account_account AND res_currency';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_id_seq OWNER TO ductin;

--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_res_company_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_res_company_rel (
    account_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_account_res_company_rel OWNER TO ductin;

--
-- Name: TABLE account_account_res_company_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_res_company_rel IS 'RELATION BETWEEN account_account AND res_company';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    color integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    applicability character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    tax_negate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_tag OWNER TO ductin;

--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.tax_negate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.tax_negate IS 'Negate Tax Balance';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_move_line_rel OWNER TO ductin;

--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_tax_repartition_line_rel OWNER TO ductin;

--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_tag_id_seq OWNER TO ductin;

--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_product_template_rel OWNER TO ductin;

--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_tax_default_rel OWNER TO ductin;

--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_accrued_orders_wizard OWNER TO ductin;

--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNER TO ductin;

--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_account OWNER TO ductin;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: account_analytic_account_account_import_summary_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_account_account_import_summary_rel (
    account_import_summary_id integer NOT NULL,
    account_analytic_account_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_account_import_summary_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_account_account_import_summary_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_account_account_import_summary_rel IS 'RELATION BETWEEN account_import_summary AND account_analytic_account';


--
-- Name: account_analytic_account_account_transfer_model_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_account_account_transfer_model_line_rel (
    account_transfer_model_line_id integer NOT NULL,
    account_analytic_account_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_account_transfer_model_line_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_account_account_transfer_model_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_account_account_transfer_model_line_rel IS 'RELATION BETWEEN account_transfer_model_line AND account_analytic_account';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO ductin;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_account_mrp_bom_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_account_mrp_bom_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_bom_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_mrp_bom_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_account_mrp_bom_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_account_mrp_bom_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_bom';


--
-- Name: account_analytic_account_mrp_production_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_account_mrp_production_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_production_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_mrp_production_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_account_mrp_production_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_account_mrp_production_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_production';


--
-- Name: account_analytic_account_mrp_workcenter_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_account_mrp_workcenter_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_workcenter_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_mrp_workcenter_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_account_mrp_workcenter_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_account_mrp_workcenter_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_workcenter';


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_applicability OWNER TO ductin;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_applicability.product_categ_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_applicability.account_prefix; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_applicability.account_prefix IS 'Financial Accounts Prefixes';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO ductin;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    sequence integer,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO ductin;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_distribution_model.product_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_distribution_model.product_categ_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_distribution_model.account_prefix; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_distribution_model.account_prefix IS 'Accounts Prefix';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO ductin;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    account_id integer,
    product_uom_id integer,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    x_plan2_id integer,
    x_plan3_id integer,
    product_id integer,
    general_account_id integer,
    journal_id integer,
    move_line_id integer,
    code character varying(8),
    ref character varying,
    task_id integer,
    parent_task_id integer,
    project_id integer,
    department_id integer,
    manager_id integer,
    employee_id integer,
    so_line integer,
    holiday_id integer,
    global_leave_id integer,
    validated boolean,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    time_start double precision,
    helpdesk_ticket_id integer,
    slot_id integer,
    timesheet_invoice_id integer,
    order_id integer,
    timesheet_invoice_type character varying,
    is_so_line_edited boolean
);


ALTER TABLE public.account_analytic_line OWNER TO ductin;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Project Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.x_plan2_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_line.x_plan3_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.x_plan3_id IS 'Internal';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.journal_id IS 'Financial Journal';


--
-- Name: COLUMN account_analytic_line.move_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.employee_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: COLUMN account_analytic_line.holiday_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.holiday_id IS 'Time Off Request';


--
-- Name: COLUMN account_analytic_line.global_leave_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.global_leave_id IS 'Global Time Off';


--
-- Name: COLUMN account_analytic_line.validated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.validated IS 'Validated line';


--
-- Name: COLUMN account_analytic_line.time_start; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.time_start IS 'Start Time';


--
-- Name: COLUMN account_analytic_line.slot_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.slot_id IS 'Planning Shift';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_id IS 'Invoice';


--
-- Name: COLUMN account_analytic_line.order_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.order_id IS 'Order Reference';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_type IS 'Billable Type';


--
-- Name: COLUMN account_analytic_line.is_so_line_edited; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_line.is_so_line_edited IS 'Is Sales Order Item Manually Edited';


--
-- Name: account_analytic_line_account_import_summary_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_line_account_import_summary_rel (
    account_import_summary_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_account_import_summary_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_line_account_import_summary_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_line_account_import_summary_rel IS 'RELATION BETWEEN account_import_summary AND account_analytic_line';


--
-- Name: account_analytic_line_hr_timesheet_merge_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel (
    hr_timesheet_merge_wizard_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_line_hr_timesheet_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel IS 'RELATION BETWEEN hr_timesheet_merge_wizard AND account_analytic_line';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO ductin;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_line_mrp_workorder_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_line_mrp_workorder_rel (
    mrp_workorder_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_mrp_workorder_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_line_mrp_workorder_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_line_mrp_workorder_rel IS 'RELATION BETWEEN mrp_workorder AND account_analytic_line';


--
-- Name: account_analytic_line_stock_move_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_line_stock_move_rel (
    stock_move_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_stock_move_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_line_stock_move_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_line_stock_move_rel IS 'RELATION BETWEEN stock_move AND account_analytic_line';


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    complete_name character varying,
    name jsonb NOT NULL,
    default_applicability jsonb,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_plan OWNER TO ductin;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: account_analytic_plan_budget_split_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_analytic_plan_budget_split_wizard_rel (
    budget_split_wizard_id integer NOT NULL,
    account_analytic_plan_id integer NOT NULL
);


ALTER TABLE public.account_analytic_plan_budget_split_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_analytic_plan_budget_split_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_analytic_plan_budget_split_wizard_rel IS 'RELATION BETWEEN budget_split_wizard AND account_analytic_plan';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO ductin;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: account_asset; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_asset (
    id integer NOT NULL,
    company_id integer NOT NULL,
    currency_id integer,
    method_number integer,
    account_asset_id integer,
    asset_group_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    journal_id integer,
    model_id integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    method character varying,
    method_period character varying,
    prorata_computation_type character varying NOT NULL,
    prorata_date date NOT NULL,
    acquisition_date date,
    disposal_date date,
    analytic_distribution jsonb,
    asset_properties_definition jsonb,
    asset_properties jsonb,
    original_value numeric,
    book_value numeric,
    salvage_value numeric,
    non_deductible_tax_value numeric,
    already_depreciated_amount_import numeric,
    net_gain_on_sale numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    method_progress_factor double precision,
    salvage_value_pct double precision,
    asset_paused_days double precision,
    vehicle_id integer
);


ALTER TABLE public.account_asset OWNER TO ductin;

--
-- Name: TABLE account_asset; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_asset IS 'Asset/Revenue Recognition';


--
-- Name: COLUMN account_asset.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.company_id IS 'Company';


--
-- Name: COLUMN account_asset.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.currency_id IS 'Currency';


--
-- Name: COLUMN account_asset.method_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.method_number IS 'Duration';


--
-- Name: COLUMN account_asset.account_asset_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.account_asset_id IS 'Fixed Asset Account';


--
-- Name: COLUMN account_asset.asset_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_asset.account_depreciation_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN account_asset.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN account_asset.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.journal_id IS 'Journal';


--
-- Name: COLUMN account_asset.model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.model_id IS 'Model';


--
-- Name: COLUMN account_asset.parent_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.parent_id IS 'Parent';


--
-- Name: COLUMN account_asset.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.name IS 'Asset Name';


--
-- Name: COLUMN account_asset.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.state IS 'Status';


--
-- Name: COLUMN account_asset.method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.method IS 'Method';


--
-- Name: COLUMN account_asset.method_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN account_asset.prorata_computation_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.prorata_computation_type IS 'Computation';


--
-- Name: COLUMN account_asset.prorata_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.prorata_date IS 'Prorata Date';


--
-- Name: COLUMN account_asset.acquisition_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.acquisition_date IS 'Acquisition Date';


--
-- Name: COLUMN account_asset.disposal_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.disposal_date IS 'Disposal Date';


--
-- Name: COLUMN account_asset.analytic_distribution; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_asset.asset_properties_definition; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.asset_properties_definition IS 'Model Properties';


--
-- Name: COLUMN account_asset.asset_properties; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.asset_properties IS 'Properties';


--
-- Name: COLUMN account_asset.original_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.original_value IS 'Original Value';


--
-- Name: COLUMN account_asset.book_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.book_value IS 'Book Value';


--
-- Name: COLUMN account_asset.salvage_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.salvage_value IS 'Not Depreciable Value';


--
-- Name: COLUMN account_asset.non_deductible_tax_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.non_deductible_tax_value IS 'Non Deductible Tax Value';


--
-- Name: COLUMN account_asset.already_depreciated_amount_import; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.already_depreciated_amount_import IS 'Already Depreciated Amount Import';


--
-- Name: COLUMN account_asset.net_gain_on_sale; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.net_gain_on_sale IS 'Net gain on sale';


--
-- Name: COLUMN account_asset.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.active IS 'Active';


--
-- Name: COLUMN account_asset.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.create_date IS 'Created on';


--
-- Name: COLUMN account_asset.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_asset.method_progress_factor; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.method_progress_factor IS 'Declining Factor';


--
-- Name: COLUMN account_asset.salvage_value_pct; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.salvage_value_pct IS 'Not Depreciable Value Percent';


--
-- Name: COLUMN account_asset.asset_paused_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.asset_paused_days IS 'Asset Paused Days';


--
-- Name: COLUMN account_asset.vehicle_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset.vehicle_id IS 'Vehicle';


--
-- Name: account_asset_group; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_asset_group (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_asset_group OWNER TO ductin;

--
-- Name: TABLE account_asset_group; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_asset_group IS 'Asset Group';


--
-- Name: COLUMN account_asset_group.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset_group.company_id IS 'Company';


--
-- Name: COLUMN account_asset_group.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset_group.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset_group.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset_group.name IS 'Name';


--
-- Name: COLUMN account_asset_group.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset_group.create_date IS 'Created on';


--
-- Name: COLUMN account_asset_group.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_asset_group.write_date IS 'Last Updated on';


--
-- Name: account_asset_group_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_asset_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_group_id_seq OWNER TO ductin;

--
-- Name: account_asset_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_asset_group_id_seq OWNED BY public.account_asset_group.id;


--
-- Name: account_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_id_seq OWNER TO ductin;

--
-- Name: account_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_asset_id_seq OWNED BY public.account_asset.id;


--
-- Name: account_auto_reconcile_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_auto_reconcile_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    search_mode character varying NOT NULL,
    from_date date,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_auto_reconcile_wizard OWNER TO ductin;

--
-- Name: TABLE account_auto_reconcile_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_auto_reconcile_wizard IS 'Account automatic reconciliation wizard';


--
-- Name: COLUMN account_auto_reconcile_wizard.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_auto_reconcile_wizard.search_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.search_mode IS 'Reconcile';


--
-- Name: COLUMN account_auto_reconcile_wizard.from_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.from_date IS 'From';


--
-- Name: COLUMN account_auto_reconcile_wizard.to_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.to_date IS 'To';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_auto_reconcile_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_auto_reconcile_wizard_account_move_line_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_account_move_line_rel OWNER TO ductin;

--
-- Name: TABLE account_auto_reconcile_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_account_move_line_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_move_line';


--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_auto_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNER TO ductin;

--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNED BY public.account_auto_reconcile_wizard.id;


--
-- Name: account_auto_reconcile_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_auto_reconcile_wizard_res_partner_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_res_partner_rel OWNER TO ductin;

--
-- Name: TABLE account_auto_reconcile_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_res_partner_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND res_partner';


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    account_type character varying,
    date date NOT NULL,
    total_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage double precision
);


ALTER TABLE public.account_automatic_entry_wizard OWNER TO ductin;

--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_automatic_entry_wizard_account_move_line_rel OWNER TO ductin;

--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNER TO ductin;

--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_autopost_bills_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_autopost_bills_wizard (
    id integer NOT NULL,
    partner_id integer,
    nb_unmodified_bills integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_autopost_bills_wizard OWNER TO ductin;

--
-- Name: TABLE account_autopost_bills_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_autopost_bills_wizard IS 'Autopost Bills Wizard';


--
-- Name: COLUMN account_autopost_bills_wizard.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN account_autopost_bills_wizard.nb_unmodified_bills; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.nb_unmodified_bills IS 'Number of bills previously unmodified from this partner';


--
-- Name: COLUMN account_autopost_bills_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_autopost_bills_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_autopost_bills_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_autopost_bills_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_date IS 'Last Updated on';


--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_autopost_bills_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNER TO ductin;

--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNED BY public.account_autopost_bills_wizard.id;


--
-- Name: account_bank_selection; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_bank_selection (
    id integer NOT NULL,
    account_online_link_id integer,
    selected_account integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_selection OWNER TO ductin;

--
-- Name: TABLE account_bank_selection; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_bank_selection IS 'Link a bank account to the selected journal';


--
-- Name: COLUMN account_bank_selection.account_online_link_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_selection.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_selection.selected_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_selection.selected_account IS 'Selected Account';


--
-- Name: COLUMN account_bank_selection.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_selection.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_selection.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_selection.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_selection.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_selection.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_selection.write_date IS 'Last Updated on';


--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_bank_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_selection_id_seq OWNER TO ductin;

--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_bank_selection_id_seq OWNED BY public.account_bank_selection.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    company_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reference character varying,
    first_line_index character varying,
    date date,
    balance_start numeric,
    balance_end numeric,
    balance_end_real numeric,
    is_complete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    message_main_attachment_id integer,
    coda_note text,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    is_in_extractable_state boolean,
    extract_state_processed boolean
);


ALTER TABLE public.account_bank_statement OWNER TO ductin;

--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.first_line_index; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.first_line_index IS 'First Line Index';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.is_complete; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.is_complete IS 'Is Complete';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement.coda_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.coda_note IS 'CODA Notes';


--
-- Name: COLUMN account_bank_statement.extract_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.extract_state IS 'Extract state';


--
-- Name: COLUMN account_bank_statement.extract_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.extract_status IS 'Extract status';


--
-- Name: COLUMN account_bank_statement.extract_document_uuid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_bank_statement.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_bank_statement.extract_state_processed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement.extract_state_processed IS 'Extract State Processed';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_id_seq OWNER TO ductin;

--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_ir_attachment_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_bank_statement_ir_attachment_rel (
    account_bank_statement_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_bank_statement_ir_attachment_rel OWNER TO ductin;

--
-- Name: TABLE account_bank_statement_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_bank_statement_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement AND ir_attachment';


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    statement_id integer,
    sequence integer,
    partner_id integer,
    currency_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying,
    internal_index character varying,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    is_reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount_residual double precision,
    cron_last_check timestamp without time zone,
    unique_import_id character varying,
    online_account_id integer,
    online_link_id integer,
    online_transaction_identifier character varying,
    online_partner_information character varying,
    pos_session_id integer,
    employee_id integer
);


ALTER TABLE public.account_bank_statement_line OWNER TO ductin;

--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.internal_index; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.internal_index IS 'Internal Reference';


--
-- Name: COLUMN account_bank_statement_line.transaction_details; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_bank_statement_line.cron_last_check; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.cron_last_check IS 'Cron Last Check';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: COLUMN account_bank_statement_line.online_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.online_account_id IS 'Online Account';


--
-- Name: COLUMN account_bank_statement_line.online_link_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_statement_line.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line.online_partner_information; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.online_partner_information IS 'Online Partner Information';


--
-- Name: COLUMN account_bank_statement_line.pos_session_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.pos_session_id IS 'Session';


--
-- Name: COLUMN account_bank_statement_line.employee_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line.employee_id IS 'Employee';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNER TO ductin;

--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_bank_statement_line_transient; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_bank_statement_line_transient (
    id integer NOT NULL,
    sequence integer,
    journal_id integer,
    online_account_id integer,
    company_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    online_transaction_identifier character varying,
    payment_ref character varying,
    account_number character varying,
    partner_name character varying,
    state character varying,
    date date,
    transaction_details text,
    amount numeric,
    amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement_line_transient OWNER TO ductin;

--
-- Name: TABLE account_bank_statement_line_transient; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_bank_statement_line_transient IS 'Transient model for bank statement line';


--
-- Name: COLUMN account_bank_statement_line_transient.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line_transient.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line_transient.online_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_bank_statement_line_transient.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line_transient.foreign_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line_transient.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line_transient.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line_transient.payment_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.payment_ref IS 'Payment Ref';


--
-- Name: COLUMN account_bank_statement_line_transient.account_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.account_number IS 'Account Number';


--
-- Name: COLUMN account_bank_statement_line_transient.partner_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line_transient.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.state IS 'State';


--
-- Name: COLUMN account_bank_statement_line_transient.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.date IS 'Date';


--
-- Name: COLUMN account_bank_statement_line_transient.transaction_details; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line_transient.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line_transient.amount_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line_transient.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_bank_statement_line_transient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNER TO ductin;

--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNED BY public.account_bank_statement_line_transient.id;


--
-- Name: account_batch_error_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_batch_error_wizard (
    id integer NOT NULL,
    batch_payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_remove_options boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard OWNER TO ductin;

--
-- Name: TABLE account_batch_error_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_batch_error_wizard IS 'Batch payments error reporting wizard';


--
-- Name: COLUMN account_batch_error_wizard.batch_payment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_batch_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard.show_remove_options; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard.show_remove_options IS 'Show Remove Options';


--
-- Name: COLUMN account_batch_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_batch_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNER TO ductin;

--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNED BY public.account_batch_error_wizard.id;


--
-- Name: account_batch_error_wizard_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_batch_error_wizard_line (
    id integer NOT NULL,
    error_wizard_id integer,
    warning_wizard_id integer,
    create_uid integer,
    write_uid integer,
    description character varying NOT NULL,
    help_message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard_line OWNER TO ductin;

--
-- Name: TABLE account_batch_error_wizard_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_batch_error_wizard_line IS 'Batch payments error reporting wizard line';


--
-- Name: COLUMN account_batch_error_wizard_line.error_wizard_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.error_wizard_id IS 'Error Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.warning_wizard_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.warning_wizard_id IS 'Warning Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard_line.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.description IS 'Description';


--
-- Name: COLUMN account_batch_error_wizard_line.help_message; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.help_message IS 'Help';


--
-- Name: COLUMN account_batch_error_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_line_account_payment_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_batch_error_wizard_line_account_payment_rel (
    account_batch_error_wizard_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_error_wizard_line_account_payment_rel OWNER TO ductin;

--
-- Name: TABLE account_batch_error_wizard_line_account_payment_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_batch_error_wizard_line_account_payment_rel IS 'RELATION BETWEEN account_batch_error_wizard_line AND account_payment';


--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_batch_error_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNER TO ductin;

--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNED BY public.account_batch_error_wizard_line.id;


--
-- Name: account_batch_payment; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_batch_payment (
    id integer NOT NULL,
    journal_id integer,
    currency_id integer,
    company_currency_id integer,
    payment_method_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    batch_type character varying NOT NULL,
    export_filename character varying,
    date date NOT NULL,
    export_file_create_date date,
    amount_residual numeric,
    amount_residual_currency numeric,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    iso20022_charge_bearer character varying,
    iso20022_batch_booking boolean,
    sdd_scheme character varying,
    sdd_required_collection_date date,
    sdd_batch_booking boolean,
    payment_identifier character varying,
    redirect_url character varying,
    payment_online_status character varying
);


ALTER TABLE public.account_batch_payment OWNER TO ductin;

--
-- Name: TABLE account_batch_payment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_batch_payment IS 'Batch Payment';


--
-- Name: COLUMN account_batch_payment.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.journal_id IS 'Bank';


--
-- Name: COLUMN account_batch_payment.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_batch_payment.company_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_batch_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_batch_payment.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.name IS 'Reference';


--
-- Name: COLUMN account_batch_payment.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.state IS 'State';


--
-- Name: COLUMN account_batch_payment.batch_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.batch_type IS 'Batch Type';


--
-- Name: COLUMN account_batch_payment.export_filename; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.export_filename IS 'File Name';


--
-- Name: COLUMN account_batch_payment.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.date IS 'Date';


--
-- Name: COLUMN account_batch_payment.export_file_create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.export_file_create_date IS 'Generation Date';


--
-- Name: COLUMN account_batch_payment.amount_residual; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual IS 'Amount Residual';


--
-- Name: COLUMN account_batch_payment.amount_residual_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual_currency IS 'Amount Residual Currency';


--
-- Name: COLUMN account_batch_payment.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.amount IS 'Amount';


--
-- Name: COLUMN account_batch_payment.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_batch_payment.iso20022_charge_bearer; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.iso20022_charge_bearer IS 'Charge Bearer';


--
-- Name: COLUMN account_batch_payment.iso20022_batch_booking; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.iso20022_batch_booking IS 'SCT Batch Booking';


--
-- Name: COLUMN account_batch_payment.sdd_scheme; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.sdd_scheme IS 'SDD Scheme';


--
-- Name: COLUMN account_batch_payment.sdd_required_collection_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.sdd_required_collection_date IS 'Required Collection Date';


--
-- Name: COLUMN account_batch_payment.sdd_batch_booking; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.sdd_batch_booking IS 'SDD Batch Booking';


--
-- Name: COLUMN account_batch_payment.payment_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.payment_identifier IS 'Batch ID';


--
-- Name: COLUMN account_batch_payment.redirect_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.redirect_url IS 'Redirect URL';


--
-- Name: COLUMN account_batch_payment.payment_online_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment.payment_online_status IS 'PIS Status';


--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_batch_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_id_seq OWNER TO ductin;

--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_batch_payment_id_seq OWNED BY public.account_batch_payment.id;


--
-- Name: account_batch_payment_rejection; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_batch_payment_rejection (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_payment_rejection OWNER TO ductin;

--
-- Name: TABLE account_batch_payment_rejection; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_batch_payment_rejection IS 'Manage the payment rejection from batch payments';


--
-- Name: COLUMN account_batch_payment_rejection.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment_rejection.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment_rejection.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment_rejection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment_rejection.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment_rejection.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment_rejection.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_batch_payment_rejection.write_date IS 'Last Updated on';


--
-- Name: account_batch_payment_rejection_account_payment_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_batch_payment_rejection_account_payment_rel (
    account_batch_payment_rejection_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_payment_rejection_account_payment_rel OWNER TO ductin;

--
-- Name: TABLE account_batch_payment_rejection_account_payment_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_batch_payment_rejection_account_payment_rel IS 'RELATION BETWEEN account_batch_payment_rejection AND account_payment';


--
-- Name: account_batch_payment_rejection_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_batch_payment_rejection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_rejection_id_seq OWNER TO ductin;

--
-- Name: account_batch_payment_rejection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_batch_payment_rejection_id_seq OWNED BY public.account_batch_payment_rejection.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    name jsonb NOT NULL,
    profit_account_id jsonb,
    loss_account_id jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_cash_rounding OWNER TO ductin;

--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.profit_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_cash_rounding.loss_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cash_rounding_id_seq OWNER TO ductin;

--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_change_lock_date; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_change_lock_date (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    exception_applies_to character varying NOT NULL,
    exception_duration character varying NOT NULL,
    exception_reason character varying,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_lock_date OWNER TO ductin;

--
-- Name: TABLE account_change_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_change_lock_date IS 'Change Lock Date';


--
-- Name: COLUMN account_change_lock_date.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.company_id IS 'Company';


--
-- Name: COLUMN account_change_lock_date.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_lock_date.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_lock_date.exception_applies_to; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.exception_applies_to IS 'Exception applies';


--
-- Name: COLUMN account_change_lock_date.exception_duration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.exception_duration IS 'Exception Duration';


--
-- Name: COLUMN account_change_lock_date.exception_reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.exception_reason IS 'Exception Reason';


--
-- Name: COLUMN account_change_lock_date.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.fiscalyear_lock_date IS 'Lock Everything';


--
-- Name: COLUMN account_change_lock_date.tax_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.tax_lock_date IS 'Lock Tax Return';


--
-- Name: COLUMN account_change_lock_date.sale_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.sale_lock_date IS 'Lock Sales';


--
-- Name: COLUMN account_change_lock_date.purchase_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.purchase_lock_date IS 'Lock Purchases';


--
-- Name: COLUMN account_change_lock_date.hard_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.hard_lock_date IS 'Hard Lock';


--
-- Name: COLUMN account_change_lock_date.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.create_date IS 'Created on';


--
-- Name: COLUMN account_change_lock_date.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_change_lock_date.write_date IS 'Last Updated on';


--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_change_lock_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_lock_date_id_seq OWNER TO ductin;

--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_change_lock_date_id_seq OWNED BY public.account_change_lock_date.id;


--
-- Name: account_debit_note; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_debit_note (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date NOT NULL,
    copy_lines boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_debit_note OWNER TO ductin;

--
-- Name: TABLE account_debit_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_debit_note IS 'Add Debit Note wizard';


--
-- Name: COLUMN account_debit_note.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_debit_note.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_debit_note.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_debit_note.create_uid IS 'Created by';


--
-- Name: COLUMN account_debit_note.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_debit_note.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_debit_note.reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_debit_note.reason IS 'Reason';


--
-- Name: COLUMN account_debit_note.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_debit_note.date IS 'Debit Note Date';


--
-- Name: COLUMN account_debit_note.copy_lines; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_debit_note.copy_lines IS 'Copy Lines';


--
-- Name: COLUMN account_debit_note.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_debit_note.create_date IS 'Created on';


--
-- Name: COLUMN account_debit_note.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_debit_note.write_date IS 'Last Updated on';


--
-- Name: account_debit_note_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_debit_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_debit_note_id_seq OWNER TO ductin;

--
-- Name: account_debit_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_debit_note_id_seq OWNED BY public.account_debit_note.id;


--
-- Name: account_disallowed_expenses_category; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_disallowed_expenses_category (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    car_category boolean
);


ALTER TABLE public.account_disallowed_expenses_category OWNER TO ductin;

--
-- Name: TABLE account_disallowed_expenses_category; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_disallowed_expenses_category IS 'Disallowed Expenses Category';


--
-- Name: COLUMN account_disallowed_expenses_category.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.company_id IS 'Company';


--
-- Name: COLUMN account_disallowed_expenses_category.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.create_uid IS 'Created by';


--
-- Name: COLUMN account_disallowed_expenses_category.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_disallowed_expenses_category.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.code IS 'Code';


--
-- Name: COLUMN account_disallowed_expenses_category.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.name IS 'Name';


--
-- Name: COLUMN account_disallowed_expenses_category.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.active IS 'Active';


--
-- Name: COLUMN account_disallowed_expenses_category.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.create_date IS 'Created on';


--
-- Name: COLUMN account_disallowed_expenses_category.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_disallowed_expenses_category.car_category; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.car_category IS 'Make Vehicle Required';


--
-- Name: account_disallowed_expenses_category_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_disallowed_expenses_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_disallowed_expenses_category_id_seq OWNER TO ductin;

--
-- Name: account_disallowed_expenses_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_disallowed_expenses_category_id_seq OWNED BY public.account_disallowed_expenses_category.id;


--
-- Name: account_disallowed_expenses_rate; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_disallowed_expenses_rate (
    id integer NOT NULL,
    category_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate double precision NOT NULL
);


ALTER TABLE public.account_disallowed_expenses_rate OWNER TO ductin;

--
-- Name: TABLE account_disallowed_expenses_rate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_disallowed_expenses_rate IS 'Disallowed Expenses Rate';


--
-- Name: COLUMN account_disallowed_expenses_rate.category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.category_id IS 'Category';


--
-- Name: COLUMN account_disallowed_expenses_rate.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.company_id IS 'Company';


--
-- Name: COLUMN account_disallowed_expenses_rate.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_disallowed_expenses_rate.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_disallowed_expenses_rate.date_from; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.date_from IS 'Start Date';


--
-- Name: COLUMN account_disallowed_expenses_rate.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_disallowed_expenses_rate.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_disallowed_expenses_rate.rate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.rate IS 'Disallowed %';


--
-- Name: account_disallowed_expenses_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_disallowed_expenses_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_disallowed_expenses_rate_id_seq OWNER TO ductin;

--
-- Name: account_disallowed_expenses_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_disallowed_expenses_rate_id_seq OWNED BY public.account_disallowed_expenses_rate.id;


--
-- Name: account_duplicate_transaction_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_duplicate_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_duplicate_transaction_wizard OWNER TO ductin;

--
-- Name: TABLE account_duplicate_transaction_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_duplicate_transaction_wizard IS 'Wizard for duplicate transactions';


--
-- Name: COLUMN account_duplicate_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_duplicate_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNER TO ductin;

--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNED BY public.account_duplicate_transaction_wizard.id;


--
-- Name: account_edi_document; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_edi_document (
    id integer NOT NULL,
    move_id integer NOT NULL,
    edi_format_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    blocking_level character varying,
    error text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_edi_document OWNER TO ductin;

--
-- Name: TABLE account_edi_document; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_edi_document IS 'Electronic Document for an account.move';


--
-- Name: COLUMN account_edi_document.move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.move_id IS 'Move';


--
-- Name: COLUMN account_edi_document.edi_format_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.edi_format_id IS 'Edi Format';


--
-- Name: COLUMN account_edi_document.attachment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.attachment_id IS 'Attachment';


--
-- Name: COLUMN account_edi_document.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_document.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_document.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.state IS 'State';


--
-- Name: COLUMN account_edi_document.blocking_level; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.blocking_level IS 'Blocking Level';


--
-- Name: COLUMN account_edi_document.error; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.error IS 'Error';


--
-- Name: COLUMN account_edi_document.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_document.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_document.write_date IS 'Last Updated on';


--
-- Name: account_edi_document_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_edi_document_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_document_id_seq OWNER TO ductin;

--
-- Name: account_edi_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_edi_document_id_seq OWNED BY public.account_edi_document.id;


--
-- Name: account_edi_format; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_edi_format (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_edi_format OWNER TO ductin;

--
-- Name: TABLE account_edi_format; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_edi_format IS 'EDI format';


--
-- Name: COLUMN account_edi_format.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_format.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_format.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_format.name IS 'Name';


--
-- Name: COLUMN account_edi_format.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_format.code IS 'Code';


--
-- Name: COLUMN account_edi_format.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_format.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_format.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_format.write_date IS 'Last Updated on';


--
-- Name: account_edi_format_account_journal_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_edi_format_account_journal_rel (
    account_journal_id integer NOT NULL,
    account_edi_format_id integer NOT NULL
);


ALTER TABLE public.account_edi_format_account_journal_rel OWNER TO ductin;

--
-- Name: TABLE account_edi_format_account_journal_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_edi_format_account_journal_rel IS 'RELATION BETWEEN account_journal AND account_edi_format';


--
-- Name: account_edi_format_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_edi_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_format_id_seq OWNER TO ductin;

--
-- Name: account_edi_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_edi_format_id_seq OWNED BY public.account_edi_format.id;


--
-- Name: account_edi_proxy_client_user; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_edi_proxy_client_user (
    id integer NOT NULL,
    company_id integer NOT NULL,
    private_key_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    id_client character varying NOT NULL,
    edi_identification character varying NOT NULL,
    refresh_token character varying,
    proxy_type character varying NOT NULL,
    edi_mode character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    peppol_verification_code character varying
);


ALTER TABLE public.account_edi_proxy_client_user OWNER TO ductin;

--
-- Name: TABLE account_edi_proxy_client_user; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_edi_proxy_client_user IS 'Account EDI proxy user';


--
-- Name: COLUMN account_edi_proxy_client_user.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.company_id IS 'Company';


--
-- Name: COLUMN account_edi_proxy_client_user.private_key_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.private_key_id IS 'Private Key';


--
-- Name: COLUMN account_edi_proxy_client_user.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_proxy_client_user.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_proxy_client_user.id_client; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.id_client IS 'Id Client';


--
-- Name: COLUMN account_edi_proxy_client_user.edi_identification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.edi_identification IS 'Edi Identification';


--
-- Name: COLUMN account_edi_proxy_client_user.refresh_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.refresh_token IS 'Refresh Token';


--
-- Name: COLUMN account_edi_proxy_client_user.proxy_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.proxy_type IS 'Proxy Type';


--
-- Name: COLUMN account_edi_proxy_client_user.edi_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.edi_mode IS 'EDI operating mode';


--
-- Name: COLUMN account_edi_proxy_client_user.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.active IS 'Active';


--
-- Name: COLUMN account_edi_proxy_client_user.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_proxy_client_user.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_edi_proxy_client_user.peppol_verification_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_edi_proxy_client_user.peppol_verification_code IS 'SMS verification code';


--
-- Name: account_edi_proxy_client_user_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_edi_proxy_client_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_proxy_client_user_id_seq OWNER TO ductin;

--
-- Name: account_edi_proxy_client_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_edi_proxy_client_user_id_seq OWNED BY public.account_edi_proxy_client_user.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_financial_year_op OWNER TO ductin;

--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_financial_year_op_id_seq OWNER TO ductin;

--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    auto_apply boolean,
    vat_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    avatax_invoice_account_id integer,
    avatax_refund_account_id integer,
    is_avatax boolean
);


ALTER TABLE public.account_fiscal_position OWNER TO ductin;

--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position.avatax_invoice_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_invoice_account_id IS 'Avatax Invoice Account';


--
-- Name: COLUMN account_fiscal_position.avatax_refund_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_refund_account_id IS 'Avatax Refund Account';


--
-- Name: COLUMN account_fiscal_position.is_avatax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position.is_avatax IS 'Use AvaTax API';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account OWNER TO ductin;

--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNER TO ductin;

--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_id_seq OWNER TO ductin;

--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_pos_config_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_fiscal_position_pos_config_rel (
    pos_config_id integer NOT NULL,
    account_fiscal_position_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_pos_config_rel OWNER TO ductin;

--
-- Name: TABLE account_fiscal_position_pos_config_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_fiscal_position_pos_config_rel IS 'RELATION BETWEEN pos_config AND account_fiscal_position';


--
-- Name: account_fiscal_position_res_config_settings_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_fiscal_position_res_config_settings_rel (
    res_config_settings_id integer NOT NULL,
    account_fiscal_position_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_config_settings_rel OWNER TO ductin;

--
-- Name: TABLE account_fiscal_position_res_config_settings_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_fiscal_position_res_config_settings_rel IS 'RELATION BETWEEN res_config_settings AND account_fiscal_position';


--
-- Name: account_fiscal_position_res_config_test_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_fiscal_position_res_config_test_rel (
    res_config_test_id integer NOT NULL,
    account_fiscal_position_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_config_test_rel OWNER TO ductin;

--
-- Name: TABLE account_fiscal_position_res_config_test_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_fiscal_position_res_config_test_rel IS 'RELATION BETWEEN res_config_test AND account_fiscal_position';


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_country_state_rel OWNER TO ductin;

--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_fiscal_position_tax (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_tax OWNER TO ductin;

--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_fiscal_position_tax IS 'Tax Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_tax.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_src_id IS 'Tax on Product';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_dest_id IS 'Tax to Apply';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_fiscal_position_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNER TO ductin;

--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNED BY public.account_fiscal_position_tax.id;


--
-- Name: account_fiscal_year; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_fiscal_year (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_year OWNER TO ductin;

--
-- Name: TABLE account_fiscal_year; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_fiscal_year IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscal_year.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_year.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_year.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_year.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_year.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_year.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_year.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_year.name IS 'Name';


--
-- Name: COLUMN account_fiscal_year.date_from; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_year.date_from IS 'Start Date';


--
-- Name: COLUMN account_fiscal_year.date_to; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_year.date_to IS 'End Date';


--
-- Name: COLUMN account_fiscal_year.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_year.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_year.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_fiscal_year.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_fiscal_year_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_year_id_seq OWNER TO ductin;

--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_fiscal_year_id_seq OWNED BY public.account_fiscal_year.id;


--
-- Name: account_followup_followup_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_followup_followup_line (
    id integer NOT NULL,
    delay integer NOT NULL,
    company_id integer NOT NULL,
    mail_template_id integer,
    sms_template_id integer,
    activity_type_id integer,
    create_uid integer,
    write_uid integer,
    activity_summary character varying,
    activity_default_responsible_type character varying NOT NULL,
    name jsonb NOT NULL,
    activity_note text,
    send_email boolean,
    join_invoices boolean,
    send_sms boolean,
    create_activity boolean,
    auto_execute boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    send_letter boolean
);


ALTER TABLE public.account_followup_followup_line OWNER TO ductin;

--
-- Name: TABLE account_followup_followup_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_followup_followup_line IS 'Follow-up Criteria';


--
-- Name: COLUMN account_followup_followup_line.delay; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.delay IS 'Due Days';


--
-- Name: COLUMN account_followup_followup_line.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.company_id IS 'Company';


--
-- Name: COLUMN account_followup_followup_line.mail_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.mail_template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_followup_line.sms_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_followup_line.activity_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN account_followup_followup_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_followup_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_followup_line.activity_summary; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_summary IS 'Summary';


--
-- Name: COLUMN account_followup_followup_line.activity_default_responsible_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_default_responsible_type IS 'Responsible';


--
-- Name: COLUMN account_followup_followup_line.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.name IS 'Description';


--
-- Name: COLUMN account_followup_followup_line.activity_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_note IS 'Note';


--
-- Name: COLUMN account_followup_followup_line.send_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.send_email IS 'Send Email';


--
-- Name: COLUMN account_followup_followup_line.join_invoices; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_followup_line.send_sms; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.send_sms IS 'Send SMS Message';


--
-- Name: COLUMN account_followup_followup_line.create_activity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.create_activity IS 'Schedule Activity';


--
-- Name: COLUMN account_followup_followup_line.auto_execute; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.auto_execute IS 'Automatic';


--
-- Name: COLUMN account_followup_followup_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_followup_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_followup_line.send_letter; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_followup_line.send_letter IS 'Send a Letter';


--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_followup_followup_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNER TO ductin;

--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNED BY public.account_followup_followup_line.id;


--
-- Name: account_followup_followup_line_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_followup_followup_line_res_users_rel (
    account_followup_followup_line_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_followup_followup_line_res_users_rel OWNER TO ductin;

--
-- Name: TABLE account_followup_followup_line_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_followup_followup_line_res_users_rel IS 'RELATION BETWEEN account_followup_followup_line AND res_users';


--
-- Name: account_followup_manual_reminder; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_followup_manual_reminder (
    id integer NOT NULL,
    template_id integer,
    partner_id integer,
    sms_template_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    sms_body character varying,
    body text,
    email boolean,
    sms boolean,
    print boolean,
    join_invoices boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    snailmail boolean
);


ALTER TABLE public.account_followup_manual_reminder OWNER TO ductin;

--
-- Name: TABLE account_followup_manual_reminder; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_followup_manual_reminder IS 'Wizard for sending manual reminders to clients';


--
-- Name: COLUMN account_followup_manual_reminder.template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_manual_reminder.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.partner_id IS 'Partner';


--
-- Name: COLUMN account_followup_manual_reminder.sms_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_manual_reminder.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_manual_reminder.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_manual_reminder.lang; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.lang IS 'Language';


--
-- Name: COLUMN account_followup_manual_reminder.subject; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.subject IS 'Subject';


--
-- Name: COLUMN account_followup_manual_reminder.sms_body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_body IS 'Sms Body';


--
-- Name: COLUMN account_followup_manual_reminder.body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.body IS 'Contents';


--
-- Name: COLUMN account_followup_manual_reminder.email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.email IS 'Email';


--
-- Name: COLUMN account_followup_manual_reminder.sms; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms IS 'Sms';


--
-- Name: COLUMN account_followup_manual_reminder.print; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.print IS 'Print';


--
-- Name: COLUMN account_followup_manual_reminder.join_invoices; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_manual_reminder.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_manual_reminder.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_manual_reminder.snailmail; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_manual_reminder.snailmail IS 'Snailmail';


--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_followup_manual_reminder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNER TO ductin;

--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNED BY public.account_followup_manual_reminder.id;


--
-- Name: account_followup_manual_reminder_ir_attachment_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_followup_manual_reminder_ir_attachment_rel (
    account_followup_manual_reminder_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_followup_manual_reminder_ir_attachment_rel OWNER TO ductin;

--
-- Name: TABLE account_followup_manual_reminder_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_followup_manual_reminder_ir_attachment_rel IS 'RELATION BETWEEN account_followup_manual_reminder AND ir_attachment';


--
-- Name: account_followup_missing_information_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_followup_missing_information_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_followup_missing_information_wizard OWNER TO ductin;

--
-- Name: TABLE account_followup_missing_information_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_followup_missing_information_wizard IS 'Followup missing information wizard';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_date IS 'Last Updated on';


--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_followup_missing_information_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNER TO ductin;

--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNED BY public.account_followup_missing_information_wizard.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    exchange_move_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_full_reconcile OWNER TO ductin;

--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_full_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_full_reconcile_id_seq OWNER TO ductin;

--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code_prefix_start character varying,
    code_prefix_end character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


ALTER TABLE public.account_group OWNER TO ductin;

--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_id_seq OWNER TO ductin;

--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_import_summary; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_import_summary (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    import_summary_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_import_summary OWNER TO ductin;

--
-- Name: TABLE account_import_summary; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_import_summary IS 'Account import summary view';


--
-- Name: COLUMN account_import_summary.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_import_summary.create_uid IS 'Created by';


--
-- Name: COLUMN account_import_summary.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_import_summary.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_import_summary.import_summary_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_import_summary.import_summary_name IS 'Import Summary Name';


--
-- Name: COLUMN account_import_summary.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_import_summary.create_date IS 'Created on';


--
-- Name: COLUMN account_import_summary.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_import_summary.write_date IS 'Last Updated on';


--
-- Name: account_import_summary_account_journal_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_import_summary_account_journal_rel (
    account_import_summary_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_journal_rel OWNER TO ductin;

--
-- Name: TABLE account_import_summary_account_journal_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_import_summary_account_journal_rel IS 'RELATION BETWEEN account_import_summary AND account_journal';


--
-- Name: account_import_summary_account_move_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_import_summary_account_move_rel (
    account_import_summary_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_move_rel OWNER TO ductin;

--
-- Name: TABLE account_import_summary_account_move_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_import_summary_account_move_rel IS 'RELATION BETWEEN account_import_summary AND account_move';


--
-- Name: account_import_summary_account_tax_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_import_summary_account_tax_rel (
    account_import_summary_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_tax_rel OWNER TO ductin;

--
-- Name: TABLE account_import_summary_account_tax_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_import_summary_account_tax_rel IS 'RELATION BETWEEN account_import_summary AND account_tax';


--
-- Name: account_import_summary_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_import_summary_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_import_summary_id_seq OWNER TO ductin;

--
-- Name: account_import_summary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_import_summary_id_seq OWNED BY public.account_import_summary.id;


--
-- Name: account_import_summary_res_partner_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_import_summary_res_partner_rel (
    account_import_summary_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_res_partner_rel OWNER TO ductin;

--
-- Name: TABLE account_import_summary_res_partner_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_import_summary_res_partner_rel IS 'RELATION BETWEEN account_import_summary AND res_partner';


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying(3) NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_incoterms OWNER TO ductin;

--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_incoterms_id_seq OWNER TO ductin;

--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_intrastat_code; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_intrastat_code (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    code character varying NOT NULL,
    description character varying,
    type character varying NOT NULL,
    supplementary_unit character varying,
    expiry_date date,
    start_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_intrastat_code OWNER TO ductin;

--
-- Name: TABLE account_intrastat_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_intrastat_code IS 'Intrastat Code';


--
-- Name: COLUMN account_intrastat_code.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.country_id IS 'Country';


--
-- Name: COLUMN account_intrastat_code.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.create_uid IS 'Created by';


--
-- Name: COLUMN account_intrastat_code.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_intrastat_code.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.name IS 'Name';


--
-- Name: COLUMN account_intrastat_code.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.code IS 'Code';


--
-- Name: COLUMN account_intrastat_code.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.description IS 'Description';


--
-- Name: COLUMN account_intrastat_code.type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.type IS 'Type';


--
-- Name: COLUMN account_intrastat_code.supplementary_unit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.supplementary_unit IS 'Supplementary Unit';


--
-- Name: COLUMN account_intrastat_code.expiry_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.expiry_date IS 'Expiry Date';


--
-- Name: COLUMN account_intrastat_code.start_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.start_date IS 'Usage start date';


--
-- Name: COLUMN account_intrastat_code.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.create_date IS 'Created on';


--
-- Name: COLUMN account_intrastat_code.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_intrastat_code.write_date IS 'Last Updated on';


--
-- Name: account_intrastat_code_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_intrastat_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_intrastat_code_id_seq OWNER TO ductin;

--
-- Name: account_intrastat_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_intrastat_code_id_seq OWNED BY public.account_intrastat_code.id;


--
-- Name: account_invoice_extract_words; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_invoice_extract_words (
    id integer NOT NULL,
    invoice_id integer NOT NULL,
    word_page integer,
    create_uid integer,
    write_uid integer,
    field character varying,
    word_text character varying,
    ocr_selected boolean,
    user_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "word_box_midX" double precision,
    "word_box_midY" double precision,
    word_box_width double precision,
    word_box_height double precision,
    word_box_angle double precision
);


ALTER TABLE public.account_invoice_extract_words OWNER TO ductin;

--
-- Name: TABLE account_invoice_extract_words; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_invoice_extract_words IS 'Extracted words from invoice scan';


--
-- Name: COLUMN account_invoice_extract_words.invoice_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_invoice_extract_words.word_page; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_page IS 'Word Page';


--
-- Name: COLUMN account_invoice_extract_words.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_extract_words.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_extract_words.field; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.field IS 'Field';


--
-- Name: COLUMN account_invoice_extract_words.word_text; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_text IS 'Word Text';


--
-- Name: COLUMN account_invoice_extract_words.ocr_selected; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.ocr_selected IS 'Ocr Selected';


--
-- Name: COLUMN account_invoice_extract_words.user_selected; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.user_selected IS 'User Selected';


--
-- Name: COLUMN account_invoice_extract_words.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_extract_words.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midX"; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midX" IS 'Word Box Midx';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midY"; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midY" IS 'Word Box Midy';


--
-- Name: COLUMN account_invoice_extract_words.word_box_width; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_width IS 'Word Box Width';


--
-- Name: COLUMN account_invoice_extract_words.word_box_height; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_height IS 'Word Box Height';


--
-- Name: COLUMN account_invoice_extract_words.word_box_angle; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_angle IS 'Word Box Angle';


--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_invoice_extract_words_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNER TO ductin;

--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNED BY public.account_invoice_extract_words.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


ALTER TABLE public.account_invoice_transaction_rel OWNER TO ductin;

--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    alias_id integer,
    default_account_id integer,
    suspense_account_id integer,
    sequence integer,
    currency_id integer,
    company_id integer NOT NULL,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    create_uid integer,
    write_uid integer,
    color integer,
    access_token character varying,
    code character varying(5) NOT NULL,
    type character varying NOT NULL,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    bank_statements_source character varying,
    name jsonb NOT NULL,
    sequence_override_regex text,
    active boolean,
    autocheck_on_post boolean,
    restrict_mode_hash_table boolean,
    refund_sequence boolean,
    payment_sequence boolean,
    show_on_dashboard boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    check_sequence_id integer,
    bank_check_printing_layout character varying,
    check_manual_sequencing boolean,
    debit_sequence boolean,
    sepa_pain_version character varying,
    account_online_account_id integer,
    account_online_link_id integer,
    renewal_contact_email character varying,
    is_peppol_journal boolean,
    debit_sepa_pain_version character varying NOT NULL,
    nacha_immediate_destination character varying,
    nacha_destination character varying,
    nacha_immediate_origin character varying,
    nacha_company_identification character varying,
    nacha_origination_dfi_identification character varying,
    nacha_entry_class_code character varying NOT NULL,
    nacha_discretionary_data character varying(20),
    nacha_is_balanced boolean,
    qif_decimal_point character varying,
    qif_date_format character varying,
    is_self_billing boolean,
    coda_split_transactions boolean,
    country_id integer,
    payment_note text,
    loan_properties_definition jsonb
);


ALTER TABLE public.account_journal OWNER TO ductin;

--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Alias';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.access_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.access_token IS 'Security Token';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.code IS 'Short Code';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.autocheck_on_post; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.autocheck_on_post IS 'Auto-Check on Post';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Secure Posted Entries with Hash';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.payment_sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.payment_sequence IS 'Dedicated Payment Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.check_sequence_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.check_sequence_id IS 'Check Sequence';


--
-- Name: COLUMN account_journal.bank_check_printing_layout; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.bank_check_printing_layout IS 'Check Layout';


--
-- Name: COLUMN account_journal.check_manual_sequencing; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.check_manual_sequencing IS 'Manual Numbering';


--
-- Name: COLUMN account_journal.debit_sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.debit_sequence IS 'Dedicated Debit Note Sequence';


--
-- Name: COLUMN account_journal.sepa_pain_version; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.sepa_pain_version IS 'XML Format';


--
-- Name: COLUMN account_journal.account_online_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.account_online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_journal.account_online_link_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_journal.renewal_contact_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.renewal_contact_email IS 'Connection Requests';


--
-- Name: COLUMN account_journal.is_peppol_journal; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.is_peppol_journal IS 'Account used for Peppol';


--
-- Name: COLUMN account_journal.debit_sepa_pain_version; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.debit_sepa_pain_version IS 'SEPA Direct Debit Pain Version';


--
-- Name: COLUMN account_journal.nacha_immediate_destination; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_destination IS 'Immediate Destination';


--
-- Name: COLUMN account_journal.nacha_destination; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.nacha_destination IS 'Destination';


--
-- Name: COLUMN account_journal.nacha_immediate_origin; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_origin IS 'Immediate Origin';


--
-- Name: COLUMN account_journal.nacha_company_identification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.nacha_company_identification IS 'Company Identification';


--
-- Name: COLUMN account_journal.nacha_origination_dfi_identification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.nacha_origination_dfi_identification IS 'Origination Dfi Identification';


--
-- Name: COLUMN account_journal.nacha_entry_class_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.nacha_entry_class_code IS 'Standard Entry Class Code';


--
-- Name: COLUMN account_journal.nacha_discretionary_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.nacha_discretionary_data IS 'Company Discretionary Data';


--
-- Name: COLUMN account_journal.nacha_is_balanced; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.nacha_is_balanced IS 'Generate Balanced Files';


--
-- Name: COLUMN account_journal.qif_decimal_point; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.qif_decimal_point IS 'QIF Decimal Separator';


--
-- Name: COLUMN account_journal.qif_date_format; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.qif_date_format IS 'QIF Dates format';


--
-- Name: COLUMN account_journal.is_self_billing; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.is_self_billing IS 'Self Billing';


--
-- Name: COLUMN account_journal.coda_split_transactions; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.coda_split_transactions IS 'Split Transactions';


--
-- Name: COLUMN account_journal.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.country_id IS 'Country';


--
-- Name: COLUMN account_journal.payment_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.payment_note IS 'Payment Note';


--
-- Name: COLUMN account_journal.loan_properties_definition; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal.loan_properties_definition IS 'Model Properties';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_journal_group_rel OWNER TO ductin;

--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_rel OWNER TO ductin;

--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_group OWNER TO ductin;

--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Ledger group';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_group_id_seq OWNER TO ductin;

--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_id_seq OWNER TO ductin;

--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_journal_sale_payment_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_journal_sale_payment_wizard_rel (
    sale_payment_wizard_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_sale_payment_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_journal_sale_payment_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_journal_sale_payment_wizard_rel IS 'RELATION BETWEEN sale_payment_wizard AND account_journal';


--
-- Name: account_journal_stock_warehouse_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_journal_stock_warehouse_rel (
    account_journal_id integer NOT NULL,
    stock_warehouse_id integer NOT NULL
);


ALTER TABLE public.account_journal_stock_warehouse_rel OWNER TO ductin;

--
-- Name: TABLE account_journal_stock_warehouse_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_journal_stock_warehouse_rel IS 'RELATION BETWEEN account_journal AND stock_warehouse';


--
-- Name: account_loan; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_loan (
    id integer NOT NULL,
    company_id integer NOT NULL,
    duration integer,
    long_term_account_id integer,
    short_term_account_id integer,
    expense_account_id integer,
    journal_id integer,
    asset_group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    display_name character varying,
    date date,
    skip_until_date date,
    loan_properties jsonb,
    amount_borrowed numeric,
    interest numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan OWNER TO ductin;

--
-- Name: TABLE account_loan; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_loan IS 'Loan';


--
-- Name: COLUMN account_loan.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.company_id IS 'Company';


--
-- Name: COLUMN account_loan.duration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.duration IS 'Duration';


--
-- Name: COLUMN account_loan.long_term_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.long_term_account_id IS 'Long Term Account';


--
-- Name: COLUMN account_loan.short_term_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.short_term_account_id IS 'Short Term Account';


--
-- Name: COLUMN account_loan.expense_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.expense_account_id IS 'Expense Account';


--
-- Name: COLUMN account_loan.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.journal_id IS 'Journal';


--
-- Name: COLUMN account_loan.asset_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_loan.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.name IS 'Name';


--
-- Name: COLUMN account_loan.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.state IS 'Status';


--
-- Name: COLUMN account_loan.display_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.display_name IS 'Loan name';


--
-- Name: COLUMN account_loan.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.date IS 'Loan Date';


--
-- Name: COLUMN account_loan.skip_until_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.skip_until_date IS 'Skip until';


--
-- Name: COLUMN account_loan.loan_properties; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.loan_properties IS 'Properties';


--
-- Name: COLUMN account_loan.amount_borrowed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.amount_borrowed IS 'Amount Borrowed';


--
-- Name: COLUMN account_loan.interest; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.interest IS 'Interest';


--
-- Name: COLUMN account_loan.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.active IS 'Active';


--
-- Name: COLUMN account_loan.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.create_date IS 'Created on';


--
-- Name: COLUMN account_loan.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_loan_close_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_close_wizard OWNER TO ductin;

--
-- Name: TABLE account_loan_close_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_loan_close_wizard IS 'Close Loan Wizard';


--
-- Name: COLUMN account_loan_close_wizard.loan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_close_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_close_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_close_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_close_wizard.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_close_wizard.date IS 'Close Date';


--
-- Name: COLUMN account_loan_close_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_close_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_loan_close_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNER TO ductin;

--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNED BY public.account_loan_close_wizard.id;


--
-- Name: account_loan_compute_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_loan_compute_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    loan_term integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_end_of_month character varying NOT NULL,
    compounding_method character varying NOT NULL,
    start_date date NOT NULL,
    first_payment_date date NOT NULL,
    loan_amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    interest_rate double precision NOT NULL
);


ALTER TABLE public.account_loan_compute_wizard OWNER TO ductin;

--
-- Name: TABLE account_loan_compute_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_loan_compute_wizard IS 'Loan Compute Wizard';


--
-- Name: COLUMN account_loan_compute_wizard.loan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_compute_wizard.loan_term; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_term IS 'Loan Term';


--
-- Name: COLUMN account_loan_compute_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_compute_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_compute_wizard.payment_end_of_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.payment_end_of_month IS 'Payment';


--
-- Name: COLUMN account_loan_compute_wizard.compounding_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.compounding_method IS 'Compounding Method';


--
-- Name: COLUMN account_loan_compute_wizard.start_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.start_date IS 'Start Date';


--
-- Name: COLUMN account_loan_compute_wizard.first_payment_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.first_payment_date IS 'First Payment';


--
-- Name: COLUMN account_loan_compute_wizard.loan_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_amount IS 'Loan Amount';


--
-- Name: COLUMN account_loan_compute_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_compute_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_loan_compute_wizard.interest_rate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_compute_wizard.interest_rate IS 'Interest Rate';


--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_loan_compute_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNER TO ductin;

--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNED BY public.account_loan_compute_wizard.id;


--
-- Name: account_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_id_seq OWNER TO ductin;

--
-- Name: account_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_loan_id_seq OWNED BY public.account_loan.id;


--
-- Name: account_loan_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_loan_line (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    principal numeric,
    interest numeric,
    payment numeric,
    long_term_theoretical_balance numeric,
    short_term_theoretical_balance numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_line OWNER TO ductin;

--
-- Name: TABLE account_loan_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_loan_line IS 'Loan Line';


--
-- Name: COLUMN account_loan_line.loan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_line.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.date IS 'Date';


--
-- Name: COLUMN account_loan_line.principal; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.principal IS 'Principal';


--
-- Name: COLUMN account_loan_line.interest; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.interest IS 'Interest';


--
-- Name: COLUMN account_loan_line.payment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.payment IS 'Payment';


--
-- Name: COLUMN account_loan_line.long_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.long_term_theoretical_balance IS 'Long-Term';


--
-- Name: COLUMN account_loan_line.short_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.short_term_theoretical_balance IS 'Short-Term';


--
-- Name: COLUMN account_loan_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_loan_line.write_date IS 'Last Updated on';


--
-- Name: account_loan_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_loan_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_line_id_seq OWNER TO ductin;

--
-- Name: account_loan_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_loan_line_id_seq OWNED BY public.account_loan_line.id;


--
-- Name: account_lock_exception; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_lock_exception (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    lock_date_field character varying NOT NULL,
    lock_date date,
    company_lock_date date,
    active boolean,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_lock_exception OWNER TO ductin;

--
-- Name: TABLE account_lock_exception; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_lock_exception IS 'Account Lock Exception';


--
-- Name: COLUMN account_lock_exception.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.company_id IS 'Company';


--
-- Name: COLUMN account_lock_exception.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.user_id IS 'User';


--
-- Name: COLUMN account_lock_exception.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.create_uid IS 'Created by';


--
-- Name: COLUMN account_lock_exception.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_lock_exception.reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.reason IS 'Reason';


--
-- Name: COLUMN account_lock_exception.lock_date_field; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.lock_date_field IS 'Lock Date Field';


--
-- Name: COLUMN account_lock_exception.lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.lock_date IS 'Changed Lock Date';


--
-- Name: COLUMN account_lock_exception.company_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.company_lock_date IS 'Original Lock Date';


--
-- Name: COLUMN account_lock_exception.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.active IS 'Active';


--
-- Name: COLUMN account_lock_exception.end_datetime; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.end_datetime IS 'End Date';


--
-- Name: COLUMN account_lock_exception.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.create_date IS 'Created on';


--
-- Name: COLUMN account_lock_exception.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_lock_exception.write_date IS 'Last Updated on';


--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_lock_exception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_lock_exception_id_seq OWNER TO ductin;

--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_lock_exception_id_seq OWNED BY public.account_lock_exception.id;


--
-- Name: account_merge_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_merge_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    is_group_by_name boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard OWNER TO ductin;

--
-- Name: TABLE account_merge_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_merge_wizard IS 'Account merge wizard';


--
-- Name: COLUMN account_merge_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard.is_group_by_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard.is_group_by_name IS 'Group by name?';


--
-- Name: COLUMN account_merge_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_merge_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_id_seq OWNER TO ductin;

--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_merge_wizard_id_seq OWNED BY public.account_merge_wizard.id;


--
-- Name: account_merge_wizard_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_merge_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    sequence integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    grouping_key character varying,
    display_type character varying NOT NULL,
    is_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard_line OWNER TO ductin;

--
-- Name: TABLE account_merge_wizard_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_merge_wizard_line IS 'Account merge wizard line';


--
-- Name: COLUMN account_merge_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_merge_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_merge_wizard_line.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.account_id IS 'Account';


--
-- Name: COLUMN account_merge_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard_line.grouping_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.grouping_key IS 'Grouping Key';


--
-- Name: COLUMN account_merge_wizard_line.display_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_merge_wizard_line.is_selected; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.is_selected IS 'Is Selected';


--
-- Name: COLUMN account_merge_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_merge_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNER TO ductin;

--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNED BY public.account_merge_wizard_line.id;


--
-- Name: account_missing_transaction_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_missing_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_missing_transaction_wizard OWNER TO ductin;

--
-- Name: TABLE account_missing_transaction_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_missing_transaction_wizard IS 'Wizard for missing transactions';


--
-- Name: COLUMN account_missing_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_missing_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_missing_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_missing_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_missing_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_missing_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_missing_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNER TO ductin;

--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNED BY public.account_missing_transaction_wizard.id;


--
-- Name: account_model_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_model_rel (
    account_transfer_model_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_model_rel OWNER TO ductin;

--
-- Name: TABLE account_model_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_model_rel IS 'RELATION BETWEEN account_transfer_model AND account_account';


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_number integer,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    company_id integer,
    origin_payment_id integer,
    statement_line_id integer,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    auto_post_origin_id integer,
    secure_sequence_number integer,
    invoice_payment_term_id integer,
    partner_id integer,
    commercial_partner_id integer,
    partner_shipping_id integer,
    partner_bank_id integer,
    fiscal_position_id integer,
    preferred_payment_method_line_id integer,
    currency_id integer NOT NULL,
    reversed_entry_id integer,
    invoice_user_id integer,
    invoice_incoterm_id integer,
    invoice_cash_rounding_id integer,
    create_uid integer,
    write_uid integer,
    sequence_prefix character varying,
    access_token character varying,
    name character varying,
    ref character varying,
    state character varying NOT NULL,
    move_type character varying NOT NULL,
    auto_post character varying NOT NULL,
    inalterable_hash character varying,
    payment_reference character varying,
    qr_code_method character varying,
    payment_state character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_origin character varying,
    incoterm_location character varying,
    date date NOT NULL,
    auto_post_until date,
    invoice_date date,
    invoice_date_due date,
    delivery_date date,
    sending_data jsonb,
    narration text,
    invoice_currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_untaxed_in_currency_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    quick_edit_total_amount numeric,
    is_storno boolean,
    always_tax_exigible boolean,
    checked boolean,
    posted_before boolean,
    made_sequence_gap boolean,
    is_manually_modified boolean,
    is_move_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    signing_user integer,
    payment_state_before_switch character varying,
    debit_origin_id integer,
    edi_state character varying,
    auto_invoice_id integer,
    auto_generated boolean,
    expense_sheet_id integer,
    stock_move_id integer,
    release_to_pay character varying DEFAULT 'exception'::character varying,
    release_to_pay_manual character varying,
    force_release_to_pay boolean,
    transfer_model_id integer,
    avatax_tax_date date,
    peppol_message_uuid character varying,
    peppol_move_state character varying,
    reversed_pos_order_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    tax_closing_report_id integer,
    asset_id integer,
    asset_number_days integer,
    asset_move_type character varying,
    asset_depreciation_beginning_date date,
    depreciation_value numeric,
    asset_value_change boolean,
    intrastat_transport_mode_id integer,
    intrastat_country_id integer,
    extract_attachment_id integer,
    extract_detected_layout integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    extract_partner_name character varying,
    extract_prefill_data jsonb,
    is_in_extractable_state boolean,
    extract_state_processed boolean,
    suspense_statement_line_id integer,
    website_id integer,
    generating_loan_line_id integer,
    is_loan_payment_move boolean,
    referrer_id integer,
    commission_po_line_id integer,
    inverse_currency_rate numeric,
    inverse_amount_total numeric,
    origin_picking_id integer,
    shipping_date_done timestamp without time zone,
    sale_order_count integer,
    status_in_payment character varying,
    amount_paid_real numeric,
    hide_data_period boolean
);


ALTER TABLE public.account_move OWNER TO ductin;

--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.origin_payment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.origin_payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.auto_post_origin_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.auto_post_origin_id IS 'First recurring entry';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalterability No Gap Sequence #';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.preferred_payment_method_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.preferred_payment_method_line_id IS 'Preferred Payment Method Line';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Auto-post';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.incoterm_location; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.auto_post_until; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.auto_post_until IS 'Auto-post until';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.delivery_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.delivery_date IS 'Delivery Date';


--
-- Name: COLUMN account_move.sending_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.sending_data IS 'Sending Data';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.invoice_currency_rate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.invoice_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_untaxed_in_currency_signed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_untaxed_in_currency_signed IS 'Untaxed Amount Signed Currency';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.quick_edit_total_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.quick_edit_total_amount IS 'Total (Tax inc.)';


--
-- Name: COLUMN account_move.is_storno; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.is_storno IS 'Is Storno';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.checked; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.checked IS 'Checked';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.made_sequence_gap; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.made_sequence_gap IS 'Made Sequence Gap';


--
-- Name: COLUMN account_move.is_manually_modified; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.is_manually_modified IS 'Is Manually Modified';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.signing_user; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.signing_user IS 'Signer';


--
-- Name: COLUMN account_move.payment_state_before_switch; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.payment_state_before_switch IS 'Payment State Before Switch';


--
-- Name: COLUMN account_move.debit_origin_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.debit_origin_id IS 'Original Invoice Debited';


--
-- Name: COLUMN account_move.edi_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.edi_state IS 'Electronic invoicing';


--
-- Name: COLUMN account_move.auto_invoice_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.auto_invoice_id IS 'Source Invoice';


--
-- Name: COLUMN account_move.auto_generated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.auto_generated IS 'Auto Generated Document';


--
-- Name: COLUMN account_move.expense_sheet_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.expense_sheet_id IS 'Expense Sheet';


--
-- Name: COLUMN account_move.stock_move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.stock_move_id IS 'Stock Move';


--
-- Name: COLUMN account_move.release_to_pay_manual; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.release_to_pay_manual IS 'Should Be Paid';


--
-- Name: COLUMN account_move.force_release_to_pay; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.force_release_to_pay IS 'Force Status';


--
-- Name: COLUMN account_move.transfer_model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.transfer_model_id IS 'Originating Model';


--
-- Name: COLUMN account_move.avatax_tax_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.avatax_tax_date IS 'Avatax Date';


--
-- Name: COLUMN account_move.peppol_message_uuid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.peppol_message_uuid IS 'PEPPOL message ID';


--
-- Name: COLUMN account_move.peppol_move_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.peppol_move_state IS 'PEPPOL status';


--
-- Name: COLUMN account_move.reversed_pos_order_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.reversed_pos_order_id IS 'Reversed POS Order';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.tax_closing_report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.tax_closing_report_id IS 'Tax Closing Report';


--
-- Name: COLUMN account_move.asset_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.asset_id IS 'Asset';


--
-- Name: COLUMN account_move.asset_number_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.asset_number_days IS 'Number of days';


--
-- Name: COLUMN account_move.asset_move_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.asset_move_type IS 'Asset Move Type';


--
-- Name: COLUMN account_move.asset_depreciation_beginning_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.asset_depreciation_beginning_date IS 'Date of the beginning of the depreciation';


--
-- Name: COLUMN account_move.depreciation_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.depreciation_value IS 'Depreciation';


--
-- Name: COLUMN account_move.asset_value_change; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.asset_value_change IS 'Asset Value Change';


--
-- Name: COLUMN account_move.intrastat_transport_mode_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.intrastat_transport_mode_id IS 'Intrastat Transport Mode';


--
-- Name: COLUMN account_move.intrastat_country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.intrastat_country_id IS 'Intrastat Country';


--
-- Name: COLUMN account_move.extract_attachment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.extract_attachment_id IS 'Extract Attachment';


--
-- Name: COLUMN account_move.extract_detected_layout; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.extract_detected_layout IS 'Extract Detected Layout Id';


--
-- Name: COLUMN account_move.extract_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.extract_state IS 'Extract state';


--
-- Name: COLUMN account_move.extract_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.extract_status IS 'Extract status';


--
-- Name: COLUMN account_move.extract_document_uuid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_move.extract_partner_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.extract_partner_name IS 'Extract Detected Partner Name';


--
-- Name: COLUMN account_move.extract_prefill_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.extract_prefill_data IS 'Extract Prefill Data';


--
-- Name: COLUMN account_move.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_move.extract_state_processed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.extract_state_processed IS 'Extract State Processed';


--
-- Name: COLUMN account_move.suspense_statement_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.suspense_statement_line_id IS 'Request document from a bank statement line';


--
-- Name: COLUMN account_move.generating_loan_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.generating_loan_line_id IS 'Generating Loan Line';


--
-- Name: COLUMN account_move.is_loan_payment_move; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.is_loan_payment_move IS 'Is Loan Payment Move';


--
-- Name: COLUMN account_move.referrer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.referrer_id IS 'Referrer';


--
-- Name: COLUMN account_move.commission_po_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.commission_po_line_id IS 'Referrer Purchase Order line';


--
-- Name: COLUMN account_move.inverse_currency_rate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.inverse_currency_rate IS 'Inverse Currency Rate';


--
-- Name: COLUMN account_move.inverse_amount_total; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.inverse_amount_total IS 'Domestic Total';


--
-- Name: COLUMN account_move.origin_picking_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.origin_picking_id IS 'Stock picking out';


--
-- Name: COLUMN account_move.shipping_date_done; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.shipping_date_done IS 'Shipping date done';


--
-- Name: COLUMN account_move.sale_order_count; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.sale_order_count IS 'Sale Order Count';


--
-- Name: COLUMN account_move.status_in_payment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.status_in_payment IS 'Status In Payment';


--
-- Name: COLUMN account_move.amount_paid_real; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.amount_paid_real IS 'Real Paid Amount';


--
-- Name: COLUMN account_move.hide_data_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move.hide_data_period IS 'Hidden by Data Management';


--
-- Name: account_move__account_payment; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move__account_payment (
    invoice_id integer NOT NULL,
    payment_id integer NOT NULL
);


ALTER TABLE public.account_move__account_payment OWNER TO ductin;

--
-- Name: TABLE account_move__account_payment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move__account_payment IS 'RELATION BETWEEN account_move AND account_payment';


--
-- Name: account_move_account_move_send_batch_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_account_move_send_batch_wizard_rel (
    account_move_send_batch_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_move_send_batch_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_move_account_move_send_batch_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_account_move_send_batch_wizard_rel IS 'RELATION BETWEEN account_move_send_batch_wizard AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_resequence_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_asset_modify_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_asset_modify_rel OWNER TO ductin;

--
-- Name: TABLE account_move_asset_modify_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move';


--
-- Name: account_move_debit_move; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_debit_move (
    debit_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_debit_move OWNER TO ductin;

--
-- Name: TABLE account_move_debit_move; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_debit_move IS 'RELATION BETWEEN account_debit_note AND account_move';


--
-- Name: account_move_deferred_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_deferred_rel (
    original_move_id integer NOT NULL,
    deferred_move_id integer NOT NULL
);


ALTER TABLE public.account_move_deferred_rel OWNER TO ductin;

--
-- Name: TABLE account_move_deferred_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_deferred_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_move_helpdesk_ticket_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_helpdesk_ticket_rel (
    helpdesk_ticket_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_helpdesk_ticket_rel OWNER TO ductin;

--
-- Name: TABLE account_move_helpdesk_ticket_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_helpdesk_ticket_rel IS 'RELATION BETWEEN helpdesk_ticket AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_id_seq OWNER TO ductin;

--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    sequence integer,
    account_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_repartition_line_id integer,
    full_reconcile_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    move_name character varying,
    parent_state character varying,
    ref character varying,
    name character varying,
    matching_number character varying,
    display_type character varying NOT NULL,
    date date,
    invoice_date date,
    date_maturity date,
    discount_date date,
    analytic_distribution jsonb,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    tax_base_amount numeric,
    amount_residual numeric,
    amount_residual_currency numeric,
    quantity numeric,
    price_unit numeric,
    price_subtotal numeric,
    price_total numeric,
    discount numeric,
    discount_amount_currency numeric,
    discount_balance numeric,
    is_imported boolean,
    tax_tag_invert boolean,
    reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    deferred_start_date date,
    deferred_end_date date,
    vehicle_id integer,
    expense_id integer,
    purchase_line_id integer,
    is_downpayment boolean,
    cogs_origin_id integer,
    can_be_paid character varying DEFAULT 'exception'::character varying,
    exclude_bank_lines boolean,
    winbooks_line_id character varying,
    is_landed_costs_line boolean,
    followup_line_id integer,
    intrastat_product_origin_country_id integer,
    intrastat_transaction_id integer,
    subscription_mrr numeric,
    subscription_id integer,
    no_followup boolean DEFAULT false,
    hide_data_period boolean,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


ALTER TABLE public.account_move_line OWNER TO ductin;

--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.invoice_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.discount_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.discount_date IS 'Discount Date';


--
-- Name: COLUMN account_move_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.discount_amount_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.discount_amount_currency IS 'Discount amount in Currency';


--
-- Name: COLUMN account_move_line.discount_balance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.discount_balance IS 'Discount Balance';


--
-- Name: COLUMN account_move_line.is_imported; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.is_imported IS 'Is Imported';


--
-- Name: COLUMN account_move_line.tax_tag_invert; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.tax_tag_invert IS 'Invert Tags';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.deferred_start_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.deferred_start_date IS 'Start Date';


--
-- Name: COLUMN account_move_line.deferred_end_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.deferred_end_date IS 'End Date';


--
-- Name: COLUMN account_move_line.vehicle_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.vehicle_id IS 'Vehicle';


--
-- Name: COLUMN account_move_line.expense_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.expense_id IS 'Expense';


--
-- Name: COLUMN account_move_line.purchase_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.purchase_line_id IS 'Purchase Order Line';


--
-- Name: COLUMN account_move_line.is_downpayment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.is_downpayment IS 'Is Downpayment';


--
-- Name: COLUMN account_move_line.cogs_origin_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.cogs_origin_id IS 'Cogs Origin';


--
-- Name: COLUMN account_move_line.exclude_bank_lines; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.exclude_bank_lines IS 'Exclude Bank Lines';


--
-- Name: COLUMN account_move_line.winbooks_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.winbooks_line_id IS 'Winbooks Line';


--
-- Name: COLUMN account_move_line.is_landed_costs_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.is_landed_costs_line IS 'Is Landed Costs Line';


--
-- Name: COLUMN account_move_line.followup_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.followup_line_id IS 'Follow-up Level';


--
-- Name: COLUMN account_move_line.intrastat_transaction_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.intrastat_transaction_id IS 'Intrastat';


--
-- Name: COLUMN account_move_line.subscription_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.subscription_id IS 'Subscription';


--
-- Name: COLUMN account_move_line.hide_data_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_line.hide_data_period IS 'Hidden by Data Management';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                display_type IN (''line_section'', ''line_note'')
                OR (
                    (balance <= 0 AND amount_currency <= 0)
                    OR
                    (balance >= 0 AND amount_currency >= 0)
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_line_account_reconcile_wizard_rel (
    account_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_reconcile_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_move_line_account_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_line_account_reconcile_wizard_rel IS 'RELATION BETWEEN account_reconcile_wizard AND account_move_line';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_rel OWNER TO ductin;

--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_asset_modify_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_line_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_asset_modify_rel OWNER TO ductin;

--
-- Name: TABLE account_move_line_asset_modify_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_line_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move_line';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_line_id_seq OWNER TO ductin;

--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_line_l10n_us_1099_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_line_l10n_us_1099_wizard_rel (
    l10n_us_1099_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_l10n_us_1099_wizard_rel OWNER TO ductin;

--
-- Name: TABLE account_move_line_l10n_us_1099_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_line_l10n_us_1099_wizard_rel IS 'RELATION BETWEEN l10n_us_1099_wizard AND account_move_line';


--
-- Name: account_move_mrp_production_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_mrp_production_rel (
    account_move_id integer NOT NULL,
    mrp_production_id integer NOT NULL
);


ALTER TABLE public.account_move_mrp_production_rel OWNER TO ductin;

--
-- Name: TABLE account_move_mrp_production_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_mrp_production_rel IS 'RELATION BETWEEN account_move AND mrp_production';


--
-- Name: account_move_purchase_order_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_purchase_order_rel (
    purchase_order_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_purchase_order_rel OWNER TO ductin;

--
-- Name: TABLE account_move_purchase_order_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_purchase_order_rel IS 'RELATION BETWEEN purchase_order AND account_move';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    helpdesk_ticket_id integer,
    helpdesk_sale_order_id integer
);


ALTER TABLE public.account_move_reversal OWNER TO ductin;

--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason displayed on Credit Note';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_reversal.helpdesk_ticket_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.helpdesk_ticket_id IS 'Helpdesk Ticket';


--
-- Name: COLUMN account_move_reversal.helpdesk_sale_order_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_reversal.helpdesk_sale_order_id IS 'Sales Order';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_reversal_id_seq OWNER TO ductin;

--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_move OWNER TO ductin;

--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_new_move OWNER TO ductin;

--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_send_batch_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_send_batch_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_batch_wizard OWNER TO ductin;

--
-- Name: TABLE account_move_send_batch_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_send_batch_wizard IS 'Account Move Send Batch Wizard';


--
-- Name: COLUMN account_move_send_batch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_batch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_batch_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_batch_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_move_send_batch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNER TO ductin;

--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNED BY public.account_move_send_batch_wizard.id;


--
-- Name: account_move_send_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_send_wizard (
    id integer NOT NULL,
    move_id integer NOT NULL,
    pdf_report_id integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    mail_subject character varying,
    sending_method_checkboxes jsonb,
    extra_edi_checkboxes jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_wizard OWNER TO ductin;

--
-- Name: TABLE account_move_send_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_send_wizard IS 'Account Move Send Wizard';


--
-- Name: COLUMN account_move_send_wizard.move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.move_id IS 'Move';


--
-- Name: COLUMN account_move_send_wizard.pdf_report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.pdf_report_id IS 'Invoice template';


--
-- Name: COLUMN account_move_send_wizard.mail_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_move_send_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_wizard.mail_subject; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_subject IS 'Subject';


--
-- Name: COLUMN account_move_send_wizard.sending_method_checkboxes; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.sending_method_checkboxes IS 'Sending Method Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.extra_edi_checkboxes; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.extra_edi_checkboxes IS 'Extra Edi Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_move_send_wizard.mail_body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_body IS 'Contents';


--
-- Name: COLUMN account_move_send_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_move_send_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_move_send_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNER TO ductin;

--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNED BY public.account_move_send_wizard.id;


--
-- Name: account_move_send_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_send_wizard_res_partner_rel (
    account_move_send_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_move_send_wizard_res_partner_rel OWNER TO ductin;

--
-- Name: TABLE account_move_send_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_send_wizard_res_partner_rel IS 'RELATION BETWEEN account_move_send_wizard AND res_partner';


--
-- Name: account_move_validate_account_move_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_move_validate_account_move_rel (
    validate_account_move_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_validate_account_move_rel OWNER TO ductin;

--
-- Name: TABLE account_move_validate_account_move_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_move_validate_account_move_rel IS 'RELATION BETWEEN validate_account_move AND account_move';


--
-- Name: account_multicurrency_revaluation_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_multicurrency_revaluation_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_multicurrency_revaluation_wizard OWNER TO ductin;

--
-- Name: TABLE account_multicurrency_revaluation_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_multicurrency_revaluation_wizard IS 'Multicurrency Revaluation Wizard';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.date IS 'Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNER TO ductin;

--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNED BY public.account_multicurrency_revaluation_wizard.id;


--
-- Name: account_online_account; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_online_account (
    id integer NOT NULL,
    account_online_link_id integer,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    online_identifier character varying,
    account_number character varying,
    account_data character varying,
    fetching_status character varying,
    last_sync date,
    inverse_balance_sign boolean,
    inverse_transaction_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    balance double precision
);


ALTER TABLE public.account_online_account OWNER TO ductin;

--
-- Name: TABLE account_online_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_online_account IS 'representation of an online bank account';


--
-- Name: COLUMN account_online_account.account_online_link_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_online_account.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.currency_id IS 'Currency';


--
-- Name: COLUMN account_online_account.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_account.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_account.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.name IS 'Account Name';


--
-- Name: COLUMN account_online_account.online_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.online_identifier IS 'Online Identifier';


--
-- Name: COLUMN account_online_account.account_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.account_number IS 'Account Number';


--
-- Name: COLUMN account_online_account.account_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.account_data IS 'Account Data';


--
-- Name: COLUMN account_online_account.fetching_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.fetching_status IS 'Fetching Status';


--
-- Name: COLUMN account_online_account.last_sync; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.last_sync IS 'Last synchronization';


--
-- Name: COLUMN account_online_account.inverse_balance_sign; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.inverse_balance_sign IS 'Inverse Balance Sign';


--
-- Name: COLUMN account_online_account.inverse_transaction_sign; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.inverse_transaction_sign IS 'Inverse Transaction Sign';


--
-- Name: COLUMN account_online_account.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.create_date IS 'Created on';


--
-- Name: COLUMN account_online_account.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_account.balance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_account.balance IS 'Balance';


--
-- Name: account_online_account_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_online_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_account_id_seq OWNER TO ductin;

--
-- Name: account_online_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_online_account_id_seq OWNED BY public.account_online_account.id;


--
-- Name: account_online_link; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_online_link (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    client_id character varying,
    refresh_token character varying,
    access_token character varying,
    provider_data character varying,
    provider_type character varying,
    expiring_synchronization_date date,
    connection_state_details jsonb,
    auto_sync boolean,
    has_unlinked_accounts boolean,
    last_refresh timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_online_link OWNER TO ductin;

--
-- Name: TABLE account_online_link; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_online_link IS 'Bank Connection';


--
-- Name: COLUMN account_online_link.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.company_id IS 'Company';


--
-- Name: COLUMN account_online_link.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_link.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_link.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.state IS 'State';


--
-- Name: COLUMN account_online_link.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.name IS 'Name';


--
-- Name: COLUMN account_online_link.client_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.client_id IS 'Client';


--
-- Name: COLUMN account_online_link.refresh_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.refresh_token IS 'Refresh Token';


--
-- Name: COLUMN account_online_link.access_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.access_token IS 'Access Token';


--
-- Name: COLUMN account_online_link.provider_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.provider_data IS 'Provider Data';


--
-- Name: COLUMN account_online_link.provider_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.provider_type IS 'Provider Type';


--
-- Name: COLUMN account_online_link.expiring_synchronization_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.expiring_synchronization_date IS 'Expiring Synchronization Date';


--
-- Name: COLUMN account_online_link.connection_state_details; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.connection_state_details IS 'Connection State Details';


--
-- Name: COLUMN account_online_link.auto_sync; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.auto_sync IS 'Automatic synchronization';


--
-- Name: COLUMN account_online_link.has_unlinked_accounts; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.has_unlinked_accounts IS 'Has Unlinked Accounts';


--
-- Name: COLUMN account_online_link.last_refresh; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.last_refresh IS 'Last Refresh';


--
-- Name: COLUMN account_online_link.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.create_date IS 'Created on';


--
-- Name: COLUMN account_online_link.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_online_link.write_date IS 'Last Updated on';


--
-- Name: account_online_link_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_online_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_link_id_seq OWNER TO ductin;

--
-- Name: account_online_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_online_link_id_seq OWNED BY public.account_online_link.id;


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    exchange_move_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    max_date date,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_partial_reconcile OWNER TO ductin;

--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNER TO ductin;

--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    partner_bank_id integer,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying NOT NULL,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    memo character varying,
    payment_reference character varying,
    date date NOT NULL,
    amount numeric,
    amount_company_currency_signed numeric,
    is_reconciled boolean,
    is_matched boolean,
    is_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    batch_payment_id integer,
    check_number character varying,
    check_amount_in_words character varying,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    iso20022_uetr character varying,
    sdd_mandate_id integer,
    pos_payment_method_id integer,
    force_outstanding_account_id integer,
    pos_session_id integer,
    end_to_end_id character varying,
    pos_order_id integer,
    crm_group_id integer,
    document_link character varying,
    note text,
    payment_date timestamp without time zone NOT NULL,
    approval_request_id integer,
    hide_data_period boolean,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


ALTER TABLE public.account_payment OWNER TO ductin;

--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.company_id IS 'Company';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.name IS 'Number';


--
-- Name: COLUMN account_payment.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.state IS 'State';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.memo; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.memo IS 'Memo';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.date IS 'Date';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.amount_company_currency_signed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.amount_company_currency_signed IS 'Amount Company Currency Signed';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.is_sent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.is_sent IS 'Is Sent';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.batch_payment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_payment.check_amount_in_words; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.check_amount_in_words IS 'Amount in Words';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: COLUMN account_payment.iso20022_uetr; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.iso20022_uetr IS 'UETR';


--
-- Name: COLUMN account_payment.sdd_mandate_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.sdd_mandate_id IS 'Sdd Mandate';


--
-- Name: COLUMN account_payment.pos_payment_method_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.pos_payment_method_id IS 'POS Payment Method';


--
-- Name: COLUMN account_payment.force_outstanding_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.force_outstanding_account_id IS 'Forced Outstanding Account';


--
-- Name: COLUMN account_payment.pos_session_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.pos_session_id IS 'POS Session';


--
-- Name: COLUMN account_payment.end_to_end_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.end_to_end_id IS 'End to End ID';


--
-- Name: COLUMN account_payment.pos_order_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.pos_order_id IS 'POS Order';


--
-- Name: COLUMN account_payment.crm_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.crm_group_id IS 'CRM Group';


--
-- Name: COLUMN account_payment.document_link; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.document_link IS 'Document Link';


--
-- Name: COLUMN account_payment.note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.note IS 'Note';


--
-- Name: COLUMN account_payment.payment_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment.approval_request_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.approval_request_id IS 'Approval Request';


--
-- Name: COLUMN account_payment.hide_data_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment.hide_data_period IS 'Hidden by Data Management';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_bank_statement_line_rel OWNER TO ductin;

--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_account_repayment_date_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_account_repayment_date_rel (
    account_repayment_date_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_repayment_date_rel OWNER TO ductin;

--
-- Name: TABLE account_payment_account_repayment_date_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_account_repayment_date_rel IS 'RELATION BETWEEN account_repayment_date AND account_payment';


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_id_seq OWNER TO ductin;

--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_method OWNER TO ductin;

--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_id_seq OWNER TO ductin;

--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_provider_id integer
);


ALTER TABLE public.account_payment_method_line OWNER TO ductin;

--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_provider_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_method_line.payment_provider_id IS 'Payment Provider';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_line_id_seq OWNER TO ductin;

--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_method_line_res_company_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_method_line_res_company_rel (
    res_company_id integer NOT NULL,
    account_payment_method_line_id integer NOT NULL
);


ALTER TABLE public.account_payment_method_line_res_company_rel OWNER TO ductin;

--
-- Name: TABLE account_payment_method_line_res_company_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_method_line_res_company_rel IS 'RELATION BETWEEN res_company AND account_payment_method_line';


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    custom_user_currency_id integer,
    source_currency_id integer,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    writeoff_account_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    installments_mode character varying,
    payment_type character varying,
    partner_type character varying,
    payment_difference_handling character varying,
    writeoff_label character varying,
    payment_date date NOT NULL,
    amount numeric,
    custom_user_amount numeric,
    source_amount numeric,
    source_amount_currency numeric,
    group_payment boolean,
    can_edit_wizard boolean,
    can_group_payments boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_token_id integer
);


ALTER TABLE public.account_payment_register OWNER TO ductin;

--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_register IS 'Pay';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.custom_user_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.custom_user_currency_id IS 'Custom User Currency';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.installments_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.installments_mode IS 'Installments Mode';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.custom_user_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.custom_user_amount IS 'Custom User Amount';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_register_id_seq OWNER TO ductin;

--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_move_line_rel OWNER TO ductin;

--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    company_id integer,
    sequence integer NOT NULL,
    discount_days integer,
    create_uid integer,
    write_uid integer,
    early_pay_discount_computation character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    display_on_invoice boolean,
    early_discount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision
);


ALTER TABLE public.account_payment_term OWNER TO ductin;

--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.discount_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.discount_days IS 'Discount Days';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.early_pay_discount_computation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.early_pay_discount_computation IS 'Cash Discount Tax Reduction';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.display_on_invoice; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.display_on_invoice IS 'Show installment dates';


--
-- Name: COLUMN account_payment_term.early_discount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.early_discount IS 'Early Discount';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.discount_percentage; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term.discount_percentage IS 'Discount %';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_id_seq OWNER TO ductin;

--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    nb_days integer,
    payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    delay_type character varying NOT NULL,
    days_next_month character varying(2),
    value_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_term_line OWNER TO ductin;

--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.nb_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.nb_days IS 'Days';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Value';


--
-- Name: COLUMN account_payment_term_line.delay_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.delay_type IS 'Delay Type';


--
-- Name: COLUMN account_payment_term_line.days_next_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.days_next_month IS 'Days on the next month';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Due';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_line_id_seq OWNER TO ductin;

--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_peppol_service; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_peppol_service (
    id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    document_identifier character varying,
    document_name character varying,
    enabled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_peppol_service OWNER TO ductin;

--
-- Name: TABLE account_peppol_service; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_peppol_service IS 'Peppol Service';


--
-- Name: COLUMN account_peppol_service.wizard_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_peppol_service.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service.create_uid IS 'Created by';


--
-- Name: COLUMN account_peppol_service.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_peppol_service.document_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service.document_identifier IS 'Document Identifier';


--
-- Name: COLUMN account_peppol_service.document_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service.document_name IS 'Document Name';


--
-- Name: COLUMN account_peppol_service.enabled; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service.enabled IS 'Enabled';


--
-- Name: COLUMN account_peppol_service.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service.create_date IS 'Created on';


--
-- Name: COLUMN account_peppol_service.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service.write_date IS 'Last Updated on';


--
-- Name: account_peppol_service_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_peppol_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_peppol_service_id_seq OWNER TO ductin;

--
-- Name: account_peppol_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_peppol_service_id_seq OWNED BY public.account_peppol_service.id;


--
-- Name: account_peppol_service_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_peppol_service_wizard (
    id integer NOT NULL,
    edi_user_id integer,
    create_uid integer,
    write_uid integer,
    service_json jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_peppol_service_wizard OWNER TO ductin;

--
-- Name: TABLE account_peppol_service_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_peppol_service_wizard IS 'Peppol Services Wizard';


--
-- Name: COLUMN account_peppol_service_wizard.edi_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service_wizard.edi_user_id IS 'EDI user';


--
-- Name: COLUMN account_peppol_service_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_peppol_service_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_peppol_service_wizard.service_json; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service_wizard.service_json IS 'Service Json';


--
-- Name: COLUMN account_peppol_service_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_peppol_service_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_peppol_service_wizard.write_date IS 'Last Updated on';


--
-- Name: account_peppol_service_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_peppol_service_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_peppol_service_wizard_id_seq OWNER TO ductin;

--
-- Name: account_peppol_service_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_peppol_service_wizard_id_seq OWNED BY public.account_peppol_service_wizard.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    past_months_limit integer,
    create_uid integer,
    write_uid integer,
    rule_type character varying NOT NULL,
    matching_order character varying NOT NULL,
    counterpart_type character varying,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    payment_tolerance_type character varying NOT NULL,
    decimal_separator character varying,
    name jsonb NOT NULL,
    active boolean,
    auto_reconcile boolean,
    to_check boolean,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    match_partner boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    payment_tolerance_param double precision
);


ALTER TABLE public.account_reconcile_model OWNER TO ductin;

--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.past_months_limit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.past_months_limit IS 'Search Months Limit';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.rule_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model.matching_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model.counterpart_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.counterpart_type IS 'Counterpart Type';


--
-- Name: COLUMN account_reconcile_model.match_nature; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.match_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model.match_note_param; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model.decimal_separator; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.auto_reconcile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model.to_check; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model.match_text_location_label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model.match_text_location_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model.match_text_location_reference; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model.match_same_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.allow_payment_tolerance IS 'Payment Tolerance';


--
-- Name: COLUMN account_reconcile_model.match_partner; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_partner IS 'Partner is Set';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_param IS 'Gap';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_id_seq OWNER TO ductin;

--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying NOT NULL,
    amount_string character varying NOT NULL,
    analytic_distribution jsonb,
    label jsonb,
    force_tax_included boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_reconcile_model_line OWNER TO ductin;

--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line.force_tax_included; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_account_tax_rel OWNER TO ductin;

--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNER TO ductin;

--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_partner_mapping; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reconcile_model_partner_mapping (
    id integer NOT NULL,
    model_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_ref_regex character varying,
    narration_regex character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_partner_mapping OWNER TO ductin;

--
-- Name: TABLE account_reconcile_model_partner_mapping; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reconcile_model_partner_mapping IS 'Partner mapping for reconciliation models';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.payment_ref_regex; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.payment_ref_regex IS 'Find Text in Label';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.narration_regex; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.narration_regex IS 'Find Text in Notes';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_reconcile_model_partner_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNER TO ductin;

--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNED BY public.account_reconcile_model_partner_mapping.id;


--
-- Name: account_reconcile_model_res_partner_category_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reconcile_model_res_partner_category_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_category_rel OWNER TO ductin;

--
-- Name: TABLE account_reconcile_model_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner_category';


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_rel OWNER TO ductin;

--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reconcile_wizard (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    account_id integer,
    to_partner_id integer,
    tax_id integer,
    create_uid integer,
    write_uid integer,
    label character varying,
    date date,
    edit_mode_amount_currency numeric,
    allow_partials boolean,
    to_check boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_wizard OWNER TO ductin;

--
-- Name: TABLE account_reconcile_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reconcile_wizard IS 'Account reconciliation wizard';


--
-- Name: COLUMN account_reconcile_wizard.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_wizard.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_wizard.to_partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_wizard.tax_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.tax_id IS 'Tax';


--
-- Name: COLUMN account_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_wizard.label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.label IS 'Label';


--
-- Name: COLUMN account_reconcile_wizard.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.date IS 'Date';


--
-- Name: COLUMN account_reconcile_wizard.edit_mode_amount_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.edit_mode_amount_currency IS 'Edit mode amount';


--
-- Name: COLUMN account_reconcile_wizard.allow_partials; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.allow_partials IS 'Allow partials';


--
-- Name: COLUMN account_reconcile_wizard.to_check; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNER TO ductin;

--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNED BY public.account_reconcile_wizard.id;


--
-- Name: account_repayment_date; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_repayment_date (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    repayment_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_repayment_date OWNER TO ductin;

--
-- Name: TABLE account_repayment_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_repayment_date IS 'Account Repayment Date';


--
-- Name: COLUMN account_repayment_date.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_repayment_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_repayment_date.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_repayment_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_repayment_date.repayment_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_repayment_date.repayment_date IS 'Repayment Date';


--
-- Name: COLUMN account_repayment_date.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_repayment_date.create_date IS 'Created on';


--
-- Name: COLUMN account_repayment_date.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_repayment_date.write_date IS 'Last Updated on';


--
-- Name: account_repayment_date_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_repayment_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_repayment_date_id_seq OWNER TO ductin;

--
-- Name: account_repayment_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_repayment_date_id_seq OWNED BY public.account_repayment_date.id;


--
-- Name: account_report; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report (
    id integer NOT NULL,
    sequence integer,
    root_report_id integer,
    country_id integer,
    load_more_limit integer,
    prefix_groups_threshold integer,
    create_uid integer,
    write_uid integer,
    chart_template character varying,
    availability_condition character varying,
    integer_rounding character varying,
    default_opening_date_filter character varying,
    currency_translation character varying,
    filter_multi_company character varying,
    filter_hide_0_lines character varying,
    filter_hierarchy character varying,
    filter_account_type character varying,
    name jsonb NOT NULL,
    active boolean,
    use_sections boolean,
    only_tax_exigible boolean,
    search_bar boolean,
    filter_date_range boolean,
    filter_show_draft boolean,
    filter_unreconciled boolean,
    filter_unfold_all boolean,
    filter_period_comparison boolean,
    filter_growth_comparison boolean,
    filter_journals boolean,
    filter_analytic boolean,
    filter_partner boolean,
    filter_fiscal_position boolean,
    filter_aml_ir_filters boolean,
    filter_budgets boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    custom_handler_model_id integer,
    tax_closing_start_date jsonb,
    send_and_print_values jsonb,
    filter_analytic_groupby boolean,
    filter_cash_basis boolean
);


ALTER TABLE public.account_report OWNER TO ductin;

--
-- Name: TABLE account_report; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report IS 'Accounting Report';


--
-- Name: COLUMN account_report.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.sequence IS 'Sequence';


--
-- Name: COLUMN account_report.root_report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.root_report_id IS 'Root Report';


--
-- Name: COLUMN account_report.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.country_id IS 'Country';


--
-- Name: COLUMN account_report.load_more_limit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.load_more_limit IS 'Load More Limit';


--
-- Name: COLUMN account_report.prefix_groups_threshold; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.prefix_groups_threshold IS 'Prefix Groups Threshold';


--
-- Name: COLUMN account_report.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_report.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report.chart_template; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.chart_template IS 'Chart of Accounts';


--
-- Name: COLUMN account_report.availability_condition; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.availability_condition IS 'Availability';


--
-- Name: COLUMN account_report.integer_rounding; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.integer_rounding IS 'Integer Rounding';


--
-- Name: COLUMN account_report.default_opening_date_filter; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.default_opening_date_filter IS 'Default Opening';


--
-- Name: COLUMN account_report.currency_translation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.currency_translation IS 'Currency Translation';


--
-- Name: COLUMN account_report.filter_multi_company; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_multi_company IS 'Multi-Company';


--
-- Name: COLUMN account_report.filter_hide_0_lines; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_hide_0_lines IS 'Hide lines at 0';


--
-- Name: COLUMN account_report.filter_hierarchy; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_hierarchy IS 'Account Groups';


--
-- Name: COLUMN account_report.filter_account_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_account_type IS 'Account Types';


--
-- Name: COLUMN account_report.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.name IS 'Name';


--
-- Name: COLUMN account_report.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.active IS 'Active';


--
-- Name: COLUMN account_report.use_sections; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.use_sections IS 'Composite Report';


--
-- Name: COLUMN account_report.only_tax_exigible; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.only_tax_exigible IS 'Only Tax Exigible Lines';


--
-- Name: COLUMN account_report.search_bar; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.search_bar IS 'Search Bar';


--
-- Name: COLUMN account_report.filter_date_range; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_date_range IS 'Date Range';


--
-- Name: COLUMN account_report.filter_show_draft; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_show_draft IS 'Draft Entries';


--
-- Name: COLUMN account_report.filter_unreconciled; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_unreconciled IS 'Unreconciled Entries';


--
-- Name: COLUMN account_report.filter_unfold_all; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_unfold_all IS 'Unfold All';


--
-- Name: COLUMN account_report.filter_period_comparison; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_period_comparison IS 'Period Comparison';


--
-- Name: COLUMN account_report.filter_growth_comparison; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_growth_comparison IS 'Growth Comparison';


--
-- Name: COLUMN account_report.filter_journals; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_journals IS 'Journals';


--
-- Name: COLUMN account_report.filter_analytic; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_analytic IS 'Analytic Filter';


--
-- Name: COLUMN account_report.filter_partner; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_partner IS 'Partners';


--
-- Name: COLUMN account_report.filter_fiscal_position; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_fiscal_position IS 'Filter Multivat';


--
-- Name: COLUMN account_report.filter_aml_ir_filters; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_aml_ir_filters IS 'Favorite Filters';


--
-- Name: COLUMN account_report.filter_budgets; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_budgets IS 'Budgets';


--
-- Name: COLUMN account_report.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_report.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report.custom_handler_model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.custom_handler_model_id IS 'Custom Handler Model';


--
-- Name: COLUMN account_report.tax_closing_start_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.tax_closing_start_date IS 'Start Date';


--
-- Name: COLUMN account_report.send_and_print_values; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.send_and_print_values IS 'Send And Print Values';


--
-- Name: COLUMN account_report.filter_analytic_groupby; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_analytic_groupby IS 'Analytic Group By';


--
-- Name: COLUMN account_report.filter_cash_basis; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report.filter_cash_basis IS 'Cash Basis';


--
-- Name: account_report_account_report_horizontal_group_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_account_report_horizontal_group_rel (
    account_report_id integer NOT NULL,
    account_report_horizontal_group_id integer NOT NULL
);


ALTER TABLE public.account_report_account_report_horizontal_group_rel OWNER TO ductin;

--
-- Name: TABLE account_report_account_report_horizontal_group_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_account_report_horizontal_group_rel IS 'RELATION BETWEEN account_report AND account_report_horizontal_group';


--
-- Name: account_report_annotation; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_annotation (
    id integer NOT NULL,
    report_id integer,
    fiscal_position_id integer,
    create_uid integer,
    write_uid integer,
    line_id character varying,
    text character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_annotation OWNER TO ductin;

--
-- Name: TABLE account_report_annotation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_annotation IS 'Account Report Annotation';


--
-- Name: COLUMN account_report_annotation.report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.report_id IS 'Report';


--
-- Name: COLUMN account_report_annotation.fiscal_position_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_report_annotation.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_annotation.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_annotation.line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.line_id IS 'Line';


--
-- Name: COLUMN account_report_annotation.text; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.text IS 'The annotation''s content.';


--
-- Name: COLUMN account_report_annotation.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.date IS 'Date';


--
-- Name: COLUMN account_report_annotation.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.create_date IS 'Created on';


--
-- Name: COLUMN account_report_annotation.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_annotation.write_date IS 'Last Updated on';


--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_annotation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_annotation_id_seq OWNER TO ductin;

--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_annotation_id_seq OWNED BY public.account_report_annotation.id;


--
-- Name: account_report_budget; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_budget (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_budget OWNER TO ductin;

--
-- Name: TABLE account_report_budget; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_budget IS 'Accounting Report Budget';


--
-- Name: COLUMN account_report_budget.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_budget.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget.company_id IS 'Company';


--
-- Name: COLUMN account_report_budget.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget.name IS 'Name';


--
-- Name: COLUMN account_report_budget.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget.write_date IS 'Last Updated on';


--
-- Name: account_report_budget_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_budget_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_id_seq OWNER TO ductin;

--
-- Name: account_report_budget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_budget_id_seq OWNED BY public.account_report_budget.id;


--
-- Name: account_report_budget_item; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_budget_item (
    id integer NOT NULL,
    budget_id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_report_budget_item OWNER TO ductin;

--
-- Name: TABLE account_report_budget_item; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_budget_item IS 'Accounting Report Budget Item';


--
-- Name: COLUMN account_report_budget_item.budget_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget_item.budget_id IS 'Budget';


--
-- Name: COLUMN account_report_budget_item.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget_item.account_id IS 'Account';


--
-- Name: COLUMN account_report_budget_item.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget_item.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget_item.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget_item.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget_item.date IS 'Date';


--
-- Name: COLUMN account_report_budget_item.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget_item.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget_item.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_budget_item.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_budget_item.amount IS 'Amount';


--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_budget_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_item_id_seq OWNER TO ductin;

--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_budget_item_id_seq OWNED BY public.account_report_budget_item.id;


--
-- Name: account_report_column; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_column (
    id integer NOT NULL,
    sequence integer,
    report_id integer,
    custom_audit_action_id integer,
    create_uid integer,
    write_uid integer,
    expression_label character varying NOT NULL,
    figure_type character varying NOT NULL,
    name jsonb NOT NULL,
    sortable boolean,
    blank_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_column OWNER TO ductin;

--
-- Name: TABLE account_report_column; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_column IS 'Accounting Report Column';


--
-- Name: COLUMN account_report_column.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_column.report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.report_id IS 'Report';


--
-- Name: COLUMN account_report_column.custom_audit_action_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.custom_audit_action_id IS 'Custom Audit Action';


--
-- Name: COLUMN account_report_column.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_column.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_column.expression_label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.expression_label IS 'Expression Label';


--
-- Name: COLUMN account_report_column.figure_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_column.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.name IS 'Name';


--
-- Name: COLUMN account_report_column.sortable; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.sortable IS 'Sortable';


--
-- Name: COLUMN account_report_column.blank_if_zero; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_column.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.create_date IS 'Created on';


--
-- Name: COLUMN account_report_column.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_column.write_date IS 'Last Updated on';


--
-- Name: account_report_column_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_column_id_seq OWNER TO ductin;

--
-- Name: account_report_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_column_id_seq OWNED BY public.account_report_column.id;


--
-- Name: account_report_expression; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_expression (
    id integer NOT NULL,
    report_line_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    engine character varying NOT NULL,
    formula character varying NOT NULL,
    subformula character varying,
    date_scope character varying NOT NULL,
    figure_type character varying,
    carryover_target character varying,
    green_on_positive boolean,
    blank_if_zero boolean,
    auditable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_report_expression_domain_engine_subformula_required CHECK ((((engine)::text <> 'domain'::text) OR (subformula IS NOT NULL)))
);


ALTER TABLE public.account_report_expression OWNER TO ductin;

--
-- Name: TABLE account_report_expression; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_expression IS 'Accounting Report Expression';


--
-- Name: COLUMN account_report_expression.report_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.report_line_id IS 'Report Line';


--
-- Name: COLUMN account_report_expression.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_expression.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_expression.label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.label IS 'Label';


--
-- Name: COLUMN account_report_expression.engine; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.engine IS 'Computation Engine';


--
-- Name: COLUMN account_report_expression.formula; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.formula IS 'Formula';


--
-- Name: COLUMN account_report_expression.subformula; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.subformula IS 'Subformula';


--
-- Name: COLUMN account_report_expression.date_scope; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.date_scope IS 'Date Scope';


--
-- Name: COLUMN account_report_expression.figure_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_expression.carryover_target; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.carryover_target IS 'Carry Over To';


--
-- Name: COLUMN account_report_expression.green_on_positive; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.green_on_positive IS 'Is Growth Good when Positive';


--
-- Name: COLUMN account_report_expression.blank_if_zero; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_expression.auditable; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.auditable IS 'Auditable';


--
-- Name: COLUMN account_report_expression.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.create_date IS 'Created on';


--
-- Name: COLUMN account_report_expression.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_expression.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_report_expression_domain_engine_subformula_required ON account_report_expression; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT account_report_expression_domain_engine_subformula_required ON public.account_report_expression IS 'CHECK(engine != ''domain'' OR subformula IS NOT NULL)';


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_expression_id_seq OWNER TO ductin;

--
-- Name: account_report_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_expression_id_seq OWNED BY public.account_report_expression.id;


--
-- Name: account_report_external_value; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_external_value (
    id integer NOT NULL,
    target_report_expression_id integer NOT NULL,
    company_id integer NOT NULL,
    foreign_vat_fiscal_position_id integer,
    carryover_origin_report_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    text_value character varying,
    carryover_origin_expression_label character varying,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.account_report_external_value OWNER TO ductin;

--
-- Name: TABLE account_report_external_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_external_value IS 'Accounting Report External Value';


--
-- Name: COLUMN account_report_external_value.target_report_expression_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.target_report_expression_id IS 'Target Expression';


--
-- Name: COLUMN account_report_external_value.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.company_id IS 'Company';


--
-- Name: COLUMN account_report_external_value.foreign_vat_fiscal_position_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.foreign_vat_fiscal_position_id IS 'Fiscal position';


--
-- Name: COLUMN account_report_external_value.carryover_origin_report_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_report_line_id IS 'Origin Line';


--
-- Name: COLUMN account_report_external_value.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_external_value.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_external_value.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.name IS 'Name';


--
-- Name: COLUMN account_report_external_value.text_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.text_value IS 'Text Value';


--
-- Name: COLUMN account_report_external_value.carryover_origin_expression_label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_expression_label IS 'Origin Expression Label';


--
-- Name: COLUMN account_report_external_value.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.date IS 'Date';


--
-- Name: COLUMN account_report_external_value.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.create_date IS 'Created on';


--
-- Name: COLUMN account_report_external_value.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_external_value.value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_external_value.value IS 'Numeric Value';


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_external_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_external_value_id_seq OWNER TO ductin;

--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_external_value_id_seq OWNED BY public.account_report_external_value.id;


--
-- Name: account_report_file_download_error_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_file_download_error_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    file_name character varying,
    actionable_errors jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_file_download_error_wizard OWNER TO ductin;

--
-- Name: TABLE account_report_file_download_error_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_file_download_error_wizard IS 'Manage the file generation errors from report exports.';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_file_download_error_wizard.file_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.file_name IS 'File Name';


--
-- Name: COLUMN account_report_file_download_error_wizard.actionable_errors; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.actionable_errors IS 'Actionable Errors';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_file_download_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNER TO ductin;

--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNED BY public.account_report_file_download_error_wizard.id;


--
-- Name: account_report_horizontal_group; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_horizontal_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group OWNER TO ductin;

--
-- Name: TABLE account_report_horizontal_group; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_horizontal_group IS 'Horizontal group for reports';


--
-- Name: COLUMN account_report_horizontal_group.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group.name IS 'Name';


--
-- Name: COLUMN account_report_horizontal_group.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_horizontal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNER TO ductin;

--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNED BY public.account_report_horizontal_group.id;


--
-- Name: account_report_horizontal_group_rule; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_horizontal_group_rule (
    id integer NOT NULL,
    horizontal_group_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    domain character varying NOT NULL,
    field_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group_rule OWNER TO ductin;

--
-- Name: TABLE account_report_horizontal_group_rule; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_horizontal_group_rule IS 'Horizontal group rule for reports';


--
-- Name: COLUMN account_report_horizontal_group_rule.horizontal_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.horizontal_group_id IS 'Horizontal Group';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group_rule.domain; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.domain IS 'Domain';


--
-- Name: COLUMN account_report_horizontal_group_rule.field_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.field_name IS 'Field';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_horizontal_group_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNER TO ductin;

--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNED BY public.account_report_horizontal_group_rule.id;


--
-- Name: account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_id_seq OWNER TO ductin;

--
-- Name: account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_id_seq OWNED BY public.account_report.id;


--
-- Name: account_report_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_line (
    id integer NOT NULL,
    report_id integer NOT NULL,
    hierarchy_level integer NOT NULL,
    parent_id integer,
    sequence integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    groupby character varying,
    user_groupby character varying,
    code character varying,
    horizontal_split_side character varying,
    name jsonb NOT NULL,
    foldable boolean,
    print_on_new_page boolean,
    hide_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_line OWNER TO ductin;

--
-- Name: TABLE account_report_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_line IS 'Accounting Report Line';


--
-- Name: COLUMN account_report_line.report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.report_id IS 'Parent Report';


--
-- Name: COLUMN account_report_line.hierarchy_level; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.hierarchy_level IS 'Level';


--
-- Name: COLUMN account_report_line.parent_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_report_line.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_line.action_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.action_id IS 'Action';


--
-- Name: COLUMN account_report_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_line.groupby; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.groupby IS 'Group By';


--
-- Name: COLUMN account_report_line.user_groupby; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.user_groupby IS 'User Group By';


--
-- Name: COLUMN account_report_line.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.code IS 'Code';


--
-- Name: COLUMN account_report_line.horizontal_split_side; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.horizontal_split_side IS 'Horizontal Split Side';


--
-- Name: COLUMN account_report_line.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.name IS 'Name';


--
-- Name: COLUMN account_report_line.foldable; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.foldable IS 'Foldable';


--
-- Name: COLUMN account_report_line.print_on_new_page; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.print_on_new_page IS 'Print On New Page';


--
-- Name: COLUMN account_report_line.hide_if_zero; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.hide_if_zero IS 'Hide if Zero';


--
-- Name: COLUMN account_report_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_report_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_line.write_date IS 'Last Updated on';


--
-- Name: account_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_line_id_seq OWNER TO ductin;

--
-- Name: account_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_line_id_seq OWNED BY public.account_report_line.id;


--
-- Name: account_report_section_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_section_rel (
    main_report_id integer NOT NULL,
    sub_report_id integer NOT NULL
);


ALTER TABLE public.account_report_section_rel OWNER TO ductin;

--
-- Name: TABLE account_report_section_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_section_rel IS 'RELATION BETWEEN account_report AND account_report';


--
-- Name: account_report_send; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_send (
    id integer NOT NULL,
    mail_template_id integer,
    account_report_id integer,
    create_uid integer,
    write_uid integer,
    mode character varying,
    mail_subject character varying,
    report_options jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    enable_download boolean,
    checkbox_download boolean,
    enable_send_mail boolean,
    checkbox_send_mail boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_send OWNER TO ductin;

--
-- Name: TABLE account_report_send; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_send IS 'Account Report Send';


--
-- Name: COLUMN account_report_send.mail_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_report_send.account_report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.account_report_id IS 'Report';


--
-- Name: COLUMN account_report_send.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_send.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_send.mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.mode IS 'Mode';


--
-- Name: COLUMN account_report_send.mail_subject; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.mail_subject IS 'Subject';


--
-- Name: COLUMN account_report_send.report_options; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.report_options IS 'Report Options';


--
-- Name: COLUMN account_report_send.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_report_send.mail_body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.mail_body IS 'Contents';


--
-- Name: COLUMN account_report_send.enable_download; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.enable_download IS 'Enable Download';


--
-- Name: COLUMN account_report_send.checkbox_download; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.checkbox_download IS 'Download';


--
-- Name: COLUMN account_report_send.enable_send_mail; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.enable_send_mail IS 'Enable Send Mail';


--
-- Name: COLUMN account_report_send.checkbox_send_mail; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.checkbox_send_mail IS 'Email';


--
-- Name: COLUMN account_report_send.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.create_date IS 'Created on';


--
-- Name: COLUMN account_report_send.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_report_send.write_date IS 'Last Updated on';


--
-- Name: account_report_send_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_report_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_send_id_seq OWNER TO ductin;

--
-- Name: account_report_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_report_send_id_seq OWNED BY public.account_report_send.id;


--
-- Name: account_report_send_res_partner_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_report_send_res_partner_rel (
    account_report_send_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_report_send_res_partner_rel OWNER TO ductin;

--
-- Name: TABLE account_report_send_res_partner_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_report_send_res_partner_rel IS 'RELATION BETWEEN account_report_send AND res_partner';


--
-- Name: account_reports_export_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reports_export_wizard (
    id integer NOT NULL,
    report_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    doc_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    folder_id integer NOT NULL,
    l10n_be_reports_periodic_vat_wizard_id integer
);


ALTER TABLE public.account_reports_export_wizard OWNER TO ductin;

--
-- Name: TABLE account_reports_export_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reports_export_wizard IS 'Export wizard for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard.report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard.report_id IS 'Parent Report Id';


--
-- Name: COLUMN account_reports_export_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard.doc_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard.doc_name IS 'Documents Name';


--
-- Name: COLUMN account_reports_export_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reports_export_wizard.folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard.folder_id IS 'Folder';


--
-- Name: COLUMN account_reports_export_wizard.l10n_be_reports_periodic_vat_wizard_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard.l10n_be_reports_periodic_vat_wizard_id IS 'Periodic VAT Export Wizard';


--
-- Name: account_reports_export_wizard_format; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_reports_export_wizard_format (
    id integer NOT NULL,
    export_wizard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    fun_to_call character varying NOT NULL,
    fun_param character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard_format OWNER TO ductin;

--
-- Name: TABLE account_reports_export_wizard_format; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_reports_export_wizard_format IS 'Export format for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard_format.export_wizard_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.export_wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN account_reports_export_wizard_format.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard_format.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard_format.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.name IS 'Name';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_to_call; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_to_call IS 'Function to Call';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_param; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_param IS 'Function Parameter';


--
-- Name: COLUMN account_reports_export_wizard_format.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard_format.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_reports_export_wizard_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNER TO ductin;

--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNED BY public.account_reports_export_wizard_format.id;


--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_reports_export_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNER TO ductin;

--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNED BY public.account_reports_export_wizard.id;


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    first_date date,
    end_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_resequence_wizard OWNER TO ductin;

--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNER TO ductin;

--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_saft_import_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_saft_import_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    attachment_name character varying,
    import_opening_balance boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_saft_import_wizard OWNER TO ductin;

--
-- Name: TABLE account_saft_import_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_saft_import_wizard IS 'Account SAF-T import wizard';


--
-- Name: COLUMN account_saft_import_wizard.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_saft_import_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_saft_import_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_saft_import_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_saft_import_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_saft_import_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_saft_import_wizard.attachment_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_saft_import_wizard.attachment_name IS 'Filename';


--
-- Name: COLUMN account_saft_import_wizard.import_opening_balance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_saft_import_wizard.import_opening_balance IS 'Import account opening balances';


--
-- Name: COLUMN account_saft_import_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_saft_import_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_saft_import_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_saft_import_wizard.write_date IS 'Last Updated on';


--
-- Name: account_saft_import_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_saft_import_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_saft_import_wizard_id_seq OWNER TO ductin;

--
-- Name: account_saft_import_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_saft_import_wizard_id_seq OWNED BY public.account_saft_import_wizard.id;


--
-- Name: account_secure_entries_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_secure_entries_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    hash_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_secure_entries_wizard OWNER TO ductin;

--
-- Name: TABLE account_secure_entries_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_secure_entries_wizard IS 'Secure Journal Entries';


--
-- Name: COLUMN account_secure_entries_wizard.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_secure_entries_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_secure_entries_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_secure_entries_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_secure_entries_wizard.hash_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_secure_entries_wizard.hash_date IS 'Hash All Entries';


--
-- Name: COLUMN account_secure_entries_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_secure_entries_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_date IS 'Last Updated on';


--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_secure_entries_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNER TO ductin;

--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNED BY public.account_secure_entries_wizard.id;


--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    num_journals_without_account integer,
    create_uid integer,
    write_uid integer,
    new_journal_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_setup_bank_manual_config OWNER TO ductin;

--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account IS 'Num Journals Without Account';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNER TO ductin;

--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer NOT NULL,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    price_include_override character varying,
    tax_exigibility character varying,
    name jsonb NOT NULL,
    description jsonb,
    invoice_label jsonb,
    invoice_legal_notes text,
    amount numeric NOT NULL,
    active boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    formula text,
    ubl_cii_tax_category_code character varying,
    ubl_cii_tax_exemption_reason_code character varying
);


ALTER TABLE public.account_tax OWNER TO ductin;

--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.price_include_override; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.price_include_override IS 'Included in Price';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.description IS 'Description';


--
-- Name: COLUMN account_tax.invoice_label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.invoice_label IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.invoice_legal_notes; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.invoice_legal_notes IS 'Legal Notes';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax.formula; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.formula IS 'Formula';


--
-- Name: COLUMN account_tax.ubl_cii_tax_category_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.ubl_cii_tax_category_code IS 'Tax Category Code';


--
-- Name: COLUMN account_tax.ubl_cii_tax_exemption_reason_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax.ubl_cii_tax_exemption_reason_code IS 'Tax Exemption Reason Code';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_filiation_rel OWNER TO ductin;

--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    tax_payable_account_id integer,
    tax_receivable_account_id integer,
    advance_tax_payment_account_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    pos_receipt_label character varying,
    name jsonb NOT NULL,
    preceding_subtotal jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_group OWNER TO ductin;

--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.company_id IS 'Company';


--
-- Name: COLUMN account_tax_group.tax_payable_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.tax_payable_account_id IS 'Tax Payable Account';


--
-- Name: COLUMN account_tax_group.tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.tax_receivable_account_id IS 'Tax Receivable Account';


--
-- Name: COLUMN account_tax_group.advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.advance_tax_payment_account_id IS 'Tax Advance Account';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.pos_receipt_label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.pos_receipt_label IS 'PoS receipt label';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_group_id_seq OWNER TO ductin;

--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_hr_expense_split_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_hr_expense_split_rel (
    hr_expense_split_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_hr_expense_split_rel OWNER TO ductin;

--
-- Name: TABLE account_tax_hr_expense_split_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_hr_expense_split_rel IS 'RELATION BETWEEN hr_expense_split AND account_tax';


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_id_seq OWNER TO ductin;

--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_loyalty_reward_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_loyalty_reward_rel (
    loyalty_reward_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_loyalty_reward_rel OWNER TO ductin;

--
-- Name: TABLE account_tax_loyalty_reward_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_loyalty_reward_rel IS 'RELATION BETWEEN loyalty_reward AND account_tax';


--
-- Name: account_tax_pos_order_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_pos_order_line_rel (
    pos_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_pos_order_line_rel OWNER TO ductin;

--
-- Name: TABLE account_tax_pos_order_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_pos_order_line_rel IS 'RELATION BETWEEN pos_order_line AND account_tax';


--
-- Name: account_tax_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_purchase_order_line_rel OWNER TO ductin;

--
-- Name: TABLE account_tax_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_tax';


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    account_id integer,
    tax_id integer,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    document_type character varying NOT NULL,
    factor_percent numeric NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_repartition_line OWNER TO ductin;

--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.tax_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.document_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.document_type IS 'Related to';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNER TO ductin;

--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_sale_order_discount_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_sale_order_discount_rel (
    sale_order_discount_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_discount_rel OWNER TO ductin;

--
-- Name: TABLE account_tax_sale_order_discount_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_sale_order_discount_rel IS 'RELATION BETWEEN sale_order_discount AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_line_rel OWNER TO ductin;

--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_unit; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_unit (
    id integer NOT NULL,
    country_id integer NOT NULL,
    main_company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    vat character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_unit OWNER TO ductin;

--
-- Name: TABLE account_tax_unit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_unit IS 'Tax Unit';


--
-- Name: COLUMN account_tax_unit.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_unit.country_id IS 'Country';


--
-- Name: COLUMN account_tax_unit.main_company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_unit.main_company_id IS 'Main Company';


--
-- Name: COLUMN account_tax_unit.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_unit.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_unit.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_unit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_unit.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_unit.name IS 'Name';


--
-- Name: COLUMN account_tax_unit.vat; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_unit.vat IS 'Tax ID';


--
-- Name: COLUMN account_tax_unit.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_unit.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_unit.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_tax_unit.write_date IS 'Last Updated on';


--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_tax_unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_unit_id_seq OWNER TO ductin;

--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_tax_unit_id_seq OWNED BY public.account_tax_unit.id;


--
-- Name: account_tax_unit_res_company_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_tax_unit_res_company_rel (
    res_company_id integer NOT NULL,
    account_tax_unit_id integer NOT NULL
);


ALTER TABLE public.account_tax_unit_res_company_rel OWNER TO ductin;

--
-- Name: TABLE account_tax_unit_res_company_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_tax_unit_res_company_rel IS 'RELATION BETWEEN res_company AND account_tax_unit';


--
-- Name: account_transfer_model; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_transfer_model (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    frequency character varying NOT NULL,
    state character varying NOT NULL,
    date_start date NOT NULL,
    date_stop date,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_transfer_model OWNER TO ductin;

--
-- Name: TABLE account_transfer_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_transfer_model IS 'Account Transfer Model';


--
-- Name: COLUMN account_transfer_model.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_transfer_model.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.name IS 'Name';


--
-- Name: COLUMN account_transfer_model.frequency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.frequency IS 'Frequency';


--
-- Name: COLUMN account_transfer_model.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.state IS 'State';


--
-- Name: COLUMN account_transfer_model.date_start; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.date_start IS 'Start Date';


--
-- Name: COLUMN account_transfer_model.date_stop; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.date_stop IS 'Stop Date';


--
-- Name: COLUMN account_transfer_model.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.active IS 'Active';


--
-- Name: COLUMN account_transfer_model.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model.write_date IS 'Last Updated on';


--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_transfer_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_transfer_model_id_seq OWNER TO ductin;

--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_transfer_model_id_seq OWNED BY public.account_transfer_model.id;


--
-- Name: account_transfer_model_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_transfer_model_line (
    id integer NOT NULL,
    transfer_model_id integer NOT NULL,
    account_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percent double precision NOT NULL
);


ALTER TABLE public.account_transfer_model_line OWNER TO ductin;

--
-- Name: TABLE account_transfer_model_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_transfer_model_line IS 'Account Transfer Model Line';


--
-- Name: COLUMN account_transfer_model_line.transfer_model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model_line.transfer_model_id IS 'Transfer Model';


--
-- Name: COLUMN account_transfer_model_line.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model_line.account_id IS 'Destination Account';


--
-- Name: COLUMN account_transfer_model_line.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_transfer_model_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_transfer_model_line.percent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_transfer_model_line.percent IS 'Percent';


--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_transfer_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNER TO ductin;

--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNED BY public.account_transfer_model_line.id;


--
-- Name: account_transfer_model_line_res_partner_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_transfer_model_line_res_partner_rel (
    account_transfer_model_line_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_transfer_model_line_res_partner_rel OWNER TO ductin;

--
-- Name: TABLE account_transfer_model_line_res_partner_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_transfer_model_line_res_partner_rel IS 'RELATION BETWEEN account_transfer_model_line AND res_partner';


--
-- Name: account_update_tax_tags_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_update_tax_tags_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_update_tax_tags_wizard OWNER TO ductin;

--
-- Name: TABLE account_update_tax_tags_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_update_tax_tags_wizard IS 'Update Tax Tags Wizard';


--
-- Name: COLUMN account_update_tax_tags_wizard.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_update_tax_tags_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_update_tax_tags_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_update_tax_tags_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_update_tax_tags_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_update_tax_tags_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_update_tax_tags_wizard.date_from; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_update_tax_tags_wizard.date_from IS 'Starting from';


--
-- Name: COLUMN account_update_tax_tags_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_update_tax_tags_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_update_tax_tags_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_update_tax_tags_wizard.write_date IS 'Last Updated on';


--
-- Name: account_update_tax_tags_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_update_tax_tags_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_update_tax_tags_wizard_id_seq OWNER TO ductin;

--
-- Name: account_update_tax_tags_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_update_tax_tags_wizard_id_seq OWNED BY public.account_update_tax_tags_wizard.id;


--
-- Name: account_winbooks_import_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.account_winbooks_import_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    suspense_code character varying,
    only_open boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_winbooks_import_wizard OWNER TO ductin;

--
-- Name: TABLE account_winbooks_import_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.account_winbooks_import_wizard IS 'Account Winbooks import wizard';


--
-- Name: COLUMN account_winbooks_import_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_winbooks_import_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_winbooks_import_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_winbooks_import_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_winbooks_import_wizard.suspense_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_winbooks_import_wizard.suspense_code IS 'Suspense Account Code';


--
-- Name: COLUMN account_winbooks_import_wizard.only_open; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_winbooks_import_wizard.only_open IS 'Import only open years';


--
-- Name: COLUMN account_winbooks_import_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_winbooks_import_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_winbooks_import_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.account_winbooks_import_wizard.write_date IS 'Last Updated on';


--
-- Name: account_winbooks_import_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.account_winbooks_import_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_winbooks_import_wizard_id_seq OWNER TO ductin;

--
-- Name: account_winbooks_import_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.account_winbooks_import_wizard_id_seq OWNED BY public.account_winbooks_import_wizard.id;


--
-- Name: accountant_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.accountant_res_users_rel (
    hr_department_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.accountant_res_users_rel OWNER TO ductin;

--
-- Name: TABLE accountant_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.accountant_res_users_rel IS 'RELATION BETWEEN hr_department AND res_users';


--
-- Name: accounting_assert_test; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.accounting_assert_test (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    "desc" jsonb,
    code_exec text NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.accounting_assert_test OWNER TO ductin;

--
-- Name: TABLE accounting_assert_test; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.accounting_assert_test IS 'Accounting Assert Test';


--
-- Name: COLUMN accounting_assert_test.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test.sequence IS 'Sequence';


--
-- Name: COLUMN accounting_assert_test.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test.create_uid IS 'Created by';


--
-- Name: COLUMN accounting_assert_test.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN accounting_assert_test.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test.name IS 'Test Name';


--
-- Name: COLUMN accounting_assert_test."desc"; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test."desc" IS 'Test Description';


--
-- Name: COLUMN accounting_assert_test.code_exec; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test.code_exec IS 'Python code';


--
-- Name: COLUMN accounting_assert_test.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test.active IS 'Active';


--
-- Name: COLUMN accounting_assert_test.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test.create_date IS 'Created on';


--
-- Name: COLUMN accounting_assert_test.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.accounting_assert_test.write_date IS 'Last Updated on';


--
-- Name: accounting_assert_test_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.accounting_assert_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.accounting_assert_test_id_seq OWNER TO ductin;

--
-- Name: accounting_assert_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.accounting_assert_test_id_seq OWNED BY public.accounting_assert_test.id;


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO ductin;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: add_iot_box; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.add_iot_box (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    pairing_code character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.add_iot_box OWNER TO ductin;

--
-- Name: TABLE add_iot_box; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.add_iot_box IS 'Add IoT Box wizard';


--
-- Name: COLUMN add_iot_box.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.add_iot_box.create_uid IS 'Created by';


--
-- Name: COLUMN add_iot_box.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.add_iot_box.write_uid IS 'Last Updated by';


--
-- Name: COLUMN add_iot_box.pairing_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.add_iot_box.pairing_code IS 'Pairing Code';


--
-- Name: COLUMN add_iot_box.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.add_iot_box.create_date IS 'Created on';


--
-- Name: COLUMN add_iot_box.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.add_iot_box.write_date IS 'Last Updated on';


--
-- Name: add_iot_box_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.add_iot_box_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.add_iot_box_id_seq OWNER TO ductin;

--
-- Name: add_iot_box_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.add_iot_box_id_seq OWNED BY public.add_iot_box.id;


--
-- Name: additional_fee; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.additional_fee (
    id integer NOT NULL,
    type_id integer NOT NULL,
    reconciliation_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    additional_expense double precision NOT NULL
);


ALTER TABLE public.additional_fee OWNER TO ductin;

--
-- Name: TABLE additional_fee; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.additional_fee IS 'Additional Fee (Mostly using for Montly Reconciliation)';


--
-- Name: COLUMN additional_fee.type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee.type_id IS 'Type';


--
-- Name: COLUMN additional_fee.reconciliation_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee.reconciliation_id IS 'Reconciliation';


--
-- Name: COLUMN additional_fee.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee.create_uid IS 'Created by';


--
-- Name: COLUMN additional_fee.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN additional_fee.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee.create_date IS 'Created on';


--
-- Name: COLUMN additional_fee.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee.write_date IS 'Last Updated on';


--
-- Name: COLUMN additional_fee.additional_expense; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee.additional_expense IS 'Additional Expense';


--
-- Name: additional_fee_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.additional_fee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.additional_fee_id_seq OWNER TO ductin;

--
-- Name: additional_fee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.additional_fee_id_seq OWNED BY public.additional_fee.id;


--
-- Name: additional_fee_type; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.additional_fee_type (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.additional_fee_type OWNER TO ductin;

--
-- Name: TABLE additional_fee_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.additional_fee_type IS 'Additional Fee Type (Mostly using for Montly Reconciliation)';


--
-- Name: COLUMN additional_fee_type.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee_type.create_uid IS 'Created by';


--
-- Name: COLUMN additional_fee_type.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN additional_fee_type.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee_type.name IS 'Name';


--
-- Name: COLUMN additional_fee_type.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee_type.create_date IS 'Created on';


--
-- Name: COLUMN additional_fee_type.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.additional_fee_type.write_date IS 'Last Updated on';


--
-- Name: additional_fee_type_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.additional_fee_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.additional_fee_type_id_seq OWNER TO ductin;

--
-- Name: additional_fee_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.additional_fee_type_id_seq OWNED BY public.additional_fee_type.id;


--
-- Name: advance_payment_history; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.advance_payment_history (
    id integer NOT NULL,
    request_id integer NOT NULL,
    request_user_id integer,
    sender_user_id integer,
    sender_wallet_id integer,
    sender_bank_id integer,
    receiver_user_id integer,
    receiver_wallet_id integer,
    receiver_bank_id integer,
    wallet_transaction_id integer,
    create_uid integer,
    write_uid integer,
    sender_account_number character varying,
    receiver_account_number character varying,
    reference text,
    receiver_is_resource_dept boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision NOT NULL
);


ALTER TABLE public.advance_payment_history OWNER TO ductin;

--
-- Name: TABLE advance_payment_history; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.advance_payment_history IS 'Advance Payment History';


--
-- Name: COLUMN advance_payment_history.request_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.request_id IS 'Request';


--
-- Name: COLUMN advance_payment_history.request_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.request_user_id IS 'Request User';


--
-- Name: COLUMN advance_payment_history.sender_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.sender_user_id IS 'Sender (Accountant)';


--
-- Name: COLUMN advance_payment_history.sender_wallet_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.sender_wallet_id IS 'Sender Wallet';


--
-- Name: COLUMN advance_payment_history.sender_bank_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.sender_bank_id IS 'Sender Bank';


--
-- Name: COLUMN advance_payment_history.receiver_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.receiver_user_id IS 'Receiver User';


--
-- Name: COLUMN advance_payment_history.receiver_wallet_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.receiver_wallet_id IS 'Receiver Wallet';


--
-- Name: COLUMN advance_payment_history.receiver_bank_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.receiver_bank_id IS 'Receiver Bank';


--
-- Name: COLUMN advance_payment_history.wallet_transaction_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.wallet_transaction_id IS 'Wallet Transaction';


--
-- Name: COLUMN advance_payment_history.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.create_uid IS 'Created by';


--
-- Name: COLUMN advance_payment_history.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN advance_payment_history.sender_account_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.sender_account_number IS 'Sender Account Number';


--
-- Name: COLUMN advance_payment_history.receiver_account_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.receiver_account_number IS 'Receiver Account Number';


--
-- Name: COLUMN advance_payment_history.reference; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.reference IS 'Reference/Content';


--
-- Name: COLUMN advance_payment_history.receiver_is_resource_dept; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.receiver_is_resource_dept IS 'Receiver is Resource Dept';


--
-- Name: COLUMN advance_payment_history.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.date IS 'Date';


--
-- Name: COLUMN advance_payment_history.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.create_date IS 'Created on';


--
-- Name: COLUMN advance_payment_history.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.write_date IS 'Last Updated on';


--
-- Name: COLUMN advance_payment_history.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.advance_payment_history.amount IS 'Amount';


--
-- Name: advance_payment_history_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.advance_payment_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.advance_payment_history_id_seq OWNER TO ductin;

--
-- Name: advance_payment_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.advance_payment_history_id_seq OWNED BY public.advance_payment_history.id;


--
-- Name: advance_payment_history_mkt_period_reconciliation_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.advance_payment_history_mkt_period_reconciliation_rel (
    mkt_period_reconciliation_id integer NOT NULL,
    advance_payment_history_id integer NOT NULL
);


ALTER TABLE public.advance_payment_history_mkt_period_reconciliation_rel OWNER TO ductin;

--
-- Name: TABLE advance_payment_history_mkt_period_reconciliation_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.advance_payment_history_mkt_period_reconciliation_rel IS 'RELATION BETWEEN mkt_period_reconciliation AND advance_payment_history';


--
-- Name: allocation_lead_history; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.allocation_lead_history (
    id integer NOT NULL,
    fb_page_id integer NOT NULL,
    resale_user_id integer,
    resale_team_id integer,
    crm_group_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.allocation_lead_history OWNER TO ductin;

--
-- Name: TABLE allocation_lead_history; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.allocation_lead_history IS 'Allocation Lead History';


--
-- Name: COLUMN allocation_lead_history.fb_page_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.allocation_lead_history.fb_page_id IS 'Fb Page';


--
-- Name: COLUMN allocation_lead_history.resale_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.allocation_lead_history.resale_user_id IS 'Resale User';


--
-- Name: COLUMN allocation_lead_history.resale_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.allocation_lead_history.resale_team_id IS 'Resale Team';


--
-- Name: COLUMN allocation_lead_history.crm_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.allocation_lead_history.crm_group_id IS 'Crm Group';


--
-- Name: COLUMN allocation_lead_history.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.allocation_lead_history.create_uid IS 'Created by';


--
-- Name: COLUMN allocation_lead_history.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.allocation_lead_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN allocation_lead_history.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.allocation_lead_history.create_date IS 'Created on';


--
-- Name: COLUMN allocation_lead_history.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.allocation_lead_history.write_date IS 'Last Updated on';


--
-- Name: allocation_lead_history_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.allocation_lead_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.allocation_lead_history_id_seq OWNER TO ductin;

--
-- Name: allocation_lead_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.allocation_lead_history_id_seq OWNED BY public.allocation_lead_history.id;


--
-- Name: amazon_account; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.amazon_account (
    id integer NOT NULL,
    base_marketplace_id integer NOT NULL,
    user_id integer,
    team_id integer,
    company_id integer NOT NULL,
    location_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    seller_key character varying,
    refresh_token character varying,
    active boolean NOT NULL,
    synchronize_inventory boolean,
    last_orders_sync timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.amazon_account OWNER TO ductin;

--
-- Name: TABLE amazon_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.amazon_account IS 'Amazon Account';


--
-- Name: COLUMN amazon_account.base_marketplace_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.base_marketplace_id IS 'Home Marketplace';


--
-- Name: COLUMN amazon_account.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.user_id IS 'Salesperson';


--
-- Name: COLUMN amazon_account.team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.team_id IS 'Sales Team';


--
-- Name: COLUMN amazon_account.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.company_id IS 'Company';


--
-- Name: COLUMN amazon_account.location_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.location_id IS 'Stock Location';


--
-- Name: COLUMN amazon_account.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.create_uid IS 'Created by';


--
-- Name: COLUMN amazon_account.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN amazon_account.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.name IS 'Name';


--
-- Name: COLUMN amazon_account.seller_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.seller_key IS 'Seller Key';


--
-- Name: COLUMN amazon_account.refresh_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.refresh_token IS 'LWA Refresh Token';


--
-- Name: COLUMN amazon_account.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.active IS 'Active';


--
-- Name: COLUMN amazon_account.synchronize_inventory; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.synchronize_inventory IS 'Synchronize FBM Inventory';


--
-- Name: COLUMN amazon_account.last_orders_sync; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.last_orders_sync IS 'Last Orders Sync';


--
-- Name: COLUMN amazon_account.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.create_date IS 'Created on';


--
-- Name: COLUMN amazon_account.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_account.write_date IS 'Last Updated on';


--
-- Name: amazon_account_active_marketplace_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.amazon_account_active_marketplace_rel (
    amazon_account_id integer NOT NULL,
    amazon_marketplace_id integer NOT NULL
);


ALTER TABLE public.amazon_account_active_marketplace_rel OWNER TO ductin;

--
-- Name: TABLE amazon_account_active_marketplace_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.amazon_account_active_marketplace_rel IS 'RELATION BETWEEN amazon_account AND amazon_marketplace';


--
-- Name: amazon_account_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.amazon_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.amazon_account_id_seq OWNER TO ductin;

--
-- Name: amazon_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.amazon_account_id_seq OWNED BY public.amazon_account.id;


--
-- Name: amazon_account_marketplace_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.amazon_account_marketplace_rel (
    amazon_account_id integer NOT NULL,
    amazon_marketplace_id integer NOT NULL
);


ALTER TABLE public.amazon_account_marketplace_rel OWNER TO ductin;

--
-- Name: TABLE amazon_account_marketplace_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.amazon_account_marketplace_rel IS 'RELATION BETWEEN amazon_account AND amazon_marketplace';


--
-- Name: amazon_marketplace; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.amazon_marketplace (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    api_ref character varying NOT NULL,
    region character varying NOT NULL,
    seller_central_url character varying NOT NULL,
    name jsonb NOT NULL,
    tax_included boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.amazon_marketplace OWNER TO ductin;

--
-- Name: TABLE amazon_marketplace; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.amazon_marketplace IS 'Amazon Marketplace';


--
-- Name: COLUMN amazon_marketplace.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.create_uid IS 'Created by';


--
-- Name: COLUMN amazon_marketplace.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.write_uid IS 'Last Updated by';


--
-- Name: COLUMN amazon_marketplace.api_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.api_ref IS 'API Identifier';


--
-- Name: COLUMN amazon_marketplace.region; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.region IS 'Region';


--
-- Name: COLUMN amazon_marketplace.seller_central_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.seller_central_url IS 'Seller Central URL';


--
-- Name: COLUMN amazon_marketplace.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.name IS 'Name';


--
-- Name: COLUMN amazon_marketplace.tax_included; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.tax_included IS 'Tax Included';


--
-- Name: COLUMN amazon_marketplace.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.create_date IS 'Created on';


--
-- Name: COLUMN amazon_marketplace.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_marketplace.write_date IS 'Last Updated on';


--
-- Name: amazon_marketplace_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.amazon_marketplace_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.amazon_marketplace_id_seq OWNER TO ductin;

--
-- Name: amazon_marketplace_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.amazon_marketplace_id_seq OWNED BY public.amazon_marketplace.id;


--
-- Name: amazon_offer; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.amazon_offer (
    id integer NOT NULL,
    account_id integer NOT NULL,
    marketplace_id integer NOT NULL,
    product_id integer NOT NULL,
    product_template_id integer,
    create_uid integer,
    write_uid integer,
    sku character varying NOT NULL,
    amazon_sync_status character varying,
    amazon_feed_ref character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.amazon_offer OWNER TO ductin;

--
-- Name: TABLE amazon_offer; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.amazon_offer IS 'Amazon Offer';


--
-- Name: COLUMN amazon_offer.account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.account_id IS 'Account';


--
-- Name: COLUMN amazon_offer.marketplace_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.marketplace_id IS 'Marketplace';


--
-- Name: COLUMN amazon_offer.product_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.product_id IS 'Product';


--
-- Name: COLUMN amazon_offer.product_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.product_template_id IS 'Product Template';


--
-- Name: COLUMN amazon_offer.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.create_uid IS 'Created by';


--
-- Name: COLUMN amazon_offer.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN amazon_offer.sku; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.sku IS 'SKU';


--
-- Name: COLUMN amazon_offer.amazon_sync_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.amazon_sync_status IS 'Amazon Synchronization Status';


--
-- Name: COLUMN amazon_offer.amazon_feed_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.amazon_feed_ref IS 'Amazon Feed Reference';


--
-- Name: COLUMN amazon_offer.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.create_date IS 'Created on';


--
-- Name: COLUMN amazon_offer.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_offer.write_date IS 'Last Updated on';


--
-- Name: amazon_offer_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.amazon_offer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.amazon_offer_id_seq OWNER TO ductin;

--
-- Name: amazon_offer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.amazon_offer_id_seq OWNED BY public.amazon_offer.id;


--
-- Name: amazon_recover_order_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.amazon_recover_order_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    amazon_order_ref character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.amazon_recover_order_wizard OWNER TO ductin;

--
-- Name: TABLE amazon_recover_order_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.amazon_recover_order_wizard IS 'Amazon Recover Order Wizard';


--
-- Name: COLUMN amazon_recover_order_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_recover_order_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN amazon_recover_order_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_recover_order_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN amazon_recover_order_wizard.amazon_order_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_recover_order_wizard.amazon_order_ref IS 'Amazon Order Reference';


--
-- Name: COLUMN amazon_recover_order_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_recover_order_wizard.create_date IS 'Created on';


--
-- Name: COLUMN amazon_recover_order_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.amazon_recover_order_wizard.write_date IS 'Last Updated on';


--
-- Name: amazon_recover_order_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.amazon_recover_order_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.amazon_recover_order_wizard_id_seq OWNER TO ductin;

--
-- Name: amazon_recover_order_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.amazon_recover_order_wizard_id_seq OWNED BY public.amazon_recover_order_wizard.id;


--
-- Name: api_request_log; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.api_request_log (
    id integer NOT NULL,
    response_status integer,
    user_id integer,
    res_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    request_method character varying,
    request_url character varying,
    res_model character varying,
    res_ref character varying,
    request_headers text,
    request_body text,
    response_headers text,
    response_data text,
    error_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.api_request_log OWNER TO ductin;

--
-- Name: TABLE api_request_log; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.api_request_log IS 'API Request Log';


--
-- Name: COLUMN api_request_log.response_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.response_status IS 'Response Status';


--
-- Name: COLUMN api_request_log.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.user_id IS 'User';


--
-- Name: COLUMN api_request_log.res_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.res_id IS 'Record ID';


--
-- Name: COLUMN api_request_log.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.company_id IS 'Company';


--
-- Name: COLUMN api_request_log.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.create_uid IS 'Created by';


--
-- Name: COLUMN api_request_log.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN api_request_log.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.name IS 'Name';


--
-- Name: COLUMN api_request_log.request_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.request_method IS 'HTTP Method';


--
-- Name: COLUMN api_request_log.request_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.request_url IS 'URL';


--
-- Name: COLUMN api_request_log.res_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.res_model IS 'Model';


--
-- Name: COLUMN api_request_log.res_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.res_ref IS 'Record';


--
-- Name: COLUMN api_request_log.request_headers; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.request_headers IS 'Headers';


--
-- Name: COLUMN api_request_log.request_body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.request_body IS 'Request Body';


--
-- Name: COLUMN api_request_log.response_headers; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.response_headers IS 'Response Headers';


--
-- Name: COLUMN api_request_log.response_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.response_data IS 'Response Data';


--
-- Name: COLUMN api_request_log.error_message; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.error_message IS 'Error Message';


--
-- Name: COLUMN api_request_log.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.create_date IS 'Created on';


--
-- Name: COLUMN api_request_log.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.write_date IS 'Last Updated on';


--
-- Name: COLUMN api_request_log.duration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.api_request_log.duration IS 'Duration (s)';


--
-- Name: api_request_log_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.api_request_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.api_request_log_id_seq OWNER TO ductin;

--
-- Name: api_request_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.api_request_log_id_seq OWNED BY public.api_request_log.id;


--
-- Name: applicant_get_refuse_reason; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.applicant_get_refuse_reason (
    id integer NOT NULL,
    refuse_reason_id integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    send_mail boolean,
    duplicates boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rejection_reason_id integer,
    rejected_by character varying NOT NULL,
    subject character varying,
    hr_receiver_email character varying,
    email_cc character varying,
    body text
);


ALTER TABLE public.applicant_get_refuse_reason OWNER TO ductin;

--
-- Name: TABLE applicant_get_refuse_reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.applicant_get_refuse_reason IS 'Get Refuse Reason';


--
-- Name: COLUMN applicant_get_refuse_reason.refuse_reason_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.refuse_reason_id IS 'Refuse Reason';


--
-- Name: COLUMN applicant_get_refuse_reason.template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.template_id IS 'Email Template';


--
-- Name: COLUMN applicant_get_refuse_reason.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.create_uid IS 'Created by';


--
-- Name: COLUMN applicant_get_refuse_reason.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN applicant_get_refuse_reason.send_mail; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.send_mail IS 'Send Email';


--
-- Name: COLUMN applicant_get_refuse_reason.duplicates; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.duplicates IS 'Duplicates';


--
-- Name: COLUMN applicant_get_refuse_reason.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.create_date IS 'Created on';


--
-- Name: COLUMN applicant_get_refuse_reason.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.write_date IS 'Last Updated on';


--
-- Name: COLUMN applicant_get_refuse_reason.rejection_reason_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.rejection_reason_id IS 'Candidate Rejection Reason';


--
-- Name: COLUMN applicant_get_refuse_reason.rejected_by; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.rejected_by IS 'Rejected By';


--
-- Name: COLUMN applicant_get_refuse_reason.subject; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.subject IS 'Subject';


--
-- Name: COLUMN applicant_get_refuse_reason.hr_receiver_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.hr_receiver_email IS 'HR Receive Email';


--
-- Name: COLUMN applicant_get_refuse_reason.email_cc; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.email_cc IS 'Email CC';


--
-- Name: COLUMN applicant_get_refuse_reason.body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.body IS 'Body';


--
-- Name: applicant_get_refuse_reason_hr_applicant_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.applicant_get_refuse_reason_hr_applicant_rel (
    applicant_get_refuse_reason_id integer NOT NULL,
    hr_applicant_id integer NOT NULL
);


ALTER TABLE public.applicant_get_refuse_reason_hr_applicant_rel OWNER TO ductin;

--
-- Name: TABLE applicant_get_refuse_reason_hr_applicant_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.applicant_get_refuse_reason_hr_applicant_rel IS 'RELATION BETWEEN applicant_get_refuse_reason AND hr_applicant';


--
-- Name: applicant_get_refuse_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.applicant_get_refuse_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.applicant_get_refuse_reason_id_seq OWNER TO ductin;

--
-- Name: applicant_get_refuse_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.applicant_get_refuse_reason_id_seq OWNED BY public.applicant_get_refuse_reason.id;


--
-- Name: applicant_send_mail; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.applicant_send_mail (
    id integer NOT NULL,
    template_id integer,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.applicant_send_mail OWNER TO ductin;

--
-- Name: TABLE applicant_send_mail; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.applicant_send_mail IS 'Send mails to applicants';


--
-- Name: COLUMN applicant_send_mail.template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.template_id IS 'Mail Template';


--
-- Name: COLUMN applicant_send_mail.author_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.author_id IS 'Author';


--
-- Name: COLUMN applicant_send_mail.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.create_uid IS 'Created by';


--
-- Name: COLUMN applicant_send_mail.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN applicant_send_mail.lang; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.lang IS 'Language';


--
-- Name: COLUMN applicant_send_mail.subject; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.subject IS 'Subject';


--
-- Name: COLUMN applicant_send_mail.body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.body IS 'Contents';


--
-- Name: COLUMN applicant_send_mail.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.create_date IS 'Created on';


--
-- Name: COLUMN applicant_send_mail.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.applicant_send_mail.write_date IS 'Last Updated on';


--
-- Name: applicant_send_mail_hr_applicant_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.applicant_send_mail_hr_applicant_rel (
    applicant_send_mail_id integer NOT NULL,
    hr_applicant_id integer NOT NULL
);


ALTER TABLE public.applicant_send_mail_hr_applicant_rel OWNER TO ductin;

--
-- Name: TABLE applicant_send_mail_hr_applicant_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.applicant_send_mail_hr_applicant_rel IS 'RELATION BETWEEN applicant_send_mail AND hr_applicant';


--
-- Name: applicant_send_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.applicant_send_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.applicant_send_mail_id_seq OWNER TO ductin;

--
-- Name: applicant_send_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.applicant_send_mail_id_seq OWNED BY public.applicant_send_mail.id;


--
-- Name: applicant_send_mail_ir_attachment_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.applicant_send_mail_ir_attachment_rel (
    applicant_send_mail_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.applicant_send_mail_ir_attachment_rel OWNER TO ductin;

--
-- Name: TABLE applicant_send_mail_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.applicant_send_mail_ir_attachment_rel IS 'RELATION BETWEEN applicant_send_mail AND ir_attachment';


--
-- Name: appointment_answer; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_answer (
    id integer NOT NULL,
    question_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.appointment_answer OWNER TO ductin;

--
-- Name: TABLE appointment_answer; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_answer IS 'Appointment Question Answers';


--
-- Name: COLUMN appointment_answer.question_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer.question_id IS 'Question';


--
-- Name: COLUMN appointment_answer.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_answer.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_answer.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_answer.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer.name IS 'Answer';


--
-- Name: COLUMN appointment_answer.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer.create_date IS 'Created on';


--
-- Name: COLUMN appointment_answer.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer.write_date IS 'Last Updated on';


--
-- Name: appointment_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_answer_id_seq OWNER TO ductin;

--
-- Name: appointment_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_answer_id_seq OWNED BY public.appointment_answer.id;


--
-- Name: appointment_answer_input; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_answer_input (
    id integer NOT NULL,
    question_id integer NOT NULL,
    value_answer_id integer,
    appointment_type_id integer NOT NULL,
    calendar_event_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    value_text_box text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    calendar_booking_id integer,
    CONSTRAINT appointment_answer_input_check_event_or_booking CHECK (((calendar_booking_id IS NOT NULL) OR (calendar_event_id IS NOT NULL))),
    CONSTRAINT appointment_answer_input_value_check CHECK (((value_answer_id IS NOT NULL) OR (COALESCE(value_text_box, ''::text) <> ''::text)))
);


ALTER TABLE public.appointment_answer_input OWNER TO ductin;

--
-- Name: TABLE appointment_answer_input; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_answer_input IS 'Appointment Answer Inputs';


--
-- Name: COLUMN appointment_answer_input.question_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.question_id IS 'Question';


--
-- Name: COLUMN appointment_answer_input.value_answer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.value_answer_id IS 'Selected Answer';


--
-- Name: COLUMN appointment_answer_input.appointment_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN appointment_answer_input.calendar_event_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.calendar_event_id IS 'Calendar Event';


--
-- Name: COLUMN appointment_answer_input.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.partner_id IS 'Customer';


--
-- Name: COLUMN appointment_answer_input.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_answer_input.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_answer_input.value_text_box; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.value_text_box IS 'Text Answer';


--
-- Name: COLUMN appointment_answer_input.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.create_date IS 'Created on';


--
-- Name: COLUMN appointment_answer_input.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_answer_input.calendar_booking_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_answer_input.calendar_booking_id IS 'Meeting Booking';


--
-- Name: CONSTRAINT appointment_answer_input_check_event_or_booking ON appointment_answer_input; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT appointment_answer_input_check_event_or_booking ON public.appointment_answer_input IS 'CHECK(calendar_booking_id IS NOT NULL OR calendar_event_id IS NOT NULL)';


--
-- Name: CONSTRAINT appointment_answer_input_value_check ON appointment_answer_input; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT appointment_answer_input_value_check ON public.appointment_answer_input IS 'CHECK(value_answer_id IS NOT NULL OR COALESCE(value_text_box, '''') <> '''')';


--
-- Name: appointment_answer_input_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_answer_input_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_answer_input_id_seq OWNER TO ductin;

--
-- Name: appointment_answer_input_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_answer_input_id_seq OWNED BY public.appointment_answer_input.id;


--
-- Name: appointment_booking_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_booking_line (
    id integer NOT NULL,
    appointment_resource_id integer NOT NULL,
    appointment_type_id integer,
    capacity_reserved integer NOT NULL,
    capacity_used integer,
    calendar_event_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    event_start timestamp without time zone,
    event_stop timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT appointment_booking_line_check_capacity_reserved CHECK ((capacity_reserved >= 0)),
    CONSTRAINT appointment_booking_line_check_capacity_used CHECK ((capacity_used >= capacity_reserved))
);


ALTER TABLE public.appointment_booking_line OWNER TO ductin;

--
-- Name: TABLE appointment_booking_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_booking_line IS 'Appointment Booking Line';


--
-- Name: COLUMN appointment_booking_line.appointment_resource_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.appointment_resource_id IS 'Appointment Resource';


--
-- Name: COLUMN appointment_booking_line.appointment_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.appointment_type_id IS 'Appointment';


--
-- Name: COLUMN appointment_booking_line.capacity_reserved; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.capacity_reserved IS 'Capacity Reserved';


--
-- Name: COLUMN appointment_booking_line.capacity_used; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.capacity_used IS 'Capacity Used';


--
-- Name: COLUMN appointment_booking_line.calendar_event_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.calendar_event_id IS 'Booking';


--
-- Name: COLUMN appointment_booking_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_booking_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_booking_line.event_start; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.event_start IS 'Booking Start';


--
-- Name: COLUMN appointment_booking_line.event_stop; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.event_stop IS 'Booking End';


--
-- Name: COLUMN appointment_booking_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.create_date IS 'Created on';


--
-- Name: COLUMN appointment_booking_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_booking_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT appointment_booking_line_check_capacity_reserved ON appointment_booking_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT appointment_booking_line_check_capacity_reserved ON public.appointment_booking_line IS 'CHECK(capacity_reserved >= 0)';


--
-- Name: CONSTRAINT appointment_booking_line_check_capacity_used ON appointment_booking_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT appointment_booking_line_check_capacity_used ON public.appointment_booking_line IS 'CHECK(capacity_used >= capacity_reserved)';


--
-- Name: appointment_booking_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_booking_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_booking_line_id_seq OWNER TO ductin;

--
-- Name: appointment_booking_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_booking_line_id_seq OWNED BY public.appointment_booking_line.id;


--
-- Name: appointment_internal_communication_employee_ids_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_internal_communication_employee_ids_rel (
    employee_id integer NOT NULL,
    category_id integer NOT NULL
);


ALTER TABLE public.appointment_internal_communication_employee_ids_rel OWNER TO ductin;

--
-- Name: TABLE appointment_internal_communication_employee_ids_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_internal_communication_employee_ids_rel IS 'RELATION BETWEEN approval_category AND hr_employee';


--
-- Name: appointment_invite; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_invite (
    id integer NOT NULL,
    appointment_type_count integer,
    create_uid integer,
    write_uid integer,
    access_token character varying NOT NULL,
    short_code character varying NOT NULL,
    resources_choice character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    opportunity_id integer,
    applicant_id integer,
    website_id integer,
    is_published boolean
);


ALTER TABLE public.appointment_invite OWNER TO ductin;

--
-- Name: TABLE appointment_invite; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_invite IS 'Appointment Invite';


--
-- Name: COLUMN appointment_invite.appointment_type_count; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.appointment_type_count IS 'Selected Appointments Count';


--
-- Name: COLUMN appointment_invite.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_invite.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_invite.access_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.access_token IS 'Token';


--
-- Name: COLUMN appointment_invite.short_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.short_code IS 'Short Code';


--
-- Name: COLUMN appointment_invite.resources_choice; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.resources_choice IS 'Assign to';


--
-- Name: COLUMN appointment_invite.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.create_date IS 'Created on';


--
-- Name: COLUMN appointment_invite.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_invite.opportunity_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.opportunity_id IS 'Opportunity/Lead';


--
-- Name: COLUMN appointment_invite.applicant_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.applicant_id IS 'Applicant';


--
-- Name: COLUMN appointment_invite.website_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.website_id IS 'Website';


--
-- Name: COLUMN appointment_invite.is_published; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_invite.is_published IS 'Is Published';


--
-- Name: appointment_invite_appointment_resource_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_invite_appointment_resource_rel (
    appointment_invite_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


ALTER TABLE public.appointment_invite_appointment_resource_rel OWNER TO ductin;

--
-- Name: TABLE appointment_invite_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_invite_appointment_resource_rel IS 'RELATION BETWEEN appointment_invite AND appointment_resource';


--
-- Name: appointment_invite_appointment_type_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_invite_appointment_type_rel (
    appointment_invite_id integer NOT NULL,
    appointment_type_id integer NOT NULL
);


ALTER TABLE public.appointment_invite_appointment_type_rel OWNER TO ductin;

--
-- Name: TABLE appointment_invite_appointment_type_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_invite_appointment_type_rel IS 'RELATION BETWEEN appointment_invite AND appointment_type';


--
-- Name: appointment_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_invite_id_seq OWNER TO ductin;

--
-- Name: appointment_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_invite_id_seq OWNED BY public.appointment_invite.id;


--
-- Name: appointment_invite_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_invite_res_users_rel (
    appointment_invite_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.appointment_invite_res_users_rel OWNER TO ductin;

--
-- Name: TABLE appointment_invite_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_invite_res_users_rel IS 'RELATION BETWEEN appointment_invite AND res_users';


--
-- Name: appointment_manage_leaves; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_manage_leaves (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    leave_start_dt timestamp without time zone NOT NULL,
    leave_end_dt timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.appointment_manage_leaves OWNER TO ductin;

--
-- Name: TABLE appointment_manage_leaves; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_manage_leaves IS 'Add or remove leaves from appointments';


--
-- Name: COLUMN appointment_manage_leaves.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_manage_leaves.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_manage_leaves.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_manage_leaves.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_manage_leaves.reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_manage_leaves.reason IS 'Reason';


--
-- Name: COLUMN appointment_manage_leaves.leave_start_dt; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_manage_leaves.leave_start_dt IS 'Start Date';


--
-- Name: COLUMN appointment_manage_leaves.leave_end_dt; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_manage_leaves.leave_end_dt IS 'End Date';


--
-- Name: COLUMN appointment_manage_leaves.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_manage_leaves.create_date IS 'Created on';


--
-- Name: COLUMN appointment_manage_leaves.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_manage_leaves.write_date IS 'Last Updated on';


--
-- Name: appointment_manage_leaves_appointment_resource_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_manage_leaves_appointment_resource_rel (
    appointment_manage_leaves_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


ALTER TABLE public.appointment_manage_leaves_appointment_resource_rel OWNER TO ductin;

--
-- Name: TABLE appointment_manage_leaves_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_manage_leaves_appointment_resource_rel IS 'RELATION BETWEEN appointment_manage_leaves AND appointment_resource';


--
-- Name: appointment_manage_leaves_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_manage_leaves_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_manage_leaves_id_seq OWNER TO ductin;

--
-- Name: appointment_manage_leaves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_manage_leaves_id_seq OWNED BY public.appointment_manage_leaves.id;


--
-- Name: appointment_question; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_question (
    id integer NOT NULL,
    sequence integer,
    appointment_type_id integer,
    create_uid integer,
    write_uid integer,
    question_type character varying,
    name jsonb NOT NULL,
    placeholder jsonb,
    question_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.appointment_question OWNER TO ductin;

--
-- Name: TABLE appointment_question; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_question IS 'Appointment Questions';


--
-- Name: COLUMN appointment_question.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_question.appointment_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN appointment_question.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_question.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_question.question_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.question_type IS 'Answer Type';


--
-- Name: COLUMN appointment_question.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.name IS 'Question';


--
-- Name: COLUMN appointment_question.placeholder; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.placeholder IS 'Placeholder';


--
-- Name: COLUMN appointment_question.question_required; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.question_required IS 'Mandatory Answer';


--
-- Name: COLUMN appointment_question.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.create_date IS 'Created on';


--
-- Name: COLUMN appointment_question.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_question.write_date IS 'Last Updated on';


--
-- Name: appointment_question_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_question_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_question_id_seq OWNER TO ductin;

--
-- Name: appointment_question_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_question_id_seq OWNED BY public.appointment_question.id;


--
-- Name: appointment_resource; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_resource (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer,
    resource_calendar_id integer,
    sequence integer NOT NULL,
    capacity integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description jsonb,
    active boolean,
    shareable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT appointment_resource_check_capacity CHECK ((capacity >= 1))
);


ALTER TABLE public.appointment_resource OWNER TO ductin;

--
-- Name: TABLE appointment_resource; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_resource IS 'Appointment Resource';


--
-- Name: COLUMN appointment_resource.resource_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.resource_id IS 'Resource';


--
-- Name: COLUMN appointment_resource.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.company_id IS 'Company';


--
-- Name: COLUMN appointment_resource.resource_calendar_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN appointment_resource.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_resource.capacity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.capacity IS 'Capacity';


--
-- Name: COLUMN appointment_resource.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_resource.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_resource.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.name IS 'Name';


--
-- Name: COLUMN appointment_resource.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.description IS 'Description';


--
-- Name: COLUMN appointment_resource.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.active IS 'Active';


--
-- Name: COLUMN appointment_resource.shareable; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.shareable IS 'Shareable';


--
-- Name: COLUMN appointment_resource.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.create_date IS 'Created on';


--
-- Name: COLUMN appointment_resource.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_resource.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT appointment_resource_check_capacity ON appointment_resource; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT appointment_resource_check_capacity ON public.appointment_resource IS 'check(capacity >= 1)';


--
-- Name: appointment_resource_appointment_slot_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_resource_appointment_slot_rel (
    appointment_slot_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


ALTER TABLE public.appointment_resource_appointment_slot_rel OWNER TO ductin;

--
-- Name: TABLE appointment_resource_appointment_slot_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_resource_appointment_slot_rel IS 'RELATION BETWEEN appointment_slot AND appointment_resource';


--
-- Name: appointment_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_resource_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_resource_id_seq OWNER TO ductin;

--
-- Name: appointment_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_resource_id_seq OWNED BY public.appointment_resource.id;


--
-- Name: appointment_resource_linked_appointment_resource; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_resource_linked_appointment_resource (
    resource_id integer NOT NULL,
    linked_resource_id integer NOT NULL
);


ALTER TABLE public.appointment_resource_linked_appointment_resource OWNER TO ductin;

--
-- Name: TABLE appointment_resource_linked_appointment_resource; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_resource_linked_appointment_resource IS 'RELATION BETWEEN appointment_resource AND appointment_resource';


--
-- Name: appointment_slot; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_slot (
    id integer NOT NULL,
    appointment_type_id integer,
    create_uid integer,
    write_uid integer,
    slot_type character varying NOT NULL,
    weekday character varying NOT NULL,
    allday boolean,
    start_datetime timestamp without time zone,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    start_hour double precision NOT NULL,
    end_hour double precision NOT NULL,
    CONSTRAINT appointment_slot_check_start_and_end_hour CHECK (((((end_hour = (0)::double precision) AND ((start_hour >= (0)::double precision) AND (start_hour <= (23.99)::double precision))) OR ((start_hour >= (0)::double precision) AND (start_hour <= end_hour))) AND ((end_hour = (0)::double precision) OR ((end_hour >= start_hour) AND (end_hour <= (23.99)::double precision)))))
);


ALTER TABLE public.appointment_slot OWNER TO ductin;

--
-- Name: TABLE appointment_slot; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_slot IS 'Appointment: Time Slot';


--
-- Name: COLUMN appointment_slot.appointment_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN appointment_slot.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_slot.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_slot.slot_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.slot_type IS 'Slot type';


--
-- Name: COLUMN appointment_slot.weekday; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.weekday IS 'Week Day';


--
-- Name: COLUMN appointment_slot.allday; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.allday IS 'All day';


--
-- Name: COLUMN appointment_slot.start_datetime; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.start_datetime IS 'From';


--
-- Name: COLUMN appointment_slot.end_datetime; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.end_datetime IS 'To';


--
-- Name: COLUMN appointment_slot.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.create_date IS 'Created on';


--
-- Name: COLUMN appointment_slot.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_slot.start_hour; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.start_hour IS 'Starting Hour';


--
-- Name: COLUMN appointment_slot.end_hour; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_slot.end_hour IS 'Ending Hour';


--
-- Name: CONSTRAINT appointment_slot_check_start_and_end_hour ON appointment_slot; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT appointment_slot_check_start_and_end_hour ON public.appointment_slot IS 'CHECK(
                ((end_hour=0 AND (start_hour BETWEEN 0 AND 23.99))
                    OR (start_hour BETWEEN 0 AND end_hour))
                AND (end_hour=0
                    OR (end_hour BETWEEN start_hour AND 23.99))
                )';


--
-- Name: appointment_slot_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_slot_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_slot_id_seq OWNER TO ductin;

--
-- Name: appointment_slot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_slot_id_seq OWNED BY public.appointment_slot.id;


--
-- Name: appointment_slot_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_slot_res_users_rel (
    appointment_slot_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.appointment_slot_res_users_rel OWNER TO ductin;

--
-- Name: TABLE appointment_slot_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_slot_res_users_rel IS 'RELATION BETWEEN appointment_slot AND res_users';


--
-- Name: appointment_type; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_type (
    id integer NOT NULL,
    sequence integer,
    location_id integer,
    booked_mail_template_id integer,
    canceled_mail_template_id integer,
    max_schedule_days integer NOT NULL,
    create_uid integer,
    write_uid integer,
    appointment_tz character varying NOT NULL,
    event_videocall_source character varying,
    assign_method character varying NOT NULL,
    avatars_display character varying,
    category character varying,
    schedule_based_on character varying NOT NULL,
    name jsonb NOT NULL,
    message_confirmation jsonb,
    message_intro jsonb,
    active boolean,
    appointment_manual_confirmation boolean,
    allow_guests boolean,
    hide_duration boolean,
    hide_timezone boolean,
    resource_manage_capacity boolean,
    is_published boolean,
    start_datetime timestamp without time zone,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    appointment_duration double precision NOT NULL,
    min_cancellation_hours double precision NOT NULL,
    min_schedule_hours double precision NOT NULL,
    resource_manual_confirmation_percentage double precision,
    google_reserve_merchant_id integer,
    google_reserve_access_token character varying,
    google_reserve_enable boolean,
    google_reserve_pending_sync boolean,
    lead_create boolean,
    work_hours_activated boolean,
    product_id integer,
    has_payment_step boolean,
    website_id integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    CONSTRAINT appointment_type_check_product_and_payment_step CHECK (((has_payment_step IS NULL) OR (NOT has_payment_step) OR (product_id IS NOT NULL))),
    CONSTRAINT appointment_type_check_resource_manual_confirmation_percentage CHECK (((resource_manual_confirmation_percentage >= (0)::double precision) AND (resource_manual_confirmation_percentage <= (1)::double precision)))
);


ALTER TABLE public.appointment_type OWNER TO ductin;

--
-- Name: TABLE appointment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_type IS 'Appointment Type';


--
-- Name: COLUMN appointment_type.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_type.location_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.location_id IS 'Location';


--
-- Name: COLUMN appointment_type.booked_mail_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.booked_mail_template_id IS 'Booking Email';


--
-- Name: COLUMN appointment_type.canceled_mail_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.canceled_mail_template_id IS 'Cancellation Email';


--
-- Name: COLUMN appointment_type.max_schedule_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.max_schedule_days IS 'Schedule not after (days)';


--
-- Name: COLUMN appointment_type.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_type.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_type.appointment_tz; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.appointment_tz IS 'Timezone';


--
-- Name: COLUMN appointment_type.event_videocall_source; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.event_videocall_source IS 'Videoconference Link';


--
-- Name: COLUMN appointment_type.assign_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.assign_method IS 'Assignment Method';


--
-- Name: COLUMN appointment_type.avatars_display; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.avatars_display IS 'Front-End Display';


--
-- Name: COLUMN appointment_type.category; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.category IS 'Category';


--
-- Name: COLUMN appointment_type.schedule_based_on; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.schedule_based_on IS 'Availability on';


--
-- Name: COLUMN appointment_type.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.name IS 'Appointment Title';


--
-- Name: COLUMN appointment_type.message_confirmation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.message_confirmation IS 'Confirmation Message';


--
-- Name: COLUMN appointment_type.message_intro; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.message_intro IS 'Introduction Message';


--
-- Name: COLUMN appointment_type.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.active IS 'Active';


--
-- Name: COLUMN appointment_type.appointment_manual_confirmation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.appointment_manual_confirmation IS 'Manual Confirmation';


--
-- Name: COLUMN appointment_type.allow_guests; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.allow_guests IS 'Allow Guests';


--
-- Name: COLUMN appointment_type.hide_duration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.hide_duration IS 'Hide Duration';


--
-- Name: COLUMN appointment_type.hide_timezone; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.hide_timezone IS 'Hide Time Zone';


--
-- Name: COLUMN appointment_type.resource_manage_capacity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.resource_manage_capacity IS 'Manage Capacities';


--
-- Name: COLUMN appointment_type.is_published; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.is_published IS 'Is Published';


--
-- Name: COLUMN appointment_type.start_datetime; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.start_datetime IS 'Start Datetime';


--
-- Name: COLUMN appointment_type.end_datetime; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.end_datetime IS 'End Datetime';


--
-- Name: COLUMN appointment_type.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.create_date IS 'Created on';


--
-- Name: COLUMN appointment_type.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_type.appointment_duration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.appointment_duration IS 'Duration';


--
-- Name: COLUMN appointment_type.min_cancellation_hours; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.min_cancellation_hours IS 'Cancel Before (hours)';


--
-- Name: COLUMN appointment_type.min_schedule_hours; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.min_schedule_hours IS 'Schedule before (hours)';


--
-- Name: COLUMN appointment_type.resource_manual_confirmation_percentage; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.resource_manual_confirmation_percentage IS 'Capacity Percentage';


--
-- Name: COLUMN appointment_type.google_reserve_merchant_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.google_reserve_merchant_id IS 'Google Reserve Merchant';


--
-- Name: COLUMN appointment_type.google_reserve_access_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.google_reserve_access_token IS 'Google Reserve Access Token';


--
-- Name: COLUMN appointment_type.google_reserve_enable; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.google_reserve_enable IS 'Enable Google Booking';


--
-- Name: COLUMN appointment_type.google_reserve_pending_sync; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.google_reserve_pending_sync IS 'Google Booking Pending Synchronization';


--
-- Name: COLUMN appointment_type.lead_create; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.lead_create IS 'Create Opportunities';


--
-- Name: COLUMN appointment_type.work_hours_activated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.work_hours_activated IS 'Limit to Work Hours';


--
-- Name: COLUMN appointment_type.product_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.product_id IS 'Booking Product';


--
-- Name: COLUMN appointment_type.has_payment_step; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.has_payment_step IS 'Up-front Payment';


--
-- Name: COLUMN appointment_type.website_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.website_id IS 'Website';


--
-- Name: COLUMN appointment_type.website_meta_og_img; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN appointment_type.website_meta_title; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN appointment_type.website_meta_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN appointment_type.website_meta_keywords; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN appointment_type.seo_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appointment_type.seo_name IS 'Seo name';


--
-- Name: CONSTRAINT appointment_type_check_product_and_payment_step ON appointment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT appointment_type_check_product_and_payment_step ON public.appointment_type IS 'CHECK(has_payment_step IS NULL OR NOT has_payment_step OR product_id IS NOT NULL)';


--
-- Name: CONSTRAINT appointment_type_check_resource_manual_confirmation_percentage ON appointment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT appointment_type_check_resource_manual_confirmation_percentage ON public.appointment_type IS 'check(resource_manual_confirmation_percentage >= 0 and resource_manual_confirmation_percentage <= 1)';


--
-- Name: appointment_type_appointment_resource_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_type_appointment_resource_rel (
    appointment_resource_id integer NOT NULL,
    appointment_type_id integer NOT NULL
);


ALTER TABLE public.appointment_type_appointment_resource_rel OWNER TO ductin;

--
-- Name: TABLE appointment_type_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_type_appointment_resource_rel IS 'RELATION BETWEEN appointment_resource AND appointment_type';


--
-- Name: appointment_type_calendar_alarm_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_type_calendar_alarm_rel (
    appointment_type_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.appointment_type_calendar_alarm_rel OWNER TO ductin;

--
-- Name: TABLE appointment_type_calendar_alarm_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_type_calendar_alarm_rel IS 'RELATION BETWEEN appointment_type AND calendar_alarm';


--
-- Name: appointment_type_country_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_type_country_rel (
    appointment_type_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.appointment_type_country_rel OWNER TO ductin;

--
-- Name: TABLE appointment_type_country_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_type_country_rel IS 'RELATION BETWEEN appointment_type AND res_country';


--
-- Name: appointment_type_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appointment_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_type_id_seq OWNER TO ductin;

--
-- Name: appointment_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appointment_type_id_seq OWNED BY public.appointment_type.id;


--
-- Name: appointment_type_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appointment_type_res_users_rel (
    appointment_type_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.appointment_type_res_users_rel OWNER TO ductin;

--
-- Name: TABLE appointment_type_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appointment_type_res_users_rel IS 'RELATION BETWEEN appointment_type AND res_users';


--
-- Name: appraisal_ask_feedback; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appraisal_ask_feedback (
    id integer NOT NULL,
    template_id integer,
    appraisal_id integer,
    author_id integer NOT NULL,
    survey_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    deadline date NOT NULL,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.appraisal_ask_feedback OWNER TO ductin;

--
-- Name: TABLE appraisal_ask_feedback; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appraisal_ask_feedback IS 'Ask Feedback for Appraisal';


--
-- Name: COLUMN appraisal_ask_feedback.template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.template_id IS 'Mail Template';


--
-- Name: COLUMN appraisal_ask_feedback.appraisal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.appraisal_id IS 'Appraisal';


--
-- Name: COLUMN appraisal_ask_feedback.author_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.author_id IS 'Author';


--
-- Name: COLUMN appraisal_ask_feedback.survey_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.survey_template_id IS 'Survey Template';


--
-- Name: COLUMN appraisal_ask_feedback.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.create_uid IS 'Created by';


--
-- Name: COLUMN appraisal_ask_feedback.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appraisal_ask_feedback.lang; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.lang IS 'Language';


--
-- Name: COLUMN appraisal_ask_feedback.subject; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.subject IS 'Subject';


--
-- Name: COLUMN appraisal_ask_feedback.deadline; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.deadline IS 'Answer Deadline';


--
-- Name: COLUMN appraisal_ask_feedback.body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.body IS 'Contents';


--
-- Name: COLUMN appraisal_ask_feedback.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.create_date IS 'Created on';


--
-- Name: COLUMN appraisal_ask_feedback.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.appraisal_ask_feedback.write_date IS 'Last Updated on';


--
-- Name: appraisal_ask_feedback_hr_employee_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appraisal_ask_feedback_hr_employee_rel (
    appraisal_ask_feedback_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.appraisal_ask_feedback_hr_employee_rel OWNER TO ductin;

--
-- Name: TABLE appraisal_ask_feedback_hr_employee_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appraisal_ask_feedback_hr_employee_rel IS 'RELATION BETWEEN appraisal_ask_feedback AND hr_employee';


--
-- Name: appraisal_ask_feedback_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.appraisal_ask_feedback_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appraisal_ask_feedback_id_seq OWNER TO ductin;

--
-- Name: appraisal_ask_feedback_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.appraisal_ask_feedback_id_seq OWNED BY public.appraisal_ask_feedback.id;


--
-- Name: appraisal_manager_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.appraisal_manager_rel (
    hr_appraisal_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.appraisal_manager_rel OWNER TO ductin;

--
-- Name: TABLE appraisal_manager_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.appraisal_manager_rel IS 'RELATION BETWEEN hr_appraisal AND hr_employee';


--
-- Name: approval_amount_step; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_amount_step (
    id integer NOT NULL,
    category_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    min_amount numeric NOT NULL,
    max_amount numeric,
    required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_amount_step OWNER TO ductin;

--
-- Name: TABLE approval_amount_step; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_amount_step IS 'Approval Amount Step';


--
-- Name: COLUMN approval_amount_step.category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.category_id IS 'Approval Category';


--
-- Name: COLUMN approval_amount_step.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.sequence IS 'Sequence';


--
-- Name: COLUMN approval_amount_step.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.create_uid IS 'Created by';


--
-- Name: COLUMN approval_amount_step.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_amount_step.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.name IS 'Approver Description';


--
-- Name: COLUMN approval_amount_step.min_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.min_amount IS 'Minimum Amount';


--
-- Name: COLUMN approval_amount_step.max_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.max_amount IS 'Maximum Amount';


--
-- Name: COLUMN approval_amount_step.required; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.required IS 'Required';


--
-- Name: COLUMN approval_amount_step.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.create_date IS 'Created on';


--
-- Name: COLUMN approval_amount_step.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_amount_step.write_date IS 'Last Updated on';


--
-- Name: approval_amount_step_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_amount_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_amount_step_id_seq OWNER TO ductin;

--
-- Name: approval_amount_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_amount_step_id_seq OWNED BY public.approval_amount_step.id;


--
-- Name: approval_approver; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_approver (
    id integer NOT NULL,
    sequence integer,
    user_id integer NOT NULL,
    request_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    status character varying,
    required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    group_id integer,
    approver_description character varying,
    is_stock_approve boolean
);


ALTER TABLE public.approval_approver OWNER TO ductin;

--
-- Name: TABLE approval_approver; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_approver IS 'Approver';


--
-- Name: COLUMN approval_approver.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.sequence IS 'Sequence';


--
-- Name: COLUMN approval_approver.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.user_id IS 'User';


--
-- Name: COLUMN approval_approver.request_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.request_id IS 'Request';


--
-- Name: COLUMN approval_approver.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.company_id IS 'Company';


--
-- Name: COLUMN approval_approver.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.create_uid IS 'Created by';


--
-- Name: COLUMN approval_approver.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_approver.status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.status IS 'Status';


--
-- Name: COLUMN approval_approver.required; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.required IS 'Required';


--
-- Name: COLUMN approval_approver.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.create_date IS 'Created on';


--
-- Name: COLUMN approval_approver.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.write_date IS 'Last Updated on';


--
-- Name: COLUMN approval_approver.group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.group_id IS 'Group';


--
-- Name: COLUMN approval_approver.approver_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.approver_description IS 'Approver Description';


--
-- Name: COLUMN approval_approver.is_stock_approve; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_approver.is_stock_approve IS 'Is Stock Approve';


--
-- Name: approval_approver_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_approver_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_approver_id_seq OWNER TO ductin;

--
-- Name: approval_approver_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_approver_id_seq OWNED BY public.approval_approver.id;


--
-- Name: approval_approver_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_approver_users_rel (
    approval_amount_step_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.approval_approver_users_rel OWNER TO ductin;

--
-- Name: TABLE approval_approver_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_approver_users_rel IS 'RELATION BETWEEN approval_amount_step AND res_users';


--
-- Name: approval_bypass_step; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_bypass_step (
    id integer NOT NULL,
    category_id integer NOT NULL,
    user_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_bypass_step OWNER TO ductin;

--
-- Name: TABLE approval_bypass_step; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_bypass_step IS 'Approval Bypass Step';


--
-- Name: COLUMN approval_bypass_step.category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_bypass_step.category_id IS 'Approval Category';


--
-- Name: COLUMN approval_bypass_step.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_bypass_step.user_id IS 'User';


--
-- Name: COLUMN approval_bypass_step.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_bypass_step.sequence IS 'Sequence';


--
-- Name: COLUMN approval_bypass_step.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_bypass_step.create_uid IS 'Created by';


--
-- Name: COLUMN approval_bypass_step.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_bypass_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_bypass_step.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_bypass_step.create_date IS 'Created on';


--
-- Name: COLUMN approval_bypass_step.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_bypass_step.write_date IS 'Last Updated on';


--
-- Name: approval_bypass_step_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_bypass_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_bypass_step_id_seq OWNER TO ductin;

--
-- Name: approval_bypass_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_bypass_step_id_seq OWNED BY public.approval_bypass_step.id;


--
-- Name: approval_category; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_category (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    approval_minimum integer NOT NULL,
    sequence_id integer,
    create_uid integer,
    write_uid integer,
    has_date character varying NOT NULL,
    has_period character varying NOT NULL,
    has_quantity character varying NOT NULL,
    has_amount character varying NOT NULL,
    has_reference character varying NOT NULL,
    has_partner character varying NOT NULL,
    has_payment_method character varying NOT NULL,
    has_location character varying NOT NULL,
    has_product character varying NOT NULL,
    requirer_document character varying NOT NULL,
    approval_type character varying,
    manager_approval character varying,
    sequence_code character varying,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    approver_sequence boolean,
    automated_sequence boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    parent_category_id integer,
    approve_type character varying NOT NULL,
    scope character varying,
    use_amount_approval boolean,
    bypass_step_enabled boolean,
    use_done_status boolean,
    appointment_internal_communication_department_id integer,
    appointment_internal_communication_type character varying,
    vat boolean,
    amount_threshold double precision,
    combo_promo_url character varying
);


ALTER TABLE public.approval_category OWNER TO ductin;

--
-- Name: TABLE approval_category; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_category IS 'Approval Category';


--
-- Name: COLUMN approval_category.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.company_id IS 'Company';


--
-- Name: COLUMN approval_category.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.sequence IS 'Sequence';


--
-- Name: COLUMN approval_category.approval_minimum; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.approval_minimum IS 'Minimum Approval';


--
-- Name: COLUMN approval_category.sequence_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.sequence_id IS 'Reference Sequence';


--
-- Name: COLUMN approval_category.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.create_uid IS 'Created by';


--
-- Name: COLUMN approval_category.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_category.has_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_date IS 'Has Date';


--
-- Name: COLUMN approval_category.has_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_period IS 'Has Period';


--
-- Name: COLUMN approval_category.has_quantity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_quantity IS 'Has Quantity';


--
-- Name: COLUMN approval_category.has_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_amount IS 'Has Amount';


--
-- Name: COLUMN approval_category.has_reference; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_reference IS 'Has Reference';


--
-- Name: COLUMN approval_category.has_partner; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_partner IS 'Has Contact';


--
-- Name: COLUMN approval_category.has_payment_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_payment_method IS 'Has Payment';


--
-- Name: COLUMN approval_category.has_location; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_location IS 'Has Location';


--
-- Name: COLUMN approval_category.has_product; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.has_product IS 'Has Product';


--
-- Name: COLUMN approval_category.requirer_document; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.requirer_document IS 'Documents';


--
-- Name: COLUMN approval_category.approval_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.approval_type IS 'Approval Type';


--
-- Name: COLUMN approval_category.manager_approval; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.manager_approval IS 'Employee''s Manager';


--
-- Name: COLUMN approval_category.sequence_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.sequence_code IS 'Code';


--
-- Name: COLUMN approval_category.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.name IS 'Name';


--
-- Name: COLUMN approval_category.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.description IS 'Description';


--
-- Name: COLUMN approval_category.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.active IS 'Active';


--
-- Name: COLUMN approval_category.approver_sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.approver_sequence IS 'Approvers Sequence?';


--
-- Name: COLUMN approval_category.automated_sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.automated_sequence IS 'Automated Sequence?';


--
-- Name: COLUMN approval_category.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.create_date IS 'Created on';


--
-- Name: COLUMN approval_category.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.write_date IS 'Last Updated on';


--
-- Name: COLUMN approval_category.parent_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.parent_category_id IS 'Parent Category';


--
-- Name: COLUMN approval_category.approve_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.approve_type IS 'Type';


--
-- Name: COLUMN approval_category.scope; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.scope IS 'Scope';


--
-- Name: COLUMN approval_category.use_amount_approval; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.use_amount_approval IS 'Use Amount Approval';


--
-- Name: COLUMN approval_category.bypass_step_enabled; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.bypass_step_enabled IS 'Enable Bypass Steps';


--
-- Name: COLUMN approval_category.use_done_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.use_done_status IS 'Use Done Status';


--
-- Name: COLUMN approval_category.appointment_internal_communication_department_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.appointment_internal_communication_department_id IS 'Appointment Internal Communication Department';


--
-- Name: COLUMN approval_category.appointment_internal_communication_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.appointment_internal_communication_type IS 'Appointment Internal Communication Type';


--
-- Name: COLUMN approval_category.vat; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.vat IS 'VAT';


--
-- Name: COLUMN approval_category.amount_threshold; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.amount_threshold IS 'Amount Threshold';


--
-- Name: COLUMN approval_category.combo_promo_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category.combo_promo_url IS 'Combo Promo URL';


--
-- Name: approval_category_approver; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_category_approver (
    id integer NOT NULL,
    sequence integer,
    category_id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    group_id integer
);


ALTER TABLE public.approval_category_approver OWNER TO ductin;

--
-- Name: TABLE approval_category_approver; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_category_approver IS 'Approval Type Approver';


--
-- Name: COLUMN approval_category_approver.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.sequence IS 'Sequence';


--
-- Name: COLUMN approval_category_approver.category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.category_id IS 'Approval Type';


--
-- Name: COLUMN approval_category_approver.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.user_id IS 'User';


--
-- Name: COLUMN approval_category_approver.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.create_uid IS 'Created by';


--
-- Name: COLUMN approval_category_approver.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_category_approver.required; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.required IS 'Required';


--
-- Name: COLUMN approval_category_approver.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.create_date IS 'Created on';


--
-- Name: COLUMN approval_category_approver.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.write_date IS 'Last Updated on';


--
-- Name: COLUMN approval_category_approver.group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_category_approver.group_id IS 'Group';


--
-- Name: approval_category_approver_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_category_approver_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_category_approver_id_seq OWNER TO ductin;

--
-- Name: approval_category_approver_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_category_approver_id_seq OWNED BY public.approval_category_approver.id;


--
-- Name: approval_category_approver_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_category_approver_res_users_rel (
    approval_category_approver_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.approval_category_approver_res_users_rel OWNER TO ductin;

--
-- Name: TABLE approval_category_approver_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_category_approver_res_users_rel IS 'RELATION BETWEEN approval_category_approver AND res_users';


--
-- Name: approval_category_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_category_id_seq OWNER TO ductin;

--
-- Name: approval_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_category_id_seq OWNED BY public.approval_category.id;


--
-- Name: approval_category_notification_user_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_category_notification_user_rel (
    category_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.approval_category_notification_user_rel OWNER TO ductin;

--
-- Name: TABLE approval_category_notification_user_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_category_notification_user_rel IS 'RELATION BETWEEN approval_category AND res_users';


--
-- Name: approval_cost_type; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_cost_type (
    id integer NOT NULL,
    approval_cost_type_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    level character varying,
    active boolean,
    is_tax boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_cost_type OWNER TO ductin;

--
-- Name: TABLE approval_cost_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_cost_type IS 'Cost Type list';


--
-- Name: COLUMN approval_cost_type.approval_cost_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.approval_cost_type_id IS 'Parent Cost Type';


--
-- Name: COLUMN approval_cost_type.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.create_uid IS 'Created by';


--
-- Name: COLUMN approval_cost_type.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_cost_type.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.name IS 'Name';


--
-- Name: COLUMN approval_cost_type.level; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.level IS 'Level';


--
-- Name: COLUMN approval_cost_type.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.active IS 'Active';


--
-- Name: COLUMN approval_cost_type.is_tax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.is_tax IS 'Is Tax';


--
-- Name: COLUMN approval_cost_type.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.create_date IS 'Created on';


--
-- Name: COLUMN approval_cost_type.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_cost_type.write_date IS 'Last Updated on';


--
-- Name: approval_cost_type_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_cost_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_cost_type_id_seq OWNER TO ductin;

--
-- Name: approval_cost_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_cost_type_id_seq OWNED BY public.approval_cost_type.id;


--
-- Name: approval_done_authorization_rule; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_done_authorization_rule (
    id integer NOT NULL,
    category_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_done_authorization_rule OWNER TO ductin;

--
-- Name: TABLE approval_done_authorization_rule; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_done_authorization_rule IS 'Approval Done State Authorization Rule';


--
-- Name: COLUMN approval_done_authorization_rule.category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_done_authorization_rule.category_id IS 'Approval Category';


--
-- Name: COLUMN approval_done_authorization_rule.group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_done_authorization_rule.group_id IS 'Group';


--
-- Name: COLUMN approval_done_authorization_rule.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_done_authorization_rule.create_uid IS 'Created by';


--
-- Name: COLUMN approval_done_authorization_rule.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_done_authorization_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_done_authorization_rule.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_done_authorization_rule.create_date IS 'Created on';


--
-- Name: COLUMN approval_done_authorization_rule.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_done_authorization_rule.write_date IS 'Last Updated on';


--
-- Name: approval_done_authorization_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_done_authorization_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_done_authorization_rule_id_seq OWNER TO ductin;

--
-- Name: approval_done_authorization_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_done_authorization_rule_id_seq OWNED BY public.approval_done_authorization_rule.id;


--
-- Name: approval_done_authorization_rule_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_done_authorization_rule_res_users_rel (
    approval_done_authorization_rule_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.approval_done_authorization_rule_res_users_rel OWNER TO ductin;

--
-- Name: TABLE approval_done_authorization_rule_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_done_authorization_rule_res_users_rel IS 'RELATION BETWEEN approval_done_authorization_rule AND res_users';


--
-- Name: approval_issue_category; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_issue_category (
    id integer NOT NULL,
    approval_category_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_issue_category OWNER TO ductin;

--
-- Name: TABLE approval_issue_category; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_issue_category IS 'Approval Issue Category';


--
-- Name: COLUMN approval_issue_category.approval_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_issue_category.approval_category_id IS 'Approval Category';


--
-- Name: COLUMN approval_issue_category.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_issue_category.create_uid IS 'Created by';


--
-- Name: COLUMN approval_issue_category.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_issue_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_issue_category.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_issue_category.name IS 'Issue Name';


--
-- Name: COLUMN approval_issue_category.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_issue_category.create_date IS 'Created on';


--
-- Name: COLUMN approval_issue_category.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_issue_category.write_date IS 'Last Updated on';


--
-- Name: approval_issue_category_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_issue_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_issue_category_id_seq OWNER TO ductin;

--
-- Name: approval_issue_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_issue_category_id_seq OWNED BY public.approval_issue_category.id;


--
-- Name: approval_notification_config; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_notification_config (
    id integer NOT NULL,
    category_id integer NOT NULL,
    group_id integer,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    notify_timing character varying NOT NULL,
    min_amount numeric NOT NULL,
    max_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_notification_config OWNER TO ductin;

--
-- Name: TABLE approval_notification_config; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_notification_config IS 'Approval Notification Configuration';


--
-- Name: COLUMN approval_notification_config.category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.category_id IS 'Approval Category';


--
-- Name: COLUMN approval_notification_config.group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.group_id IS 'Group';


--
-- Name: COLUMN approval_notification_config.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.currency_id IS 'Company Currency';


--
-- Name: COLUMN approval_notification_config.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.create_uid IS 'Created by';


--
-- Name: COLUMN approval_notification_config.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_notification_config.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.name IS 'Approver Description';


--
-- Name: COLUMN approval_notification_config.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.code IS 'Code';


--
-- Name: COLUMN approval_notification_config.notify_timing; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.notify_timing IS 'Notify timing';


--
-- Name: COLUMN approval_notification_config.min_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.min_amount IS 'Minimum Amount';


--
-- Name: COLUMN approval_notification_config.max_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.max_amount IS 'Maximum Amount';


--
-- Name: COLUMN approval_notification_config.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.create_date IS 'Created on';


--
-- Name: COLUMN approval_notification_config.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_notification_config.write_date IS 'Last Updated on';


--
-- Name: approval_notification_config_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_notification_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_notification_config_id_seq OWNER TO ductin;

--
-- Name: approval_notification_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_notification_config_id_seq OWNED BY public.approval_notification_config.id;


--
-- Name: approval_notification_config_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_notification_config_res_users_rel (
    approval_notification_config_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.approval_notification_config_res_users_rel OWNER TO ductin;

--
-- Name: TABLE approval_notification_config_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_notification_config_res_users_rel IS 'RELATION BETWEEN approval_notification_config AND res_users';


--
-- Name: approval_product_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_product_line (
    id integer NOT NULL,
    approval_request_id integer NOT NULL,
    company_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    description character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    quantity double precision,
    purchase_order_line_id integer,
    seller_id integer,
    warehouse_id integer,
    country_id integer,
    currency_id integer,
    price_unit_currency numeric,
    price_total numeric
);


ALTER TABLE public.approval_product_line OWNER TO ductin;

--
-- Name: TABLE approval_product_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_product_line IS 'Product Line';


--
-- Name: COLUMN approval_product_line.approval_request_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.approval_request_id IS 'Approval Request';


--
-- Name: COLUMN approval_product_line.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.company_id IS 'Company';


--
-- Name: COLUMN approval_product_line.product_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.product_id IS 'Products';


--
-- Name: COLUMN approval_product_line.product_uom_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN approval_product_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.create_uid IS 'Created by';


--
-- Name: COLUMN approval_product_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_product_line.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.description IS 'Description';


--
-- Name: COLUMN approval_product_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.create_date IS 'Created on';


--
-- Name: COLUMN approval_product_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN approval_product_line.quantity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.quantity IS 'Quantity';


--
-- Name: COLUMN approval_product_line.purchase_order_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.purchase_order_line_id IS 'Purchase Order Line';


--
-- Name: COLUMN approval_product_line.seller_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.seller_id IS 'Vendors';


--
-- Name: COLUMN approval_product_line.warehouse_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN approval_product_line.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.country_id IS 'Country';


--
-- Name: COLUMN approval_product_line.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.currency_id IS 'Currency';


--
-- Name: COLUMN approval_product_line.price_unit_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.price_unit_currency IS 'Unit Price';


--
-- Name: COLUMN approval_product_line.price_total; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_product_line.price_total IS 'Total Price';


--
-- Name: approval_product_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_product_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_product_line_id_seq OWNER TO ductin;

--
-- Name: approval_product_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_product_line_id_seq OWNED BY public.approval_product_line.id;


--
-- Name: approval_request; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_request (
    id integer NOT NULL,
    message_main_attachment_id integer,
    category_id integer NOT NULL,
    company_id integer,
    partner_id integer,
    request_owner_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    location character varying,
    reference character varying,
    request_status character varying,
    reason text,
    date timestamp without time zone,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    date_confirmed timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    quantity double precision,
    amount double precision,
    employee_id integer,
    job_id integer,
    department_id integer,
    manager_id integer,
    contract_id integer,
    parent_department_id integer,
    primary_department_id integer,
    currency_id integer,
    approval_cost_type_id integer,
    market_country_id integer,
    product_category_id integer,
    sequence_code character varying,
    employee_code character varying,
    next_approver_info character varying,
    url_request character varying,
    company_amount numeric,
    vat boolean,
    date_approved timestamp without time zone,
    approval_progress double precision,
    doc_approval_primary_contact_id integer,
    document_type character varying,
    document_style character varying,
    document_number character varying,
    old_document_number character varying,
    doc_approval_request_date date,
    doc_approval_expected_issue_date date,
    document_type_detail text,
    doc_approval_details text,
    crm_group_id integer,
    product_brand_id integer,
    brand_director_id integer,
    employee_appointment_id integer,
    manager_emp_appointment_id integer,
    job_emp_appointment_id integer,
    department_emp_appointment_id integer,
    work_location_emp_appointment_id integer,
    resource_calendar_emp_appointment_id integer,
    new_manager_emp_appointment_id integer,
    new_job_emp_appointment_id integer,
    new_department_emp_appointment_id integer,
    new_work_location_emp_appointment_id integer,
    new_resource_calendar_emp_appointment_id integer,
    appointment_notification character varying,
    appointment_state character varying,
    employee_appointment_code character varying,
    employee_appointment_type character varying,
    new_employee_appointment_type character varying,
    internal_communication_appointment_status character varying,
    effective_appointment_date date,
    appointment_note text,
    is_employee_appointment_updated boolean,
    total integer,
    probationary_assessment_state character varying,
    probationary_assessment_notification character varying,
    workload character varying,
    professional_skills character varying,
    ability_process_manage_work character varying,
    team_work_skills character varying,
    sense_responsibility character varying,
    feature_creation character varying,
    work_result_achieved character varying,
    official_date date,
    probationary_resignation_date date,
    probationary_archive_odoo_date date,
    positive_side text,
    negative_side text,
    prospect text,
    recruitment_plan_job_position_id integer,
    recruitment_plan_candidate_manager_id integer,
    recruitment_plan_department_id integer,
    recruitment_plan_quantity integer,
    recruitment_plan_name character varying,
    recruitment_month character varying,
    recruitment_year character varying,
    recruitment_plan_approval_status character varying,
    main_department_name character varying,
    recruitment_plan_proposal_date date,
    recruitment_plan_candidate_profile text,
    recruitment_plan_interview_questions text,
    recruitment_plan_expected_answers text,
    is_proposal_ontime boolean,
    recruitment_plan_candidate_score double precision,
    recruitment_plan_sales_target double precision,
    resignation_reason_id integer,
    resignation_notification character varying,
    resignation_state character varying,
    link_survey character varying,
    attachment_status character varying,
    resignation_date date,
    resignation_reason_details text,
    survey_completed boolean,
    employee_transfer_id integer,
    manager_emp_transfer_id integer,
    job_emp_transfer_id integer,
    department_emp_transfer_id integer,
    work_location_emp_transfer_id integer,
    resource_calendar_emp_transfer_id integer,
    new_manager_emp_transfer_id integer,
    new_job_emp_transfer_id integer,
    new_department_emp_transfer_id integer,
    new_work_location_emp_transfer_id integer,
    new_resource_calendar_emp_transfer_id integer,
    transfer_notification character varying,
    transfer_state character varying,
    employee_transfer_code character varying,
    employee_transfer_type character varying,
    new_employee_transfer_type character varying,
    effective_transfer_date date,
    transfer_note text,
    is_employee_transfer_updated boolean,
    payment_approval_category_id integer,
    expenditure_object_id integer,
    bank_id integer,
    approval_cost_type_2_id integer,
    approval_cost_type_3_id integer,
    payment_method character varying,
    bank_account character varying,
    bank_account_owner character varying,
    total_amount_text character varying,
    expected_payment_date date,
    total_amount numeric,
    total_amount_detail numeric,
    sale_person_id integer,
    order_id integer,
    branch_manager_id integer,
    reason_details text,
    person_in_charge_id integer,
    approval_issue_category_id integer,
    branch_director_id integer,
    direct_manager_id integer,
    customer_name character varying,
    page_name character varying,
    chat_link character varying,
    violating_content text,
    violating_date timestamp without time zone,
    resource_calendar_id integer,
    explain_attendance_state character varying,
    explanation_attendance_notification character varying,
    input_country_id integer,
    input_certificate_id integer,
    input_study_field_id integer,
    input_study_school_id integer,
    input_bank_id integer,
    emp_input_information_notification character varying,
    emp_input_information_state character varying,
    input_identification_id character varying,
    input_identification_address character varying,
    input_gender character varying,
    input_ssnid character varying,
    input_registration_number character varying,
    input_head_household_name character varying,
    input_head_household_relationship character varying,
    input_head_household_identification_id character varying,
    input_bank_account_number character varying,
    input_identification_date date,
    input_date_of_birth date,
    expense_advance_approval_category_id integer,
    payment_source character varying,
    thailand_payment_method character varying,
    note text,
    purchase_propose_content text,
    work_online_notification character varying,
    work_online_state character varying,
    work_online_start_date date,
    work_online_end_date date,
    work_online_reason text,
    expense_refund_approval_category_id integer,
    product_supply_payment_method character varying,
    sale_return_reason_id integer,
    warehouse_explanation text,
    debt_order_reason_id integer,
    justification_image_url character varying,
    facebook_conversation_link character varying,
    is_validated boolean,
    overtime_notification character varying,
    overtime_state character varying,
    overtime_date date,
    overtime_reason text,
    overtime_time_start_float double precision,
    overtime_time_end_float double precision,
    overtime_break_time double precision,
    proposed_date date,
    employee_salary_proposal_contract_id integer,
    salary_increase_proposal_reason_id integer,
    increase_value_percent integer,
    employee_salary_increase_proposal_id integer,
    salary_increase_proposal_state character varying,
    salary_increase_proposal_notification character varying,
    increase_type character varying,
    apply_date date,
    salary_increase_proposal_description text,
    increase_value_amount double precision,
    new_salary double precision,
    country_id integer,
    recipient_bank integer,
    refund_accounting_date timestamp without time zone,
    sales_employee_id integer,
    sales_team_id integer,
    marketing_responsible_id integer,
    marketing_team_id integer,
    new_sales_employee_id integer,
    new_sales_team_id integer,
    new_marketing_responsible_id integer,
    new_marketing_team_id integer,
    new_crm_group_id integer,
    shipping_revenue_reason text
);


ALTER TABLE public.approval_request OWNER TO ductin;

--
-- Name: TABLE approval_request; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_request IS 'Approval Request';


--
-- Name: COLUMN approval_request.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN approval_request.category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.category_id IS 'Category';


--
-- Name: COLUMN approval_request.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.company_id IS 'Company';


--
-- Name: COLUMN approval_request.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.partner_id IS 'Contact';


--
-- Name: COLUMN approval_request.request_owner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.request_owner_id IS 'Request Owner';


--
-- Name: COLUMN approval_request.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.create_uid IS 'Created by';


--
-- Name: COLUMN approval_request.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_request.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.name IS 'Approval Subject';


--
-- Name: COLUMN approval_request.location; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.location IS 'Location';


--
-- Name: COLUMN approval_request.reference; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.reference IS 'Reference';


--
-- Name: COLUMN approval_request.request_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.request_status IS 'Request Status';


--
-- Name: COLUMN approval_request.reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.reason IS 'Description';


--
-- Name: COLUMN approval_request.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.date IS 'Date';


--
-- Name: COLUMN approval_request.date_start; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.date_start IS 'Date start';


--
-- Name: COLUMN approval_request.date_end; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.date_end IS 'Date end';


--
-- Name: COLUMN approval_request.date_confirmed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.date_confirmed IS 'Date Confirmed';


--
-- Name: COLUMN approval_request.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.create_date IS 'Created on';


--
-- Name: COLUMN approval_request.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.write_date IS 'Last Updated on';


--
-- Name: COLUMN approval_request.quantity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.quantity IS 'Quantity';


--
-- Name: COLUMN approval_request.amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.amount IS 'Amount';


--
-- Name: COLUMN approval_request.employee_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_id IS 'Employee';


--
-- Name: COLUMN approval_request.job_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.job_id IS 'Job';


--
-- Name: COLUMN approval_request.department_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.department_id IS 'Department';


--
-- Name: COLUMN approval_request.manager_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.manager_id IS 'Manager';


--
-- Name: COLUMN approval_request.contract_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.contract_id IS 'Contract';


--
-- Name: COLUMN approval_request.parent_department_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.parent_department_id IS 'Parent Department';


--
-- Name: COLUMN approval_request.primary_department_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.primary_department_id IS 'Primary department';


--
-- Name: COLUMN approval_request.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.currency_id IS 'Currency';


--
-- Name: COLUMN approval_request.approval_cost_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.approval_cost_type_id IS 'Payment Type';


--
-- Name: COLUMN approval_request.market_country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.market_country_id IS 'Market Country';


--
-- Name: COLUMN approval_request.product_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.product_category_id IS 'Product Category';


--
-- Name: COLUMN approval_request.sequence_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.sequence_code IS 'Sequence Code';


--
-- Name: COLUMN approval_request.employee_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_code IS 'Employee Code';


--
-- Name: COLUMN approval_request.next_approver_info; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.next_approver_info IS 'Next Approver (Include Employee code)';


--
-- Name: COLUMN approval_request.url_request; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.url_request IS 'URL Request';


--
-- Name: COLUMN approval_request.company_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.company_amount IS 'Company Amount';


--
-- Name: COLUMN approval_request.vat; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.vat IS 'VAT';


--
-- Name: COLUMN approval_request.date_approved; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.date_approved IS 'Date Approved';


--
-- Name: COLUMN approval_request.approval_progress; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.approval_progress IS 'Approval Progress';


--
-- Name: COLUMN approval_request.doc_approval_primary_contact_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.doc_approval_primary_contact_id IS 'Primary Contact';


--
-- Name: COLUMN approval_request.document_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.document_type IS 'Document Type';


--
-- Name: COLUMN approval_request.document_style; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.document_style IS 'Document Style';


--
-- Name: COLUMN approval_request.document_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.document_number IS 'Document Number';


--
-- Name: COLUMN approval_request.old_document_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.old_document_number IS 'Old Document Number';


--
-- Name: COLUMN approval_request.doc_approval_request_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.doc_approval_request_date IS 'Request Date';


--
-- Name: COLUMN approval_request.doc_approval_expected_issue_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.doc_approval_expected_issue_date IS 'Expected Issue Date';


--
-- Name: COLUMN approval_request.document_type_detail; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.document_type_detail IS 'Document Type Detail';


--
-- Name: COLUMN approval_request.doc_approval_details; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.doc_approval_details IS 'Details';


--
-- Name: COLUMN approval_request.crm_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.crm_group_id IS 'CRM Group';


--
-- Name: COLUMN approval_request.product_brand_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.product_brand_id IS 'Product Brand';


--
-- Name: COLUMN approval_request.brand_director_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.brand_director_id IS 'Brand Director';


--
-- Name: COLUMN approval_request.employee_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_appointment_id IS 'Employee Appointment';


--
-- Name: COLUMN approval_request.manager_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.manager_emp_appointment_id IS 'Current Manager employee appointment';


--
-- Name: COLUMN approval_request.job_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.job_emp_appointment_id IS 'Current Job employee appointment';


--
-- Name: COLUMN approval_request.department_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.department_emp_appointment_id IS 'Current Department employee appointment';


--
-- Name: COLUMN approval_request.work_location_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.work_location_emp_appointment_id IS 'Current Work Location employee appointment';


--
-- Name: COLUMN approval_request.resource_calendar_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.resource_calendar_emp_appointment_id IS 'Current Resource Calendar employee appointment';


--
-- Name: COLUMN approval_request.new_manager_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_manager_emp_appointment_id IS 'New Manager employee appointment';


--
-- Name: COLUMN approval_request.new_job_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_job_emp_appointment_id IS 'New Job employee appointment';


--
-- Name: COLUMN approval_request.new_department_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_department_emp_appointment_id IS 'New Department employee appointment';


--
-- Name: COLUMN approval_request.new_work_location_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_work_location_emp_appointment_id IS 'New Work Location employee appointment';


--
-- Name: COLUMN approval_request.new_resource_calendar_emp_appointment_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_resource_calendar_emp_appointment_id IS 'New Resource Calendar employee appointment';


--
-- Name: COLUMN approval_request.appointment_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.appointment_notification IS 'Appointment Notification';


--
-- Name: COLUMN approval_request.appointment_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.appointment_state IS 'Appointment State';


--
-- Name: COLUMN approval_request.employee_appointment_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_appointment_code IS 'Employee Appointment Code';


--
-- Name: COLUMN approval_request.employee_appointment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_appointment_type IS 'Current Employee appointment type';


--
-- Name: COLUMN approval_request.new_employee_appointment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_employee_appointment_type IS 'New Employee appointment type';


--
-- Name: COLUMN approval_request.internal_communication_appointment_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.internal_communication_appointment_status IS 'Internal Communication Appointment Status';


--
-- Name: COLUMN approval_request.effective_appointment_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.effective_appointment_date IS 'Effective appointment date';


--
-- Name: COLUMN approval_request.appointment_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.appointment_note IS 'Appointment Note';


--
-- Name: COLUMN approval_request.is_employee_appointment_updated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.is_employee_appointment_updated IS 'Is Employee Appointment Updated';


--
-- Name: COLUMN approval_request.total; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.total IS 'Total';


--
-- Name: COLUMN approval_request.probationary_assessment_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.probationary_assessment_state IS 'Probationary Assessment State';


--
-- Name: COLUMN approval_request.probationary_assessment_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.probationary_assessment_notification IS 'Probationary Assessment Notification';


--
-- Name: COLUMN approval_request.workload; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.workload IS 'Workload';


--
-- Name: COLUMN approval_request.professional_skills; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.professional_skills IS 'Professional Skills';


--
-- Name: COLUMN approval_request.ability_process_manage_work; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.ability_process_manage_work IS 'Ability to process and manage work';


--
-- Name: COLUMN approval_request.team_work_skills; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.team_work_skills IS 'Team Work Skills';


--
-- Name: COLUMN approval_request.sense_responsibility; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.sense_responsibility IS 'Sense of Responsibility';


--
-- Name: COLUMN approval_request.feature_creation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.feature_creation IS 'Feature Creation';


--
-- Name: COLUMN approval_request.work_result_achieved; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.work_result_achieved IS 'Work Result Achieved';


--
-- Name: COLUMN approval_request.official_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.official_date IS 'Official Date';


--
-- Name: COLUMN approval_request.probationary_resignation_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.probationary_resignation_date IS 'Probationary Resignation Date';


--
-- Name: COLUMN approval_request.probationary_archive_odoo_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.probationary_archive_odoo_date IS 'Probationary Archive Odoo Date';


--
-- Name: COLUMN approval_request.positive_side; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.positive_side IS 'Positive Side';


--
-- Name: COLUMN approval_request.negative_side; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.negative_side IS 'Negative Side';


--
-- Name: COLUMN approval_request.prospect; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.prospect IS 'Prospect';


--
-- Name: COLUMN approval_request.recruitment_plan_job_position_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_job_position_id IS 'Open Position';


--
-- Name: COLUMN approval_request.recruitment_plan_candidate_manager_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_candidate_manager_id IS 'Candidate Manager';


--
-- Name: COLUMN approval_request.recruitment_plan_department_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_department_id IS 'Recruitment Plan Department';


--
-- Name: COLUMN approval_request.recruitment_plan_quantity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_quantity IS 'Recruitment Plan Quantity';


--
-- Name: COLUMN approval_request.recruitment_plan_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_name IS 'Plan Name';


--
-- Name: COLUMN approval_request.recruitment_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_month IS 'Recruitment Month';


--
-- Name: COLUMN approval_request.recruitment_year; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_year IS 'Recruitment Year';


--
-- Name: COLUMN approval_request.recruitment_plan_approval_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_approval_status IS 'Approval Status';


--
-- Name: COLUMN approval_request.main_department_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.main_department_name IS 'Main Department Name';


--
-- Name: COLUMN approval_request.recruitment_plan_proposal_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_proposal_date IS 'Proposal Date';


--
-- Name: COLUMN approval_request.recruitment_plan_candidate_profile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_candidate_profile IS 'Candidate Profile';


--
-- Name: COLUMN approval_request.recruitment_plan_interview_questions; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_interview_questions IS '5 Interview Questions';


--
-- Name: COLUMN approval_request.recruitment_plan_expected_answers; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_expected_answers IS '5 Expected Answers';


--
-- Name: COLUMN approval_request.is_proposal_ontime; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.is_proposal_ontime IS 'On Time';


--
-- Name: COLUMN approval_request.recruitment_plan_candidate_score; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_candidate_score IS 'Candidate Score (%)';


--
-- Name: COLUMN approval_request.recruitment_plan_sales_target; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recruitment_plan_sales_target IS 'Sales Target (VND)';


--
-- Name: COLUMN approval_request.resignation_reason_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.resignation_reason_id IS 'Resignation Reason';


--
-- Name: COLUMN approval_request.resignation_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.resignation_notification IS 'Resignation Notification';


--
-- Name: COLUMN approval_request.resignation_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.resignation_state IS 'Resignation State';


--
-- Name: COLUMN approval_request.link_survey; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.link_survey IS 'Link Survey';


--
-- Name: COLUMN approval_request.attachment_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.attachment_status IS 'Attachment Status';


--
-- Name: COLUMN approval_request.resignation_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.resignation_date IS 'Resignation Date';


--
-- Name: COLUMN approval_request.resignation_reason_details; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.resignation_reason_details IS 'Resignation Reason Details';


--
-- Name: COLUMN approval_request.survey_completed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.survey_completed IS 'Survey Completed';


--
-- Name: COLUMN approval_request.employee_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_transfer_id IS 'Employee Transfer';


--
-- Name: COLUMN approval_request.manager_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.manager_emp_transfer_id IS 'Current Manager employee transfer';


--
-- Name: COLUMN approval_request.job_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.job_emp_transfer_id IS 'Current Job employee transfer';


--
-- Name: COLUMN approval_request.department_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.department_emp_transfer_id IS 'Current Department employee transfer';


--
-- Name: COLUMN approval_request.work_location_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.work_location_emp_transfer_id IS 'Current Work Location employee transfer';


--
-- Name: COLUMN approval_request.resource_calendar_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.resource_calendar_emp_transfer_id IS 'Current Resource Calendar employee transfer';


--
-- Name: COLUMN approval_request.new_manager_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_manager_emp_transfer_id IS 'New Manager employee transfer';


--
-- Name: COLUMN approval_request.new_job_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_job_emp_transfer_id IS 'New Job employee transfer';


--
-- Name: COLUMN approval_request.new_department_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_department_emp_transfer_id IS 'New Department employee transfer';


--
-- Name: COLUMN approval_request.new_work_location_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_work_location_emp_transfer_id IS 'New Work Location employee transfer';


--
-- Name: COLUMN approval_request.new_resource_calendar_emp_transfer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_resource_calendar_emp_transfer_id IS 'New Resource Calendar employee transfer';


--
-- Name: COLUMN approval_request.transfer_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.transfer_notification IS 'Transfer Notification';


--
-- Name: COLUMN approval_request.transfer_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.transfer_state IS 'Transfer State';


--
-- Name: COLUMN approval_request.employee_transfer_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_transfer_code IS 'Employee Transfer Code';


--
-- Name: COLUMN approval_request.employee_transfer_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_transfer_type IS 'Current Employee transfer type';


--
-- Name: COLUMN approval_request.new_employee_transfer_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_employee_transfer_type IS 'New Employee transfer type';


--
-- Name: COLUMN approval_request.effective_transfer_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.effective_transfer_date IS 'Effective transfer date';


--
-- Name: COLUMN approval_request.transfer_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.transfer_note IS 'Transfer Note';


--
-- Name: COLUMN approval_request.is_employee_transfer_updated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.is_employee_transfer_updated IS 'Is Employee Transfer Updated';


--
-- Name: COLUMN approval_request.payment_approval_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.payment_approval_category_id IS 'Payment Approval Category';


--
-- Name: COLUMN approval_request.expenditure_object_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.expenditure_object_id IS 'Expenditure Object';


--
-- Name: COLUMN approval_request.bank_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.bank_id IS 'Bank Name';


--
-- Name: COLUMN approval_request.approval_cost_type_2_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.approval_cost_type_2_id IS 'Payment Type 2';


--
-- Name: COLUMN approval_request.approval_cost_type_3_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.approval_cost_type_3_id IS 'Payment Type 3';


--
-- Name: COLUMN approval_request.payment_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.payment_method IS 'Payment Method';


--
-- Name: COLUMN approval_request.bank_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.bank_account IS 'Bank Account';


--
-- Name: COLUMN approval_request.bank_account_owner; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.bank_account_owner IS 'Bank account owner';


--
-- Name: COLUMN approval_request.total_amount_text; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.total_amount_text IS 'Total Amount by text';


--
-- Name: COLUMN approval_request.expected_payment_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.expected_payment_date IS 'Expected Payment Date';


--
-- Name: COLUMN approval_request.total_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.total_amount IS 'Total Amount';


--
-- Name: COLUMN approval_request.total_amount_detail; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.total_amount_detail IS 'Total Amount Detail';


--
-- Name: COLUMN approval_request.sale_person_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.sale_person_id IS 'Sale Person';


--
-- Name: COLUMN approval_request.order_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.order_id IS 'Order';


--
-- Name: COLUMN approval_request.branch_manager_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.branch_manager_id IS 'Branch Manager';


--
-- Name: COLUMN approval_request.reason_details; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.reason_details IS 'Reason Details';


--
-- Name: COLUMN approval_request.person_in_charge_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.person_in_charge_id IS 'Person In Charge';


--
-- Name: COLUMN approval_request.approval_issue_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.approval_issue_category_id IS 'Violation Issue';


--
-- Name: COLUMN approval_request.branch_director_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.branch_director_id IS 'Branch Director';


--
-- Name: COLUMN approval_request.direct_manager_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.direct_manager_id IS 'Direct Manager of the Person in Charge';


--
-- Name: COLUMN approval_request.customer_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.customer_name IS 'Customer Name';


--
-- Name: COLUMN approval_request.page_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.page_name IS 'Page Name';


--
-- Name: COLUMN approval_request.chat_link; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.chat_link IS 'Link Chat';


--
-- Name: COLUMN approval_request.violating_content; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.violating_content IS 'Violating Content';


--
-- Name: COLUMN approval_request.violating_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.violating_date IS 'Violating Date';


--
-- Name: COLUMN approval_request.resource_calendar_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.resource_calendar_id IS 'Resource Calendar';


--
-- Name: COLUMN approval_request.explain_attendance_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.explain_attendance_state IS 'Explanation Attendance State';


--
-- Name: COLUMN approval_request.explanation_attendance_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.explanation_attendance_notification IS 'Explanation Attendance Notification';


--
-- Name: COLUMN approval_request.input_country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_country_id IS 'Country';


--
-- Name: COLUMN approval_request.input_certificate_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_certificate_id IS 'Level of Certificate';


--
-- Name: COLUMN approval_request.input_study_field_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_study_field_id IS 'Field of Study';


--
-- Name: COLUMN approval_request.input_study_school_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_study_school_id IS 'School';


--
-- Name: COLUMN approval_request.input_bank_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_bank_id IS 'Bank';


--
-- Name: COLUMN approval_request.emp_input_information_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.emp_input_information_notification IS 'Employee Input Information Notification';


--
-- Name: COLUMN approval_request.emp_input_information_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.emp_input_information_state IS 'Employee Input Information State';


--
-- Name: COLUMN approval_request.input_identification_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_identification_id IS 'Identification ID';


--
-- Name: COLUMN approval_request.input_identification_address; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_identification_address IS 'Identification address';


--
-- Name: COLUMN approval_request.input_gender; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_gender IS 'Gender';


--
-- Name: COLUMN approval_request.input_ssnid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_ssnid IS 'SSN No';


--
-- Name: COLUMN approval_request.input_registration_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_registration_number IS 'Registration Number';


--
-- Name: COLUMN approval_request.input_head_household_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_head_household_name IS 'Head of Household''s Name';


--
-- Name: COLUMN approval_request.input_head_household_relationship; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_head_household_relationship IS 'Head of Household''s Relationship';


--
-- Name: COLUMN approval_request.input_head_household_identification_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_head_household_identification_id IS 'Head of Household''s Identification ID';


--
-- Name: COLUMN approval_request.input_bank_account_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_bank_account_number IS 'Bank Account Number';


--
-- Name: COLUMN approval_request.input_identification_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_identification_date IS 'Identification date';


--
-- Name: COLUMN approval_request.input_date_of_birth; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.input_date_of_birth IS 'Date of birth';


--
-- Name: COLUMN approval_request.expense_advance_approval_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.expense_advance_approval_category_id IS 'Expense Advance Category';


--
-- Name: COLUMN approval_request.payment_source; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.payment_source IS 'Payment Source';


--
-- Name: COLUMN approval_request.thailand_payment_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.thailand_payment_method IS 'Payment method';


--
-- Name: COLUMN approval_request.note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.note IS 'Note';


--
-- Name: COLUMN approval_request.purchase_propose_content; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.purchase_propose_content IS 'Purchase Propose Content';


--
-- Name: COLUMN approval_request.work_online_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.work_online_notification IS 'Work Online Notification';


--
-- Name: COLUMN approval_request.work_online_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.work_online_state IS 'Work Online State';


--
-- Name: COLUMN approval_request.work_online_start_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.work_online_start_date IS 'Work Online Start Date';


--
-- Name: COLUMN approval_request.work_online_end_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.work_online_end_date IS 'Work Online End Date';


--
-- Name: COLUMN approval_request.work_online_reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.work_online_reason IS 'Work Online Reason';


--
-- Name: COLUMN approval_request.expense_refund_approval_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.expense_refund_approval_category_id IS 'Expense Refund Category';


--
-- Name: COLUMN approval_request.product_supply_payment_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.product_supply_payment_method IS 'Payment methods';


--
-- Name: COLUMN approval_request.sale_return_reason_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.sale_return_reason_id IS 'Sale Return Reason';


--
-- Name: COLUMN approval_request.warehouse_explanation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.warehouse_explanation IS 'Warehouse Explanation';


--
-- Name: COLUMN approval_request.debt_order_reason_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.debt_order_reason_id IS 'Debt Order Reason';


--
-- Name: COLUMN approval_request.justification_image_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.justification_image_url IS 'Justification Image URL';


--
-- Name: COLUMN approval_request.facebook_conversation_link; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.facebook_conversation_link IS 'Facebook Conversation Link';


--
-- Name: COLUMN approval_request.is_validated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.is_validated IS 'Is Validated';


--
-- Name: COLUMN approval_request.overtime_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.overtime_notification IS 'Overtime Notification';


--
-- Name: COLUMN approval_request.overtime_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.overtime_state IS 'Overtime State';


--
-- Name: COLUMN approval_request.overtime_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.overtime_date IS 'Overtime Date';


--
-- Name: COLUMN approval_request.overtime_reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.overtime_reason IS 'Overtime Reason';


--
-- Name: COLUMN approval_request.overtime_time_start_float; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.overtime_time_start_float IS 'Overtime Time Start';


--
-- Name: COLUMN approval_request.overtime_time_end_float; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.overtime_time_end_float IS 'Overtime Time End';


--
-- Name: COLUMN approval_request.overtime_break_time; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.overtime_break_time IS 'Overtime Break Time';


--
-- Name: COLUMN approval_request.proposed_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.proposed_date IS 'Proposed Date';


--
-- Name: COLUMN approval_request.employee_salary_proposal_contract_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_salary_proposal_contract_id IS 'Employee Salary Proposal Contract';


--
-- Name: COLUMN approval_request.salary_increase_proposal_reason_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.salary_increase_proposal_reason_id IS 'Salary Increase Proposal Reason';


--
-- Name: COLUMN approval_request.increase_value_percent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.increase_value_percent IS 'Increase Value (%)';


--
-- Name: COLUMN approval_request.employee_salary_increase_proposal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.employee_salary_increase_proposal_id IS 'Employee Salary Increase Proposal';


--
-- Name: COLUMN approval_request.salary_increase_proposal_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.salary_increase_proposal_state IS 'Salary Increase Proposal State';


--
-- Name: COLUMN approval_request.salary_increase_proposal_notification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.salary_increase_proposal_notification IS 'Salary Increase Proposal Notification';


--
-- Name: COLUMN approval_request.increase_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.increase_type IS 'Increase Type';


--
-- Name: COLUMN approval_request.apply_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.apply_date IS 'Apply Date';


--
-- Name: COLUMN approval_request.salary_increase_proposal_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.salary_increase_proposal_description IS 'Salary Increase Proposal Description';


--
-- Name: COLUMN approval_request.increase_value_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.increase_value_amount IS 'Increase Value (Amount)';


--
-- Name: COLUMN approval_request.new_salary; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_salary IS 'New Salary';


--
-- Name: COLUMN approval_request.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.country_id IS 'Customer Country';


--
-- Name: COLUMN approval_request.recipient_bank; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.recipient_bank IS 'Recipient Bank';


--
-- Name: COLUMN approval_request.refund_accounting_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.refund_accounting_date IS 'Refund Accounting Date';


--
-- Name: COLUMN approval_request.sales_employee_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.sales_employee_id IS 'Sales/Resale Employee';


--
-- Name: COLUMN approval_request.sales_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.sales_team_id IS 'Sales/Resale Team';


--
-- Name: COLUMN approval_request.marketing_responsible_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.marketing_responsible_id IS 'Marketing Responsible';


--
-- Name: COLUMN approval_request.marketing_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.marketing_team_id IS 'Marketing Team';


--
-- Name: COLUMN approval_request.new_sales_employee_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_sales_employee_id IS 'New Sales/Resale Employee';


--
-- Name: COLUMN approval_request.new_sales_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_sales_team_id IS 'New Sales/Resale Team';


--
-- Name: COLUMN approval_request.new_marketing_responsible_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_marketing_responsible_id IS 'New Marketing Responsible';


--
-- Name: COLUMN approval_request.new_marketing_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_marketing_team_id IS 'New Marketing Team';


--
-- Name: COLUMN approval_request.new_crm_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.new_crm_group_id IS 'New Branch';


--
-- Name: COLUMN approval_request.shipping_revenue_reason; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_request.shipping_revenue_reason IS 'Reason';


--
-- Name: approval_request_available_marketing_team_ids_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_request_available_marketing_team_ids_rel (
    approval_request_id integer NOT NULL,
    crm_team_id integer NOT NULL
);


ALTER TABLE public.approval_request_available_marketing_team_ids_rel OWNER TO ductin;

--
-- Name: TABLE approval_request_available_marketing_team_ids_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_request_available_marketing_team_ids_rel IS 'RELATION BETWEEN approval_request AND crm_team';


--
-- Name: approval_request_available_sales_team_ids_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_request_available_sales_team_ids_rel (
    approval_request_id integer NOT NULL,
    crm_team_id integer NOT NULL
);


ALTER TABLE public.approval_request_available_sales_team_ids_rel OWNER TO ductin;

--
-- Name: TABLE approval_request_available_sales_team_ids_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_request_available_sales_team_ids_rel IS 'RELATION BETWEEN approval_request AND crm_team';


--
-- Name: approval_request_hr_recruitment_reason_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_request_hr_recruitment_reason_rel (
    approval_request_id integer NOT NULL,
    hr_recruitment_reason_id integer NOT NULL
);


ALTER TABLE public.approval_request_hr_recruitment_reason_rel OWNER TO ductin;

--
-- Name: TABLE approval_request_hr_recruitment_reason_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_request_hr_recruitment_reason_rel IS 'RELATION BETWEEN approval_request AND hr_recruitment_reason';


--
-- Name: approval_request_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_request_id_seq OWNER TO ductin;

--
-- Name: approval_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_request_id_seq OWNED BY public.approval_request.id;


--
-- Name: approval_request_ir_attachment_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_request_ir_attachment_rel (
    approval_request_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.approval_request_ir_attachment_rel OWNER TO ductin;

--
-- Name: TABLE approval_request_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_request_ir_attachment_rel IS 'RELATION BETWEEN approval_request AND ir_attachment';


--
-- Name: approval_request_next_approver_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_request_next_approver_rel (
    request_id integer NOT NULL,
    approver_id integer NOT NULL
);


ALTER TABLE public.approval_request_next_approver_rel OWNER TO ductin;

--
-- Name: TABLE approval_request_next_approver_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_request_next_approver_rel IS 'RELATION BETWEEN approval_request AND res_users';


--
-- Name: approval_request_tag_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_request_tag_rel (
    request_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.approval_request_tag_rel OWNER TO ductin;

--
-- Name: TABLE approval_request_tag_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_request_tag_rel IS 'RELATION BETWEEN approval_request AND approval_tag';


--
-- Name: approval_rule_users_to_notify_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_rule_users_to_notify_rel (
    studio_approval_rule_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.approval_rule_users_to_notify_rel OWNER TO ductin;

--
-- Name: TABLE approval_rule_users_to_notify_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_rule_users_to_notify_rel IS 'RELATION BETWEEN studio_approval_rule AND res_users';


--
-- Name: approval_sub_approver_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_sub_approver_users_rel (
    approval_approver_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.approval_sub_approver_users_rel OWNER TO ductin;

--
-- Name: TABLE approval_sub_approver_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_sub_approver_users_rel IS 'RELATION BETWEEN approval_approver AND res_users';


--
-- Name: approval_tag; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approval_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_tag OWNER TO ductin;

--
-- Name: TABLE approval_tag; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approval_tag IS 'Approval Tag';


--
-- Name: COLUMN approval_tag.color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_tag.color IS 'Color';


--
-- Name: COLUMN approval_tag.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_tag.create_uid IS 'Created by';


--
-- Name: COLUMN approval_tag.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_tag.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_tag.name IS 'Tag Name';


--
-- Name: COLUMN approval_tag.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_tag.create_date IS 'Created on';


--
-- Name: COLUMN approval_tag.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.approval_tag.write_date IS 'Last Updated on';


--
-- Name: approval_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.approval_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_tag_id_seq OWNER TO ductin;

--
-- Name: approval_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.approval_tag_id_seq OWNED BY public.approval_tag.id;


--
-- Name: approvals_tags_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.approvals_tags_rel (
    res_company_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.approvals_tags_rel OWNER TO ductin;

--
-- Name: TABLE approvals_tags_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.approvals_tags_rel IS 'RELATION BETWEEN res_company AND documents_tag';


--
-- Name: asset_modify; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.asset_modify (
    id integer NOT NULL,
    asset_id integer NOT NULL,
    method_number integer NOT NULL,
    account_asset_id integer,
    account_asset_counterpart_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    create_uid integer,
    write_uid integer,
    method_period character varying,
    modify_action character varying,
    date date,
    name text,
    value_residual numeric,
    salvage_value numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.asset_modify OWNER TO ductin;

--
-- Name: TABLE asset_modify; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.asset_modify IS 'Modify Asset';


--
-- Name: COLUMN asset_modify.asset_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.asset_id IS 'Asset';


--
-- Name: COLUMN asset_modify.method_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.method_number IS 'Duration';


--
-- Name: COLUMN asset_modify.account_asset_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.account_asset_id IS 'Gross Increase Account';


--
-- Name: COLUMN asset_modify.account_asset_counterpart_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.account_asset_counterpart_id IS 'Asset Counterpart Account';


--
-- Name: COLUMN asset_modify.account_depreciation_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN asset_modify.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN asset_modify.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.create_uid IS 'Created by';


--
-- Name: COLUMN asset_modify.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.write_uid IS 'Last Updated by';


--
-- Name: COLUMN asset_modify.method_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN asset_modify.modify_action; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.modify_action IS 'Action';


--
-- Name: COLUMN asset_modify.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.date IS 'Date';


--
-- Name: COLUMN asset_modify.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.name IS 'Note';


--
-- Name: COLUMN asset_modify.value_residual; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.value_residual IS 'Depreciable Amount';


--
-- Name: COLUMN asset_modify.salvage_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.salvage_value IS 'Not Depreciable Amount';


--
-- Name: COLUMN asset_modify.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.create_date IS 'Created on';


--
-- Name: COLUMN asset_modify.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.asset_modify.write_date IS 'Last Updated on';


--
-- Name: asset_modify_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.asset_modify_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.asset_modify_id_seq OWNER TO ductin;

--
-- Name: asset_modify_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.asset_modify_id_seq OWNED BY public.asset_modify.id;


--
-- Name: asset_move_line_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.asset_move_line_rel (
    asset_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.asset_move_line_rel OWNER TO ductin;

--
-- Name: TABLE asset_move_line_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.asset_move_line_rel IS 'RELATION BETWEEN account_asset AND account_move_line';


--
-- Name: attendance_device_config; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.attendance_device_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    serial character varying NOT NULL,
    location character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.attendance_device_config OWNER TO ductin;

--
-- Name: TABLE attendance_device_config; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.attendance_device_config IS 'Attendance Device Configuration';


--
-- Name: COLUMN attendance_device_config.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.attendance_device_config.create_uid IS 'Created by';


--
-- Name: COLUMN attendance_device_config.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.attendance_device_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN attendance_device_config.serial; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.attendance_device_config.serial IS 'Serial';


--
-- Name: COLUMN attendance_device_config.location; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.attendance_device_config.location IS 'Location';


--
-- Name: COLUMN attendance_device_config.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.attendance_device_config.create_date IS 'Created on';


--
-- Name: COLUMN attendance_device_config.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.attendance_device_config.write_date IS 'Last Updated on';


--
-- Name: attendance_device_config_crawl_attendance_wizard_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.attendance_device_config_crawl_attendance_wizard_rel (
    crawl_attendance_wizard_id integer NOT NULL,
    attendance_device_config_id integer NOT NULL
);


ALTER TABLE public.attendance_device_config_crawl_attendance_wizard_rel OWNER TO ductin;

--
-- Name: TABLE attendance_device_config_crawl_attendance_wizard_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.attendance_device_config_crawl_attendance_wizard_rel IS 'RELATION BETWEEN crawl_attendance_wizard AND attendance_device_config';


--
-- Name: attendance_device_config_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.attendance_device_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.attendance_device_config_id_seq OWNER TO ductin;

--
-- Name: attendance_device_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.attendance_device_config_id_seq OWNED BY public.attendance_device_config.id;


--
-- Name: auditlog_autovacuum; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auditlog_autovacuum (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auditlog_autovacuum OWNER TO ductin;

--
-- Name: TABLE auditlog_autovacuum; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auditlog_autovacuum IS 'Auditlog - Delete old logs';


--
-- Name: COLUMN auditlog_autovacuum.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_autovacuum.create_uid IS 'Created by';


--
-- Name: COLUMN auditlog_autovacuum.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_autovacuum.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auditlog_autovacuum.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_autovacuum.create_date IS 'Created on';


--
-- Name: COLUMN auditlog_autovacuum.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_autovacuum.write_date IS 'Last Updated on';


--
-- Name: auditlog_autovacuum_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auditlog_autovacuum_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auditlog_autovacuum_id_seq OWNER TO ductin;

--
-- Name: auditlog_autovacuum_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auditlog_autovacuum_id_seq OWNED BY public.auditlog_autovacuum.id;


--
-- Name: auditlog_http_request; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auditlog_http_request (
    id integer NOT NULL,
    user_id integer,
    http_session_id integer,
    create_uid integer,
    write_uid integer,
    display_name character varying,
    name character varying,
    root_url character varying,
    user_context character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auditlog_http_request OWNER TO ductin;

--
-- Name: TABLE auditlog_http_request; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auditlog_http_request IS 'Auditlog - HTTP request log';


--
-- Name: COLUMN auditlog_http_request.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.user_id IS 'User';


--
-- Name: COLUMN auditlog_http_request.http_session_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.http_session_id IS 'Session';


--
-- Name: COLUMN auditlog_http_request.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.create_uid IS 'Created by';


--
-- Name: COLUMN auditlog_http_request.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auditlog_http_request.display_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.display_name IS 'Name';


--
-- Name: COLUMN auditlog_http_request.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.name IS 'Path';


--
-- Name: COLUMN auditlog_http_request.root_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.root_url IS 'Root URL';


--
-- Name: COLUMN auditlog_http_request.user_context; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.user_context IS 'Context';


--
-- Name: COLUMN auditlog_http_request.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.create_date IS 'Created on';


--
-- Name: COLUMN auditlog_http_request.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_request.write_date IS 'Last Updated on';


--
-- Name: auditlog_http_request_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auditlog_http_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auditlog_http_request_id_seq OWNER TO ductin;

--
-- Name: auditlog_http_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auditlog_http_request_id_seq OWNED BY public.auditlog_http_request.id;


--
-- Name: auditlog_http_session; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auditlog_http_session (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    display_name character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auditlog_http_session OWNER TO ductin;

--
-- Name: TABLE auditlog_http_session; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auditlog_http_session IS 'Auditlog - HTTP User session log';


--
-- Name: COLUMN auditlog_http_session.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_session.user_id IS 'User';


--
-- Name: COLUMN auditlog_http_session.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_session.create_uid IS 'Created by';


--
-- Name: COLUMN auditlog_http_session.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auditlog_http_session.display_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_session.display_name IS 'Name';


--
-- Name: COLUMN auditlog_http_session.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_session.name IS 'Session ID';


--
-- Name: COLUMN auditlog_http_session.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_session.create_date IS 'Created on';


--
-- Name: COLUMN auditlog_http_session.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_http_session.write_date IS 'Last Updated on';


--
-- Name: auditlog_http_session_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auditlog_http_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auditlog_http_session_id_seq OWNER TO ductin;

--
-- Name: auditlog_http_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auditlog_http_session_id_seq OWNED BY public.auditlog_http_session.id;


--
-- Name: auditlog_log; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auditlog_log (
    id integer NOT NULL,
    model_id integer,
    res_id integer,
    user_id integer,
    http_session_id integer,
    http_request_id integer,
    create_uid integer,
    write_uid integer,
    name character varying(64),
    model_name character varying,
    model_model character varying,
    res_ids character varying,
    method character varying(64),
    log_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auditlog_log OWNER TO ductin;

--
-- Name: TABLE auditlog_log; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auditlog_log IS 'Auditlog - Log';


--
-- Name: COLUMN auditlog_log.model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.model_id IS 'Model';


--
-- Name: COLUMN auditlog_log.res_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.res_id IS 'Resource ID';


--
-- Name: COLUMN auditlog_log.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.user_id IS 'User';


--
-- Name: COLUMN auditlog_log.http_session_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.http_session_id IS 'Session';


--
-- Name: COLUMN auditlog_log.http_request_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.http_request_id IS 'HTTP Request';


--
-- Name: COLUMN auditlog_log.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.create_uid IS 'Created by';


--
-- Name: COLUMN auditlog_log.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auditlog_log.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.name IS 'Resource Name';


--
-- Name: COLUMN auditlog_log.model_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.model_name IS 'Model Name';


--
-- Name: COLUMN auditlog_log.model_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.model_model IS 'Technical Model Name';


--
-- Name: COLUMN auditlog_log.res_ids; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.res_ids IS 'Resource IDs';


--
-- Name: COLUMN auditlog_log.method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.method IS 'Method';


--
-- Name: COLUMN auditlog_log.log_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.log_type IS 'Type';


--
-- Name: COLUMN auditlog_log.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.create_date IS 'Created on';


--
-- Name: COLUMN auditlog_log.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log.write_date IS 'Last Updated on';


--
-- Name: auditlog_log_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auditlog_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auditlog_log_id_seq OWNER TO ductin;

--
-- Name: auditlog_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auditlog_log_id_seq OWNED BY public.auditlog_log.id;


--
-- Name: auditlog_log_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auditlog_log_line (
    id integer NOT NULL,
    field_id integer,
    log_id integer,
    create_uid integer,
    write_uid integer,
    field_name character varying,
    field_description character varying,
    old_value text,
    new_value text,
    old_value_text text,
    new_value_text text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auditlog_log_line OWNER TO ductin;

--
-- Name: TABLE auditlog_log_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auditlog_log_line IS 'Auditlog - Log details (fields updated)';


--
-- Name: COLUMN auditlog_log_line.field_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.field_id IS 'Field';


--
-- Name: COLUMN auditlog_log_line.log_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.log_id IS 'Log';


--
-- Name: COLUMN auditlog_log_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.create_uid IS 'Created by';


--
-- Name: COLUMN auditlog_log_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auditlog_log_line.field_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.field_name IS 'Technical name';


--
-- Name: COLUMN auditlog_log_line.field_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.field_description IS 'Description';


--
-- Name: COLUMN auditlog_log_line.old_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.old_value IS 'Old Value';


--
-- Name: COLUMN auditlog_log_line.new_value; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.new_value IS 'New Value';


--
-- Name: COLUMN auditlog_log_line.old_value_text; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.old_value_text IS 'Old value Text';


--
-- Name: COLUMN auditlog_log_line.new_value_text; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.new_value_text IS 'New value Text';


--
-- Name: COLUMN auditlog_log_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.create_date IS 'Created on';


--
-- Name: COLUMN auditlog_log_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_log_line.write_date IS 'Last Updated on';


--
-- Name: auditlog_log_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auditlog_log_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auditlog_log_line_id_seq OWNER TO ductin;

--
-- Name: auditlog_log_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auditlog_log_line_id_seq OWNED BY public.auditlog_log_line.id;


--
-- Name: auditlog_rule; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auditlog_rule (
    id integer NOT NULL,
    model_id integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model_name character varying,
    model_model character varying,
    log_type character varying NOT NULL,
    state character varying NOT NULL,
    log_read boolean,
    log_write boolean,
    log_unlink boolean,
    log_create boolean,
    log_export_data boolean,
    capture_record boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auditlog_rule OWNER TO ductin;

--
-- Name: TABLE auditlog_rule; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auditlog_rule IS 'Auditlog - Rule';


--
-- Name: COLUMN auditlog_rule.model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.model_id IS 'Model';


--
-- Name: COLUMN auditlog_rule.action_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.action_id IS 'Action';


--
-- Name: COLUMN auditlog_rule.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.create_uid IS 'Created by';


--
-- Name: COLUMN auditlog_rule.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auditlog_rule.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.name IS 'Name';


--
-- Name: COLUMN auditlog_rule.model_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.model_name IS 'Model Name';


--
-- Name: COLUMN auditlog_rule.model_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.model_model IS 'Technical Model Name';


--
-- Name: COLUMN auditlog_rule.log_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.log_type IS 'Type';


--
-- Name: COLUMN auditlog_rule.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.state IS 'State';


--
-- Name: COLUMN auditlog_rule.log_read; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.log_read IS 'Log Reads';


--
-- Name: COLUMN auditlog_rule.log_write; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.log_write IS 'Log Writes';


--
-- Name: COLUMN auditlog_rule.log_unlink; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.log_unlink IS 'Log Deletes';


--
-- Name: COLUMN auditlog_rule.log_create; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.log_create IS 'Log Creates';


--
-- Name: COLUMN auditlog_rule.log_export_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.log_export_data IS 'Log Exports';


--
-- Name: COLUMN auditlog_rule.capture_record; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.capture_record IS 'Capture Record';


--
-- Name: COLUMN auditlog_rule.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.create_date IS 'Created on';


--
-- Name: COLUMN auditlog_rule.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auditlog_rule.write_date IS 'Last Updated on';


--
-- Name: auditlog_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auditlog_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auditlog_rule_id_seq OWNER TO ductin;

--
-- Name: auditlog_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auditlog_rule_id_seq OWNED BY public.auditlog_rule.id;


--
-- Name: auditlog_rule_ir_model_fields_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auditlog_rule_ir_model_fields_rel (
    auditlog_rule_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.auditlog_rule_ir_model_fields_rel OWNER TO ductin;

--
-- Name: TABLE auditlog_rule_ir_model_fields_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auditlog_rule_ir_model_fields_rel IS 'RELATION BETWEEN auditlog_rule AND ir_model_fields';


--
-- Name: auditlog_rule_res_users_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auditlog_rule_res_users_rel (
    auditlog_rule_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.auditlog_rule_res_users_rel OWNER TO ductin;

--
-- Name: TABLE auditlog_rule_res_users_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auditlog_rule_res_users_rel IS 'RELATION BETWEEN auditlog_rule AND res_users';


--
-- Name: audittail_rules_users; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.audittail_rules_users (
    user_id integer NOT NULL,
    rule_id integer NOT NULL
);


ALTER TABLE public.audittail_rules_users OWNER TO ductin;

--
-- Name: TABLE audittail_rules_users; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.audittail_rules_users IS 'RELATION BETWEEN auditlog_rule AND res_users';


--
-- Name: auth_api_key; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auth_api_key (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    key character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_api_key OWNER TO ductin;

--
-- Name: TABLE auth_api_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auth_api_key IS 'API Key';


--
-- Name: COLUMN auth_api_key.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_api_key.user_id IS 'User';


--
-- Name: COLUMN auth_api_key.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_api_key.create_uid IS 'Created by';


--
-- Name: COLUMN auth_api_key.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_api_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_api_key.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_api_key.name IS 'Name';


--
-- Name: COLUMN auth_api_key.key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_api_key.key IS 'Key';


--
-- Name: COLUMN auth_api_key.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_api_key.active IS 'Active';


--
-- Name: COLUMN auth_api_key.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_api_key.create_date IS 'Created on';


--
-- Name: COLUMN auth_api_key.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_api_key.write_date IS 'Last Updated on';


--
-- Name: auth_api_key_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auth_api_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_api_key_id_seq OWNER TO ductin;

--
-- Name: auth_api_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auth_api_key_id_seq OWNED BY public.auth_api_key.id;


--
-- Name: auth_oauth_provider; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auth_oauth_provider (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    client_id character varying,
    auth_endpoint character varying NOT NULL,
    scope character varying,
    validation_endpoint character varying NOT NULL,
    data_endpoint character varying,
    css_class character varying,
    body jsonb NOT NULL,
    enabled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_oauth_provider OWNER TO ductin;

--
-- Name: TABLE auth_oauth_provider; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auth_oauth_provider IS 'OAuth2 provider';


--
-- Name: COLUMN auth_oauth_provider.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.sequence IS 'Sequence';


--
-- Name: COLUMN auth_oauth_provider.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.create_uid IS 'Created by';


--
-- Name: COLUMN auth_oauth_provider.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_oauth_provider.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.name IS 'Provider name';


--
-- Name: COLUMN auth_oauth_provider.client_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.client_id IS 'Client ID';


--
-- Name: COLUMN auth_oauth_provider.auth_endpoint; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.auth_endpoint IS 'Authorization URL';


--
-- Name: COLUMN auth_oauth_provider.scope; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.scope IS 'Scope';


--
-- Name: COLUMN auth_oauth_provider.validation_endpoint; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.validation_endpoint IS 'UserInfo URL';


--
-- Name: COLUMN auth_oauth_provider.data_endpoint; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.data_endpoint IS 'Data Endpoint';


--
-- Name: COLUMN auth_oauth_provider.css_class; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.css_class IS 'CSS class';


--
-- Name: COLUMN auth_oauth_provider.body; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.body IS 'Login button label';


--
-- Name: COLUMN auth_oauth_provider.enabled; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.enabled IS 'Allowed';


--
-- Name: COLUMN auth_oauth_provider.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.create_date IS 'Created on';


--
-- Name: COLUMN auth_oauth_provider.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_oauth_provider.write_date IS 'Last Updated on';


--
-- Name: auth_oauth_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auth_oauth_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_oauth_provider_id_seq OWNER TO ductin;

--
-- Name: auth_oauth_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auth_oauth_provider_id_seq OWNED BY public.auth_oauth_provider.id;


--
-- Name: auth_passkey_key; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auth_passkey_key (
    id integer NOT NULL,
    sign_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    credential_identifier character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    public_key character varying
);


ALTER TABLE public.auth_passkey_key OWNER TO ductin;

--
-- Name: TABLE auth_passkey_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auth_passkey_key IS 'Passkey';


--
-- Name: COLUMN auth_passkey_key.sign_count; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key.sign_count IS 'Sign Count';


--
-- Name: COLUMN auth_passkey_key.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key.create_uid IS 'Created by';


--
-- Name: COLUMN auth_passkey_key.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key.credential_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key.credential_identifier IS 'Credential Identifier';


--
-- Name: COLUMN auth_passkey_key.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auth_passkey_key_create (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_passkey_key_create OWNER TO ductin;

--
-- Name: TABLE auth_passkey_key_create; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auth_passkey_key_create IS 'Create a Passkey';


--
-- Name: COLUMN auth_passkey_key_create.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_uid IS 'Created by';


--
-- Name: COLUMN auth_passkey_key_create.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key_create.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key_create.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key_create.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key_create.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auth_passkey_key_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNER TO ductin;

--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNED BY public.auth_passkey_key_create.id;


--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auth_passkey_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_id_seq OWNER TO ductin;

--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auth_passkey_key_id_seq OWNED BY public.auth_passkey_key.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO ductin;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO ductin;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_rate_limit_log; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auth_totp_rate_limit_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    scope character varying,
    ip character varying,
    limit_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_rate_limit_log OWNER TO ductin;

--
-- Name: TABLE auth_totp_rate_limit_log; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auth_totp_rate_limit_log IS 'TOTP rate limit logs';


--
-- Name: COLUMN auth_totp_rate_limit_log.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.user_id IS 'User';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_rate_limit_log.scope; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.scope IS 'Scope';


--
-- Name: COLUMN auth_totp_rate_limit_log.ip; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.ip IS 'Ip';


--
-- Name: COLUMN auth_totp_rate_limit_log.limit_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.limit_type IS 'Limit Type';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_date IS 'Last Updated on';


--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auth_totp_rate_limit_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNER TO ductin;

--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNED BY public.auth_totp_rate_limit_log.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO ductin;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO ductin;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: avatax_connection_test_result; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.avatax_connection_test_result (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_response text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_connection_test_result OWNER TO ductin;

--
-- Name: TABLE avatax_connection_test_result; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.avatax_connection_test_result IS 'Test connection with avatax';


--
-- Name: COLUMN avatax_connection_test_result.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_connection_test_result.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_connection_test_result.server_response; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_connection_test_result.server_response IS 'Server Response';


--
-- Name: COLUMN avatax_connection_test_result.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_date IS 'Created on';


--
-- Name: COLUMN avatax_connection_test_result.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_date IS 'Last Updated on';


--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.avatax_connection_test_result_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNER TO ductin;

--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNED BY public.avatax_connection_test_result.id;


--
-- Name: avatax_exemption; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.avatax_exemption (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_exemption OWNER TO ductin;

--
-- Name: TABLE avatax_exemption; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.avatax_exemption IS 'Avatax Partner Exemption Codes';


--
-- Name: COLUMN avatax_exemption.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_exemption.company_id IS 'Company';


--
-- Name: COLUMN avatax_exemption.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_exemption.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_exemption.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_exemption.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_exemption.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_exemption.name IS 'Name';


--
-- Name: COLUMN avatax_exemption.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_exemption.code IS 'Code';


--
-- Name: COLUMN avatax_exemption.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_exemption.description IS 'Description';


--
-- Name: COLUMN avatax_exemption.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_exemption.create_date IS 'Created on';


--
-- Name: COLUMN avatax_exemption.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_exemption.write_date IS 'Last Updated on';


--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.avatax_exemption_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_exemption_id_seq OWNER TO ductin;

--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.avatax_exemption_id_seq OWNED BY public.avatax_exemption.id;


--
-- Name: avatax_exemption_res_country_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.avatax_exemption_res_country_rel (
    avatax_exemption_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.avatax_exemption_res_country_rel OWNER TO ductin;

--
-- Name: TABLE avatax_exemption_res_country_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.avatax_exemption_res_country_rel IS 'RELATION BETWEEN avatax_exemption AND res_country';


--
-- Name: avatax_validate_address; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.avatax_validate_address (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_validate_address OWNER TO ductin;

--
-- Name: TABLE avatax_validate_address; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.avatax_validate_address IS 'Suggests validated addresses from Avatax';


--
-- Name: COLUMN avatax_validate_address.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_validate_address.partner_id IS 'Partner';


--
-- Name: COLUMN avatax_validate_address.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_validate_address.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_validate_address.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_validate_address.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_validate_address.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_validate_address.create_date IS 'Created on';


--
-- Name: COLUMN avatax_validate_address.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.avatax_validate_address.write_date IS 'Last Updated on';


--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.avatax_validate_address_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_validate_address_id_seq OWNER TO ductin;

--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.avatax_validate_address_id_seq OWNED BY public.avatax_validate_address.id;


--
-- Name: bad_debt_sequence_data; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.bad_debt_sequence_data (
    id integer NOT NULL,
    invoice_id integer NOT NULL,
    bad_debt_sequence integer NOT NULL,
    user_id integer,
    country_id integer,
    delivery_month date NOT NULL,
    report_month date
);


ALTER TABLE public.bad_debt_sequence_data OWNER TO ductin;

--
-- Name: TABLE bad_debt_sequence_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.bad_debt_sequence_data IS 'Bad Debt Sequence Data';


--
-- Name: COLUMN bad_debt_sequence_data.invoice_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bad_debt_sequence_data.invoice_id IS 'Invoice ID';


--
-- Name: COLUMN bad_debt_sequence_data.bad_debt_sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bad_debt_sequence_data.bad_debt_sequence IS 'Bad Debt Sequence';


--
-- Name: COLUMN bad_debt_sequence_data.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bad_debt_sequence_data.user_id IS 'User ID';


--
-- Name: COLUMN bad_debt_sequence_data.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bad_debt_sequence_data.country_id IS 'Country ID';


--
-- Name: COLUMN bad_debt_sequence_data.delivery_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bad_debt_sequence_data.delivery_month IS 'Delivery Month';


--
-- Name: COLUMN bad_debt_sequence_data.report_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bad_debt_sequence_data.report_month IS 'Report Month';


--
-- Name: crm_lead; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.crm_lead (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    message_bounce integer,
    user_id integer,
    team_id integer,
    company_id integer,
    stage_id integer,
    color integer,
    recurring_plan integer,
    partner_id integer,
    title integer,
    lang_id integer,
    state_id integer,
    country_id integer,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    phone_sanitized character varying,
    email_normalized character varying,
    email_cc character varying,
    name character varying NOT NULL,
    referred character varying,
    type character varying NOT NULL,
    priority character varying,
    contact_name character varying,
    partner_name character varying,
    function character varying,
    email_from character varying,
    email_domain_criterion character varying,
    phone character varying,
    mobile character varying,
    phone_state character varying,
    email_state character varying,
    website character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    date_deadline date,
    lead_properties jsonb,
    description text,
    expected_revenue numeric,
    prorated_revenue numeric,
    recurring_revenue numeric,
    recurring_revenue_monthly numeric,
    recurring_revenue_monthly_prorated numeric,
    recurring_revenue_prorated numeric,
    active boolean,
    date_closed timestamp without time zone,
    date_automation_last timestamp without time zone,
    date_open timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    date_conversion timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    day_open double precision,
    day_close double precision,
    probability double precision,
    automated_probability double precision,
    won_status character varying,
    days_to_convert double precision,
    days_exceeding_closing double precision,
    crm_group_id integer,
    crm_type character varying,
    event_lead_rule_id integer,
    event_id integer,
    reveal_id character varying,
    iap_enrich_done boolean,
    lead_mining_request_id integer,
    reveal_iap_credits integer,
    reveal_rule_id integer,
    reveal_ip character varying,
    partner_assigned_id integer,
    date_partner_assign date,
    partner_latitude numeric,
    partner_longitude numeric,
    user_marketing_id integer,
    product_category_id integer,
    insight_purchasing_frequency_id integer,
    insight_time_to_take_effect_id integer,
    customer_type character varying NOT NULL,
    facebook_url character varying,
    sub_facebook_url character varying,
    tiktok_url character varying,
    decision_factor_note text,
    time_to_take_effect_note text,
    flavor_and_product_color_rating text,
    customer_support_rating text,
    customer_feedback text,
    marketing_team_id integer,
    old_sale_user_id integer,
    old_sale_team_id integer,
    origin_sale_opportunity_id integer,
    crm_lead_for_resale_id integer,
    readonly_old_sale_info boolean,
    is_resale_lead_created_from_sale_lead boolean,
    sales_commission_period date,
    fb_page_id integer,
    old_id integer,
    old_partner_id integer,
    CONSTRAINT crm_lead_check_probability CHECK (((probability >= (0)::double precision) AND (probability <= (100)::double precision)))
);


ALTER TABLE public.crm_lead OWNER TO ductin;

--
-- Name: TABLE crm_lead; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.crm_lead IS 'Lead/Opportunity';


--
-- Name: COLUMN crm_lead.campaign_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.campaign_id IS 'Campaign';


--
-- Name: COLUMN crm_lead.source_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.source_id IS 'Source';


--
-- Name: COLUMN crm_lead.medium_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.medium_id IS 'Medium';


--
-- Name: COLUMN crm_lead.message_bounce; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.message_bounce IS 'Bounce';


--
-- Name: COLUMN crm_lead.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead.team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.company_id IS 'Company';


--
-- Name: COLUMN crm_lead.stage_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.stage_id IS 'Stage';


--
-- Name: COLUMN crm_lead.color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.color IS 'Color Index';


--
-- Name: COLUMN crm_lead.recurring_plan; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.recurring_plan IS 'Recurring Plan';


--
-- Name: COLUMN crm_lead.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead.title; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.title IS 'Title';


--
-- Name: COLUMN crm_lead.lang_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.lang_id IS 'Language';


--
-- Name: COLUMN crm_lead.state_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.state_id IS 'State';


--
-- Name: COLUMN crm_lead.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.country_id IS 'Country';


--
-- Name: COLUMN crm_lead.lost_reason_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead.phone_sanitized; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN crm_lead.email_normalized; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN crm_lead.email_cc; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.email_cc IS 'Email cc';


--
-- Name: COLUMN crm_lead.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.name IS 'Opportunity';


--
-- Name: COLUMN crm_lead.referred; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.referred IS 'Referred By';


--
-- Name: COLUMN crm_lead.type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.type IS 'Type';


--
-- Name: COLUMN crm_lead.priority; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.priority IS 'Priority';


--
-- Name: COLUMN crm_lead.contact_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.contact_name IS 'Contact Name';


--
-- Name: COLUMN crm_lead.partner_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.partner_name IS 'Company Name';


--
-- Name: COLUMN crm_lead.function; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.function IS 'Job Position';


--
-- Name: COLUMN crm_lead.email_from; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.email_from IS 'Email';


--
-- Name: COLUMN crm_lead.email_domain_criterion; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.email_domain_criterion IS 'Email Domain Criterion';


--
-- Name: COLUMN crm_lead.phone; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.phone IS 'Phone';


--
-- Name: COLUMN crm_lead.mobile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.mobile IS 'Mobile';


--
-- Name: COLUMN crm_lead.phone_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.phone_state IS 'Phone Quality';


--
-- Name: COLUMN crm_lead.email_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.email_state IS 'Email Quality';


--
-- Name: COLUMN crm_lead.website; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.website IS 'Website';


--
-- Name: COLUMN crm_lead.street; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.street IS 'Street';


--
-- Name: COLUMN crm_lead.street2; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.street2 IS 'Street2';


--
-- Name: COLUMN crm_lead.zip; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.zip IS 'Zip';


--
-- Name: COLUMN crm_lead.city; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.city IS 'City';


--
-- Name: COLUMN crm_lead.date_deadline; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.date_deadline IS 'Expected Closing';


--
-- Name: COLUMN crm_lead.lead_properties; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.lead_properties IS 'Properties';


--
-- Name: COLUMN crm_lead.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.description IS 'Notes';


--
-- Name: COLUMN crm_lead.expected_revenue; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.expected_revenue IS 'Expected Revenue';


--
-- Name: COLUMN crm_lead.prorated_revenue; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.prorated_revenue IS 'Prorated Revenue';


--
-- Name: COLUMN crm_lead.recurring_revenue; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue IS 'Recurring Revenues';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly IS 'Expected MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly_prorated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly_prorated IS 'Prorated MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_prorated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_prorated IS 'Prorated Recurring Revenues';


--
-- Name: COLUMN crm_lead.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.active IS 'Active';


--
-- Name: COLUMN crm_lead.date_closed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.date_closed IS 'Closed Date';


--
-- Name: COLUMN crm_lead.date_automation_last; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.date_automation_last IS 'Last Action';


--
-- Name: COLUMN crm_lead.date_open; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.date_open IS 'Assignment Date';


--
-- Name: COLUMN crm_lead.date_last_stage_update; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN crm_lead.date_conversion; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.date_conversion IS 'Conversion Date';


--
-- Name: COLUMN crm_lead.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_lead.day_open; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.day_open IS 'Days to Assign';


--
-- Name: COLUMN crm_lead.day_close; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.day_close IS 'Days to Close';


--
-- Name: COLUMN crm_lead.probability; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.probability IS 'Probability';


--
-- Name: COLUMN crm_lead.automated_probability; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.automated_probability IS 'Automated Probability';


--
-- Name: COLUMN crm_lead.won_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.won_status IS 'Is Won';


--
-- Name: COLUMN crm_lead.days_to_convert; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.days_to_convert IS 'Days To Convert';


--
-- Name: COLUMN crm_lead.days_exceeding_closing; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.days_exceeding_closing IS 'Exceeded Closing Days';


--
-- Name: COLUMN crm_lead.crm_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.crm_group_id IS 'CRM Group';


--
-- Name: COLUMN crm_lead.crm_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.crm_type IS 'CRM Type';


--
-- Name: COLUMN crm_lead.event_lead_rule_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.event_lead_rule_id IS 'Registration Rule';


--
-- Name: COLUMN crm_lead.event_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.event_id IS 'Source Event';


--
-- Name: COLUMN crm_lead.reveal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.reveal_id IS 'Reveal ID';


--
-- Name: COLUMN crm_lead.iap_enrich_done; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.iap_enrich_done IS 'Enrichment done';


--
-- Name: COLUMN crm_lead.lead_mining_request_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.lead_mining_request_id IS 'Lead Mining Request';


--
-- Name: COLUMN crm_lead.reveal_iap_credits; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.reveal_iap_credits IS 'IAP Credits';


--
-- Name: COLUMN crm_lead.reveal_rule_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.reveal_rule_id IS 'Lead Generation Rule';


--
-- Name: COLUMN crm_lead.reveal_ip; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.reveal_ip IS 'IP Address';


--
-- Name: COLUMN crm_lead.partner_assigned_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.partner_assigned_id IS 'Assigned Partner';


--
-- Name: COLUMN crm_lead.date_partner_assign; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.date_partner_assign IS 'Partner Assignment Date';


--
-- Name: COLUMN crm_lead.partner_latitude; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN crm_lead.partner_longitude; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN crm_lead.user_marketing_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.user_marketing_id IS 'Marketing User';


--
-- Name: COLUMN crm_lead.product_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.product_category_id IS 'Product Category';


--
-- Name: COLUMN crm_lead.insight_purchasing_frequency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.insight_purchasing_frequency_id IS 'Purchasing Frequency';


--
-- Name: COLUMN crm_lead.insight_time_to_take_effect_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.insight_time_to_take_effect_id IS 'Time To Take Effect';


--
-- Name: COLUMN crm_lead.customer_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.customer_type IS 'Customer Type';


--
-- Name: COLUMN crm_lead.facebook_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.facebook_url IS 'Facebook URL';


--
-- Name: COLUMN crm_lead.sub_facebook_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.sub_facebook_url IS 'Sub Facebook URL';


--
-- Name: COLUMN crm_lead.tiktok_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.tiktok_url IS 'Tiktok URL';


--
-- Name: COLUMN crm_lead.decision_factor_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.decision_factor_note IS 'Decision Factor Note';


--
-- Name: COLUMN crm_lead.time_to_take_effect_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.time_to_take_effect_note IS 'Time To Take Effect Note';


--
-- Name: COLUMN crm_lead.flavor_and_product_color_rating; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.flavor_and_product_color_rating IS 'Flavor and Product Color Rating';


--
-- Name: COLUMN crm_lead.customer_support_rating; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.customer_support_rating IS 'Customer Support Rating';


--
-- Name: COLUMN crm_lead.customer_feedback; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.customer_feedback IS 'Customer Feedback';


--
-- Name: COLUMN crm_lead.marketing_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.marketing_team_id IS 'Marketing Team';


--
-- Name: COLUMN crm_lead.old_sale_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.old_sale_user_id IS 'Old Sale User';


--
-- Name: COLUMN crm_lead.old_sale_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.old_sale_team_id IS 'Old Sale Team';


--
-- Name: COLUMN crm_lead.origin_sale_opportunity_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.origin_sale_opportunity_id IS 'Origin Sale Opportunity';


--
-- Name: COLUMN crm_lead.crm_lead_for_resale_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.crm_lead_for_resale_id IS 'Crm Lead For Resale';


--
-- Name: COLUMN crm_lead.readonly_old_sale_info; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.readonly_old_sale_info IS 'Readonly Old Sale Info';


--
-- Name: COLUMN crm_lead.is_resale_lead_created_from_sale_lead; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.is_resale_lead_created_from_sale_lead IS 'Is Resale Lead Created From Sale Lead';


--
-- Name: COLUMN crm_lead.sales_commission_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.sales_commission_period IS 'Sales Commission Period';


--
-- Name: COLUMN crm_lead.fb_page_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.fb_page_id IS 'Fb Page';


--
-- Name: COLUMN crm_lead.old_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.old_id IS 'Old ID';


--
-- Name: COLUMN crm_lead.old_partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.crm_lead.old_partner_id IS 'Old Partner ID';


--
-- Name: CONSTRAINT crm_lead_check_probability ON crm_lead; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT crm_lead_check_probability ON public.crm_lead IS 'check(probability >= 0 and probability <= 100)';


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    user_tech_id integer,
    social_twitter character varying,
    social_facebook character varying,
    social_github character varying,
    social_linkedin character varying,
    social_youtube character varying,
    social_instagram character varying,
    social_tiktok character varying,
    nomenclature_id integer,
    resource_calendar_id integer,
    archived_user_disable_auth_api_key boolean,
    alias_domain_id integer,
    alias_domain_name character varying,
    email_primary_color character varying,
    email_secondary_color character varying,
    disable_send_message boolean,
    lunch_notify_message jsonb,
    lunch_minimum_threshold double precision,
    partner_gid integer,
    iap_enrich_auto_done boolean,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean,
    payment_onboarding_payment_method character varying,
    sign_terms_type character varying,
    sign_terms jsonb,
    sign_terms_html jsonb,
    sms_provider character varying,
    sms_twilio_account_sid character varying,
    sms_twilio_auth_token character varying,
    fiscalyear_last_day integer NOT NULL,
    transfer_account_id integer,
    default_cash_difference_income_account_id integer,
    default_cash_difference_expense_account_id integer,
    account_journal_suspense_account_id integer,
    account_journal_early_pay_discount_gain_account_id integer,
    account_journal_early_pay_discount_loss_account_id integer,
    account_sale_tax_id integer,
    account_purchase_tax_id integer,
    currency_exchange_journal_id integer,
    income_currency_exchange_account_id integer,
    expense_currency_exchange_account_id integer,
    incoterm_id integer,
    batch_payment_sequence_id integer,
    account_opening_move_id integer,
    account_default_pos_receivable_account_id integer,
    expense_accrual_account_id integer,
    revenue_accrual_account_id integer,
    automatic_entry_default_journal_id integer,
    account_fiscal_country_id integer,
    tax_cash_basis_journal_id integer,
    account_cash_basis_base_account_id integer,
    account_discount_income_allocation_id integer,
    account_discount_expense_allocation_id integer,
    fiscalyear_last_month character varying NOT NULL,
    chart_template character varying,
    bank_account_code_prefix character varying,
    cash_account_code_prefix character varying,
    transfer_account_code_prefix character varying,
    tax_calculation_rounding_method character varying,
    terms_type character varying,
    quick_edit_mode character varying,
    account_price_include character varying NOT NULL,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    account_opening_date date NOT NULL,
    invoice_terms jsonb,
    invoice_terms_html jsonb,
    expects_chart_of_accounts boolean,
    anglo_saxon_accounting boolean,
    qr_code boolean,
    display_invoice_amount_total_words boolean,
    display_invoice_tax_company_currency boolean,
    account_use_credit_limit boolean,
    tax_exigibility boolean,
    account_storno boolean,
    check_account_audit_trail boolean,
    autopost_bills boolean,
    hr_presence_control_email_amount integer,
    hr_presence_control_ip_list character varying,
    employee_properties_definition jsonb,
    hr_presence_control_login boolean,
    hr_presence_control_email boolean,
    hr_presence_control_ip boolean,
    hr_presence_control_attendance boolean,
    internal_transit_location_id integer,
    stock_mail_confirmation_template_id integer,
    annual_inventory_day integer,
    annual_inventory_month character varying,
    stock_move_email_validation boolean,
    website_id integer,
    signing_user integer,
    deferred_expense_journal_id integer,
    deferred_expense_account_id integer,
    deferred_revenue_journal_id integer,
    deferred_revenue_account_id integer,
    generate_deferred_expense_entries_method character varying NOT NULL,
    deferred_expense_amount_computation_method character varying NOT NULL,
    generate_deferred_revenue_entries_method character varying NOT NULL,
    deferred_revenue_amount_computation_method character varying NOT NULL,
    invoicing_switch_threshold date,
    predict_bill_product boolean,
    sign_invoice boolean,
    account_check_printing_layout character varying,
    account_check_printing_date_label boolean,
    account_check_printing_multi_stub boolean,
    account_check_printing_margin_top double precision,
    account_check_printing_margin_left double precision,
    account_check_printing_margin_right double precision,
    intercompany_purchase_journal_id integer,
    intercompany_user_id integer,
    intercompany_document_state character varying,
    intercompany_generate_bills_refund boolean,
    vat_check_vies boolean,
    currency_interval_unit character varying NOT NULL,
    currency_provider character varying,
    currency_next_execution_date date,
    documents_fleet_folder integer,
    documents_fleet_settings boolean,
    documents_hr_folder integer,
    documents_hr_settings boolean,
    product_folder_id integer,
    documents_product_settings boolean,
    documents_sign_folder_id integer,
    document_spreadsheet_folder_id integer,
    appraisal_template_id integer,
    appraisal_confirm_mail_template integer,
    duration_after_recruitment integer,
    duration_first_appraisal integer,
    duration_next_appraisal integer,
    appraisal_plan boolean,
    overtime_company_threshold integer,
    overtime_employee_threshold integer,
    attendance_kiosk_delay integer,
    attendance_kiosk_mode character varying,
    attendance_barcode_source character varying,
    attendance_kiosk_key character varying,
    attendance_overtime_validation character varying,
    hr_attendance_display_overtime boolean,
    attendance_kiosk_use_pin boolean,
    attendance_from_systray boolean,
    auto_check_out boolean,
    absence_management boolean,
    auto_check_out_tolerance double precision,
    contract_expiration_notice_period integer,
    work_permit_expiration_notice_period integer,
    expense_journal_id integer,
    expense_outstanding_account_id integer,
    candidate_properties_definition jsonb,
    job_properties_definition jsonb,
    manufacturing_lead double precision NOT NULL,
    po_lock character varying,
    po_double_validation character varying,
    po_double_validation_amount numeric,
    po_lead double precision NOT NULL,
    account_production_wip_account_id integer,
    account_production_wip_overhead_account_id integer,
    allow_interwarehouse_sudo boolean,
    stock_sms_confirmation_template_id integer,
    stock_move_sms_validation boolean,
    has_received_warning_stock_sms boolean,
    avalara_api_id character varying,
    avalara_api_key character varying,
    avalara_environment character varying NOT NULL,
    avalara_commit boolean,
    avalara_address_validation boolean,
    avalara_use_upc boolean,
    setting_account_avatax boolean,
    iso20022_orgid_id character varying(35),
    iso20022_orgid_issr character varying(35),
    iso20022_initiating_party_name character varying(70),
    peppol_purchase_journal_id integer,
    account_peppol_contact_email character varying,
    account_peppol_migration_key character varying,
    account_peppol_phone_number character varying,
    account_peppol_proxy_state character varying NOT NULL,
    sdd_creditor_identifier character varying,
    approvals_folder_id integer,
    documents_approvals_settings boolean,
    recruitment_folder_id integer,
    documents_recruitment_settings boolean,
    appraisal_survey_template_id integer,
    hr_presence_last_compute_date timestamp without time zone,
    recruitment_extract_show_ocr_option_selection character varying,
    project_time_mode_id integer,
    timesheet_encode_uom_id integer,
    internal_project_id integer,
    subcontracting_location_id integer,
    planning_generation_interval integer NOT NULL,
    planning_self_unassign_days_before integer,
    planning_employee_unavailabilities character varying NOT NULL,
    point_of_sale_update_stock_quantities character varying,
    point_of_sale_ticket_portal_url_display_mode character varying NOT NULL,
    point_of_sale_use_ticket_qr_code boolean,
    point_of_sale_ticket_unique_code boolean,
    days_to_purchase double precision,
    quotation_validity_days integer,
    sale_discount_product_id integer,
    sale_onboarding_payment_method character varying,
    portal_confirmation_sign boolean,
    portal_confirmation_pay boolean,
    prepayment_percent double precision,
    account_tax_periodicity_reminder_day integer NOT NULL,
    account_tax_periodicity_journal_id integer,
    account_revaluation_journal_id integer,
    account_revaluation_expense_provision_account_id integer,
    account_revaluation_income_provision_account_id integer,
    account_representative_id integer,
    account_tax_periodicity character varying NOT NULL,
    totals_below_sections boolean,
    documents_account_peppol_folder_id integer,
    expense_extract_show_ocr_option_selection character varying,
    hr_recruitment_monster_username character varying,
    hr_recruitment_monster_password character varying,
    manufacturing_period_to_display_year integer,
    manufacturing_period_to_display_month integer,
    manufacturing_period_to_display_week integer,
    manufacturing_period_to_display_day integer,
    manufacturing_period character varying NOT NULL,
    mrp_mps_show_starting_inventory boolean,
    mrp_mps_show_demand_forecast boolean,
    mrp_mps_show_actual_demand boolean,
    mrp_mps_show_indirect_demand boolean,
    mrp_mps_show_to_replenish boolean,
    mrp_mps_show_actual_replenishment boolean,
    mrp_mps_show_safety_stock boolean,
    mrp_mps_show_available_to_promise boolean,
    mrp_mps_show_actual_demand_year_minus_1 boolean,
    mrp_mps_show_actual_demand_year_minus_2 boolean,
    leave_timesheet_task_id integer,
    sale_order_template_id integer,
    min_extra_hour integer,
    extra_product integer,
    extra_hour double precision,
    extra_day double precision,
    security_lead double precision NOT NULL,
    lc_journal_id integer,
    timesheet_mail_employee_delay integer,
    timesheet_mail_delay integer,
    timesheet_mail_employee_interval character varying NOT NULL,
    timesheet_mail_interval character varying NOT NULL,
    timesheet_mail_employee_allow boolean,
    timesheet_mail_allow boolean,
    timesheet_mail_employee_nextdate timestamp without time zone,
    timesheet_mail_nextdate timestamp without time zone,
    gain_account_id integer,
    loss_account_id integer,
    extract_bank_statement_digitalization_mode character varying,
    intrastat_region_id integer,
    intrastat_transport_mode_id integer,
    intrastat_default_invoice_transaction_code_id integer,
    intrastat_default_refund_transaction_code_id integer,
    extract_in_invoice_digitalization_mode character varying,
    extract_out_invoice_digitalization_mode character varying,
    extract_single_line_per_tax boolean,
    account_folder_id integer,
    documents_account_settings boolean,
    hr_contract_timeoff_auto_allocation_type_id integer,
    hr_contract_timeoff_auto_allocation boolean,
    ytd_reset_day integer,
    ytd_reset_month character varying,
    gelato_api_key character varying,
    gelato_webhook_secret character varying,
    intercompany_generate_sales_orders boolean,
    intercompany_generate_purchase_orders boolean,
    rental_sign_tmpl_id integer,
    rental_loc_id integer,
    padding_time double precision,
    documents_payroll_folder_id integer,
    batch_payroll_move_lines boolean,
    deferred_time_off_manager integer,
    commission_automatic_po_frequency character varying NOT NULL,
    commission_po_minimum numeric,
    intercompany_warehouse_id integer,
    intercompany_receipt_type_id integer,
    intercompany_sync_delivery_receipt boolean,
    renting_minimal_time_duration integer,
    renting_minimal_time_unit character varying NOT NULL,
    renting_forbidden_mon boolean,
    renting_forbidden_tue boolean,
    renting_forbidden_wed boolean,
    renting_forbidden_thu boolean,
    renting_forbidden_fri boolean,
    renting_forbidden_sat boolean,
    renting_forbidden_sun boolean,
    can_edit_so_line_price boolean,
    onss_certificate_id integer,
    onss_company_id character varying,
    onss_registration_number character varying,
    dmfa_employer_class character varying,
    l10n_be_company_number character varying,
    l10n_be_revenue_code character varying,
    l10n_be_ffe_employer_type character varying,
    onss_expeditor_number character varying,
    accident_insurance_name character varying,
    accident_insurance_number character varying,
    l10n_us_ca_ett_tax boolean,
    dropship_subcontractor_pick_type_id integer,
    hr_employee_not_attendance_alert_days character varying,
    hr_probationary_assessment_remind_days character varying,
    hr_probationary_assessment_link character varying,
    exemption_doctor_master_account_id integer,
    exemption_bachelor_account_id integer,
    exemption_bachelor_capping_account_id integer,
    exemption_journal_id integer,
    onss_sftp_private_key integer,
    onss_technical_user_name character varying,
    group_s_sequence_number integer,
    group_s_code character varying,
    partena_sequence_number integer,
    partena_code character varying,
    sdworx_code character varying,
    ucm_code character varying,
    ucm_company_code character varying,
    cash_rounding_by_sale_order_id integer,
    is_round_price boolean,
    timesheet_show_rates boolean,
    timesheet_show_leaderboard boolean,
    hr_employee_end_of_leave_remind_days character varying,
    monthly_scan_day_overdue integer,
    monthly_scan_day_bde integer,
    is_apply_bad_debt_order boolean,
    block_auto_reassign_manual_unreserve boolean,
    returned_approval_category_id integer,
    wholesale_threshold double precision,
    CONSTRAINT res_company_auto_allocation CHECK (((hr_contract_timeoff_auto_allocation = false) OR (hr_contract_timeoff_auto_allocation_type_id IS NOT NULL))),
    CONSTRAINT res_company_check_quotation_validity_days CHECK ((quotation_validity_days >= 0)),
    CONSTRAINT res_company_min_extra_hour CHECK ((min_extra_hour >= 1)),
    CONSTRAINT res_company_planning_self_unassign_days_before_positive CHECK ((planning_self_unassign_days_before >= 0)),
    CONSTRAINT res_company_positif_number_months CHECK (((duration_after_recruitment > 0) AND (duration_first_appraisal > 0) AND (duration_next_appraisal > 0)))
);


ALTER TABLE public.res_company OWNER TO ductin;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.user_tech_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.user_tech_id IS 'Technical User';


--
-- Name: COLUMN res_company.social_twitter; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.social_twitter IS 'X Account';


--
-- Name: COLUMN res_company.social_facebook; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.social_facebook IS 'Facebook Account';


--
-- Name: COLUMN res_company.social_github; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.social_github IS 'GitHub Account';


--
-- Name: COLUMN res_company.social_linkedin; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.social_linkedin IS 'LinkedIn Account';


--
-- Name: COLUMN res_company.social_youtube; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.social_youtube IS 'Youtube Account';


--
-- Name: COLUMN res_company.social_instagram; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.social_instagram IS 'Instagram Account';


--
-- Name: COLUMN res_company.social_tiktok; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.social_tiktok IS 'TikTok Account';


--
-- Name: COLUMN res_company.nomenclature_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.nomenclature_id IS 'Nomenclature';


--
-- Name: COLUMN res_company.resource_calendar_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.resource_calendar_id IS 'Default Working Hours';


--
-- Name: COLUMN res_company.archived_user_disable_auth_api_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.archived_user_disable_auth_api_key IS 'Disable API key for archived user';


--
-- Name: COLUMN res_company.alias_domain_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.alias_domain_id IS 'Email Domain';


--
-- Name: COLUMN res_company.alias_domain_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.alias_domain_name IS 'Alias Domain Name';


--
-- Name: COLUMN res_company.email_primary_color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.email_primary_color IS 'Email Header Color';


--
-- Name: COLUMN res_company.email_secondary_color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.email_secondary_color IS 'Email Button Color';


--
-- Name: COLUMN res_company.disable_send_message; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.disable_send_message IS 'Disable Send Message';


--
-- Name: COLUMN res_company.lunch_notify_message; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.lunch_notify_message IS 'Lunch Notify Message';


--
-- Name: COLUMN res_company.lunch_minimum_threshold; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.lunch_minimum_threshold IS 'Lunch Minimum Threshold';


--
-- Name: COLUMN res_company.partner_gid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.partner_gid IS 'Company database ID';


--
-- Name: COLUMN res_company.iap_enrich_auto_done; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.iap_enrich_auto_done IS 'Enrich Done';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Snailmail Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: COLUMN res_company.payment_onboarding_payment_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.payment_onboarding_payment_method IS 'Selected onboarding payment method';


--
-- Name: COLUMN res_company.sign_terms_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sign_terms_type IS 'Sign Terms & Conditions format';


--
-- Name: COLUMN res_company.sign_terms; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sign_terms IS 'Sign Default Terms and Conditions';


--
-- Name: COLUMN res_company.sign_terms_html; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sign_terms_html IS 'Sign Default Terms and Conditions as a Web page';


--
-- Name: COLUMN res_company.sms_provider; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sms_provider IS 'SMS Provider';


--
-- Name: COLUMN res_company.sms_twilio_account_sid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sms_twilio_account_sid IS 'Account SID';


--
-- Name: COLUMN res_company.sms_twilio_auth_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sms_twilio_auth_token IS 'Auth Token';


--
-- Name: COLUMN res_company.fiscalyear_last_day; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.fiscalyear_last_day IS 'Fiscalyear Last Day';


--
-- Name: COLUMN res_company.transfer_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.transfer_account_id IS 'Inter-Banks Transfer Account';


--
-- Name: COLUMN res_company.default_cash_difference_income_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.default_cash_difference_income_account_id IS 'Cash Difference Income';


--
-- Name: COLUMN res_company.default_cash_difference_expense_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.default_cash_difference_expense_account_id IS 'Cash Difference Expense';


--
-- Name: COLUMN res_company.account_journal_suspense_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_journal_suspense_account_id IS 'Journal Suspense Account';


--
-- Name: COLUMN res_company.account_journal_early_pay_discount_gain_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_journal_early_pay_discount_gain_account_id IS 'Cash Discount Write-Off Gain Account';


--
-- Name: COLUMN res_company.account_journal_early_pay_discount_loss_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_journal_early_pay_discount_loss_account_id IS 'Cash Discount Write-Off Loss Account';


--
-- Name: COLUMN res_company.account_sale_tax_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_sale_tax_id IS 'Default Sale Tax';


--
-- Name: COLUMN res_company.account_purchase_tax_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_purchase_tax_id IS 'Default Purchase Tax';


--
-- Name: COLUMN res_company.currency_exchange_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.currency_exchange_journal_id IS 'Exchange Gain or Loss Journal';


--
-- Name: COLUMN res_company.income_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.income_currency_exchange_account_id IS 'Gain Exchange Rate Account';


--
-- Name: COLUMN res_company.expense_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.expense_currency_exchange_account_id IS 'Loss Exchange Rate Account';


--
-- Name: COLUMN res_company.incoterm_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.incoterm_id IS 'Default incoterm';


--
-- Name: COLUMN res_company.batch_payment_sequence_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.batch_payment_sequence_id IS 'Batch Payment Sequence';


--
-- Name: COLUMN res_company.account_opening_move_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_opening_move_id IS 'Opening Journal Entry';


--
-- Name: COLUMN res_company.account_default_pos_receivable_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_default_pos_receivable_account_id IS 'Default PoS Receivable Account';


--
-- Name: COLUMN res_company.expense_accrual_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.expense_accrual_account_id IS 'Expense Accrual Account';


--
-- Name: COLUMN res_company.revenue_accrual_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.revenue_accrual_account_id IS 'Revenue Accrual Account';


--
-- Name: COLUMN res_company.automatic_entry_default_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.automatic_entry_default_journal_id IS 'Automatic Entry Default Journal';


--
-- Name: COLUMN res_company.account_fiscal_country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_fiscal_country_id IS 'Fiscal Country';


--
-- Name: COLUMN res_company.tax_cash_basis_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.tax_cash_basis_journal_id IS 'Cash Basis Journal';


--
-- Name: COLUMN res_company.account_cash_basis_base_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_cash_basis_base_account_id IS 'Base Tax Received Account';


--
-- Name: COLUMN res_company.account_discount_income_allocation_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_discount_income_allocation_id IS 'Separate account for income discount';


--
-- Name: COLUMN res_company.account_discount_expense_allocation_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_discount_expense_allocation_id IS 'Separate account for expense discount';


--
-- Name: COLUMN res_company.fiscalyear_last_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.fiscalyear_last_month IS 'Fiscalyear Last Month';


--
-- Name: COLUMN res_company.chart_template; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.chart_template IS 'Chart Template';


--
-- Name: COLUMN res_company.bank_account_code_prefix; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.bank_account_code_prefix IS 'Prefix of the bank accounts';


--
-- Name: COLUMN res_company.cash_account_code_prefix; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.cash_account_code_prefix IS 'Prefix of the cash accounts';


--
-- Name: COLUMN res_company.transfer_account_code_prefix; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.transfer_account_code_prefix IS 'Prefix of the transfer accounts';


--
-- Name: COLUMN res_company.tax_calculation_rounding_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.tax_calculation_rounding_method IS 'Tax Calculation Rounding Method';


--
-- Name: COLUMN res_company.terms_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.terms_type IS 'Terms & Conditions format';


--
-- Name: COLUMN res_company.quick_edit_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.quick_edit_mode IS 'Quick encoding';


--
-- Name: COLUMN res_company.account_price_include; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_price_include IS 'Default Sales Price Include';


--
-- Name: COLUMN res_company.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.fiscalyear_lock_date IS 'Global Lock Date';


--
-- Name: COLUMN res_company.tax_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.tax_lock_date IS 'Tax Return Lock Date';


--
-- Name: COLUMN res_company.sale_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sale_lock_date IS 'Sales Lock Date';


--
-- Name: COLUMN res_company.purchase_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.purchase_lock_date IS 'Purchase Lock date';


--
-- Name: COLUMN res_company.hard_lock_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hard_lock_date IS 'Hard Lock Date';


--
-- Name: COLUMN res_company.account_opening_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_opening_date IS 'Opening Entry';


--
-- Name: COLUMN res_company.invoice_terms; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.invoice_terms IS 'Default Terms and Conditions';


--
-- Name: COLUMN res_company.invoice_terms_html; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.invoice_terms_html IS 'Default Terms and Conditions as a Web page';


--
-- Name: COLUMN res_company.expects_chart_of_accounts; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.expects_chart_of_accounts IS 'Expects a Chart of Accounts';


--
-- Name: COLUMN res_company.anglo_saxon_accounting; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.anglo_saxon_accounting IS 'Use anglo-saxon accounting';


--
-- Name: COLUMN res_company.qr_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.qr_code IS 'Display QR-code on invoices';


--
-- Name: COLUMN res_company.display_invoice_amount_total_words; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.display_invoice_amount_total_words IS 'Total amount of invoice in letters';


--
-- Name: COLUMN res_company.display_invoice_tax_company_currency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.display_invoice_tax_company_currency IS 'Taxes in company currency';


--
-- Name: COLUMN res_company.account_use_credit_limit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_use_credit_limit IS 'Sales Credit Limit';


--
-- Name: COLUMN res_company.tax_exigibility; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.tax_exigibility IS 'Use Cash Basis';


--
-- Name: COLUMN res_company.account_storno; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_storno IS 'Storno accounting';


--
-- Name: COLUMN res_company.check_account_audit_trail; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.check_account_audit_trail IS 'Audit Trail';


--
-- Name: COLUMN res_company.autopost_bills; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.autopost_bills IS 'Auto-validate bills';


--
-- Name: COLUMN res_company.hr_presence_control_email_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email_amount IS '# emails to send';


--
-- Name: COLUMN res_company.hr_presence_control_ip_list; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip_list IS 'Valid IP addresses';


--
-- Name: COLUMN res_company.employee_properties_definition; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.employee_properties_definition IS 'Employee Properties';


--
-- Name: COLUMN res_company.hr_presence_control_login; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_presence_control_login IS 'Based on user status in system';


--
-- Name: COLUMN res_company.hr_presence_control_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email IS 'Based on number of emails sent';


--
-- Name: COLUMN res_company.hr_presence_control_ip; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip IS 'Based on IP Address';


--
-- Name: COLUMN res_company.hr_presence_control_attendance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_presence_control_attendance IS 'Based on attendances';


--
-- Name: COLUMN res_company.internal_transit_location_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.internal_transit_location_id IS 'Internal Transit Location';


--
-- Name: COLUMN res_company.stock_mail_confirmation_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.stock_mail_confirmation_template_id IS 'Email Template confirmation picking';


--
-- Name: COLUMN res_company.annual_inventory_day; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.annual_inventory_day IS 'Day of the month';


--
-- Name: COLUMN res_company.annual_inventory_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.annual_inventory_month IS 'Annual Inventory Month';


--
-- Name: COLUMN res_company.stock_move_email_validation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.stock_move_email_validation IS 'Email Confirmation picking';


--
-- Name: COLUMN res_company.website_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.website_id IS 'Website';


--
-- Name: COLUMN res_company.signing_user; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.signing_user IS 'Signing User';


--
-- Name: COLUMN res_company.deferred_expense_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.deferred_expense_journal_id IS 'Deferred Expense Journal';


--
-- Name: COLUMN res_company.deferred_expense_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.deferred_expense_account_id IS 'Deferred Expense Account';


--
-- Name: COLUMN res_company.deferred_revenue_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.deferred_revenue_journal_id IS 'Deferred Revenue Journal';


--
-- Name: COLUMN res_company.deferred_revenue_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.deferred_revenue_account_id IS 'Deferred Revenue Account';


--
-- Name: COLUMN res_company.generate_deferred_expense_entries_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.generate_deferred_expense_entries_method IS 'Generate Deferred Expense Entries';


--
-- Name: COLUMN res_company.deferred_expense_amount_computation_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.deferred_expense_amount_computation_method IS 'Deferred Expense Based on';


--
-- Name: COLUMN res_company.generate_deferred_revenue_entries_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.generate_deferred_revenue_entries_method IS 'Generate Deferred Revenue Entries';


--
-- Name: COLUMN res_company.deferred_revenue_amount_computation_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.deferred_revenue_amount_computation_method IS 'Deferred Revenue Based on';


--
-- Name: COLUMN res_company.invoicing_switch_threshold; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.invoicing_switch_threshold IS 'Invoicing Switch Threshold';


--
-- Name: COLUMN res_company.predict_bill_product; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.predict_bill_product IS 'Predict Bill Product';


--
-- Name: COLUMN res_company.sign_invoice; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sign_invoice IS 'Display signing field on invoices';


--
-- Name: COLUMN res_company.account_check_printing_layout; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_check_printing_layout IS 'Check Layout';


--
-- Name: COLUMN res_company.account_check_printing_date_label; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_check_printing_date_label IS 'Print Date Label';


--
-- Name: COLUMN res_company.account_check_printing_multi_stub; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_check_printing_multi_stub IS 'Multi-Pages Check Stub';


--
-- Name: COLUMN res_company.account_check_printing_margin_top; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_check_printing_margin_top IS 'Check Top Margin';


--
-- Name: COLUMN res_company.account_check_printing_margin_left; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_check_printing_margin_left IS 'Check Left Margin';


--
-- Name: COLUMN res_company.account_check_printing_margin_right; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_check_printing_margin_right IS 'Right Margin';


--
-- Name: COLUMN res_company.intercompany_purchase_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_purchase_journal_id IS 'Purchase Journal';


--
-- Name: COLUMN res_company.intercompany_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_user_id IS 'Create as';


--
-- Name: COLUMN res_company.intercompany_document_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_document_state IS 'Automation';


--
-- Name: COLUMN res_company.intercompany_generate_bills_refund; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_generate_bills_refund IS 'Generate Bills and Refunds';


--
-- Name: COLUMN res_company.vat_check_vies; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.vat_check_vies IS 'Verify VAT Numbers';


--
-- Name: COLUMN res_company.currency_interval_unit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.currency_interval_unit IS 'Interval Unit';


--
-- Name: COLUMN res_company.currency_provider; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.currency_provider IS 'Service Provider';


--
-- Name: COLUMN res_company.currency_next_execution_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.currency_next_execution_date IS 'Next Execution Date';


--
-- Name: COLUMN res_company.documents_fleet_folder; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_fleet_folder IS 'Fleet Workspace';


--
-- Name: COLUMN res_company.documents_fleet_settings; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_fleet_settings IS 'Documents Fleet Settings';


--
-- Name: COLUMN res_company.documents_hr_folder; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_hr_folder IS 'hr Workspace';


--
-- Name: COLUMN res_company.documents_hr_settings; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_hr_settings IS 'Documents Hr Settings';


--
-- Name: COLUMN res_company.product_folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.product_folder_id IS 'Product Workspace';


--
-- Name: COLUMN res_company.documents_product_settings; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_product_settings IS 'Documents Product Settings';


--
-- Name: COLUMN res_company.documents_sign_folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_sign_folder_id IS 'Sign Folder';


--
-- Name: COLUMN res_company.document_spreadsheet_folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.document_spreadsheet_folder_id IS 'Document Spreadsheet Folder';


--
-- Name: COLUMN res_company.appraisal_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.appraisal_template_id IS 'Appraisal Template';


--
-- Name: COLUMN res_company.appraisal_confirm_mail_template; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.appraisal_confirm_mail_template IS 'Appraisal Confirm Mail Template';


--
-- Name: COLUMN res_company.duration_after_recruitment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.duration_after_recruitment IS 'Create an Appraisal after recruitment';


--
-- Name: COLUMN res_company.duration_first_appraisal; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.duration_first_appraisal IS 'Create a first Appraisal after';


--
-- Name: COLUMN res_company.duration_next_appraisal; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.duration_next_appraisal IS 'Create a second Appraisal after';


--
-- Name: COLUMN res_company.appraisal_plan; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.appraisal_plan IS 'Automatically Generate Appraisals';


--
-- Name: COLUMN res_company.overtime_company_threshold; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.overtime_company_threshold IS 'Tolerance Time In Favor Of Company';


--
-- Name: COLUMN res_company.overtime_employee_threshold; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.overtime_employee_threshold IS 'Tolerance Time In Favor Of Employee';


--
-- Name: COLUMN res_company.attendance_kiosk_delay; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.attendance_kiosk_delay IS 'Attendance Kiosk Delay';


--
-- Name: COLUMN res_company.attendance_kiosk_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.attendance_kiosk_mode IS 'Attendance Mode';


--
-- Name: COLUMN res_company.attendance_barcode_source; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.attendance_barcode_source IS 'Barcode Source';


--
-- Name: COLUMN res_company.attendance_kiosk_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.attendance_kiosk_key IS 'Attendance Kiosk Key';


--
-- Name: COLUMN res_company.attendance_overtime_validation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.attendance_overtime_validation IS 'Extra Hours Validation';


--
-- Name: COLUMN res_company.hr_attendance_display_overtime; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_attendance_display_overtime IS 'Display Extra Hours';


--
-- Name: COLUMN res_company.attendance_kiosk_use_pin; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.attendance_kiosk_use_pin IS 'Employee PIN Identification';


--
-- Name: COLUMN res_company.attendance_from_systray; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.attendance_from_systray IS 'Attendance From Systray';


--
-- Name: COLUMN res_company.auto_check_out; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.auto_check_out IS 'Automatic Check Out';


--
-- Name: COLUMN res_company.absence_management; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.absence_management IS 'Absence Management';


--
-- Name: COLUMN res_company.auto_check_out_tolerance; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.auto_check_out_tolerance IS 'Auto Check Out Tolerance';


--
-- Name: COLUMN res_company.contract_expiration_notice_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.contract_expiration_notice_period IS 'Contract Expiry Notice Period';


--
-- Name: COLUMN res_company.work_permit_expiration_notice_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.work_permit_expiration_notice_period IS 'Work Permit Expiry Notice Period';


--
-- Name: COLUMN res_company.expense_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.expense_journal_id IS 'Default Expense Journal';


--
-- Name: COLUMN res_company.expense_outstanding_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.expense_outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN res_company.candidate_properties_definition; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.candidate_properties_definition IS 'Candidate Properties';


--
-- Name: COLUMN res_company.job_properties_definition; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.job_properties_definition IS 'Job Properties';


--
-- Name: COLUMN res_company.manufacturing_lead; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.manufacturing_lead IS 'Manufacturing Lead Time';


--
-- Name: COLUMN res_company.po_lock; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.po_lock IS 'Purchase Order Modification';


--
-- Name: COLUMN res_company.po_double_validation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.po_double_validation IS 'Levels of Approvals';


--
-- Name: COLUMN res_company.po_double_validation_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.po_double_validation_amount IS 'Double validation amount';


--
-- Name: COLUMN res_company.po_lead; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.po_lead IS 'Purchase Lead Time';


--
-- Name: COLUMN res_company.account_production_wip_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_production_wip_account_id IS 'Production WIP Account';


--
-- Name: COLUMN res_company.account_production_wip_overhead_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_production_wip_overhead_account_id IS 'Production WIP Overhead Account';


--
-- Name: COLUMN res_company.allow_interwarehouse_sudo; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.allow_interwarehouse_sudo IS 'Allow Inter-Warehouse Picking Access';


--
-- Name: COLUMN res_company.stock_sms_confirmation_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.stock_sms_confirmation_template_id IS 'SMS Template';


--
-- Name: COLUMN res_company.stock_move_sms_validation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.stock_move_sms_validation IS 'SMS Confirmation';


--
-- Name: COLUMN res_company.has_received_warning_stock_sms; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.has_received_warning_stock_sms IS 'Has Received Warning Stock Sms';


--
-- Name: COLUMN res_company.avalara_api_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.avalara_api_id IS 'Avalara API ID';


--
-- Name: COLUMN res_company.avalara_api_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.avalara_api_key IS 'Avalara API KEY';


--
-- Name: COLUMN res_company.avalara_environment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.avalara_environment IS 'Avalara Environment';


--
-- Name: COLUMN res_company.avalara_commit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.avalara_commit IS 'Commit in Avatax';


--
-- Name: COLUMN res_company.avalara_address_validation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.avalara_address_validation IS 'Avalara Address Validation';


--
-- Name: COLUMN res_company.avalara_use_upc; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.avalara_use_upc IS 'Use UPC';


--
-- Name: COLUMN res_company.setting_account_avatax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.setting_account_avatax IS 'Use AvaTax';


--
-- Name: COLUMN res_company.iso20022_orgid_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.iso20022_orgid_id IS 'Identification';


--
-- Name: COLUMN res_company.iso20022_orgid_issr; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.iso20022_orgid_issr IS 'Issuer';


--
-- Name: COLUMN res_company.iso20022_initiating_party_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.iso20022_initiating_party_name IS 'Your Company Name';


--
-- Name: COLUMN res_company.peppol_purchase_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.peppol_purchase_journal_id IS 'PEPPOL Purchase Journal';


--
-- Name: COLUMN res_company.account_peppol_contact_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_peppol_contact_email IS 'Primary contact email';


--
-- Name: COLUMN res_company.account_peppol_migration_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_peppol_migration_key IS 'Migration Key';


--
-- Name: COLUMN res_company.account_peppol_phone_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_peppol_phone_number IS 'Mobile number';


--
-- Name: COLUMN res_company.account_peppol_proxy_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_peppol_proxy_state IS 'PEPPOL status';


--
-- Name: COLUMN res_company.sdd_creditor_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sdd_creditor_identifier IS 'SDD creditor identifier';


--
-- Name: COLUMN res_company.approvals_folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.approvals_folder_id IS 'Approvals Workspace';


--
-- Name: COLUMN res_company.documents_approvals_settings; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_approvals_settings IS 'Documents Approvals Settings';


--
-- Name: COLUMN res_company.recruitment_folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.recruitment_folder_id IS 'Recruitment Workspace';


--
-- Name: COLUMN res_company.documents_recruitment_settings; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_recruitment_settings IS 'Documents Recruitment Settings';


--
-- Name: COLUMN res_company.appraisal_survey_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.appraisal_survey_template_id IS 'Appraisal Survey Template';


--
-- Name: COLUMN res_company.hr_presence_last_compute_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_presence_last_compute_date IS 'Hr Presence Last Compute Date';


--
-- Name: COLUMN res_company.recruitment_extract_show_ocr_option_selection; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.recruitment_extract_show_ocr_option_selection IS 'Send mode on candidate attachments';


--
-- Name: COLUMN res_company.project_time_mode_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.project_time_mode_id IS 'Project Time Unit';


--
-- Name: COLUMN res_company.timesheet_encode_uom_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_encode_uom_id IS 'Timesheet Encoding Unit';


--
-- Name: COLUMN res_company.internal_project_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.internal_project_id IS 'Internal Project';


--
-- Name: COLUMN res_company.subcontracting_location_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.subcontracting_location_id IS 'Subcontracting Location';


--
-- Name: COLUMN res_company.planning_generation_interval; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.planning_generation_interval IS 'Rate Of Shift Generation';


--
-- Name: COLUMN res_company.planning_self_unassign_days_before; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.planning_self_unassign_days_before IS 'Days before shift for unassignment';


--
-- Name: COLUMN res_company.planning_employee_unavailabilities; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.planning_employee_unavailabilities IS 'Employee Unavailabilities';


--
-- Name: COLUMN res_company.point_of_sale_update_stock_quantities; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.point_of_sale_update_stock_quantities IS 'Update quantities in stock';


--
-- Name: COLUMN res_company.point_of_sale_ticket_portal_url_display_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.point_of_sale_ticket_portal_url_display_mode IS 'Print';


--
-- Name: COLUMN res_company.point_of_sale_use_ticket_qr_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.point_of_sale_use_ticket_qr_code IS 'Self-service invoicing';


--
-- Name: COLUMN res_company.point_of_sale_ticket_unique_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.point_of_sale_ticket_unique_code IS 'Generate a code on ticket';


--
-- Name: COLUMN res_company.days_to_purchase; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.days_to_purchase IS 'Days to Purchase';


--
-- Name: COLUMN res_company.quotation_validity_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.quotation_validity_days IS 'Default Quotation Validity';


--
-- Name: COLUMN res_company.sale_discount_product_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sale_discount_product_id IS 'Discount Product';


--
-- Name: COLUMN res_company.sale_onboarding_payment_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sale_onboarding_payment_method IS 'Sale onboarding selected payment method';


--
-- Name: COLUMN res_company.portal_confirmation_sign; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.portal_confirmation_sign IS 'Online Signature';


--
-- Name: COLUMN res_company.portal_confirmation_pay; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.portal_confirmation_pay IS 'Online Payment';


--
-- Name: COLUMN res_company.prepayment_percent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.prepayment_percent IS 'Prepayment percentage';


--
-- Name: COLUMN res_company.account_tax_periodicity_reminder_day; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_tax_periodicity_reminder_day IS 'Start from';


--
-- Name: COLUMN res_company.account_tax_periodicity_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_tax_periodicity_journal_id IS 'Journal';


--
-- Name: COLUMN res_company.account_revaluation_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_revaluation_journal_id IS 'Account Revaluation Journal';


--
-- Name: COLUMN res_company.account_revaluation_expense_provision_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_revaluation_expense_provision_account_id IS 'Expense Provision Account';


--
-- Name: COLUMN res_company.account_revaluation_income_provision_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_revaluation_income_provision_account_id IS 'Income Provision Account';


--
-- Name: COLUMN res_company.account_representative_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_representative_id IS 'Accounting Firm';


--
-- Name: COLUMN res_company.account_tax_periodicity; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_tax_periodicity IS 'Delay units';


--
-- Name: COLUMN res_company.totals_below_sections; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.totals_below_sections IS 'Add totals below sections';


--
-- Name: COLUMN res_company.documents_account_peppol_folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_account_peppol_folder_id IS 'Document Workspace';


--
-- Name: COLUMN res_company.expense_extract_show_ocr_option_selection; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.expense_extract_show_ocr_option_selection IS 'Send mode on expense attachments';


--
-- Name: COLUMN res_company.hr_recruitment_monster_username; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_recruitment_monster_username IS 'Monster Identifier';


--
-- Name: COLUMN res_company.hr_recruitment_monster_password; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_recruitment_monster_password IS 'Monster Password';


--
-- Name: COLUMN res_company.manufacturing_period_to_display_year; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.manufacturing_period_to_display_year IS 'Number of columns for the yearly period to display in Master Production Schedule';


--
-- Name: COLUMN res_company.manufacturing_period_to_display_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.manufacturing_period_to_display_month IS 'Number of columns for the monthly period to display in Master Production Schedule';


--
-- Name: COLUMN res_company.manufacturing_period_to_display_week; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.manufacturing_period_to_display_week IS 'Number of columns for the weekly period to display in Master Production Schedule';


--
-- Name: COLUMN res_company.manufacturing_period_to_display_day; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.manufacturing_period_to_display_day IS 'Number of columns for the daily period to display in Master Production Schedule';


--
-- Name: COLUMN res_company.manufacturing_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.manufacturing_period IS 'Manufacturing Period';


--
-- Name: COLUMN res_company.mrp_mps_show_starting_inventory; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_starting_inventory IS 'Display Starting Inventory';


--
-- Name: COLUMN res_company.mrp_mps_show_demand_forecast; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_demand_forecast IS 'Display Demand Forecast';


--
-- Name: COLUMN res_company.mrp_mps_show_actual_demand; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_actual_demand IS 'Display Actual Demand';


--
-- Name: COLUMN res_company.mrp_mps_show_indirect_demand; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_indirect_demand IS 'Display Indirect Demand';


--
-- Name: COLUMN res_company.mrp_mps_show_to_replenish; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_to_replenish IS 'Display To Replenish';


--
-- Name: COLUMN res_company.mrp_mps_show_actual_replenishment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_actual_replenishment IS 'Display Actual Replenishment';


--
-- Name: COLUMN res_company.mrp_mps_show_safety_stock; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_safety_stock IS 'Display Safety Stock';


--
-- Name: COLUMN res_company.mrp_mps_show_available_to_promise; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_available_to_promise IS 'Display Available to Promise';


--
-- Name: COLUMN res_company.mrp_mps_show_actual_demand_year_minus_1; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_actual_demand_year_minus_1 IS 'Display Actual Demand Last Year';


--
-- Name: COLUMN res_company.mrp_mps_show_actual_demand_year_minus_2; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.mrp_mps_show_actual_demand_year_minus_2 IS 'Display Actual Demand Before Year';


--
-- Name: COLUMN res_company.leave_timesheet_task_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.leave_timesheet_task_id IS 'Time Off Task';


--
-- Name: COLUMN res_company.sale_order_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sale_order_template_id IS 'Default Sale Template';


--
-- Name: COLUMN res_company.min_extra_hour; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.min_extra_hour IS 'Minimum delay time before applying fines.';


--
-- Name: COLUMN res_company.extra_product; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.extra_product IS 'Product';


--
-- Name: COLUMN res_company.extra_hour; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.extra_hour IS 'Per Hour';


--
-- Name: COLUMN res_company.extra_day; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.extra_day IS 'Per Day';


--
-- Name: COLUMN res_company.security_lead; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.security_lead IS 'Sales Safety Days';


--
-- Name: COLUMN res_company.lc_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.lc_journal_id IS 'Lc Journal';


--
-- Name: COLUMN res_company.timesheet_mail_employee_delay; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_delay IS 'Employee Reminder Days';


--
-- Name: COLUMN res_company.timesheet_mail_delay; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_mail_delay IS 'Approver Reminder Days';


--
-- Name: COLUMN res_company.timesheet_mail_employee_interval; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_interval IS 'Employee Frequency';


--
-- Name: COLUMN res_company.timesheet_mail_interval; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_mail_interval IS 'Approver Reminder Frequency';


--
-- Name: COLUMN res_company.timesheet_mail_employee_allow; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_allow IS 'Employee Reminder';


--
-- Name: COLUMN res_company.timesheet_mail_allow; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_mail_allow IS 'Approver Reminder';


--
-- Name: COLUMN res_company.timesheet_mail_employee_nextdate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_nextdate IS 'Next scheduled date for employee reminder';


--
-- Name: COLUMN res_company.timesheet_mail_nextdate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_mail_nextdate IS 'Next scheduled date for approver reminder';


--
-- Name: COLUMN res_company.gain_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.gain_account_id IS 'Gain Account';


--
-- Name: COLUMN res_company.loss_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN res_company.extract_bank_statement_digitalization_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.extract_bank_statement_digitalization_mode IS 'Digitization mode on bank statements';


--
-- Name: COLUMN res_company.intrastat_region_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intrastat_region_id IS 'Intrastat region';


--
-- Name: COLUMN res_company.intrastat_transport_mode_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intrastat_transport_mode_id IS 'Default transport mode';


--
-- Name: COLUMN res_company.intrastat_default_invoice_transaction_code_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intrastat_default_invoice_transaction_code_id IS 'Default invoice transaction code';


--
-- Name: COLUMN res_company.intrastat_default_refund_transaction_code_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intrastat_default_refund_transaction_code_id IS 'Default refund transaction code';


--
-- Name: COLUMN res_company.extract_in_invoice_digitalization_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.extract_in_invoice_digitalization_mode IS 'Digitization mode on vendor bills';


--
-- Name: COLUMN res_company.extract_out_invoice_digitalization_mode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.extract_out_invoice_digitalization_mode IS 'Digitization mode on customer invoices';


--
-- Name: COLUMN res_company.extract_single_line_per_tax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.extract_single_line_per_tax IS 'Single Invoice Line Per Tax';


--
-- Name: COLUMN res_company.account_folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.account_folder_id IS 'Accounting Workspace';


--
-- Name: COLUMN res_company.documents_account_settings; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_account_settings IS 'Documents Account Settings';


--
-- Name: COLUMN res_company.hr_contract_timeoff_auto_allocation_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_contract_timeoff_auto_allocation_type_id IS 'Time Off Type';


--
-- Name: COLUMN res_company.hr_contract_timeoff_auto_allocation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_contract_timeoff_auto_allocation IS 'Extra Time Off Allocation on contract signature';


--
-- Name: COLUMN res_company.ytd_reset_day; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.ytd_reset_day IS 'YTD Reset Day of the month';


--
-- Name: COLUMN res_company.ytd_reset_month; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.ytd_reset_month IS 'YTD Reset Month';


--
-- Name: COLUMN res_company.gelato_api_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.gelato_api_key IS 'Gelato API Key';


--
-- Name: COLUMN res_company.gelato_webhook_secret; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.gelato_webhook_secret IS 'Gelato Webhook Secret';


--
-- Name: COLUMN res_company.intercompany_generate_sales_orders; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_generate_sales_orders IS 'Generate Sales order';


--
-- Name: COLUMN res_company.intercompany_generate_purchase_orders; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_generate_purchase_orders IS 'Generate Purchase Orders';


--
-- Name: COLUMN res_company.rental_sign_tmpl_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.rental_sign_tmpl_id IS 'Default Document Template for Rentals';


--
-- Name: COLUMN res_company.rental_loc_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.rental_loc_id IS 'Rental Location';


--
-- Name: COLUMN res_company.padding_time; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.padding_time IS 'Padding Time';


--
-- Name: COLUMN res_company.documents_payroll_folder_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.documents_payroll_folder_id IS 'Documents Payroll Folder';


--
-- Name: COLUMN res_company.batch_payroll_move_lines; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.batch_payroll_move_lines IS 'Batch Payroll Move Lines';


--
-- Name: COLUMN res_company.deferred_time_off_manager; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.deferred_time_off_manager IS 'Deferred Time Off Manager';


--
-- Name: COLUMN res_company.commission_automatic_po_frequency; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.commission_automatic_po_frequency IS 'Commission Automatic Po Frequency';


--
-- Name: COLUMN res_company.commission_po_minimum; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.commission_po_minimum IS 'Minimum Total Amount for PO commission';


--
-- Name: COLUMN res_company.intercompany_warehouse_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_warehouse_id IS 'Warehouse';


--
-- Name: COLUMN res_company.intercompany_receipt_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_receipt_type_id IS 'Receipt Operation Type';


--
-- Name: COLUMN res_company.intercompany_sync_delivery_receipt; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.intercompany_sync_delivery_receipt IS 'Synchronize Deliveries to your Receipts';


--
-- Name: COLUMN res_company.renting_minimal_time_duration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_minimal_time_duration IS 'Minimal Rental Duration';


--
-- Name: COLUMN res_company.renting_minimal_time_unit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_minimal_time_unit IS 'Minimal Rental Duration Unit';


--
-- Name: COLUMN res_company.renting_forbidden_mon; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_forbidden_mon IS 'Monday';


--
-- Name: COLUMN res_company.renting_forbidden_tue; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_forbidden_tue IS 'Tuesday';


--
-- Name: COLUMN res_company.renting_forbidden_wed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_forbidden_wed IS 'Wednesday';


--
-- Name: COLUMN res_company.renting_forbidden_thu; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_forbidden_thu IS 'Thursday';


--
-- Name: COLUMN res_company.renting_forbidden_fri; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_forbidden_fri IS 'Friday';


--
-- Name: COLUMN res_company.renting_forbidden_sat; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_forbidden_sat IS 'Saturday';


--
-- Name: COLUMN res_company.renting_forbidden_sun; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.renting_forbidden_sun IS 'Sunday';


--
-- Name: COLUMN res_company.can_edit_so_line_price; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.can_edit_so_line_price IS 'Can Edit SO Line Price';


--
-- Name: COLUMN res_company.onss_certificate_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.onss_certificate_id IS 'ONSS Certificate';


--
-- Name: COLUMN res_company.onss_company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.onss_company_id IS 'ONSS Company ID';


--
-- Name: COLUMN res_company.onss_registration_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.onss_registration_number IS 'ONSS Registration Number';


--
-- Name: COLUMN res_company.dmfa_employer_class; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.dmfa_employer_class IS 'DMFA Employer Class';


--
-- Name: COLUMN res_company.l10n_be_company_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.l10n_be_company_number IS 'Company Number';


--
-- Name: COLUMN res_company.l10n_be_revenue_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.l10n_be_revenue_code IS 'Revenue Code';


--
-- Name: COLUMN res_company.l10n_be_ffe_employer_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.l10n_be_ffe_employer_type IS 'L10N Be Ffe Employer Type';


--
-- Name: COLUMN res_company.onss_expeditor_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.onss_expeditor_number IS 'ONSS Expeditor Number';


--
-- Name: COLUMN res_company.accident_insurance_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.accident_insurance_name IS 'Accident Insurance Name';


--
-- Name: COLUMN res_company.accident_insurance_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.accident_insurance_number IS 'Accident Insurance Number';


--
-- Name: COLUMN res_company.l10n_us_ca_ett_tax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.l10n_us_ca_ett_tax IS 'California: ETT Tax';


--
-- Name: COLUMN res_company.dropship_subcontractor_pick_type_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.dropship_subcontractor_pick_type_id IS 'Dropship Subcontractor Pick Type';


--
-- Name: COLUMN res_company.hr_employee_not_attendance_alert_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_employee_not_attendance_alert_days IS 'Employee Absence Alert Days';


--
-- Name: COLUMN res_company.hr_probationary_assessment_remind_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_probationary_assessment_remind_days IS 'Probationary Assessment Reminder Days';


--
-- Name: COLUMN res_company.hr_probationary_assessment_link; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_probationary_assessment_link IS 'Probationary Assessment Link';


--
-- Name: COLUMN res_company.exemption_doctor_master_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.exemption_doctor_master_account_id IS 'Exemption Doctor Master Account';


--
-- Name: COLUMN res_company.exemption_bachelor_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.exemption_bachelor_account_id IS 'Exemption Bachelor Account';


--
-- Name: COLUMN res_company.exemption_bachelor_capping_account_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.exemption_bachelor_capping_account_id IS 'Exemption Bachelor Capping Account';


--
-- Name: COLUMN res_company.exemption_journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.exemption_journal_id IS 'Salary Journal';


--
-- Name: COLUMN res_company.onss_sftp_private_key; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.onss_sftp_private_key IS 'ONSS Technical User Private Key';


--
-- Name: COLUMN res_company.onss_technical_user_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.onss_technical_user_name IS 'ONSS Technical User Name';


--
-- Name: COLUMN res_company.group_s_sequence_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.group_s_sequence_number IS 'Group S Sequence Number';


--
-- Name: COLUMN res_company.group_s_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.group_s_code IS 'Group S Affiliation Number';


--
-- Name: COLUMN res_company.partena_sequence_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.partena_sequence_number IS 'Partena Sequence Number';


--
-- Name: COLUMN res_company.partena_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.partena_code IS 'Partena Affiliation Number';


--
-- Name: COLUMN res_company.sdworx_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.sdworx_code IS 'SDWorx code';


--
-- Name: COLUMN res_company.ucm_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.ucm_code IS 'UCM Affiliation Number';


--
-- Name: COLUMN res_company.ucm_company_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.ucm_company_code IS 'UCM folder Number';


--
-- Name: COLUMN res_company.cash_rounding_by_sale_order_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.cash_rounding_by_sale_order_id IS 'Default Cash Rounding by SO';


--
-- Name: COLUMN res_company.is_round_price; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.is_round_price IS 'Is Round Price';


--
-- Name: COLUMN res_company.timesheet_show_rates; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_show_rates IS 'Timesheet Show Rates';


--
-- Name: COLUMN res_company.timesheet_show_leaderboard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.timesheet_show_leaderboard IS 'Timesheet Show Leaderboard';


--
-- Name: COLUMN res_company.hr_employee_end_of_leave_remind_days; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.hr_employee_end_of_leave_remind_days IS 'End of Leave Reminding Days';


--
-- Name: COLUMN res_company.monthly_scan_day_overdue; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.monthly_scan_day_overdue IS 'Monthly Scan Days Overdue';


--
-- Name: COLUMN res_company.monthly_scan_day_bde; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.monthly_scan_day_bde IS 'Monthly Scan Days for BDE';


--
-- Name: COLUMN res_company.is_apply_bad_debt_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.is_apply_bad_debt_order IS 'Apply Bad Debt Order';


--
-- Name: COLUMN res_company.block_auto_reassign_manual_unreserve; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.block_auto_reassign_manual_unreserve IS 'Block Auto State Change After Manual Unreserve';


--
-- Name: COLUMN res_company.returned_approval_category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.returned_approval_category_id IS 'Returned Approval Category';


--
-- Name: COLUMN res_company.wholesale_threshold; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_company.wholesale_threshold IS 'Wholesale Threshold';


--
-- Name: CONSTRAINT res_company_auto_allocation ON res_company; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT res_company_auto_allocation ON public.res_company IS 'CHECK(hr_contract_timeoff_auto_allocation = ''f'' OR hr_contract_timeoff_auto_allocation_type_id IS NOT NULL)';


--
-- Name: CONSTRAINT res_company_check_quotation_validity_days ON res_company; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT res_company_check_quotation_validity_days ON public.res_company IS 'CHECK(quotation_validity_days >= 0)';


--
-- Name: CONSTRAINT res_company_min_extra_hour ON res_company; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT res_company_min_extra_hour ON public.res_company IS 'CHECK(min_extra_hour >= 1)';


--
-- Name: CONSTRAINT res_company_planning_self_unassign_days_before_positive ON res_company; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT res_company_planning_self_unassign_days_before_positive ON public.res_company IS 'CHECK(planning_self_unassign_days_before >= 0)';


--
-- Name: CONSTRAINT res_company_positif_number_months ON res_company; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT res_company_positif_number_months ON public.res_company IS 'CHECK(duration_after_recruitment > 0 AND duration_first_appraisal > 0 AND duration_next_appraisal > 0)';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    title integer,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    commercial_company_name character varying,
    company_name character varying,
    barcode jsonb,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    monetary numeric,
    date date,
    date_localization date,
    contact_address_complete character varying,
    message_bounce integer,
    email_normalized character varying,
    signup_type character varying,
    calendar_last_notif_ack timestamp without time zone,
    plan_to_change_car boolean,
    plan_to_change_bike boolean,
    specific_property_product_pricelist jsonb,
    city_id integer,
    street_name character varying,
    street_number character varying,
    street_number2 character varying,
    ocn_token character varying,
    partner_gid integer,
    additional_info character varying,
    national_phone character varying,
    national_mobile character varying,
    phone_sanitized character varying,
    invoice_template_pdf_report_id integer,
    supplier_rank integer,
    customer_rank integer,
    invoice_warn character varying,
    autopost_bills character varying NOT NULL,
    credit_limit jsonb,
    property_account_payable_id jsonb,
    property_account_receivable_id jsonb,
    property_account_position_id jsonb,
    property_payment_term_id jsonb,
    property_supplier_payment_term_id jsonb,
    trust jsonb,
    ignore_abnormal_invoice_date jsonb,
    ignore_abnormal_invoice_amount jsonb,
    invoice_sending_method jsonb,
    invoice_edi_format_store jsonb,
    property_outbound_payment_method_line_id jsonb,
    property_inbound_payment_method_line_id jsonb,
    invoice_warn_msg text,
    debit_limit numeric,
    picking_warn character varying,
    property_stock_customer jsonb,
    property_stock_supplier jsonb,
    picking_warn_msg text,
    website_id integer,
    is_published boolean,
    global_location_number character varying,
    peppol_endpoint character varying,
    peppol_eas character varying,
    vies_valid boolean,
    associate_member integer,
    membership_state character varying,
    membership_start date,
    membership_stop date,
    membership_cancel date,
    membership_amount numeric,
    free_member boolean,
    buyer_id integer,
    purchase_warn character varying,
    property_purchase_currency_id jsonb,
    receipt_reminder_email jsonb,
    reminder_date_before_receipt jsonb,
    purchase_warn_msg text,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    website_description jsonb,
    website_short_description jsonb,
    avalara_partner_code character varying,
    avalara_exemption_id jsonb,
    iso20022_lei character varying,
    online_partner_information character varying,
    peppol_verification_state jsonb,
    box_1099_id integer,
    property_stock_subcontractor jsonb,
    sale_warn character varying,
    sale_warn_msg text,
    is_avatax_valid boolean,
    property_delivery_carrier_id jsonb,
    partner_weight integer,
    grade_id integer,
    grade_sequence integer,
    activation integer,
    assigned_partner_id integer,
    implemented_partner_count integer,
    date_partnership date,
    date_review date,
    date_review_next date,
    followup_reminder_type character varying,
    followup_next_action_date jsonb,
    followup_responsible_id jsonb,
    property_ups_carrier_account jsonb,
    commission_plan_id integer,
    amazon_email character varying,
    shopee_buyer_identifier integer,
    citizen_identification character varying,
    source_id integer,
    nationality integer,
    dob integer,
    mob integer,
    yob integer,
    facebook_url character varying,
    sub_facebook_url character varying,
    tiktok_url character varying,
    date_of_birth date,
    town_id integer,
    customer_code character varying,
    old_id integer,
    customer_id_identifier character varying,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO ductin;

--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.barcode; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.barcode IS 'Barcode';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.monetary; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.monetary IS 'Monetary';


--
-- Name: COLUMN res_partner.date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.date IS 'Date';


--
-- Name: COLUMN res_partner.date_localization; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.date_localization IS 'Geolocation Date';


--
-- Name: COLUMN res_partner.contact_address_complete; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.contact_address_complete IS 'Contact Address Complete';


--
-- Name: COLUMN res_partner.message_bounce; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.message_bounce IS 'Bounce';


--
-- Name: COLUMN res_partner.email_normalized; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.calendar_last_notif_ack; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.calendar_last_notif_ack IS 'Last notification marked as read from base Calendar';


--
-- Name: COLUMN res_partner.plan_to_change_car; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.plan_to_change_car IS 'Plan To Change Car';


--
-- Name: COLUMN res_partner.plan_to_change_bike; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.plan_to_change_bike IS 'Plan To Change Bike';


--
-- Name: COLUMN res_partner.specific_property_product_pricelist; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.specific_property_product_pricelist IS 'Specific Property Product Pricelist';


--
-- Name: COLUMN res_partner.city_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.city_id IS 'City ID';


--
-- Name: COLUMN res_partner.street_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.street_name IS 'Street Name';


--
-- Name: COLUMN res_partner.street_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.street_number IS 'House';


--
-- Name: COLUMN res_partner.street_number2; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.street_number2 IS 'Door';


--
-- Name: COLUMN res_partner.ocn_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.ocn_token IS 'OCN Token';


--
-- Name: COLUMN res_partner.partner_gid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.partner_gid IS 'Company database ID';


--
-- Name: COLUMN res_partner.additional_info; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.additional_info IS 'Additional info';


--
-- Name: COLUMN res_partner.national_phone; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.national_phone IS 'National Phone';


--
-- Name: COLUMN res_partner.national_mobile; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.national_mobile IS 'National Mobile';


--
-- Name: COLUMN res_partner.phone_sanitized; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN res_partner.invoice_template_pdf_report_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.invoice_template_pdf_report_id IS 'Invoice template';


--
-- Name: COLUMN res_partner.supplier_rank; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.supplier_rank IS 'Supplier Rank';


--
-- Name: COLUMN res_partner.customer_rank; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.customer_rank IS 'Customer Rank';


--
-- Name: COLUMN res_partner.invoice_warn; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.invoice_warn IS 'Invoice';


--
-- Name: COLUMN res_partner.autopost_bills; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.autopost_bills IS 'Auto-post bills';


--
-- Name: COLUMN res_partner.credit_limit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.credit_limit IS 'Credit Limit';


--
-- Name: COLUMN res_partner.property_account_payable_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_account_payable_id IS 'Account Payable';


--
-- Name: COLUMN res_partner.property_account_receivable_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_account_receivable_id IS 'Account Receivable';


--
-- Name: COLUMN res_partner.property_account_position_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_account_position_id IS 'Fiscal Position';


--
-- Name: COLUMN res_partner.property_payment_term_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_payment_term_id IS 'Customer Payment Terms';


--
-- Name: COLUMN res_partner.property_supplier_payment_term_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_supplier_payment_term_id IS 'Vendor Payment Terms';


--
-- Name: COLUMN res_partner.trust; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.trust IS 'Degree of trust you have in this debtor';


--
-- Name: COLUMN res_partner.ignore_abnormal_invoice_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.ignore_abnormal_invoice_date IS 'Ignore Abnormal Invoice Date';


--
-- Name: COLUMN res_partner.ignore_abnormal_invoice_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.ignore_abnormal_invoice_amount IS 'Ignore Abnormal Invoice Amount';


--
-- Name: COLUMN res_partner.invoice_sending_method; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.invoice_sending_method IS 'Invoice sending';


--
-- Name: COLUMN res_partner.invoice_edi_format_store; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.invoice_edi_format_store IS 'Invoice Edi Format Store';


--
-- Name: COLUMN res_partner.property_outbound_payment_method_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_outbound_payment_method_line_id IS 'Property Outbound Payment Method Line';


--
-- Name: COLUMN res_partner.property_inbound_payment_method_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_inbound_payment_method_line_id IS 'Property Inbound Payment Method Line';


--
-- Name: COLUMN res_partner.invoice_warn_msg; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.invoice_warn_msg IS 'Message for Invoice';


--
-- Name: COLUMN res_partner.debit_limit; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.debit_limit IS 'Payable Limit';


--
-- Name: COLUMN res_partner.picking_warn; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.picking_warn IS 'Stock Picking';


--
-- Name: COLUMN res_partner.property_stock_customer; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_stock_customer IS 'Customer Location';


--
-- Name: COLUMN res_partner.property_stock_supplier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_stock_supplier IS 'Vendor Location';


--
-- Name: COLUMN res_partner.picking_warn_msg; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.picking_warn_msg IS 'Message for Stock Picking';


--
-- Name: COLUMN res_partner.website_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.website_id IS 'Website';


--
-- Name: COLUMN res_partner.is_published; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.is_published IS 'Is Published';


--
-- Name: COLUMN res_partner.global_location_number; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.global_location_number IS 'GLN';


--
-- Name: COLUMN res_partner.peppol_endpoint; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.peppol_endpoint IS 'Peppol Endpoint';


--
-- Name: COLUMN res_partner.peppol_eas; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.peppol_eas IS 'Peppol e-address (EAS)';


--
-- Name: COLUMN res_partner.vies_valid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.vies_valid IS 'Intra-Community Valid';


--
-- Name: COLUMN res_partner.associate_member; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.associate_member IS 'Associate Member';


--
-- Name: COLUMN res_partner.membership_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.membership_state IS 'Current Membership Status';


--
-- Name: COLUMN res_partner.membership_start; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.membership_start IS 'Membership Start Date';


--
-- Name: COLUMN res_partner.membership_stop; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.membership_stop IS 'Membership End Date';


--
-- Name: COLUMN res_partner.membership_cancel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.membership_cancel IS 'Cancel Membership Date';


--
-- Name: COLUMN res_partner.membership_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.membership_amount IS 'Membership Amount';


--
-- Name: COLUMN res_partner.free_member; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.free_member IS 'Free Member';


--
-- Name: COLUMN res_partner.buyer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.buyer_id IS 'Buyer';


--
-- Name: COLUMN res_partner.purchase_warn; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.purchase_warn IS 'Purchase Order Warning';


--
-- Name: COLUMN res_partner.property_purchase_currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_purchase_currency_id IS 'Supplier Currency';


--
-- Name: COLUMN res_partner.receipt_reminder_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.receipt_reminder_email IS 'Receipt Reminder';


--
-- Name: COLUMN res_partner.reminder_date_before_receipt; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.reminder_date_before_receipt IS 'Days Before Receipt';


--
-- Name: COLUMN res_partner.purchase_warn_msg; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.purchase_warn_msg IS 'Message for Purchase Order';


--
-- Name: COLUMN res_partner.website_meta_og_img; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN res_partner.website_meta_title; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN res_partner.website_meta_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN res_partner.website_meta_keywords; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN res_partner.seo_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.seo_name IS 'Seo name';


--
-- Name: COLUMN res_partner.website_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.website_description IS 'Website Partner Full Description';


--
-- Name: COLUMN res_partner.website_short_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.website_short_description IS 'Website Partner Short Description';


--
-- Name: COLUMN res_partner.avalara_partner_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.avalara_partner_code IS 'Avalara Partner Code';


--
-- Name: COLUMN res_partner.avalara_exemption_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.avalara_exemption_id IS 'Avalara Exemption';


--
-- Name: COLUMN res_partner.iso20022_lei; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.iso20022_lei IS 'LEI';


--
-- Name: COLUMN res_partner.online_partner_information; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.online_partner_information IS 'Online Partner Information';


--
-- Name: COLUMN res_partner.peppol_verification_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.peppol_verification_state IS 'Peppol status';


--
-- Name: COLUMN res_partner.box_1099_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.box_1099_id IS '1099 Box';


--
-- Name: COLUMN res_partner.property_stock_subcontractor; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_stock_subcontractor IS 'Subcontractor Location';


--
-- Name: COLUMN res_partner.sale_warn; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.sale_warn IS 'Sales Warnings';


--
-- Name: COLUMN res_partner.sale_warn_msg; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.sale_warn_msg IS 'Message for Sales Order';


--
-- Name: COLUMN res_partner.is_avatax_valid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.is_avatax_valid IS 'Is Avatax Valid';


--
-- Name: COLUMN res_partner.property_delivery_carrier_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_delivery_carrier_id IS 'Delivery Method';


--
-- Name: COLUMN res_partner.partner_weight; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.partner_weight IS 'Level Weight';


--
-- Name: COLUMN res_partner.grade_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.grade_id IS 'Partner Level';


--
-- Name: COLUMN res_partner.grade_sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.grade_sequence IS 'Sequence';


--
-- Name: COLUMN res_partner.activation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.activation IS 'Activation';


--
-- Name: COLUMN res_partner.assigned_partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.assigned_partner_id IS 'Implemented by';


--
-- Name: COLUMN res_partner.implemented_partner_count; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.implemented_partner_count IS 'Implemented Partner Count';


--
-- Name: COLUMN res_partner.date_partnership; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.date_partnership IS 'Partnership Date';


--
-- Name: COLUMN res_partner.date_review; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.date_review IS 'Latest Partner Review';


--
-- Name: COLUMN res_partner.date_review_next; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.date_review_next IS 'Next Partner Review';


--
-- Name: COLUMN res_partner.followup_reminder_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.followup_reminder_type IS 'Reminders';


--
-- Name: COLUMN res_partner.followup_next_action_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.followup_next_action_date IS 'Next reminder';


--
-- Name: COLUMN res_partner.followup_responsible_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.followup_responsible_id IS 'Responsible';


--
-- Name: COLUMN res_partner.property_ups_carrier_account; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.property_ups_carrier_account IS 'UPS Account Number';


--
-- Name: COLUMN res_partner.commission_plan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.commission_plan_id IS 'Commission Plan';


--
-- Name: COLUMN res_partner.amazon_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.amazon_email IS 'Amazon Email';


--
-- Name: COLUMN res_partner.shopee_buyer_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.shopee_buyer_identifier IS 'Shopee Buyer ID';


--
-- Name: COLUMN res_partner.citizen_identification; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.citizen_identification IS 'Citizen Identification';


--
-- Name: COLUMN res_partner.source_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.source_id IS 'Source UTM';


--
-- Name: COLUMN res_partner.nationality; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.nationality IS 'Nationality';


--
-- Name: COLUMN res_partner.dob; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.dob IS 'Day of Birth';


--
-- Name: COLUMN res_partner.mob; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.mob IS 'Month of Birth';


--
-- Name: COLUMN res_partner.yob; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.yob IS 'Year of Birth';


--
-- Name: COLUMN res_partner.facebook_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.facebook_url IS 'Facebook URL';


--
-- Name: COLUMN res_partner.sub_facebook_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.sub_facebook_url IS 'Sub Facebook URL';


--
-- Name: COLUMN res_partner.tiktok_url; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.tiktok_url IS 'Tiktok URL';


--
-- Name: COLUMN res_partner.date_of_birth; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.date_of_birth IS 'Date of Birth Customer';


--
-- Name: COLUMN res_partner.town_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.town_id IS 'Town';


--
-- Name: COLUMN res_partner.customer_code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.customer_code IS 'Customer ID';


--
-- Name: COLUMN res_partner.old_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.old_id IS 'Old ID';


--
-- Name: COLUMN res_partner.customer_id_identifier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.res_partner.customer_id_identifier IS 'Customer ID Identifier';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: sale_order; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.sale_order (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    journal_id integer,
    partner_invoice_id integer NOT NULL,
    partner_shipping_id integer NOT NULL,
    fiscal_position_id integer,
    payment_term_id integer,
    pricelist_id integer,
    currency_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    access_token character varying,
    name character varying NOT NULL,
    state character varying,
    client_order_ref character varying,
    origin character varying,
    reference character varying,
    signed_by character varying,
    invoice_status character varying,
    validity_date date,
    note text,
    currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    locked boolean,
    require_signature boolean,
    require_payment boolean,
    create_date timestamp without time zone,
    commitment_date timestamp without time zone,
    date_order timestamp without time zone NOT NULL,
    signed_on timestamp without time zone,
    write_date timestamp without time zone,
    prepayment_percent double precision,
    carrier_id integer,
    delivery_message character varying,
    pickup_location_data jsonb,
    recompute_delivery_price boolean,
    shipping_weight double precision,
    pending_email_template_id integer,
    opportunity_id integer,
    sale_order_template_id integer,
    report_grids boolean,
    rental_start_date timestamp without time zone,
    rental_return_date timestamp without time zone,
    rental_status character varying,
    next_action_date timestamp without time zone,
    is_rental_order boolean,
    incoterm integer,
    warehouse_id integer,
    procurement_group_id integer,
    incoterm_location character varying,
    picking_policy character varying NOT NULL,
    delivery_status character varying,
    effective_date timestamp without time zone,
    crm_group_id integer,
    amount_unpaid numeric,
    margin numeric,
    margin_percent double precision,
    customizable_pdf_form_fields jsonb,
    auto_purchase_order_id integer,
    auto_generated boolean,
    is_subscription boolean,
    payment_exception boolean,
    close_reason_id integer,
    subscription_state character varying,
    rating_last_value double precision,
    end_date date,
    payment_token_id integer,
    kpi_1month_mrr_delta double precision,
    kpi_1month_mrr_percentage double precision,
    kpi_3months_mrr_delta double precision,
    kpi_3months_mrr_percentage double precision,
    percentage_satisfaction integer,
    health character varying,
    origin_order_id integer,
    subscription_id integer,
    recurring_monthly numeric,
    plan_id integer,
    start_date date,
    next_invoice_date date,
    first_contract_date date,
    last_reminder_date date,
    internal_note text,
    recurring_total numeric,
    is_batch boolean,
    is_invoice_cron boolean,
    pending_transaction boolean,
    website_id integer,
    shop_warning character varying,
    cart_recovery_email_sent boolean,
    referrer_id integer,
    commission_plan_id integer,
    commission_plan_frozen boolean,
    amazon_order_ref character varying,
    amazon_channel character varying,
    project_id integer,
    shopee_shop_id integer,
    shopee_order_ref character varying,
    shopee_fulfillment_type character varying,
    shopee_delivery_status character varying,
    sale_note text,
    inverse_currency_rate numeric,
    inverse_amount_total numeric,
    cancel_datetime timestamp without time zone,
    voucher_id integer,
    delivery_note text,
    cod_amount numeric,
    is_cod boolean,
    is_joint_inspection boolean,
    round_price_rule_id integer,
    round_price double precision,
    task_id integer,
    sol_ids character varying,
    stock_confirmed_user_id integer,
    customer_type character varying,
    sale_receivable_state character varying,
    is_bad_debt_explained boolean,
    is_overdue_explained boolean,
    tracking_days_receivable_overdue timestamp without time zone,
    tracking_days_receivable_bde timestamp without time zone,
    old_sale_user_id integer,
    old_sale_team_id integer,
    payment_done_date timestamp without time zone,
    line_details text,
    user_marketing_id integer,
    marketing_team_id integer,
    hide_data_period boolean,
    payment_status character varying,
    resale_opportunity_id integer,
    old_state character varying,
    old_delivery_carrier character varying,
    old_delivery_date timestamp without time zone,
    old_confirm_date timestamp without time zone,
    CONSTRAINT sale_order_check_start_date_lower_next_invoice_date CHECK (((next_invoice_date IS NULL) OR (start_date IS NULL) OR (next_invoice_date >= start_date))),
    CONSTRAINT sale_order_date_order_conditional_required CHECK (((((state)::text = 'sale'::text) AND (date_order IS NOT NULL)) OR ((state)::text <> 'sale'::text))),
    CONSTRAINT sale_order_rental_period_coherence CHECK ((rental_start_date < rental_return_date)),
    CONSTRAINT sale_order_sale_subscription_state_coherence CHECK ((NOT ((is_subscription = true) AND ((state)::text = 'sale'::text) AND ((subscription_state)::text = '1_draft'::text)))),
    CONSTRAINT sale_order_sale_subscription_state_coherence_2 CHECK ((NOT ((is_subscription = true) AND ((state)::text = ANY ((ARRAY['draft'::character varying, 'sent'::character varying])::text[])) AND ((subscription_state)::text = ANY ((ARRAY['3_progress'::character varying, '4_paused'::character varying])::text[])))))
);


ALTER TABLE public.sale_order OWNER TO ductin;

--
-- Name: TABLE sale_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.sale_order IS 'Sales Order';


--
-- Name: COLUMN sale_order.campaign_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.campaign_id IS 'Campaign';


--
-- Name: COLUMN sale_order.source_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.source_id IS 'Source';


--
-- Name: COLUMN sale_order.medium_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.medium_id IS 'Medium';


--
-- Name: COLUMN sale_order.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.company_id IS 'Company';


--
-- Name: COLUMN sale_order.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.partner_id IS 'Customer';


--
-- Name: COLUMN sale_order.journal_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.journal_id IS 'Invoicing Journal';


--
-- Name: COLUMN sale_order.partner_invoice_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.partner_invoice_id IS 'Invoice Address';


--
-- Name: COLUMN sale_order.partner_shipping_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN sale_order.fiscal_position_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN sale_order.payment_term_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN sale_order.pricelist_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN sale_order.currency_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.currency_id IS 'Currency';


--
-- Name: COLUMN sale_order.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.user_id IS 'Salesperson';


--
-- Name: COLUMN sale_order.team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.team_id IS 'Sales Team';


--
-- Name: COLUMN sale_order.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.create_uid IS 'Created by';


--
-- Name: COLUMN sale_order.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sale_order.access_token; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.access_token IS 'Security Token';


--
-- Name: COLUMN sale_order.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.name IS 'Order Reference';


--
-- Name: COLUMN sale_order.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.state IS 'Status';


--
-- Name: COLUMN sale_order.client_order_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.client_order_ref IS 'Customer Reference';


--
-- Name: COLUMN sale_order.origin; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.origin IS 'Source Document';


--
-- Name: COLUMN sale_order.reference; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.reference IS 'Payment Ref.';


--
-- Name: COLUMN sale_order.signed_by; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.signed_by IS 'Signed By';


--
-- Name: COLUMN sale_order.invoice_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.invoice_status IS 'Invoice Status';


--
-- Name: COLUMN sale_order.validity_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.validity_date IS 'Expiration';


--
-- Name: COLUMN sale_order.note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.note IS 'Terms and conditions';


--
-- Name: COLUMN sale_order.currency_rate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN sale_order.amount_untaxed; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN sale_order.amount_tax; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.amount_tax IS 'Taxes';


--
-- Name: COLUMN sale_order.amount_total; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.amount_total IS 'Total';


--
-- Name: COLUMN sale_order.locked; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.locked IS 'Locked';


--
-- Name: COLUMN sale_order.require_signature; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.require_signature IS 'Online signature';


--
-- Name: COLUMN sale_order.require_payment; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.require_payment IS 'Online payment';


--
-- Name: COLUMN sale_order.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.create_date IS 'Creation Date';


--
-- Name: COLUMN sale_order.commitment_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.commitment_date IS 'Delivery Date';


--
-- Name: COLUMN sale_order.date_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.date_order IS 'Order Date';


--
-- Name: COLUMN sale_order.signed_on; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.signed_on IS 'Signed On';


--
-- Name: COLUMN sale_order.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.write_date IS 'Last Updated on';


--
-- Name: COLUMN sale_order.prepayment_percent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.prepayment_percent IS 'Prepayment percentage';


--
-- Name: COLUMN sale_order.carrier_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.carrier_id IS 'Delivery Method';


--
-- Name: COLUMN sale_order.delivery_message; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.delivery_message IS 'Delivery Message';


--
-- Name: COLUMN sale_order.pickup_location_data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.pickup_location_data IS 'Pickup Location Data';


--
-- Name: COLUMN sale_order.recompute_delivery_price; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.recompute_delivery_price IS 'Delivery cost should be recomputed';


--
-- Name: COLUMN sale_order.shipping_weight; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.shipping_weight IS 'Shipping Weight';


--
-- Name: COLUMN sale_order.pending_email_template_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.pending_email_template_id IS 'Pending Email Template';


--
-- Name: COLUMN sale_order.opportunity_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.opportunity_id IS 'Opportunity';


--
-- Name: COLUMN sale_order.report_grids; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.report_grids IS 'Print Variant Grids';


--
-- Name: COLUMN sale_order.is_rental_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.is_rental_order IS 'Created In App Rental';


--
-- Name: COLUMN sale_order.incoterm; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.incoterm IS 'Incoterm';


--
-- Name: COLUMN sale_order.warehouse_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN sale_order.procurement_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.procurement_group_id IS 'Procurement Group';


--
-- Name: COLUMN sale_order.incoterm_location; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN sale_order.picking_policy; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.picking_policy IS 'Shipping Policy';


--
-- Name: COLUMN sale_order.delivery_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.delivery_status IS 'Delivery Status';


--
-- Name: COLUMN sale_order.effective_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.effective_date IS 'Effective Date';


--
-- Name: COLUMN sale_order.crm_group_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.crm_group_id IS 'CRM Group';


--
-- Name: COLUMN sale_order.amount_unpaid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.amount_unpaid IS 'Amount To Pay In POS';


--
-- Name: COLUMN sale_order.margin; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.margin IS 'Margin';


--
-- Name: COLUMN sale_order.margin_percent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.margin_percent IS 'Margin (%)';


--
-- Name: COLUMN sale_order.customizable_pdf_form_fields; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.customizable_pdf_form_fields IS 'Customizable PDF Form Fields';


--
-- Name: COLUMN sale_order.auto_purchase_order_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.auto_purchase_order_id IS 'Source Purchase Order';


--
-- Name: COLUMN sale_order.auto_generated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.auto_generated IS 'Auto Generated Sales Order';


--
-- Name: COLUMN sale_order.plan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.plan_id IS 'Recurring Plan';


--
-- Name: COLUMN sale_order.start_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.start_date IS 'Start Date';


--
-- Name: COLUMN sale_order.next_invoice_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.next_invoice_date IS 'Next Invoice';


--
-- Name: COLUMN sale_order.first_contract_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.first_contract_date IS 'First Contract Date';


--
-- Name: COLUMN sale_order.last_reminder_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.last_reminder_date IS 'Last Reminder Date';


--
-- Name: COLUMN sale_order.internal_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.internal_note IS 'Internal Note';


--
-- Name: COLUMN sale_order.recurring_total; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.recurring_total IS 'Total Recurring';


--
-- Name: COLUMN sale_order.is_batch; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.is_batch IS 'Is Batch';


--
-- Name: COLUMN sale_order.is_invoice_cron; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.is_invoice_cron IS 'Is a Subscription invoiced in cron';


--
-- Name: COLUMN sale_order.pending_transaction; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.pending_transaction IS 'Pending Transaction';


--
-- Name: COLUMN sale_order.website_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.website_id IS 'Website';


--
-- Name: COLUMN sale_order.shop_warning; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.shop_warning IS 'Warning';


--
-- Name: COLUMN sale_order.cart_recovery_email_sent; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.cart_recovery_email_sent IS 'Cart recovery email already sent';


--
-- Name: COLUMN sale_order.referrer_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.referrer_id IS 'Referrer';


--
-- Name: COLUMN sale_order.commission_plan_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.commission_plan_id IS 'Commission Plan';


--
-- Name: COLUMN sale_order.commission_plan_frozen; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.commission_plan_frozen IS 'Freeze Plan';


--
-- Name: COLUMN sale_order.amazon_order_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.amazon_order_ref IS 'Amazon Reference';


--
-- Name: COLUMN sale_order.amazon_channel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.amazon_channel IS 'Fulfillment Channel';


--
-- Name: COLUMN sale_order.project_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.project_id IS 'Project';


--
-- Name: COLUMN sale_order.shopee_shop_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.shopee_shop_id IS 'Shopee Shop';


--
-- Name: COLUMN sale_order.shopee_order_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.shopee_order_ref IS 'Shopee Reference';


--
-- Name: COLUMN sale_order.shopee_fulfillment_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.shopee_fulfillment_type IS 'Shopee Fulfillment Type';


--
-- Name: COLUMN sale_order.shopee_delivery_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.shopee_delivery_status IS 'Shopee Status';


--
-- Name: COLUMN sale_order.sale_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.sale_note IS 'Sale Note';


--
-- Name: COLUMN sale_order.inverse_currency_rate; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.inverse_currency_rate IS 'Inverse Currency Rate';


--
-- Name: COLUMN sale_order.inverse_amount_total; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.inverse_amount_total IS 'Company Total';


--
-- Name: COLUMN sale_order.cancel_datetime; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.cancel_datetime IS 'Cancel Date';


--
-- Name: COLUMN sale_order.voucher_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.voucher_id IS 'Applied Voucher';


--
-- Name: COLUMN sale_order.delivery_note; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.delivery_note IS 'Delivery Note';


--
-- Name: COLUMN sale_order.cod_amount; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.cod_amount IS 'COD Amount';


--
-- Name: COLUMN sale_order.is_cod; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.is_cod IS 'Cash on Delivery';


--
-- Name: COLUMN sale_order.is_joint_inspection; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.is_joint_inspection IS 'Joint Inspection';


--
-- Name: COLUMN sale_order.round_price_rule_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.round_price_rule_id IS 'Price Round Rule';


--
-- Name: COLUMN sale_order.round_price; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.round_price IS 'Rounding';


--
-- Name: COLUMN sale_order.task_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.task_id IS 'Task';


--
-- Name: COLUMN sale_order.sol_ids; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.sol_ids IS 'Sol';


--
-- Name: COLUMN sale_order.stock_confirmed_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.stock_confirmed_user_id IS 'Stock Confirmed By';


--
-- Name: COLUMN sale_order.customer_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.customer_type IS 'Customer Type';


--
-- Name: COLUMN sale_order.sale_receivable_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.sale_receivable_state IS 'Sale Receivable Status';


--
-- Name: COLUMN sale_order.is_bad_debt_explained; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.is_bad_debt_explained IS 'Is Bad Debt Explained';


--
-- Name: COLUMN sale_order.is_overdue_explained; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.is_overdue_explained IS 'Is Overdue Explained';


--
-- Name: COLUMN sale_order.tracking_days_receivable_overdue; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.tracking_days_receivable_overdue IS 'Tracking Days Overdue';


--
-- Name: COLUMN sale_order.tracking_days_receivable_bde; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.tracking_days_receivable_bde IS 'Tracking Days for BDE';


--
-- Name: COLUMN sale_order.old_sale_user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.old_sale_user_id IS 'Old Sale User';


--
-- Name: COLUMN sale_order.old_sale_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.old_sale_team_id IS 'Old Sale Team';


--
-- Name: COLUMN sale_order.payment_done_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.payment_done_date IS 'Payment Done Date';


--
-- Name: COLUMN sale_order.line_details; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.line_details IS 'Line Details';


--
-- Name: COLUMN sale_order.user_marketing_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.user_marketing_id IS 'User Marketing';


--
-- Name: COLUMN sale_order.marketing_team_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.marketing_team_id IS 'Marketing Team';


--
-- Name: COLUMN sale_order.hide_data_period; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.hide_data_period IS 'Hidden by Data Management';


--
-- Name: COLUMN sale_order.payment_status; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.payment_status IS 'Payment Status';


--
-- Name: COLUMN sale_order.resale_opportunity_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.resale_opportunity_id IS 'Resale Opportunity';


--
-- Name: COLUMN sale_order.old_state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.old_state IS 'Old State';


--
-- Name: COLUMN sale_order.old_delivery_carrier; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.old_delivery_carrier IS 'Old Delivery Carrier';


--
-- Name: COLUMN sale_order.old_delivery_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.old_delivery_date IS 'Old Delivery Date';


--
-- Name: COLUMN sale_order.old_confirm_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.sale_order.old_confirm_date IS 'Old Confirm Date';


--
-- Name: CONSTRAINT sale_order_check_start_date_lower_next_invoice_date ON sale_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT sale_order_check_start_date_lower_next_invoice_date ON public.sale_order IS 'CHECK((next_invoice_date IS NULL OR start_date IS NULL) OR (next_invoice_date >= start_date))';


--
-- Name: CONSTRAINT sale_order_date_order_conditional_required ON sale_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT sale_order_date_order_conditional_required ON public.sale_order IS 'CHECK((state = ''sale'' AND date_order IS NOT NULL) OR state != ''sale'')';


--
-- Name: CONSTRAINT sale_order_rental_period_coherence ON sale_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT sale_order_rental_period_coherence ON public.sale_order IS 'CHECK(rental_start_date < rental_return_date)';


--
-- Name: CONSTRAINT sale_order_sale_subscription_state_coherence ON sale_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT sale_order_sale_subscription_state_coherence ON public.sale_order IS 'CHECK(NOT (is_subscription=TRUE AND state = ''sale'' AND subscription_state=''1_draft''))';


--
-- Name: CONSTRAINT sale_order_sale_subscription_state_coherence_2 ON sale_order; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON CONSTRAINT sale_order_sale_subscription_state_coherence_2 ON public.sale_order IS 'CHECK(NOT (is_subscription=TRUE AND state in (''draft'', ''sent'') AND subscription_state in (''3_progress'', ''4_paused'')) )';


--
-- Name: stock_picking_stock_tag_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.stock_picking_stock_tag_rel (
    picking_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.stock_picking_stock_tag_rel OWNER TO ductin;

--
-- Name: TABLE stock_picking_stock_tag_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.stock_picking_stock_tag_rel IS 'RELATION BETWEEN stock_picking AND stock_tag';


--
-- Name: stock_tag; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.stock_tag (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_tag OWNER TO ductin;

--
-- Name: TABLE stock_tag; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.stock_tag IS 'Stock Tag';


--
-- Name: COLUMN stock_tag.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.stock_tag.sequence IS 'Sequence';


--
-- Name: COLUMN stock_tag.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.stock_tag.create_uid IS 'Created by';


--
-- Name: COLUMN stock_tag.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.stock_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_tag.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.stock_tag.name IS 'Tag Name';


--
-- Name: COLUMN stock_tag.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.stock_tag.active IS 'Active';


--
-- Name: COLUMN stock_tag.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.stock_tag.create_date IS 'Created on';


--
-- Name: COLUMN stock_tag.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.stock_tag.write_date IS 'Last Updated on';


--
-- Name: bad_debt_report_data; Type: MATERIALIZED VIEW; Schema: public; Owner: ductin
--

CREATE MATERIALIZED VIEW public.bad_debt_report_data AS
 WITH cte_invoice_info_base AS MATERIALIZED (
         SELECT am.delivery_date,
            (date_trunc('month'::text, (am.delivery_date)::timestamp with time zone))::date AS delivery_month,
            (((fr.full_reconcile_date AT TIME ZONE 'UTC'::text) AT TIME ZONE 'Europe/Brussels'::text))::date AS full_reconcile_date,
            so.id AS sale_id,
            so.payment_status,
            so.delivery_status,
            am.id AS invoice_id,
            so.user_id,
            so.team_id,
            so.company_id,
            so.partner_id,
            so.crm_group_id,
            so.opportunity_id,
            rp.country_id,
            rc.currency_id,
            am.inverse_amount_total AS ship_amount,
            am.amount_total AS currency_ship_amount,
            so.hide_data_period,
            am.invoice_date,
            am.state,
            am.move_type,
            am.payment_state
           FROM ((((public.account_move am
             JOIN public.sale_order so ON (((so.name)::text = (am.invoice_origin)::text)))
             LEFT JOIN public.res_partner rp ON ((rp.id = so.partner_id)))
             LEFT JOIN public.res_company rc ON ((rc.id = so.company_id)))
             LEFT JOIN ( SELECT DISTINCT aml.move_id,
                    aml.full_reconcile_id,
                    (((fr_1.create_date AT TIME ZONE 'UTC'::text) AT TIME ZONE 'Europe/Brussels'::text))::date AS full_reconcile_date
                   FROM (public.account_move_line aml
                     JOIN public.account_full_reconcile fr_1 ON ((aml.full_reconcile_id = fr_1.id)))
                  WHERE (aml.full_reconcile_id IS NOT NULL)) fr ON ((am.id = fr.move_id)))
          WHERE (((am.move_type)::text = 'out_invoice'::text) AND ((am.state)::text = 'posted'::text) AND (am.inverse_amount_total > (0)::numeric) AND (am.delivery_date IS NOT NULL))
        ), cte_invoice_info AS (
         SELECT t.month_date AS report_month,
            i.delivery_date,
            i.delivery_month,
            i.full_reconcile_date,
            i.sale_id,
            i.payment_status,
            i.delivery_status,
            i.invoice_id,
            i.user_id,
            i.team_id,
            i.company_id,
            i.partner_id,
            i.crm_group_id,
            i.opportunity_id,
            i.country_id,
            i.currency_id,
            i.ship_amount,
            i.currency_ship_amount,
            i.hide_data_period,
            i.invoice_date,
            i.state,
            i.move_type,
            i.payment_state
           FROM (cte_invoice_info_base i
             CROSS JOIN LATERAL ( SELECT (gs.gs)::date AS month_date
                   FROM generate_series((i.delivery_month)::timestamp with time zone, GREATEST((i.delivery_month)::timestamp with time zone,
                        CASE
                            WHEN ((i.full_reconcile_date IS NOT NULL) AND (i.full_reconcile_date <= ((i.delivery_month + '1 mon'::interval) + '14 days'::interval))) THEN (i.delivery_month)::timestamp with time zone
                            WHEN ((i.full_reconcile_date IS NOT NULL) AND (i.full_reconcile_date > ((i.delivery_month + '1 mon'::interval) + '14 days'::interval)) AND (EXTRACT(day FROM i.full_reconcile_date) > (6)::numeric)) THEN (i.full_reconcile_date)::timestamp with time zone
                            ELSE COALESCE((i.full_reconcile_date)::timestamp with time zone,
                            CASE
                                WHEN (EXTRACT(day FROM CURRENT_DATE) > (6)::numeric) THEN date_trunc('month'::text, (CURRENT_DATE)::timestamp with time zone)
                                ELSE (date_trunc('month'::text, (CURRENT_DATE)::timestamp with time zone) - '1 mon'::interval)
                            END)
                        END), '1 mon'::interval) gs(gs)) t)
        ), cte_payment_amounts AS (
         SELECT inv_move.id AS invoice_id,
            apr.amount AS payment_amount,
            apr.debit_amount_currency AS currency_payment_amount,
            (((pay.payment_date AT TIME ZONE 'UTC'::text) AT TIME ZONE 'Europe/Brussels'::text))::date AS payment_date,
            (date_trunc('month'::text, (inv_move.delivery_date)::timestamp with time zone))::date AS delivery_month,
            (((date_trunc('month'::text, (inv_move.delivery_date)::timestamp with time zone) + '1 mon'::interval) + '14 days'::interval))::date AS reward_period
           FROM (((((public.account_partial_reconcile apr
             JOIN public.account_move_line inv_aml ON ((apr.debit_move_id = inv_aml.id)))
             JOIN public.account_move inv_move ON (((inv_aml.move_id = inv_move.id) AND ((inv_move.move_type)::text = 'out_invoice'::text) AND ((inv_move.state)::text = 'posted'::text))))
             JOIN public.account_move_line pay_aml ON ((apr.credit_move_id = pay_aml.id)))
             JOIN public.account_move pay_move ON (((pay_aml.move_id = pay_move.id) AND ((pay_move.move_type)::text = 'entry'::text))))
             JOIN public.account_payment pay ON ((pay.move_id = pay_move.id)))
          WHERE (((pay.state)::text = 'paid'::text) AND (inv_move.delivery_date IS NOT NULL) AND (pay.payment_date IS NOT NULL))
        ), cte_pay_report AS (
         SELECT pa.invoice_id,
            pa.payment_amount,
            pa.currency_payment_amount,
                CASE
                    WHEN (pa.payment_date <= pa.reward_period) THEN (pa.delivery_month)::timestamp without time zone
                    WHEN (EXTRACT(day FROM pa.payment_date) > (6)::numeric) THEN ((date_trunc('month'::text, (pa.payment_date)::timestamp with time zone))::date)::timestamp without time zone
                    ELSE ((date_trunc('month'::text, (pa.payment_date)::timestamp with time zone))::date - '1 mon'::interval)
                END AS report_month
           FROM cte_payment_amounts pa
          WHERE (pa.payment_date IS NOT NULL)
        ), cte_real_credit AS (
         SELECT inv_move.reversed_entry_id AS invoice_id,
            (- pay.amount_company_currency_signed) AS credit_amount,
            pay.amount AS currency_credit_amount,
            (((pay.payment_date AT TIME ZONE 'UTC'::text) AT TIME ZONE 'Europe/Brussels'::text))::date AS credit_date,
            (((date_trunc('month'::text, (inv_move.delivery_date)::timestamp with time zone) + '1 mon'::interval) + '14 days'::interval))::date AS reward_period,
            (date_trunc('month'::text, (inv_move.delivery_date)::timestamp with time zone))::date AS delivery_month
           FROM (((((public.account_partial_reconcile apr
             JOIN public.account_move_line inv_aml ON ((apr.credit_move_id = inv_aml.id)))
             JOIN public.account_move inv_move ON (((inv_aml.move_id = inv_move.id) AND ((inv_move.move_type)::text = 'out_refund'::text) AND ((inv_move.state)::text = 'posted'::text))))
             JOIN public.account_move_line pay_aml ON ((apr.debit_move_id = pay_aml.id)))
             JOIN public.account_move pay_move ON (((pay_aml.move_id = pay_move.id) AND ((pay_move.move_type)::text = 'entry'::text))))
             LEFT JOIN public.account_payment pay ON ((pay.move_id = pay_move.id)))
          WHERE (((pay.state)::text = 'paid'::text) AND (inv_move.delivery_date IS NOT NULL) AND (pay.payment_date IS NOT NULL))
        ), cte_unpaid_credit AS (
         SELECT inv_move.reversed_entry_id AS invoice_id,
            apr.amount AS credit_amount,
            apr.credit_amount_currency AS currency_credit_amount,
            inv_move.invoice_date AS credit_date,
            (((date_trunc('month'::text, (inv_move.delivery_date)::timestamp with time zone) + '1 mon'::interval) + '14 days'::interval))::date AS reward_period,
            (date_trunc('month'::text, (inv_move.delivery_date)::timestamp with time zone))::date AS delivery_month
           FROM ((((public.account_partial_reconcile apr
             JOIN public.account_move_line inv_aml ON ((apr.credit_move_id = inv_aml.id)))
             JOIN public.account_move inv_move ON (((inv_aml.move_id = inv_move.id) AND ((inv_move.move_type)::text = 'out_refund'::text) AND ((inv_move.state)::text = 'posted'::text) AND ((inv_move.payment_state)::text = ANY ((ARRAY['paid'::character varying, 'partial'::character varying])::text[])))))
             JOIN public.account_move_line pay_aml ON ((apr.debit_move_id = pay_aml.id)))
             JOIN public.account_move pay_move ON (((pay_aml.move_id = pay_move.id) AND (inv_move.reversed_entry_id = pay_move.id) AND ((pay_move.move_type)::text = 'out_invoice'::text))))
        ), cte_real_credit_report AS (
         SELECT cte_real_credit.invoice_id,
            cte_real_credit.credit_amount,
            cte_real_credit.currency_credit_amount,
                CASE
                    WHEN (cte_real_credit.credit_date <= cte_real_credit.reward_period) THEN (cte_real_credit.delivery_month)::timestamp without time zone
                    WHEN (EXTRACT(day FROM cte_real_credit.credit_date) > (6)::numeric) THEN ((date_trunc('month'::text, (cte_real_credit.credit_date)::timestamp with time zone))::date)::timestamp without time zone
                    ELSE ((date_trunc('month'::text, (cte_real_credit.credit_date)::timestamp with time zone))::date - '1 mon'::interval)
                END AS report_month
           FROM cte_real_credit
          WHERE (cte_real_credit.credit_date IS NOT NULL)
        ), cte_unpaid_credit_report AS (
         SELECT cte_unpaid_credit.invoice_id,
            cte_unpaid_credit.credit_amount,
            cte_unpaid_credit.currency_credit_amount,
                CASE
                    WHEN (cte_unpaid_credit.credit_date <= cte_unpaid_credit.reward_period) THEN (cte_unpaid_credit.delivery_month)::timestamp without time zone
                    WHEN (EXTRACT(day FROM cte_unpaid_credit.credit_date) > (6)::numeric) THEN ((date_trunc('month'::text, (cte_unpaid_credit.credit_date)::timestamp with time zone))::date)::timestamp without time zone
                    ELSE ((date_trunc('month'::text, (cte_unpaid_credit.credit_date)::timestamp with time zone))::date - '1 mon'::interval)
                END AS report_month
           FROM cte_unpaid_credit
          WHERE (cte_unpaid_credit.credit_date IS NOT NULL)
        ), cte_all_credit_report AS MATERIALIZED (
         SELECT cte_real_credit_report.invoice_id,
            cte_real_credit_report.credit_amount,
            cte_real_credit_report.currency_credit_amount,
            cte_real_credit_report.report_month
           FROM cte_real_credit_report
        UNION ALL
         SELECT cte_unpaid_credit_report.invoice_id,
            cte_unpaid_credit_report.credit_amount,
            cte_unpaid_credit_report.currency_credit_amount,
            cte_unpaid_credit_report.report_month
           FROM cte_unpaid_credit_report
        ), cte_invoice_cumulative AS (
         SELECT i.report_month,
            i.delivery_date,
            i.delivery_month,
            i.full_reconcile_date,
            i.sale_id,
            i.payment_status,
            i.delivery_status,
            i.invoice_id,
            i.user_id,
            i.team_id,
            i.company_id,
            i.partner_id,
            i.crm_group_id,
            i.opportunity_id,
            i.country_id,
            i.currency_id,
            i.ship_amount,
            i.currency_ship_amount,
            i.hide_data_period,
            i.invoice_date,
            i.state,
            i.move_type,
            i.payment_state,
            COALESCE(cr.credit_amount, (0)::numeric) AS real_credit_amount,
            COALESCE(cr.currency_credit_amount, (0)::numeric) AS currency_real_credit_amount,
            COALESCE(cu.credit_amount, (0)::numeric) AS credit_unpaid_amount,
            COALESCE(cu.currency_credit_amount, (0)::numeric) AS currency_unpaid_credit_amount,
            COALESCE(ca.credit_amount, (0)::numeric) AS credit_all_amount,
            COALESCE(ca.currency_credit_amount, (0)::numeric) AS currency_all_credit_amount,
            COALESCE(p.payment_amount, (0)::numeric) AS paid_amount,
            COALESCE(p.currency_payment_amount, (0)::numeric) AS currency_paid_amount,
            sum(COALESCE(p.payment_amount, (0)::numeric)) OVER w AS cumulative_payment_amount,
            sum(COALESCE(p.currency_payment_amount, (0)::numeric)) OVER w AS cumulative_currency_payment_amount,
            sum(COALESCE(cr.credit_amount, (0)::numeric)) OVER w AS cumulative_real_credit_amount,
            sum(COALESCE(cr.currency_credit_amount, (0)::numeric)) OVER w AS cumulative_real_currency_credit_amount,
            sum(COALESCE(cu.credit_amount, (0)::numeric)) OVER w AS cumulative_unpaid_credit_amount,
            sum(COALESCE(cu.currency_credit_amount, (0)::numeric)) OVER w AS cumulative_unpaid_currency_credit_amount,
            sum(COALESCE(ca.credit_amount, (0)::numeric)) OVER w AS cumulative_all_credit_amount,
            sum(COALESCE(ca.currency_credit_amount, (0)::numeric)) OVER w AS cumulative_all_currency_credit_amount,
            row_number() OVER w AS month_count
           FROM ((((cte_invoice_info i
             LEFT JOIN ( SELECT cte_real_credit_report.invoice_id,
                    cte_real_credit_report.report_month,
                    sum(cte_real_credit_report.credit_amount) AS credit_amount,
                    sum(cte_real_credit_report.currency_credit_amount) AS currency_credit_amount
                   FROM cte_real_credit_report
                  GROUP BY cte_real_credit_report.invoice_id, cte_real_credit_report.report_month) cr ON (((i.invoice_id = cr.invoice_id) AND (i.report_month = cr.report_month))))
             LEFT JOIN ( SELECT cte_unpaid_credit_report.invoice_id,
                    cte_unpaid_credit_report.report_month,
                    sum(cte_unpaid_credit_report.credit_amount) AS credit_amount,
                    sum(cte_unpaid_credit_report.currency_credit_amount) AS currency_credit_amount
                   FROM cte_unpaid_credit_report
                  GROUP BY cte_unpaid_credit_report.invoice_id, cte_unpaid_credit_report.report_month) cu ON (((i.invoice_id = cu.invoice_id) AND (i.report_month = cu.report_month))))
             LEFT JOIN ( SELECT cte_all_credit_report.invoice_id,
                    cte_all_credit_report.report_month,
                    sum(cte_all_credit_report.credit_amount) AS credit_amount,
                    sum(cte_all_credit_report.currency_credit_amount) AS currency_credit_amount
                   FROM cte_all_credit_report
                  GROUP BY cte_all_credit_report.invoice_id, cte_all_credit_report.report_month) ca ON (((i.invoice_id = ca.invoice_id) AND (i.report_month = ca.report_month))))
             LEFT JOIN ( SELECT cte_pay_report.invoice_id,
                    cte_pay_report.report_month,
                    sum(cte_pay_report.payment_amount) AS payment_amount,
                    sum(cte_pay_report.currency_payment_amount) AS currency_payment_amount
                   FROM cte_pay_report
                  GROUP BY cte_pay_report.invoice_id, cte_pay_report.report_month) p ON (((i.invoice_id = p.invoice_id) AND (i.report_month = p.report_month))))
          WINDOW w AS (PARTITION BY i.invoice_id ORDER BY i.report_month ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)
        ), cte_calc_amounts AS (
         SELECT i.report_month,
            i.delivery_date,
            i.delivery_month,
            i.full_reconcile_date,
            i.sale_id,
            i.payment_status,
            i.delivery_status,
            i.invoice_id,
            i.user_id,
            i.team_id,
            i.company_id,
            i.partner_id,
            i.crm_group_id,
            i.opportunity_id,
            i.country_id,
            i.currency_id,
            i.ship_amount,
            i.currency_ship_amount,
            i.hide_data_period,
            i.invoice_date,
            i.state,
            i.move_type,
            i.payment_state,
            i.real_credit_amount,
            i.currency_real_credit_amount,
            i.credit_unpaid_amount,
            i.currency_unpaid_credit_amount,
            i.credit_all_amount,
            i.currency_all_credit_amount,
            i.paid_amount,
            i.currency_paid_amount,
            i.cumulative_payment_amount,
            i.cumulative_currency_payment_amount,
            i.cumulative_real_credit_amount,
            i.cumulative_real_currency_credit_amount,
            i.cumulative_unpaid_credit_amount,
            i.cumulative_unpaid_currency_credit_amount,
            i.cumulative_all_credit_amount,
            i.cumulative_all_currency_credit_amount,
            i.month_count,
            ((i.ship_amount - i.cumulative_payment_amount) - i.cumulative_unpaid_credit_amount) AS remaining_amount,
            ((i.currency_ship_amount - i.cumulative_currency_payment_amount) - i.cumulative_unpaid_currency_credit_amount) AS remaining_currency_amount,
            ((i.currency_ship_amount - i.cumulative_real_currency_credit_amount) - i.cumulative_unpaid_currency_credit_amount) AS cumulative_currency_invoice_amount_after_credit
           FROM cte_invoice_cumulative i
        ), cte_invoice_with_lost_tag AS (
         SELECT c_1.report_month,
            c_1.delivery_date,
            c_1.delivery_month,
            c_1.full_reconcile_date,
            c_1.sale_id,
            c_1.payment_status,
            c_1.delivery_status,
            c_1.invoice_id,
            c_1.user_id,
            c_1.team_id,
            c_1.company_id,
            c_1.partner_id,
            c_1.crm_group_id,
            c_1.opportunity_id,
            c_1.country_id,
            c_1.currency_id,
            c_1.ship_amount,
            c_1.currency_ship_amount,
            c_1.hide_data_period,
            c_1.invoice_date,
            c_1.state,
            c_1.move_type,
            c_1.payment_state,
            c_1.real_credit_amount,
            c_1.currency_real_credit_amount,
            c_1.credit_unpaid_amount,
            c_1.currency_unpaid_credit_amount,
            c_1.credit_all_amount,
            c_1.currency_all_credit_amount,
            c_1.paid_amount,
            c_1.currency_paid_amount,
            c_1.cumulative_payment_amount,
            c_1.cumulative_currency_payment_amount,
            c_1.cumulative_real_credit_amount,
            c_1.cumulative_real_currency_credit_amount,
            c_1.cumulative_unpaid_credit_amount,
            c_1.cumulative_unpaid_currency_credit_amount,
            c_1.cumulative_all_credit_amount,
            c_1.cumulative_all_currency_credit_amount,
            c_1.month_count,
            c_1.remaining_amount,
            c_1.remaining_currency_amount,
            c_1.cumulative_currency_invoice_amount_after_credit,
                CASE
                    WHEN (tag.id IS NOT NULL) THEN 1
                    ELSE 0
                END AS has_lost_tag
           FROM (cte_calc_amounts c_1
             LEFT JOIN ( SELECT DISTINCT am.id
                   FROM ((public.account_move am
                     JOIN public.stock_picking_stock_tag_rel r ON ((am.origin_picking_id = r.picking_id)))
                     JOIN public.stock_tag st ON ((r.tag_id = st.id)))
                  WHERE ((st.active = true) AND ((st.name)::text = 'Đơn thất lạc'::text))) tag ON ((c_1.invoice_id = tag.id)))
        ), bad_debt_cte AS (
         SELECT c_1.report_month,
            c_1.delivery_date,
            c_1.delivery_month,
            c_1.full_reconcile_date,
            c_1.sale_id,
            c_1.payment_status,
            c_1.delivery_status,
            c_1.invoice_id,
            c_1.user_id,
            c_1.team_id,
            c_1.company_id,
            c_1.partner_id,
            c_1.crm_group_id,
            c_1.opportunity_id,
            c_1.country_id,
            c_1.currency_id,
            c_1.ship_amount,
            c_1.currency_ship_amount,
            c_1.hide_data_period,
            c_1.invoice_date,
            c_1.state,
            c_1.move_type,
            c_1.payment_state,
            c_1.real_credit_amount,
            c_1.currency_real_credit_amount,
            c_1.credit_unpaid_amount,
            c_1.currency_unpaid_credit_amount,
            c_1.credit_all_amount,
            c_1.currency_all_credit_amount,
            c_1.paid_amount,
            c_1.currency_paid_amount,
            c_1.cumulative_payment_amount,
            c_1.cumulative_currency_payment_amount,
            c_1.cumulative_real_credit_amount,
            c_1.cumulative_real_currency_credit_amount,
            c_1.cumulative_unpaid_credit_amount,
            c_1.cumulative_unpaid_currency_credit_amount,
            c_1.cumulative_all_credit_amount,
            c_1.cumulative_all_currency_credit_amount,
            c_1.month_count,
            c_1.remaining_amount,
            c_1.remaining_currency_amount,
            c_1.cumulative_currency_invoice_amount_after_credit,
            c_1.has_lost_tag,
                CASE
                    WHEN (c_1.has_lost_tag = 1) THEN false
                    WHEN ((c_1.country_id = 121) AND (c_1.remaining_currency_amount <= (5000)::numeric)) THEN false
                    WHEN (c_1.remaining_currency_amount > (0)::numeric) THEN true
                    ELSE false
                END AS is_bad_debt
           FROM cte_invoice_with_lost_tag c_1
        ), bad_debt_sequence_cte AS (
         SELECT a.invoice_id,
            COALESCE((b.bad_debt_sequence)::bigint, row_number() OVER (PARTITION BY a.user_id, a.delivery_month, a.report_month, a.country_id ORDER BY a.delivery_date, a.invoice_id)) AS bad_debt_sequence
           FROM (bad_debt_cte a
             LEFT JOIN public.bad_debt_sequence_data b ON ((a.invoice_id = b.invoice_id)))
          WHERE ((a.is_bad_debt = true) AND (a.month_count = 2))
        ), bad_debt_penalty_cte AS (
         SELECT a.report_month,
            a.delivery_date,
            a.delivery_month,
            a.full_reconcile_date,
            a.sale_id,
            a.payment_status,
            a.delivery_status,
            a.invoice_id,
            a.user_id,
            a.team_id,
            a.company_id,
            a.partner_id,
            a.crm_group_id,
            a.opportunity_id,
            a.country_id,
            a.currency_id,
            a.ship_amount,
            a.currency_ship_amount,
            a.hide_data_period,
            a.invoice_date,
            a.state,
            a.move_type,
            a.payment_state,
            a.real_credit_amount,
            a.currency_real_credit_amount,
            a.credit_unpaid_amount,
            a.currency_unpaid_credit_amount,
            a.credit_all_amount,
            a.currency_all_credit_amount,
            a.paid_amount,
            a.currency_paid_amount,
            a.cumulative_payment_amount,
            a.cumulative_currency_payment_amount,
            a.cumulative_real_credit_amount,
            a.cumulative_real_currency_credit_amount,
            a.cumulative_unpaid_credit_amount,
            a.cumulative_unpaid_currency_credit_amount,
            a.cumulative_all_credit_amount,
            a.cumulative_all_currency_credit_amount,
            a.month_count,
            a.remaining_amount,
            a.remaining_currency_amount,
            a.cumulative_currency_invoice_amount_after_credit,
            a.has_lost_tag,
            a.is_bad_debt,
            b.bad_debt_sequence,
                CASE
                    WHEN (a.country_id = 121) THEN
                    CASE
                        WHEN (b.bad_debt_sequence = 3) THEN 0.20
                        WHEN (b.bad_debt_sequence = 4) THEN 0.30
                        WHEN (b.bad_debt_sequence = 5) THEN 0.50
                        WHEN (b.bad_debt_sequence > 5) THEN (1)::numeric
                        ELSE NULL::numeric
                    END
                    WHEN (a.country_id = 233) THEN
                    CASE
                        WHEN (b.bad_debt_sequence = 3) THEN 0.10
                        WHEN (b.bad_debt_sequence = 4) THEN 0.20
                        WHEN (b.bad_debt_sequence = 5) THEN 0.50
                        WHEN (b.bad_debt_sequence > 5) THEN (1)::numeric
                        ELSE NULL::numeric
                    END
                    ELSE NULL::numeric
                END AS penalty_multiplier
           FROM (bad_debt_cte a
             LEFT JOIN bad_debt_sequence_cte b ON ((a.invoice_id = b.invoice_id)))
        )
 SELECT row_number() OVER (ORDER BY c.invoice_id, c.delivery_month) AS id,
    c.report_month,
    c.delivery_date,
    c.delivery_month,
    c.full_reconcile_date,
    c.sale_id,
    c.payment_status,
    c.delivery_status,
    c.invoice_id,
    c.user_id,
    c.team_id,
    c.company_id,
    c.partner_id,
    c.crm_group_id,
    c.opportunity_id,
    c.country_id,
    c.currency_id,
    c.ship_amount,
    c.currency_ship_amount,
    c.hide_data_period,
    c.invoice_date,
    c.state,
    c.move_type,
    c.payment_state,
    c.real_credit_amount,
    c.currency_real_credit_amount,
    c.credit_unpaid_amount,
    c.currency_unpaid_credit_amount,
    c.credit_all_amount,
    c.currency_all_credit_amount,
    c.paid_amount,
    c.currency_paid_amount,
    c.cumulative_payment_amount,
    c.cumulative_currency_payment_amount,
    c.cumulative_real_credit_amount,
    c.cumulative_real_currency_credit_amount,
    c.cumulative_unpaid_credit_amount,
    c.cumulative_unpaid_currency_credit_amount,
    c.cumulative_all_credit_amount,
    c.cumulative_all_currency_credit_amount,
    c.month_count,
    c.remaining_amount,
    c.remaining_currency_amount,
    c.cumulative_currency_invoice_amount_after_credit,
    c.has_lost_tag,
    c.is_bad_debt,
    c.bad_debt_sequence,
    c.penalty_multiplier,
    crm.crm_type,
    crm.user_marketing_id,
    crm.marketing_team_id,
    c.remaining_amount AS bad_debt_amount,
    c.remaining_currency_amount AS currency_bad_debt_amount,
        CASE
            WHEN ((c.month_count = 2) AND (c.bad_debt_sequence IS NOT NULL)) THEN (c.remaining_amount * c.penalty_multiplier)
            ELSE (0)::numeric
        END AS penalty_amount,
        CASE
            WHEN ((c.month_count >= 3) AND (c.bad_debt_sequence IS NOT NULL)) THEN (c.paid_amount * c.penalty_multiplier)
            ELSE (0)::numeric
        END AS return_penalty_amount,
        CASE
            WHEN ((((c.country_id = 121) AND (c.remaining_currency_amount <= (5000)::numeric)) OR (c.remaining_currency_amount = (0)::numeric)) AND (c.cumulative_currency_invoice_amount_after_credit > (0)::numeric) AND (c.month_count = 1)) THEN true
            ELSE false
        END AS is_complete
   FROM (bad_debt_penalty_cte c
     LEFT JOIN public.crm_lead crm ON ((crm.id = c.opportunity_id)))
  WITH NO DATA;


ALTER MATERIALIZED VIEW public.bad_debt_report_data OWNER TO ductin;

--
-- Name: bad_debt_sequence_data_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.bad_debt_sequence_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bad_debt_sequence_data_id_seq OWNER TO ductin;

--
-- Name: bad_debt_sequence_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.bad_debt_sequence_data_id_seq OWNED BY public.bad_debt_sequence_data.id;


--
-- Name: badge_unlocked_definition_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.badge_unlocked_definition_rel (
    gamification_badge_id integer NOT NULL,
    gamification_goal_definition_id integer NOT NULL
);


ALTER TABLE public.badge_unlocked_definition_rel OWNER TO ductin;

--
-- Name: TABLE badge_unlocked_definition_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.badge_unlocked_definition_rel IS 'RELATION BETWEEN gamification_badge AND gamification_goal_definition';


--
-- Name: barcode_nomenclature; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.barcode_nomenclature (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    upc_ean_conv character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    gs1_separator_fnc1 character varying,
    is_gs1_nomenclature boolean
);


ALTER TABLE public.barcode_nomenclature OWNER TO ductin;

--
-- Name: TABLE barcode_nomenclature; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.barcode_nomenclature IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_nomenclature.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_nomenclature.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_nomenclature.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_nomenclature.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_nomenclature.name IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.upc_ean_conv; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_nomenclature.upc_ean_conv IS 'UPC/EAN Conversion';


--
-- Name: COLUMN barcode_nomenclature.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_nomenclature.create_date IS 'Created on';


--
-- Name: COLUMN barcode_nomenclature.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_nomenclature.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_nomenclature.gs1_separator_fnc1; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_nomenclature.gs1_separator_fnc1 IS 'FNC1 Separator';


--
-- Name: COLUMN barcode_nomenclature.is_gs1_nomenclature; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_nomenclature.is_gs1_nomenclature IS 'Is GS1 Nomenclature';


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.barcode_nomenclature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNER TO ductin;

--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNED BY public.barcode_nomenclature.id;


--
-- Name: barcode_rule; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.barcode_rule (
    id integer NOT NULL,
    barcode_nomenclature_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    encoding character varying NOT NULL,
    type character varying NOT NULL,
    pattern character varying NOT NULL,
    alias character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    associated_uom_id integer,
    gs1_content_type character varying,
    gs1_decimal_usage boolean
);


ALTER TABLE public.barcode_rule OWNER TO ductin;

--
-- Name: TABLE barcode_rule; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.barcode_rule IS 'Barcode Rule';


--
-- Name: COLUMN barcode_rule.barcode_nomenclature_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.barcode_nomenclature_id IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_rule.sequence; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.sequence IS 'Sequence';


--
-- Name: COLUMN barcode_rule.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_rule.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_rule.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.name IS 'Rule Name';


--
-- Name: COLUMN barcode_rule.encoding; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.encoding IS 'Encoding';


--
-- Name: COLUMN barcode_rule.type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.type IS 'Type';


--
-- Name: COLUMN barcode_rule.pattern; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.pattern IS 'Barcode Pattern';


--
-- Name: COLUMN barcode_rule.alias; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.alias IS 'Alias';


--
-- Name: COLUMN barcode_rule.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.create_date IS 'Created on';


--
-- Name: COLUMN barcode_rule.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_rule.associated_uom_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.associated_uom_id IS 'Associated Uom';


--
-- Name: COLUMN barcode_rule.gs1_content_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.gs1_content_type IS 'GS1 Content Type';


--
-- Name: COLUMN barcode_rule.gs1_decimal_usage; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.barcode_rule.gs1_decimal_usage IS 'Decimal';


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.barcode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_rule_id_seq OWNER TO ductin;

--
-- Name: barcode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.barcode_rule_id_seq OWNED BY public.barcode_rule.id;


--
-- Name: base_automation; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation (
    id integer NOT NULL,
    model_id integer NOT NULL,
    trg_selection_field_id integer,
    trg_field_ref integer,
    trg_date_id integer,
    trg_date_range integer,
    trg_date_calendar_id integer,
    create_uid integer,
    write_uid integer,
    webhook_uuid character varying,
    record_getter character varying,
    trigger character varying NOT NULL,
    trg_date_range_type character varying,
    filter_pre_domain character varying,
    filter_domain character varying,
    name jsonb NOT NULL,
    description text,
    log_webhook_calls boolean,
    active boolean,
    last_run timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    trg_date_resource_field_id integer,
    is_sale_order_alert boolean
);


ALTER TABLE public.base_automation OWNER TO ductin;

--
-- Name: TABLE base_automation; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation IS 'Automation Rule';


--
-- Name: COLUMN base_automation.model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.model_id IS 'Model';


--
-- Name: COLUMN base_automation.trg_selection_field_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.trg_selection_field_id IS 'Trigger Field';


--
-- Name: COLUMN base_automation.trg_field_ref; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.trg_field_ref IS 'Trigger Reference';


--
-- Name: COLUMN base_automation.trg_date_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.trg_date_id IS 'Trigger Date';


--
-- Name: COLUMN base_automation.trg_date_range; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.trg_date_range IS 'Delay after trigger date';


--
-- Name: COLUMN base_automation.trg_date_calendar_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.trg_date_calendar_id IS 'Use Calendar';


--
-- Name: COLUMN base_automation.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation.webhook_uuid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.webhook_uuid IS 'Webhook UUID';


--
-- Name: COLUMN base_automation.record_getter; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.record_getter IS 'Record Getter';


--
-- Name: COLUMN base_automation.trigger; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.trigger IS 'Trigger';


--
-- Name: COLUMN base_automation.trg_date_range_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.trg_date_range_type IS 'Delay type';


--
-- Name: COLUMN base_automation.filter_pre_domain; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.filter_pre_domain IS 'Before Update Domain';


--
-- Name: COLUMN base_automation.filter_domain; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.filter_domain IS 'Apply on';


--
-- Name: COLUMN base_automation.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.name IS 'Automation Rule Name';


--
-- Name: COLUMN base_automation.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.description IS 'Description';


--
-- Name: COLUMN base_automation.log_webhook_calls; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.log_webhook_calls IS 'Log Calls';


--
-- Name: COLUMN base_automation.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.active IS 'Active';


--
-- Name: COLUMN base_automation.last_run; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.last_run IS 'Last Run';


--
-- Name: COLUMN base_automation.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.create_date IS 'Created on';


--
-- Name: COLUMN base_automation.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_automation.trg_date_resource_field_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.trg_date_resource_field_id IS 'Use employee work schedule';


--
-- Name: COLUMN base_automation.is_sale_order_alert; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation.is_sale_order_alert IS 'Is Sale Order Alert';


--
-- Name: base_automation_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_automation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_id_seq OWNER TO ductin;

--
-- Name: base_automation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_automation_id_seq OWNED BY public.base_automation.id;


--
-- Name: base_automation_ir_model_fields_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_ir_model_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_ir_model_fields_rel OWNER TO ductin;

--
-- Name: TABLE base_automation_ir_model_fields_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_ir_model_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_lead_test; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_lead_test (
    id integer NOT NULL,
    user_id integer,
    partner_id integer,
    stage_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    active boolean,
    employee boolean,
    priority boolean,
    deadline boolean,
    is_assigned_to_admin boolean,
    date_automation_last timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_automation_lead_test OWNER TO ductin;

--
-- Name: TABLE base_automation_lead_test; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_lead_test IS 'Automated Rule Test';


--
-- Name: COLUMN base_automation_lead_test.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.user_id IS 'Responsible';


--
-- Name: COLUMN base_automation_lead_test.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.partner_id IS 'Partner';


--
-- Name: COLUMN base_automation_lead_test.stage_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.stage_id IS 'Stage';


--
-- Name: COLUMN base_automation_lead_test.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation_lead_test.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation_lead_test.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.name IS 'Subject';


--
-- Name: COLUMN base_automation_lead_test.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.state IS 'Status';


--
-- Name: COLUMN base_automation_lead_test.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.active IS 'Active';


--
-- Name: COLUMN base_automation_lead_test.employee; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.employee IS 'Employee';


--
-- Name: COLUMN base_automation_lead_test.priority; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.priority IS 'Priority';


--
-- Name: COLUMN base_automation_lead_test.deadline; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.deadline IS 'Deadline';


--
-- Name: COLUMN base_automation_lead_test.is_assigned_to_admin; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.is_assigned_to_admin IS 'Assigned to admin user';


--
-- Name: COLUMN base_automation_lead_test.date_automation_last; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.date_automation_last IS 'Last Automation';


--
-- Name: COLUMN base_automation_lead_test.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.create_date IS 'Created on';


--
-- Name: COLUMN base_automation_lead_test.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_test.write_date IS 'Last Updated on';


--
-- Name: base_automation_lead_test_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_automation_lead_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_lead_test_id_seq OWNER TO ductin;

--
-- Name: base_automation_lead_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_automation_lead_test_id_seq OWNED BY public.base_automation_lead_test.id;


--
-- Name: base_automation_lead_test_test_base_automation_tag_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_lead_test_test_base_automation_tag_rel (
    base_automation_lead_test_id integer NOT NULL,
    test_base_automation_tag_id integer NOT NULL
);


ALTER TABLE public.base_automation_lead_test_test_base_automation_tag_rel OWNER TO ductin;

--
-- Name: TABLE base_automation_lead_test_test_base_automation_tag_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_lead_test_test_base_automation_tag_rel IS 'RELATION BETWEEN base_automation_lead_test AND test_base_automation_tag';


--
-- Name: base_automation_lead_thread_test; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_lead_thread_test (
    id integer NOT NULL,
    user_id integer,
    partner_id integer,
    stage_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    active boolean,
    employee boolean,
    priority boolean,
    deadline boolean,
    is_assigned_to_admin boolean,
    date_automation_last timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_automation_lead_thread_test OWNER TO ductin;

--
-- Name: TABLE base_automation_lead_thread_test; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_lead_thread_test IS 'Threaded Lead Test';


--
-- Name: COLUMN base_automation_lead_thread_test.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.user_id IS 'Responsible';


--
-- Name: COLUMN base_automation_lead_thread_test.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.partner_id IS 'Partner';


--
-- Name: COLUMN base_automation_lead_thread_test.stage_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.stage_id IS 'Stage';


--
-- Name: COLUMN base_automation_lead_thread_test.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation_lead_thread_test.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation_lead_thread_test.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.name IS 'Subject';


--
-- Name: COLUMN base_automation_lead_thread_test.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.state IS 'Status';


--
-- Name: COLUMN base_automation_lead_thread_test.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.active IS 'Active';


--
-- Name: COLUMN base_automation_lead_thread_test.employee; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.employee IS 'Employee';


--
-- Name: COLUMN base_automation_lead_thread_test.priority; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.priority IS 'Priority';


--
-- Name: COLUMN base_automation_lead_thread_test.deadline; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.deadline IS 'Deadline';


--
-- Name: COLUMN base_automation_lead_thread_test.is_assigned_to_admin; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.is_assigned_to_admin IS 'Assigned to admin user';


--
-- Name: COLUMN base_automation_lead_thread_test.date_automation_last; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.date_automation_last IS 'Last Automation';


--
-- Name: COLUMN base_automation_lead_thread_test.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.create_date IS 'Created on';


--
-- Name: COLUMN base_automation_lead_thread_test.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_lead_thread_test.write_date IS 'Last Updated on';


--
-- Name: base_automation_lead_thread_test_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_automation_lead_thread_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_lead_thread_test_id_seq OWNER TO ductin;

--
-- Name: base_automation_lead_thread_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_automation_lead_thread_test_id_seq OWNED BY public.base_automation_lead_thread_test.id;


--
-- Name: base_automation_lead_thread_test_test_base_automation_tag_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_lead_thread_test_test_base_automation_tag_rel (
    base_automation_lead_thread_test_id integer NOT NULL,
    test_base_automation_tag_id integer NOT NULL
);


ALTER TABLE public.base_automation_lead_thread_test_test_base_automation_tag_rel OWNER TO ductin;

--
-- Name: TABLE base_automation_lead_thread_test_test_base_automation_tag_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_lead_thread_test_test_base_automation_tag_rel IS 'RELATION BETWEEN base_automation_lead_thread_test AND test_base_automation_tag';


--
-- Name: base_automation_line_test; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_line_test (
    id integer NOT NULL,
    lead_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_automation_line_test OWNER TO ductin;

--
-- Name: TABLE base_automation_line_test; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_line_test IS 'Automated Rule Line Test';


--
-- Name: COLUMN base_automation_line_test.lead_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_line_test.lead_id IS 'Lead';


--
-- Name: COLUMN base_automation_line_test.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_line_test.user_id IS 'User';


--
-- Name: COLUMN base_automation_line_test.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_line_test.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation_line_test.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_line_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation_line_test.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_line_test.name IS 'Name';


--
-- Name: COLUMN base_automation_line_test.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_line_test.create_date IS 'Created on';


--
-- Name: COLUMN base_automation_line_test.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_line_test.write_date IS 'Last Updated on';


--
-- Name: base_automation_line_test_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_automation_line_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_line_test_id_seq OWNER TO ductin;

--
-- Name: base_automation_line_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_automation_line_test_id_seq OWNED BY public.base_automation_line_test.id;


--
-- Name: base_automation_link_test; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_link_test (
    id integer NOT NULL,
    linked_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_automation_link_test OWNER TO ductin;

--
-- Name: TABLE base_automation_link_test; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_link_test IS 'Automated Rule Link Test';


--
-- Name: COLUMN base_automation_link_test.linked_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_link_test.linked_id IS 'Linked';


--
-- Name: COLUMN base_automation_link_test.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_link_test.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation_link_test.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_link_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation_link_test.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_link_test.name IS 'Name';


--
-- Name: COLUMN base_automation_link_test.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_link_test.create_date IS 'Created on';


--
-- Name: COLUMN base_automation_link_test.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_link_test.write_date IS 'Last Updated on';


--
-- Name: base_automation_link_test_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_automation_link_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_link_test_id_seq OWNER TO ductin;

--
-- Name: base_automation_link_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_automation_link_test_id_seq OWNED BY public.base_automation_link_test.id;


--
-- Name: base_automation_linked_test; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_linked_test (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    another_field character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_automation_linked_test OWNER TO ductin;

--
-- Name: TABLE base_automation_linked_test; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_linked_test IS 'Automated Rule Linked Test';


--
-- Name: COLUMN base_automation_linked_test.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_linked_test.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation_linked_test.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_linked_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation_linked_test.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_linked_test.name IS 'Name';


--
-- Name: COLUMN base_automation_linked_test.another_field; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_linked_test.another_field IS 'Another Field';


--
-- Name: COLUMN base_automation_linked_test.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_linked_test.create_date IS 'Created on';


--
-- Name: COLUMN base_automation_linked_test.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_linked_test.write_date IS 'Last Updated on';


--
-- Name: base_automation_linked_test_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_automation_linked_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_linked_test_id_seq OWNER TO ductin;

--
-- Name: base_automation_linked_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_automation_linked_test_id_seq OWNED BY public.base_automation_linked_test.id;


--
-- Name: base_automation_model_with_recname_char; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_model_with_recname_char (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_automation_model_with_recname_char OWNER TO ductin;

--
-- Name: TABLE base_automation_model_with_recname_char; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_model_with_recname_char IS 'Model with Char as _rec_name';


--
-- Name: COLUMN base_automation_model_with_recname_char.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_char.user_id IS 'Responsible';


--
-- Name: COLUMN base_automation_model_with_recname_char.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_char.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation_model_with_recname_char.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_char.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation_model_with_recname_char.description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_char.description IS 'Description';


--
-- Name: COLUMN base_automation_model_with_recname_char.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_char.create_date IS 'Created on';


--
-- Name: COLUMN base_automation_model_with_recname_char.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_char.write_date IS 'Last Updated on';


--
-- Name: base_automation_model_with_recname_char_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_automation_model_with_recname_char_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_model_with_recname_char_id_seq OWNER TO ductin;

--
-- Name: base_automation_model_with_recname_char_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_automation_model_with_recname_char_id_seq OWNED BY public.base_automation_model_with_recname_char.id;


--
-- Name: base_automation_model_with_recname_m2o; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_model_with_recname_m2o (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_automation_model_with_recname_m2o OWNER TO ductin;

--
-- Name: TABLE base_automation_model_with_recname_m2o; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_model_with_recname_m2o IS 'Model with Many2one as _rec_name and name_create';


--
-- Name: COLUMN base_automation_model_with_recname_m2o.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_m2o.user_id IS 'Responsible';


--
-- Name: COLUMN base_automation_model_with_recname_m2o.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_m2o.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation_model_with_recname_m2o.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_m2o.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation_model_with_recname_m2o.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_m2o.create_date IS 'Created on';


--
-- Name: COLUMN base_automation_model_with_recname_m2o.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_automation_model_with_recname_m2o.write_date IS 'Last Updated on';


--
-- Name: base_automation_model_with_recname_m2o_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_automation_model_with_recname_m2o_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_model_with_recname_m2o_id_seq OWNER TO ductin;

--
-- Name: base_automation_model_with_recname_m2o_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_automation_model_with_recname_m2o_id_seq OWNED BY public.base_automation_model_with_recname_m2o.id;


--
-- Name: base_automation_onchange_fields_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_automation_onchange_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_onchange_fields_rel OWNER TO ductin;

--
-- Name: TABLE base_automation_onchange_fields_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_automation_onchange_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_assets OWNER TO ductin;

--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_default OWNER TO ductin;

--
-- Name: base_cache_signaling_groups; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_cache_signaling_groups
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_groups OWNER TO ductin;

--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_routing OWNER TO ductin;

--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_templates OWNER TO ductin;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    from_invoice boolean
);


ALTER TABLE public.base_document_layout OWNER TO ductin;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_document_layout.from_invoice; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_document_layout.from_invoice IS 'From Invoice';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO ductin;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO ductin;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO ductin;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_geo_provider; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_geo_provider (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tech_name character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_geo_provider OWNER TO ductin;

--
-- Name: TABLE base_geo_provider; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_geo_provider IS 'Geo Provider';


--
-- Name: COLUMN base_geo_provider.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_geo_provider.create_uid IS 'Created by';


--
-- Name: COLUMN base_geo_provider.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_geo_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_geo_provider.tech_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_geo_provider.tech_name IS 'Technical Name';


--
-- Name: COLUMN base_geo_provider.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_geo_provider.name IS 'Name';


--
-- Name: COLUMN base_geo_provider.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_geo_provider.create_date IS 'Created on';


--
-- Name: COLUMN base_geo_provider.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_geo_provider.write_date IS 'Last Updated on';


--
-- Name: base_geo_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_geo_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_geo_provider_id_seq OWNER TO ductin;

--
-- Name: base_geo_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_geo_provider_id_seq OWNED BY public.base_geo_provider.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO ductin;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO ductin;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO ductin;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO ductin;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO ductin;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO ductin;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO ductin;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO ductin;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO ductin;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO ductin;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO ductin;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO ductin;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_language_install_website_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_language_install_website_rel (
    base_language_install_id integer NOT NULL,
    website_id integer NOT NULL
);


ALTER TABLE public.base_language_install_website_rel OWNER TO ductin;

--
-- Name: TABLE base_language_install_website_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_language_install_website_rel IS 'RELATION BETWEEN base_language_install AND website';


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO ductin;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO ductin;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO ductin;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO ductin;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO ductin;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO ductin;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO ductin;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO ductin;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO ductin;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO ductin;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO ductin;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO ductin;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO ductin;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO ductin;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO ductin;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO ductin;

--
-- Name: bill_to_po_wizard; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.bill_to_po_wizard (
    id integer NOT NULL,
    purchase_order_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bill_to_po_wizard OWNER TO ductin;

--
-- Name: TABLE bill_to_po_wizard; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.bill_to_po_wizard IS 'Bill to Purchase Order';


--
-- Name: COLUMN bill_to_po_wizard.purchase_order_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bill_to_po_wizard.purchase_order_id IS 'Purchase Order';


--
-- Name: COLUMN bill_to_po_wizard.partner_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bill_to_po_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN bill_to_po_wizard.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bill_to_po_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN bill_to_po_wizard.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bill_to_po_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bill_to_po_wizard.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bill_to_po_wizard.create_date IS 'Created on';


--
-- Name: COLUMN bill_to_po_wizard.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.bill_to_po_wizard.write_date IS 'Last Updated on';


--
-- Name: bill_to_po_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.bill_to_po_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bill_to_po_wizard_id_seq OWNER TO ductin;

--
-- Name: bill_to_po_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.bill_to_po_wizard_id_seq OWNED BY public.bill_to_po_wizard.id;


--
-- Name: binary_test; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.binary_test (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.binary_test OWNER TO ductin;

--
-- Name: TABLE binary_test; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.binary_test IS 'binary.test';


--
-- Name: COLUMN binary_test.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.binary_test.create_uid IS 'Created by';


--
-- Name: COLUMN binary_test.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.binary_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN binary_test.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.binary_test.create_date IS 'Created on';


--
-- Name: COLUMN binary_test.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.binary_test.write_date IS 'Last Updated on';


--
-- Name: binary_test_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.binary_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.binary_test_id_seq OWNER TO ductin;

--
-- Name: binary_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.binary_test_id_seq OWNED BY public.binary_test.id;


--
-- Name: blog_blog; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.blog_blog (
    id integer NOT NULL,
    website_id integer,
    create_uid integer,
    write_uid integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    name jsonb NOT NULL,
    subtitle jsonb,
    content jsonb,
    cover_properties text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.blog_blog OWNER TO ductin;

--
-- Name: TABLE blog_blog; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.blog_blog IS 'Blog';


--
-- Name: COLUMN blog_blog.website_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.website_id IS 'Website';


--
-- Name: COLUMN blog_blog.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.create_uid IS 'Created by';


--
-- Name: COLUMN blog_blog.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.write_uid IS 'Last Updated by';


--
-- Name: COLUMN blog_blog.website_meta_og_img; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN blog_blog.website_meta_title; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN blog_blog.website_meta_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN blog_blog.website_meta_keywords; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN blog_blog.seo_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.seo_name IS 'Seo name';


--
-- Name: COLUMN blog_blog.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.name IS 'Blog Name';


--
-- Name: COLUMN blog_blog.subtitle; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.subtitle IS 'Blog Subtitle';


--
-- Name: COLUMN blog_blog.content; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.content IS 'Content';


--
-- Name: COLUMN blog_blog.cover_properties; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.cover_properties IS 'Cover Properties';


--
-- Name: COLUMN blog_blog.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.active IS 'Active';


--
-- Name: COLUMN blog_blog.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.create_date IS 'Created on';


--
-- Name: COLUMN blog_blog.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_blog.write_date IS 'Last Updated on';


--
-- Name: blog_blog_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.blog_blog_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.blog_blog_id_seq OWNER TO ductin;

--
-- Name: blog_blog_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.blog_blog_id_seq OWNED BY public.blog_blog.id;


--
-- Name: blog_post; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.blog_post (
    id integer NOT NULL,
    website_id integer,
    author_id integer,
    blog_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    visits integer,
    website_meta_og_img character varying,
    author_name character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    name jsonb NOT NULL,
    subtitle jsonb,
    content jsonb,
    teaser_manual jsonb,
    cover_properties text,
    is_published boolean,
    active boolean,
    create_date timestamp without time zone,
    published_date timestamp without time zone,
    post_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.blog_post OWNER TO ductin;

--
-- Name: TABLE blog_post; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.blog_post IS 'Blog Post';


--
-- Name: COLUMN blog_post.website_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.website_id IS 'Website';


--
-- Name: COLUMN blog_post.author_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.author_id IS 'Author';


--
-- Name: COLUMN blog_post.blog_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.blog_id IS 'Blog';


--
-- Name: COLUMN blog_post.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.create_uid IS 'Created by';


--
-- Name: COLUMN blog_post.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.write_uid IS 'Last Contributor';


--
-- Name: COLUMN blog_post.visits; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.visits IS 'No of Views';


--
-- Name: COLUMN blog_post.website_meta_og_img; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN blog_post.author_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.author_name IS 'Author Name';


--
-- Name: COLUMN blog_post.website_meta_title; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN blog_post.website_meta_description; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN blog_post.website_meta_keywords; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN blog_post.seo_name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.seo_name IS 'Seo name';


--
-- Name: COLUMN blog_post.name; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.name IS 'Title';


--
-- Name: COLUMN blog_post.subtitle; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.subtitle IS 'Sub Title';


--
-- Name: COLUMN blog_post.content; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.content IS 'Content';


--
-- Name: COLUMN blog_post.teaser_manual; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.teaser_manual IS 'Teaser Content';


--
-- Name: COLUMN blog_post.cover_properties; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.cover_properties IS 'Cover Properties';


--
-- Name: COLUMN blog_post.is_published; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.is_published IS 'Is Published';


--
-- Name: COLUMN blog_post.active; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.active IS 'Active';


--
-- Name: COLUMN blog_post.create_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.create_date IS 'Created on';


--
-- Name: COLUMN blog_post.published_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.published_date IS 'Published Date';


--
-- Name: COLUMN blog_post.post_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.post_date IS 'Publishing date';


--
-- Name: COLUMN blog_post.write_date; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_post.write_date IS 'Last Updated on';


--
-- Name: blog_post_blog_tag_rel; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.blog_post_blog_tag_rel (
    blog_tag_id integer NOT NULL,
    blog_post_id integer NOT NULL
);


ALTER TABLE public.blog_post_blog_tag_rel OWNER TO ductin;

--
-- Name: TABLE blog_post_blog_tag_rel; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.blog_post_blog_tag_rel IS 'RELATION BETWEEN blog_tag AND blog_post';


--
-- Name: blog_post_id_seq; Type: SEQUENCE; Schema: public; Owner: ductin
--

CREATE SEQUENCE public.blog_post_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.blog_post_id_seq OWNER TO ductin;

--
-- Name: blog_post_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ductin
--

ALTER SEQUENCE public.blog_post_id_seq OWNED BY public.blog_post.id;


--
-- Name: blog_tag; Type: TABLE; Schema: public; Owner: ductin
--

CREATE TABLE public.blog_tag (
    id integer NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.blog_tag OWNER TO ductin;

--
-- Name: TABLE blog_tag; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON TABLE public.blog_tag IS 'Blog Tag';


--
-- Name: COLUMN blog_tag.category_id; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_tag.category_id IS 'Category';


--
-- Name: COLUMN blog_tag.color; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_tag.color IS 'Color';


--
-- Name: COLUMN blog_tag.create_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_tag.create_uid IS 'Created by';


--
-- Name: COLUMN blog_tag.write_uid; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN blog_tag.website_meta_og_img; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_tag.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN blog_tag.website_meta_title; Type: COMMENT; Schema: public; Owner: ductin
--

COMMENT ON COLUMN public.blog_tag.website_meta_title IS 'Website meta title';